
{Sample ASCII transmission test program for FA1x series audiometers}
{ Copyright 1992,1994 Frye Electronics  -- writen by Michael Day }
{ V1.31 as of 10 October 1994 }
program ASCIIA;

{$IFDEF WINDOWS}
  {$R AUD.RES}
  uses DosCrt,WinTypes,strings,agsub,audsubs,VidSubs,TermSub;
  {$DEFINE PMODE}
{$ELSE}
  uses crt,agsub,audsubs,VidSubs,TermSub;
{$ENDIF}
{$IFDEF DPMI}
  {$DEFINE PMODE}
{$ENDIF}

{$I+,R+}

{Show the copyright message}
procedure DoTitle;
begin
  gotoxy(70,1);
  write('Audiogram');
  gotoxy(70,2);
  write('V1.30');
  if DoASCII then write(' (A)') else write(' (P)');
  gotoxy(70,3);
  write('(C) 1994');
  gotoxy(70,4);
  write('Frye Elec');
  gotoxy(70,5);
  write('10 Oct 94');
end;


{-----------------------------------------------------------------}

var Pcnt : word;
    Pstr : string[80];
    IOport,IRQn:word;
    Err:integer;

begin
 {$IFDEF WINDOWS}           {init WinCrt stuff}
    ScreenSize.X := 80;
    ScreenSize.Y := 25;
    WindowSize.X := 1000 {639};  {make it as big as it will go}
    WindowSize.Y := 800 {439};
    StrCopy(WindowTitle,'AUDGRAM');
    DosCrtFont := OEM_FIXED_FONT;
    InitDosCrtWindow;
    AutoTracking := false;
 {$ENDIF}

   gotoxy(1,25);
   writeln;
   writeln;
   writeln('Audiogram  Copyright 1992,1994 Frye Electronics');
   writeln('Version 1.31  as of 10 October 1994');

  PatReq := false;
  DoASCII := true;
  IOport := 0;
  IRQn := 0;
  pcnt := ParamCount;
  while Pcnt > 0 do
  begin
    PStr := ParamStr(Pcnt);
    case upcase(Pstr[1]) of
      '2': IOPort := 1;
      '3': IOPort := 2;
      '4': IOPort := 3;
      'R': PatReq := true;    {must press pat rsp switch to accept values}
      'P': DoASCII := false;   {use packet instead of ASCII mode}
      'I': begin
              while ((Pstr[1] < '0') or (Pstr[1] > '9')) and (length(Pstr) > 0) do
                delete(Pstr,1,1);
              while ((Pstr[length(Pstr)] < '0') or
                    (Pstr[length(Pstr)] > '9')) and (length(Pstr) > 0) do
                dec(Pstr[0]);
              val(Pstr,Irqn,Err);
              if (IrqN > 15) or (Err <> 0) then IrqN := 0;
           end;
    end;
    dec(Pcnt);
  end;

   if DoASCII then
     writeln('ASCII transmission via COM',succ(IOport))
   else
     writeln('Packet transmission via COM',succ(IOport));

   FryersOK := true;   {default to fryers ok}
   writeln('Initializing port: COM',succ(IOport));
   if not InitAGPort(IOport,IRQn) then
   begin
     FryersOK := false;
     writeln('  ** Error : FRYERS.COM not found **');
     writeln('Warning: Occasional data loss may occur');
     writeln;
     if DoASCII then
     begin
       writeln('Warning: FRYERS.COM should be run before using this program');
       writeln('in ASCII mode to prevent possible data loss from the audiometer.');
       writeln;
       writeln(' --- Now switching to polled IO --- ');
       writeln;
       writeln('  >>  Press any key to continue  <<');
     end
     else
     begin
       writeln('FRYERS.COM must be run before you can use this program');
       writeln('in FIPP packet mode');
       Halt(1);
     end;
     if readkey = #0 then if readkey = #0 then {nop};
     {switch to polled io?}
   end;
   writeln;
   writeln('Port initialized');

   done := false;
   NormalText;
   clrscr;
   SelectCursor(Off);
   NormalText;
   InitGraph;       {init stuff}
   drawgraph;
   DoTitle;
   repeat
     DoSpin;        {blinking lights to show we are operational}
     chk := #255;
     GetPanel;      {grab a copy of the front panel state}
     Ltrg := false;
     Rtrg := false;
     if keypressed then
     begin
       chk := GetKey;
       case chk of
        'L','l': begin                {no rsp or clear left chan}
                   Ltrg := true;
                   Ltgl := not(Ltgl);
                 end;
        'R','r': begin                {no rsp or clear right chan}
                   Rtrg := true;
                   Rtgl := not(Rtgl);
                 end;
       end;
     end;
     UpdateRegs;           {update internal audiogram registers}
     UpdateGraph;          {update the screen}
     case chk of
       #$1b,'Q','q': Done := true;   {quit?}
       'c','C': begin
                   clrscr;
                   NormalText;  {clear the screen and start over}
                   InitGraph;
                   drawgraph;
                   DoTitle;
                 end;
       't','T' : Trigger;  {(for ascii) forced request of front panel data}
     end; {case ch of}
   until done;
   RestorePacketMode;    {force audiometer back into packet mode}
   SelectCursor(On);
   ClosePort;            {turn off the lights when you leave}
   {$IFDEF WINDOWS}
     DoneDosCrtWindow;
   {$ENDIF}
end.
