{Misc routines used by APAC program }
{09 November 1992 written by Michael Day}
{Copyright 1992 Frye Electronics, Inc. }

unit AudIO;
interface
{$IFDEF WINDOWS}
  uses DosCrt,Audunit,AudFipp,Audsubs;
  {$DEFINE PMODE}
{$ELSE}
  uses crt,mouse,Audunit,AudFipp,Audsubs;
{$ENDIF}
{$IFDEF DPMI}
  {$DEFINE PMODE}
{$ENDIF}

{$I-,R-}

const Cx : integer = 0;
      Cy : integer = 0;

      AllDone : boolean = false;
      KeyClicked : boolean = false;
      Key : char = #255;

      ComputerControl : boolean = false;

procedure ManageIO;
procedure UpdateAudiometer;
procedure UpdateComputer;

implementation


const LeftArrow  = char(75+128);
      RightArrow = char(77+128);
      UpArrow    = char(72+128);
      DownArrow  = char(80+128);
      AltC = char(46+128);
      AltF = char(33+128);
      AltL = char(38+128);
      AltR = char(19+128);
      AltW = char(17+128);
      AltO = char(24+128);
      AltP = char(25+128);
      AltT = char(20+128);
      CtrlL = #12;
      CtrlR = #18;
      CtrlF = #6;


function KeyClick:boolean;
begin
  KeyClick := KeyClicked;
  KeyClicked := false;
end;


procedure ManageKeys;
begin
  if KeyPressed then
  begin
     KeyClicked := true;
     Key := readkey;
     if Key = #0 then Key := char(ord(readkey)+$80);

{    Aud.WriteMsg(1,1,fstr(ord(Key))+' '+Key+'  ');  }

    case Key of
     LeftArrow : begin
                   Aud.LeftBox;
                   Aud.GetCurPos(Cx,Cy);
                 end;
     RightArrow: begin
                   Aud.RightBox;
                   Aud.GetCurPos(Cx,Cy);
                 end;
     UpArrow   : begin
                   Aud.UpField;
                   Aud.GetCurPos(Cx,Cy);
                 end;
     DownArrow : begin
                   Aud.DownField;
                   Aud.GetCurPos(Cx,Cy);
                 end;
          CtrlL : begin
                   Aud.GotoBox(LLbox);
                   Aud.GetCurPos(Cx,Cy);
                 end;
          CtrlR : begin
                   Aud.GotoBox(RLbox);
                   Aud.GetCurPos(Cx,Cy);
                 end;

          AltC : begin
                   Aud.GotoBox(CmdBox);
                   Aud.GetCurPos(Cx,Cy);
                 end;
          AltL : begin
                   Aud.GotoBox(FLbox);
                   Aud.GetCurPos(Cx,Cy);
                 end;
          AltR : begin
                   Aud.GotoBox(FRbox);
                   Aud.GetCurPos(Cx,Cy);
                 end;

          AltW : begin
                   Aud.GotoBox(WarbleBox);
                   Aud.GetCurPos(Cx,Cy);
                 end;
          AltO : begin
                   Aud.GotoBox(OutRevBox);
                   Aud.GetCurPos(Cx,Cy);
                 end;
          AltP : begin
                   Aud.GotoBox(PulseBox);
                   Aud.GetCurPos(Cx,Cy);
                 end;
          AltT : begin
                   Aud.GotoBox(TlkFwdBox);
                   Aud.GetCurPos(Cx,Cy);
                 end;

     'F','f',AltF : begin
                      Aud.GotoBox(FBox);
                      Aud.GetCurPos(Cx,Cy);
                    end;
          'L','l' : begin
                      Aud.ToggleBox(LstimBox);
                    end;
          'R','r' : begin
                      Aud.ToggleBox(RstimBox);
                    end;
          'C','c' : begin
                      if ComputerControl = true then
                        ComputerControl := false
                      else
                        ComputerControl := true;
                      if ComputerControl then
                        Aud.UpdateBoxField(CmdBox,2)
                      else
                        Aud.UpdateBoxField(CmdBox,1);
                    end;



      ^C,'Q','q',#$1b : AllDone := true;
    end; {case Key of}
  end;

end;


procedure UpdateAudiometer;
begin
   with Aud,AudCom^.D.XpnRec do
   begin
     LLevel := LevelTable[Box[LLbox].Field] * 100;
     RLevel := LevelTable[Box[RLbox].Field] * 100;
     LFreq  := FreqTable[Box[FLbox].Field];
     RFreq  := FreqTable[Box[FRbox].Field];
     Lsim   := pred(Box[LSbox].Field);
     Rsim   := pred(Box[RSbox].Field);
     Ldest  :=      Box[LObox].Field;
     Rdest  :=      Box[RObox].Field;
     Lsrc   := pred(Box[LIbox].Field);
     Rsrc   := pred(Box[RIbox].Field);

     if Box[LstimBox].Field > 0 then
       PBstat := (PBstat and not(1)) or (pred(Box[LstimBox].Field) and 1);
     if Box[RstimBox].Field > 0 then
       PBstat := (PBstat and not($100)) or ((pred(Box[RstimBox].Field) and 1) shl 8);

     if Box[WarbleBox].Field > 0 then
     begin
       PBstat := (PBstat and not(4)) or ((pred(Box[WarbleBox].Field) and 1) shl 2);
       PBstat := (PBstat and not($400)) or ((pred(Box[WarbleBox].Field) and 1) shl 6);
     end;
     if Box[PulseBox].Field > 0 then
     begin
       PBstat := (PBstat and not(2)) or ((pred(Box[PulseBox].Field) and 1) shl 1);
       PBstat := (PBstat and not($200)) or ((pred(Box[PulseBox].Field) and 1) shl 9);
     end;
     if Box[TlkfwdBox].Field > 0 then
     begin
       PBstat := (PBstat and not($8)) or ((pred(Box[TlkfwdBox].Field) and 1) shl 3);
       PBstat := (PBstat and not($800)) or ((pred(Box[TlkfwdBox].Field) and 1) shl 11);
     end;
     if Box[OutrevBox].Field > 0 then
     begin
       PBstat := (PBstat and not($10)) or ((pred(Box[OutrevBox].Field) and 1) shl 4);
       PBstat := (PBstat and not($1000)) or ((pred(Box[OutrevBox].Field) and 1) shl 12);
     end;
   end;
end;


procedure UpdateComputer;
begin
   with Aud,AudCom^.D.XpnRec do
   begin
     UpdateBoxField(LLbox,LevelIndex(LLevel));
     UpdateBoxField(RLbox,LevelIndex(RLevel));
     UpdateBoxField(Fbox,FreqIndex(LFreq));
     SetSecondaryField(Fbox,FreqIndex(RFreq));
     UpdateBoxField(FLbox,FreqIndex(LFreq));
     UpdateBoxField(FRbox,FreqIndex(RFreq));

     UpdateBoxField(LSbox,succ(Lsim));
     UpdateBoxField(RSbox,succ(Rsim));
     UpdateBoxField(LObox,Ldest);
     UpdateBoxField(RObox,Rdest);
     UpdateBoxField(LIbox,succ(Lsrc));
     UpdateBoxField(RIbox,succ(Rsrc));

     UpdateBoxField(LstimBox,succ(PBstat and 1));
     UpdateBoxField(RstimBox,succ(hi(PBstat) and 1));
     UpdateBoxField(WarbleBox,succ((PBstat shr 2) and 1));
     UpdateBoxField(PulseBox,succ((PBstat shr 1) and 1));
     UpdateBoxField(OutrevBox,succ((PBstat shr 4) and 1));
     UpdateBoxField(TlkfwdBox,succ((PBstat shr 3) and 1));

   end;
end;





procedure ManageIO;
var B:word;
begin
  ManageKeys;
  ReadMouse;
  if MouseClicked then
  begin
    Cx := GetMx(ClickMouseX);
    Cy := GetMy(ClickMouseY);
  end;

  if KeyClicked then Key := #255;
  if Aud.Box[CmdBox].Field = 2 then ComputerControl := true
    else ComputerControl := false;
  if not(MouseClick) and not(KeyClick) then Exit;

  B := Aud.ActiveHit(Cx,Cy);
  if B = 0 then Exit;
  Aud.SelectBox(B,Cx,Cy);
  if B = FLbox then
    Aud.UpdateBoxField(Fbox,Aud.Box[FLbox].Field);
  if B = FRbox then
    Aud.SetSecondaryField(Fbox,Aud.Box[FRbox].Field);
  if B = Fbox then
  begin
    Aud.UpdateBoxField(FLbox,Aud.Box[Fbox].Field);
    Aud.UpdateBoxField(FRbox,Aud.Box[Fbox].Field);
    Aud.SetSecondaryField(Fbox,Aud.Box[Fbox].Field);
  end;
  if Aud.Box[CmdBox].Field = 2 then ComputerControl := true
    else ComputerControl := false;

end;

begin
end.