
{This program shows the current state of the front panel switches}
{it uses the fipp packets to read the state of the audiometer}
{The program shows example programming for MSDOS real mode, }
{MSDOS protected mode, and Windows programming using Borland Pascal}
{In most cases very little changing needs to be done to switch }
{between the various methods.

{In most cases the programs are backward compatible to Turbo Pascal V6.0}
{and will compile without changes. Since BASM functions were used in many}
{of the units, the code will not compile on versions of Turbo Pascal}
{prior to TP6.0.  However, if you have a need to compile in the earlier}
{TP5.x versions of Turbo Pascal, you could change the ASM code to be}
{implemented as register based calls to the interrupts since the interrupt}
{calls are the only thing that really is important to the code.}

{Note that DOSCRT is derived from Borland's WINCRT unit.}
{DOSCRT allows the program to have greater control over the unit. }
{I called it DOSCRT to keep it seperately identified from WINCRT}
{so that the two would not get confused.}

{10 November 1992 written by Michael Day}
{Copyright 1992 Frye Electronics}


program audkey;
{$IFDEF WINDOWS}
  {$R AUD.RES}
  USES Windos,DosCrt,Strings,AudFipp,AudParms,Audsubs,VidSubs;
  {$DEFINE PMODE}
{$ELSE}
  USES dos,crt,AudFipp,AudParms,Audsubs,VidSubs;
{$ENDIF}
{$IFDEF DPMI}
  {$DEFINE PMODE}
{$ENDIF}


{$I+,R+}

var
    OldCur : word;
    Ch : char;
    SpinCnt : word;
    IOport,IRQn:word;
    Pcnt,Err:integer;
    Pstr:string;

procedure Spin;
begin
   gotoxy(39,12);
   case SpinCnt of
    0: write('|');
    1: write('/');
    2: write('-');
    3: write('\');
   end;
   SpinCnt := Succ(SpinCnt) and $3;
end;


procedure nop;
inline($90);

begin
 {$IFDEF WINDOWS}
    ScreenSize.X := 80;
    ScreenSize.Y := 25;
    WindowSize.X := 1000 {639};
    WindowSize.Y := 800 {439};
    StrCopy(WindowTitle,'AUDKEY');
    InitDosCrtWindow;
    AutoTracking := false;
 {$ENDIF}

   NormalText;
   clrscr;


  IOport := 0;
  IRQn := 0;
  pcnt := ParamCount;
  while Pcnt > 0 do
  begin
    PStr := ParamStr(Pcnt);
    case upcase(Pstr[1]) of
      '2': IOPort := 1;
      '3': IOPort := 2;
      '4': IOPort := 3;
      'I': begin
              while ((Pstr[1] < '0') or (Pstr[1] > '9')) and (length(Pstr) > 0) do
                delete(Pstr,1,1);
              while ((Pstr[length(Pstr)] < '0') or
                    (Pstr[length(Pstr)] > '9')) and (length(Pstr) > 0) do
                dec(Pstr[0]);
              val(Pstr,Irqn,Err);
              if (IrqN > 15) or (Err <> 0) then IrqN := 0;
           end;
    end;
    dec(Pcnt);
  end;


   gotoxy(40,1);
   write('| Audiometer Keyboard Test Program');
   gotoxy(40,2);
   write('| Version 1.30 - 10 November 1992');
   gotoxy(40,3);
   write('| Copyright 1992 Frye Electronics');
   gotoxy(40,4);
   write('---------------------------------------');

   if not(AudCom^.InitRS232(IOport,IRQn,true)) then
   begin
     gotoxy(1,24);
     writeln('Could not open com port',IOport,' IRQ',AudCom^.D.IRQnum[IOport]);
     if readkey = #0 then nop;
     halt(1);
   end;
   SelectCursor(Off);
   NormalText;

   Ch := #255;

   repeat
     AudCom^.Cmd(GetPLcount);
     gotoxy(42,6);
     if AudCom^.Fail then
        write('PLR read error ',AudCom^.FailMsg)
     else
        write('                                     ');

     if AudCom^.D.PLcount <> 0 then
     begin
       if (Ch <> 'S') and (Ch <> 's') then
       begin
         AudCom^.Cmd(GetPrlImg);
         gotoxy(62,6);
         if AudCom^.Fail then
            write('PRL read error ',AudCom^.FailMsg)
         else
            write('                                 ');
       end;
     end;

     AudCom^.Cmd(GetXpnImg);
     gotoxy(42,7);
     if AudCom^.Fail then
        write('XPN read error',AudCom^.FailMsg)
     else
        write('                                     ');
     AudCom^.Cmd(GetKeyImg);
     gotoxy(62,7);
     if AudCom^.Fail then
        write('KEY read error',AudCom^.FailMsg)
     else
        write('                                     ');

     ShowPrlParms;
     ShowXpnParms;
     ShowAudKeys;
     if KeyPressed then
       Ch := ReadKey;

     Spin;

   until Ch < #$20;

   AudCom^.CloseRS232(AudCom^.D.Comport);
   SelectCursor(On);
   {$IFDEF WINDOWS}
     DoneDosCrtWindow;
   {$ENDIF}
end.

