
{ Misc routines used by APAC program }
{ Copyright 1992 Frye Electronics Inc. }
{ Written by Micahel Day 09 November 1992 }

unit AudMisc;

interface
{$IFDEF WINDOWS}
  uses DosCrt,AudIO,AudFipp,AudUnit,Audsubs;
  {$DEFINE PMODE}
{$ELSE}
  uses crt,AudIO,AudFipp,AudUnit,Audsubs;
{$ENDIF}
{$IFDEF DPMI}
  {$DEFINE PMODE}
{$ENDIF}

{$I+,R+}

  procedure TransferData;
  procedure ResetAudiometer;
  procedure UpdateDisplay;
  procedure InitScreen;
  procedure SetLabel(S:string; X,Y:word);


implementation

  procedure TransferData;
  begin
    if ComputerControl then
    begin
      AudCom^.D.XpnRec.PBStat := AudCom^.D.Xpnrec.PBstat or $8080;

      AudCom^.Cmd(SetXpnImg);
      if AudCom^.Fail then Aud.WriteMsg(1,1,'Ack!!! Bad Write!')
        else Aud.WriteMsg(2,1,'                 ');

      AudCom^.Cmd(GetCmdStatus);
      if AudCom^.Fail or (AudCom^.D.CMDstatus > 0) then
        Aud.WriteMsg(2,1,'Bad Cmd transfer!'+hexW(AudCom^.D.cmdstatus)+'   ')
      else Aud.WriteMsg(2,1,'                     ');
    end
    else
    begin
      if AudCom^.D.Xpnrec.PBstat and $8080 <> 0 then
      begin
        AudCom^.D.XpnRec.PBStat := AudCom^.D.Xpnrec.PBstat and not($8080);
        AudCom^.Cmd(SetXpnImg);
        if AudCom^.Fail then Aud.WriteMsg(1,1,'Ack!!! Bad Write!');
        AudCom^.Cmd(GetCmdStatus);
        if AudCom^.Fail then
        begin
          Aud.WriteMsg(2,1,'Bad Cmd transfer!');
          AudCom^.D.XpnRec.PBStat := AudCom^.D.Xpnrec.PBstat or $8080;
        end
          else Aud.WriteMsg(2,1,'                 ');
      end;

      AudCom^.Cmd(GetXpnImg);
      if AudCom^.Fail then Aud.WriteMsg(1,1,'Ack!!! Bad Read!');
    end;
  end;


  procedure ResetAudiometer;
  begin
    AudCom^.Cmd(DoReset);
    AudCom^.Cmd(GetCmdStatus);
    if AudCom^.Fail then
      Aud.ErrMsg('Ack! can''t find Audiometer');
  end;

procedure UpdateDisplay;
begin
  with Aud do
  begin
    UpdateBox(LLbox,1,LevelTable);
    UpdateBox(RLbox,1,LevelTable);
    UpdateBox(Fbox,1,FreqTable);
    UpdateBox(FLbox,2,LeftFreqLabel);
    UpdateBox(FRbox,2,RightFreqLabel);
    UpdateBox(LSbox,0,HasTable);
    UpdateBox(RSbox,0,HasTable);
    UpdateBox(LObox,0,LeftOutputTable);
    UpdateBox(RObox,0,RightOutputTable);
    UpdateBox(LIbox,0,leftInputTable);
    UpdateBox(RIbox,0,RightInputTable);
    UpdateBox(LstimBox,0,OnOffTable);
    UpdateBox(RstimBox,0,OnOffTable);
    UpdateBox(WarbleBox,0,OnOffTable);
    UpdateBox(PulseBox,0,OnOffTable);
    UpdateBox(OutrevBox,0,OnOffTable);
    UpdateBox(TlkfwdBox,0,OnOffTable);

    UpdateBox(LFNbox,3,AudCom^.D.XpnRec.LFREQ);
    UpdateBox(RFNbox,3,AudCom^.D.XpnRec.RFREQ);
    UpdateBox(LLNbox,4,AudCom^.D.XpnRec.LLEVEL);
    UpdateBox(RLNbox,4,AudCom^.D.XpnRec.RLEVEL);

    UpdateBox(CmdBox,0,OnOffTable);
  end;
end;

procedure SetLabel(S:string; X,Y:word);
begin
   gotoxy(X,Y);
   write(S);
end;


procedure InitScreen;
begin
  with Aud do
  begin
    InitBox(LLbox,19,1,3,23,DualBorder,Backward);
    SetLabel('Level',19-5,1);
    SetLabel('dB HL',19-5,2);
    InitBox(RLbox,57,1,3,23,DualBorder,Backward);
    SetLabel('Level',57+5,1);
    SetLabel('dB HL',57+5,2);
    InitBox(Fbox,37,8,4,11,DualBorder,BackWard);
    SetLabel('Freq',38,7);
    InitBox(FLbox,36,8,2,11,NoBorder,BackWard);
    InitBox(FRbox,42,8,2,11,NoBorder,BackWard);
    InitBox(LSbox,1,2,4,8,DualBorder,Forward);
    SetLabel('HA sim',1,1);
    InitBox(RSbox,74,2,4,8,DualBorder,Forward);
    SetLabel('HA sim',74,1);
    InitBox(LObox,1,16,5,4,DualBorder,Forward);
    SetLabel('Output',1,15);
    InitBox(RObox,73,16,5,4,DualBorder,Forward);
    SetLabel('Output',74,15);
    InitBox(LIbox,10,16,5,8,DualBorder,Forward);
    SetLabel('Input',11,15);
    InitBox(RIbox,64,16,5,8,DualBorder,Forward);
    SetLabel('Input',65,15);
    InitBox(MsgBox,25,3,29,2,SingleBorder,Forward);

    InitBox(LLNbox,12,3,5,1,SingleBorder,Forward);
    InitBox(RLNbox,62,3,5,1,SingleBorder,Forward);
    InitBox(LFNbox,29,7,4,1,SingleBorder,Forward);
    InitBox(RFNbox,45,7,4,1,SingleBorder,Forward);
    SetLabel('Left',25,8);
    SetLabel('Right',51,8);

    SetLabel('Stim',25,21);
    InitBox(LstimBox,25,22,3,2,SingleBorder,Backward);
    SetLabel('Stim',52,21);
    InitBox(RstimBox,51,22,3,2,SingleBorder,Backward);
    UpdateBoxField(LstimBox,1);
    UpdateBoxField(RstimBox,1);

    SetLabel('Pulse',26,11);
    InitBox(PulseBox,26,12,3,2,SingleBorder,Backward);
    SetLabel('Warble',50,11);
    InitBox(WarbleBox,50,12,3,2,SingleBorder,Backward);
    UpdateBoxField(PulseBox,1);
    UpdateBoxField(WarbleBox,1);

    SetLabel('OutRev',10,7);
    InitBox(OutrevBox,11,8,3,2,SingleBorder,Backward);
    SetLabel('TlkFwd',65,7);
    InitBox(TlkfwdBox,65,8,3,2,SingleBorder,Backward);
    UpdateBoxField(OutrevBox,1);
    UpdateBoxField(TlkfwdBox,1);

    SetLabel('Computer',37,21);
    InitBox(CmdBox,38,22,3,2,SingleBorder,Backward);
    UpdateBoxField(CmdBox,1);
    ComputerControl := false;
  end;
end;

end.

