
{misc routines used by AUDKEY program }
{09 November 1992 written by Michael Day}
{Copyright 1992 Frye Electronics, Inc.}

unit AudParms;

interface
{$IFDEF WINDOWS}
  uses DosCrt,hets,AudFipp;
  {$DEFINE PMODE}
{$ELSE}
  uses crt,hets,AudFipp;
{$ENDIF}
{$IFDEF DPMI}
  {$DEFINE PMODE}
{$ENDIF}

{$I-,R-}

procedure ShowXPNParms;
procedure ShowPRLParms;
procedure ShowAudKeys;
procedure ShowRawKeys;

implementation

var y : word;
    X : WORD;


function Lstr(num:integer):string;
var s,s1,s2 : string[8];
    n,m:integer;
begin
  n := num div 100;
  m := abs(num mod 100) div 10;
  str(n,s1);
  str(m,s2);
  s := s1+'.'+s2+'dB        ';
  Lstr := s;
end;

function Fstr(num:integer):string;
var s : string[8];
begin
  str(Num,s);
  s := s+'Hz        ';
  Fstr := s;
end;

function Sstr(num:integer):string;
var s : string[8];
begin
  case num of
{   0:s := 'Tone';
   1:s := 'NBN';
   2:s := 'WhiteN';
   3:s := 'SpeechN';
   4:s := 'Mic';
   5:s := 'External';
   6:s := 'OtherExt';
   7:s := 'Stenger'; }

   0:s := 'Tone';
   1:s := 'Mic';
   2:s := 'External';
   3:s := 'OtherExt';
   4:s := 'Stenger';
   5:s := 'WhiteN';
   6:s := 'SpeechN';
   7:s := 'NBN';

  else
   s := 'Unknown';
  end;
  s := s+'         ';
  SStr := s;
end;

function Ostr(num:integer):string;
var s : string[8];
begin
  case num of
   0:s := 'Off';
   1:s := 'Phone';
   2:s := 'Bone';
   3:s := 'Speaker';
   4:s := 'OtherChn';
  else
   s := 'Unknown';
  end;
  s := s+'         ';
  OStr := s;
end;


function Hstr(num:integer):string;
var s : string[8];
begin
  case num of
   0:s := 'Off';
   1:s := '6dB';
   2:s := '12dB';
   3:s := '18dB';
   4:s := 'HFE';
   5:s := 'Opt C';
   6:s := 'Opt B';
   7:s := 'Opt A';
  else
   s := 'Unknown';
  end;
  s := s+'         ';
  HStr := s;
end;


function Bstr(num:byte):string;
var s : string[8];
    i : integer;
begin
  s := '';
  for i := 7 downto 0 do
  begin
    if num and (1 shl i) = 0 then s := s+'0'
    else s := s+'1';
  end;

  BStr := s;
end;


procedure ShowXPNParms;
var i : word;
begin
   X := 1;
   y := 12;
   gotoxy(x,Y);
   write('============= XPN Image =============');
   gotoxy(x,y+1);
   write('|----- Left -----');
   gotoxy(x+18,y+1);
   write('|----- Right -----');

   with AudCom^,D do
   begin
     gotoxy(X,y+2);
     write('| Freq   :',Fstr(XpnRec.Lfreq));
     gotoxy(X,y+3);
     write('| Level  :',Lstr(XpnRec.LLevel));
     gotoxy(X,y+4);
     write('| Offset :',Lstr(XpnRec.Lloffs));
     gotoxy(X,y+5);
     write('| Source :',SStr(XpnRec.LSrc));
     gotoxy(X,y+6);
     write('| Output :',Ostr(XpnRec.LDest));
     gotoxy(X,y+7);
     write('| Ha Sim :',Hstr(XpnRec.LSim));
     gotoxy(X,y+8);
     write('| Buttons:',Bstr(lo(XpnRec.PBstat)));

     gotoxy(X+18,y+2);
     write('| Freq   :',Fstr(XpnRec.Rfreq));
     gotoxy(X+18,y+3);
     write('| Level  :',Lstr(XpnRec.RLevel));
     gotoxy(X+18,y+4);
     write('| Offset :',Lstr(XpnRec.Rloffs));
     gotoxy(X+18,y+5);
     write('| Source :',SStr(XpnRec.RSrc));
     gotoxy(X+18,y+6);
     write('| Output :',Ostr(XpnRec.RDest));
     gotoxy(X+18,y+7);
     write('| Ha Sim :',Hstr(XpnRec.RSim));
     gotoxy(X+18,y+8);
     write('| Buttons:',Bstr(hi(XpnRec.PBstat)));

     gotoxy(X,y+9);
     write('| Stim:',lo(XpnRec.PBstat) and 1);
     gotoxy(X+18,y+9);
     write('| Stim:',hi(XpnRec.PBstat) and 1);

     gotoxy(X+9,y+9);
     write('| Puls:',ord(lo(XpnRec.PBstat) and 2 = 2));
     gotoxy(X+18+9,y+9);
     write('| Puls:',ord(hi(XpnRec.PBstat) and 2 = 2));

     gotoxy(X,y+10);
     write('| Wrbl:',ord(lo(XpnRec.PBstat) and 4 = 4));
     gotoxy(X+18,y+10);
     write('| Wrbl:',ord(hi(XpnRec.PBstat) and 4 = 4));

     gotoxy(X+9,y+10);
     write('| TFwd:',ord(lo(XpnRec.PBstat) and 8 = 8));
     gotoxy(X+18+9,y+10);
     write('| TFwd:',ord(hi(XpnRec.PBstat) and 8 = 8));

     gotoxy(X,y+11);
     write('| DRev:',ord(lo(XpnRec.PBstat) and 16 = 16));
     gotoxy(X+18,y+11);
     write('| DRev:',ord(hi(XpnRec.PBstat) and 16 = 16));

     gotoxy(X+9,y+11);
     write('| PRsp:',ord(lo(XpnRec.PBstat) and 32 = 32));
     gotoxy(X+18+9,y+11);
     write('| PRsp:',ord(hi(XpnRec.PBstat) and 32 = 32));

     gotoxy(X,y+12);
     write('| N/A :',ord(lo(XpnRec.PBstat) and 64 = 64));
     gotoxy(X+18,y+12);
     write('| N/A :',ord(hi(XpnRec.PBstat) and 64 = 64));

     gotoxy(X+9,y+12);
     write('| RSen:',ord(lo(XpnRec.PBstat) and 128 = 128));
     gotoxy(X+18+9,y+12);
     write('| RSen:',ord(hi(XpnRec.PBstat) and 128 = 128));
   end;

   for i := 1 to 12 do
   begin
     gotoxy(x+18+18,Y+i);
     write('|');
   end;
   gotoxy(X,Y+13);
   write('=====================================');

end;

procedure ShowPRLParms;
var i : word;
begin
   X := 41;
   y := 12;
   gotoxy(x,Y);
   write('============= PRL Image =============');
   gotoxy(x,y+1);
   write('|----- Left -----');
   gotoxy(x+18,y+1);
   write('|----- Right -----');

   with AudCom^,D do
   begin
     gotoxy(X,y+2);
     write('| Freq   :',Fstr(PrlRec.Lfreq));
     gotoxy(X,y+3);
     write('| Level  :',Lstr(PrlRec.LLevel));
     gotoxy(X,y+4);
     write('| Offset :',Lstr(PrlRec.Lloffs));
     gotoxy(X,y+5);
     write('| Source :',SStr(PrlRec.LSrc));
     gotoxy(X,y+6);
     write('| Output :',Ostr(PrlRec.LDest));
     gotoxy(X,y+7);
     write('| Ha Sim :',Hstr(PrlRec.LSim));
     gotoxy(X,y+8);
     write('| Buttons:',Bstr(lo(PrlRec.PBstat)));

     gotoxy(X+18,y+2);
     write('| Freq   :',Fstr(PrlRec.Rfreq));
     gotoxy(X+18,y+3);
     write('| Level  :',Lstr(PrlRec.RLevel));
     gotoxy(X+18,y+4);
     write('| Offset :',Lstr(PrlRec.Rloffs));
     gotoxy(X+18,y+5);
     write('| Source :',SStr(PrlRec.RSrc));
     gotoxy(X+18,y+6);
     write('| Output :',Ostr(PrlRec.RDest));
     gotoxy(X+18,y+7);
     write('| Ha Sim :',Hstr(PrlRec.RSim));
     gotoxy(X+18,y+8);
     write('| Buttons:',Bstr(hi(PrlRec.PBstat)));

     gotoxy(X,y+9);
     write('| Stim:',lo(PrlRec.PBstat) and 1);
     gotoxy(X+18,y+9);
     write('| Stim:',hi(PrlRec.PBstat) and 1);

     gotoxy(X+9,y+9);
     write('| Puls:',ord(lo(PrlRec.PBstat) and 2 = 2));
     gotoxy(X+18+9,y+9);
     write('| Puls:',ord(hi(PrlRec.PBstat) and 2 = 2));

     gotoxy(X,y+10);
     write('| Wrbl:',ord(lo(PrlRec.PBstat) and 4 = 4));
     gotoxy(X+18,y+10);
     write('| Wrbl:',ord(hi(PrlRec.PBstat) and 4 = 4));

     gotoxy(X+9,y+10);
     write('| TFwd:',ord(lo(PrlRec.PBstat) and 8 = 8));
     gotoxy(X+18+9,y+10);
     write('| TFwd:',ord(hi(PrlRec.PBstat) and 8 = 8));

     gotoxy(X,y+11);
     write('| DRev:',ord(lo(PrlRec.PBstat) and 16 = 16));
     gotoxy(X+18,y+11);
     write('| DRev:',ord(hi(PrlRec.PBstat) and 16 = 16));

     gotoxy(X+9,y+11);
     write('| PRsp:',ord(lo(PrlRec.PBstat) and 32 = 32));
     gotoxy(X+18+9,y+11);
     write('| PRsp:',ord(hi(PrlRec.PBstat) and 32 = 32));

     gotoxy(X,y+12);
     write('| N/A :',ord(lo(PrlRec.PBstat) and 64 = 64));
     gotoxy(X+18,y+12);
     write('| N/A :',ord(hi(PrlRec.PBstat) and 64 = 64));

     gotoxy(X+9,y+12);
     write('| RSen:',ord(lo(PrlRec.PBstat) and 128 = 128));
     gotoxy(X+18+9,y+12);
     write('| RSen:',ord(hi(PrlRec.PBstat) and 128 = 128));
   end;

   for i := 1 to 12 do
   begin
     gotoxy(x+18+18,Y+i);
     write('|');
   end;
   gotoxy(X,Y+13);
   write('=====================================');

end;

procedure ShowAudKeys;
begin
   X := 1;
   y := 1;

   with AudCom^,D do
   begin
     gotoxy(X,y+1);
     write('RotSwt 1:',KeyRec.ROTSWT[0],'     ');
     gotoxy(X,y+2);
     write('RotSwt 2:',KeyRec.ROTSWT[1],'     ');
     gotoxy(X,y+3);
     write('RotSwt 3:',KeyRec.ROTSWT[2],'     ');
     gotoxy(X,y+4);
     write('RotSwt 4:',KeyRec.ROTSWT[3],'     ');
     gotoxy(X,y+5);
     write('RotSwt 5:',KeyRec.ROTSWT[4],'     ');
     gotoxy(X,y+6);
     write('RotSwt 6:',KeyRec.ROTSWT[5],'     ');
     gotoxy(X,y+7);
     write('RotSwt 7:',KeyRec.ROTSWT[6],'     ');
     gotoxy(X,y+8);
     write('RotSwt 8:',KeyRec.ROTSWT[7],'     ');
     gotoxy(X,y+9);
     write('RotSwt 9:',KeyRec.ROTSWT[8],'     ');


     gotoxy(X+18,y+1);
     write('Push Buttons:',KeyRec.KEYPBD,'      ');
     gotoxy(X+18,y+2);
     write('Pat Resp Sw :',KeyRec.PATSW,'     ');
     gotoxy(X+18,y+3);
     write('Key Error   :',KeyRec.KEYERR,'     ');

     gotoxy(X+18,y+3);
     write('Buff Count :',BPcount,'     ');
     gotoxy(X+18,y+3);
     write('Latch Count :',PLcount,'     ');
   end;
end;

procedure ShowRawKeys;
begin
   X := 19;
   y := 4;

   gotoxy(X,y+1);
   write('RawInp 1:',MemImg.KeyImg[0],'     ');
   gotoxy(X,y+2);
   write('RawInp 2:',MemImg.KeyImg[1],'     ');
   gotoxy(X,y+3);
   write('RawInp 3:',MemImg.KeyImg[2],'     ');
   gotoxy(X,y+4);
   write('RawInp 4:',MemImg.KeyImg[3],'     ');
   gotoxy(X,y+5);
   write('RawInp 5:',MemImg.KeyImg[4],'     ');
   gotoxy(X,y+6);
   write('RawInp 6:',MemImg.KeyImg[5],'     ');

end;



begin
 with AudCom^,D do
 begin
  fillchar(PRLRec,sizeof(PRLRec),0);
  fillchar(XPNRec,sizeof(XPNRec),0);
  fillchar(KeyRec,sizeof(KeyRec),0);
  PLcount := 0;
  BPcount := 0;
 end;
end.
