
{misc audiometer routines for use with audiometer programs}
{Copyright 1992 Frye Electronics -- writen by Michael Day}
{V1.30 as of 09 November 1992}

unit audsubs;
interface

{$IFDEF WINDOWS}
  uses WinProcs,WinDos,DosCrt;
  {$DEFINE PMODE}
{$ELSE}
  uses Dos,Ticker;
{$ENDIF}
{$IFDEF DPMI}
  {$DEFINE PMODE}
{$ENDIF}

{$I+,R+}

type string2 = string[2];
     string4 = string[4];
     string8 = string[8];
     string9 = string[9];
     string12 = string[12];
     string80 = string[80];
     Pval=Record Ofs,Seg:word; End;
     Dval=Record  Lw, Hw:word; End;
     TOrecType = record
                    StartCount : word;
                    EndCount : word;
                    Temp : word;
                    TimedOut : boolean;
                 end;

var TOcount : TOrecType;

const
    Hex : array[0..15] of char = '0123456789ABCDEF';

function hexB(B:byte):string2;
function hexW(W:word):string4;
function hexL(L:longint):string8;
function hexP(P:pointer):string9;
function fstr(L:longint):string12;
function ArgVal(var S; var C:word):word;
function KeyWaiting:boolean;
function GetKey:char;
procedure fillword(var D; Ws,V:word);
procedure fillint(var D; Ws,V:integer);
procedure fillLong(var D; Ws:word; V:longint);
procedure outint(i:integer; d:byte);           {print a decimal integer}
function rstr(i:integer; L:byte):string;       {right justified integer}
function lstr(i:integer; L:byte):string;        {left justified integer}
function spc(cnt:integer):string;                    {return cnt spaces}
function Str2D(value:integer):string9;
function Str2Df(value:integer):string12;
procedure ClkWait(Value:word);
procedure InitTimeOut(TimeCount:word; var TOcount:TOrecType);
function TimeOut(var TOcount:TOrecType):boolean;
function Lcomp(A,B:longint):integer;

procedure nop; inline($90);

implementation


{----------------------------------------------------}
{convert a byte to hex}
function hexB(B:byte):string2;
begin
  hexB[1] := Hex[B shr 4];
  hexB[2] := Hex[B and 15];
  hexB[0] := #2;
end;

{convert a word to hex}
function hexW(W:word):string4;
Begin
  hexW[1] := Hex[hi(W) shr 4];
  hexW[2] := Hex[hi(W) and 15];
  hexW[3] := Hex[lo(W) shr 4];
  hexW[4] := Hex[lo(W) and 15];
  hexW[0] := #4;
end;

{convert a longint to hex}
function hexL(L:longint):string8;
Begin
  hexL := hexW(Dval(L).Hw)+hexW(Dval(L).Lw);
end;

{hex value of a pointer}
function hexP(P:Pointer):String9;
Begin
   hexP := hexW(Pval(P).Seg)+':'+hexW(Pval(P).Ofs);
End;


function fstr(L:longint):string12;
var S : string12;
begin
  str(L,S);
  fstr := s;
end;


{--------------------------------------------------}

{$IFDEF WINDOWS}
  function KeyWaiting:boolean;
  begin
    Keywaiting := KeyPressed;
  end;

  function GetKey:char;
  begin
    GetKey := ReadKey;
  end;

{$ELSE}
  function KeyStat:boolean;
  inline(
   $31/$C0      { xor ax,ax }
  /$FE/$C4      { inc ah    }
  /$CD/$16      { int $16   }
  /$B0/$00      { mov al,0  }
  /$74/$02      { jr z,done }
  /$FE/$C0      { inc al    }
                {done:      }
  );
  function KeyWaiting:boolean;
  begin
    KeyWaiting := KeyStat;
  end;


  function InputKey:char;
  inline(
   $31/$C0      { xor ax,ax  }
  /$CD/$16      { int $16    }
  /$08/$C0      { or al,al   }
  /$75/$06      { jr nz,done }
  /$31/$C0      { xor ax,ax  }
  /$CD/$16      { int $16    }
  /$0C/$80      { or al,$80  }
                {done:       }
  );
  function GetKey:char;
  begin
    GetKey := InputKey;
  end;
{$ENDIF}

{++++++++++++++++++++++++++++++++++++++++++}
procedure outint(i:integer; d:byte);
var stemp:string[8];
begin
  str(i:d,stemp);
  write(stemp);
end;
function rstr(i:integer; L:byte):string;
var stemp:string;
begin
  str(i,stemp);
  while length(stemp) < L do
    stemp := ' '+stemp;
  rstr:=stemp;
end;
function lstr(i:integer; L:byte):string;
var stemp:string;
begin
  str(i,stemp);
  while length(stemp) < L do
    stemp := stemp+' ';
  lstr:=stemp;
end;

function spc(cnt:integer):string;
var temp:string;
    i:integer;
begin
   temp := '';
   for i := 1 to cnt do
     temp := temp+' ';
   spc := temp;
end;

{------------------------------------------------}
function Str2D(value:integer):string9;
var ts1,ts2,ts3 : string9;
    i,ts : integer;
begin
  ts3 := '';
  ts := (value+5) div 100;  {force roundup}
  str(ts,ts1);
  if ((value+5) < 0) and (ts = 0) then ts1 := '-0';
  ts := abs((value+5) mod 100) div 10;
  str(ts,ts2);
  if length(ts1) < 4 then
    for i := 1 to 4 - length(ts1) do
      ts3 := ts3+' ';
  Str2D := ts3+ts1+'.'+ts2;
end;

{------------------------------------------------}
function Str2Df(value:integer):string12;
var ts1,ts2,ts3 : string9;
    i,ts : integer;
begin
  ts3 := '';
  ts := (value+5) div 100;
  str(ts,ts1);
  if ((value+5) < 0) and (ts = 0) then ts1 := '-0';
  ts := abs((value+5) mod 100);  {force roundup}
  str(ts,ts2);
  if length(ts2) < 2 then ts2 := ts2+'0';
  if length(ts1) < 4 then
    for i := 1 to 4 - length(ts1) do
      ts3 := ts3+' ';
  Str2Df := ts3+ts1+'.'+ts2;
end;


{+++++++++++++++++++++++++++++++++}
procedure fillword(var D; Ws,V:word);
begin
  asm
    cld
    les di,[D]
    mov ax,[V]
    mov cx,[Ws]
    rep stosw
  end;
end;

procedure fillint(var D; Ws,V:integer);
begin
  asm
    cld
    les di,[D]
    mov ax,[V]
    mov cx,[Ws]
    rep stosw
  end;
end;

procedure fillLong(var D; Ws:word; V:longint);
begin
  asm
    cld
    les di,[D]
    mov ax,word ptr [V]
    mov dx,word ptr [V+2]
    mov cx,[Ws]
   @loopy:
    stosw
    xchg ax,dx
    stosw
    xchg ax,dx
    loop @loopy
  end;
end;



{Warning: this is an assembler macro do not interface it}
function InArgval(var S):longint;
Inline(         {;CONV ASCII # TO BINARY}
  $5F           {  POP DI}
  /$07          {  POP ES     ;GET ADDRESS OF BUFFER}
  /$31/$DB      {  XOR BX,BX}
  /$31/$D2      {  XOR DX,DX  ;INIT REGISTERS}
  /$31/$C0      {  XOR AX,AX}
  /$26          {  ES:}
  /$8A/$09      {  MOV CL,[DI+BX]  ;READ CHARACTER}
  /$80/$F9/$2D  {  CMP CL,'-'  ;SEE IF NEG NUMBER}
  /$75/$01      {  JNZ AR810   ;IF SO, DO AS NEGATIVE}
  /$43          {  INC BX}
                {AR810:}
  /$26          {  ES:}
  /$8A/$01      {  MOV AL,[DI+BX]  ;READ CHARACTER}
  /$2C/$30      {  SUB AL,'0'  ;CONVERT TO BINARY}
  /$3C/$0A      {  CMP AL,10   ;SEE IF VALID ASCII #}
  /$73/$10      {  JNC AR820   ;IF NOT WE ARE DONE}
  /$89/$D6      {  MOV SI,DX}
  /$01/$D2      {  ADD DX,DX}
  /$01/$D2      {  ADD DX,DX   ;MULT X10}
  /$01/$F2      {  ADD DX,SI}
  /$01/$D2      {  ADD DX,DX}
  /$01/$C2      {  ADD DX,AX   ;ADD NEW VALUE}
  /$43          {  INC BX}
  /$E9/$E7/$FF  {  JMP NEAR AR810 ;LOOP TIL DONE}
                {AR820:}
  /$80/$F9/$2D  {  CMP CL,'-'  ;IF WAS NEGATIVE NUMBER}
  /$75/$02      {  JNZ AR830   ;MAKE IT SO}
  /$F7/$DA      {  NEG DX}
                {AR830:}
  /$89/$D0      {  MOV AX,DX  ;RET DATA IN AX}
  /$89/$DA      {  MOV DX,BX  ;RET INDEX IN DX }
  );            {;USAGE =  VAR NUM,CNT : WORD;}
                {;              TMP : LONGINT;}
                {;          BEGIN}
                {;            TMP := ARGVAL(ARRAY);  {CONVERT TO BIN}
                {;            CNT := SEG(TMP^);      {# CHARS READ}
                {;            NUM := OFS(TMP^);      {CONVERTED NUMBER}
                {;            IF CNT = 0 THEN ERROR; {IF CNT=0 NO NUMBER}
                {;          END;}


function ArgVal(var S; var C:word):word;
type Trec = record lo,hi:word; end;
var  Tmp : longint;
begin
  Tmp := InArgVal(S);
  ArgVal := trec(Tmp).lo;
  C := trec(Tmp).hi;
end;


{----------------------------------------------------------------------}
{Long word compare. Returns -1 if A<B, returns 0 if A=B, returns +1 if A>B}
function Lcomp(A,B:longint):integer;
begin
  asm
    mov ax,word ptr [A]
    mov bx,word ptr [A+2]
    mov cx,word ptr [B]
    mov dx,word ptr [B+2]
    cmp bx,dx
    jnz @nomatch
    cmp ax,cx
   @nomatch:
    mov ax,-1
    jc @done
    mov ax,1
    jnz @done
    mov ax,0
   @done:
    mov @result,ax 
  end;
end;

{-----------------------------------------------------------------------}
function ModAdd(A,B:word):word;
Inline($58               {	pop ax}
      /$5B               {	pop bx}
      /$01/$D8);         {	add ax,bx}

(*
{--$IFNDEF WINDOWS}
function GetTickCount:longint;
begin
  GetTickCount := Ticker.TickCount;
end;
{--$ENDIF}
*)

procedure InitTimeOut(TimeCount:word; var TOcount:TOrecType);
begin
  with TOCount do
  begin  
    StartCount := (GetTickCount div 55) and $ffff;
    EndCount := ModAdd(StartCount,TimeCount);
    TimedOut := false;
  end;
end;

function TimeOut(var TOcount:TOrecType):boolean;
begin
   with TOCount do
   begin
     if TimedOut then
     begin
       TimeOut := true;
       Exit;
     end;
     TimeOut := false; 
     Temp := (GetTickCount div 55) and $ffff;
     if StartCount < EndCount then
     begin
       if Temp < EndCount then  Exit;
       TimedOut := true;
       Exit;
     end;

     if Temp > StartCount then Exit;
     if Temp < EndCount then Exit;
     TimedOut := true;
   end;
end;


{-------------------------------------------------}
{waits for the number of 55ms ticks given in Value}
procedure ClkWait(Value:word);
{$IFDEF WINDOWS}
   begin
     DosCrt.Delay(Value*55);
   end;
{$ELSE}
  var ClkTO : TOrecType;
  begin
    InitTimeOut(Value, ClkTO);
    repeat
      if KeyWaiting then {nop};
    until TimeOut(ClkTO);
  end;
{$ENDIF}

{------}
end.


