{misc routines used by APAC program}
{09 Novembwer 1992  written by Michael Day}
{Copyright 1992 Frye Electronics, Inc}

unit AudUnit;
interface
{$IFDEF WINDOWS}
  uses DosCrt,AudSubs,VidSubs;
  {$DEFINE PMODE}
{$ELSE}
  uses crt,AudSubs,VidSubs;
{$ENDIF}
{$IFDEF DPMI}
  {$DEFINE PMODE}
{$ENDIF}



const MaxBox = 25;

type string8 = string[8];
     string80 = string[80];

     Rect = record
       X1,Y1,X2,Y2:integer;
     end;

     FieldRec = record
       R : rect;
       Size: byte;
     end;

     CurRec = record
       B,F : integer;
       X,Y : integer;
     end;

type BoxRec = record
       sX : integer;   {box start X pos}
       sY : integer;   {box start Y pos}
       bW : integer;   {width of box}
       bH : integer;   {height of box}
       bF : integer;   {total active fields in Box}
       bD : boolean;   {field direction; true=forward; false=backward}
       Area : rect;    {active area inside box}
       Field : integer;  {current selected field of the box}
       Field2 : integer; {secondary selection field}
       OldField : integer; {previous selected field}
       Fp : array[0..30] of FieldRec; {position of fields in box}
     end;

type  AudObj = Object
        Box : array[0..MaxBox] of BoxRec;   {array of box info}
        Cur : CurRec;              {current selected box/field}

        constructor CreateAud;
        procedure SelectBox(B,Px,Py:word);
        procedure InitBox(B,X,Y,W,H,F:integer; D:boolean);
        procedure UpdateBox(B,T:word; var A);
        function  InBox(B,Px,Py:word):boolean;
        function  InField(B,Px,Py:word):word;
        function  ActiveHit(Hx,Hy:word):word;
        procedure GetCurPos(var X,Y:integer);
        procedure GotoBox(B:word);
        procedure GotoField(F:word);
        procedure LeftBox;
        procedure RightBox;
        procedure UpField;
        procedure DownField;
        procedure ToggleBox(B:word);
        procedure UpdateBoxField(B,F:word);
        procedure SetSecondaryField(B,F:word);
        function  FreqIndex(F:integer):integer;
        function  LevelIndex(L:integer):integer;
        function  FreqIndexMatch(F,I:word):boolean;
        function  LevelIndexMatch(L,I:word):boolean;
        procedure WriteMsg(L,C:word; S:string80);
        procedure ErrMsg(S:string80);
      end;

var   Aud : AudObj;



const FreqTable : array[0..12] of word = (0,
        125,250,500,750,1000,1500,2000,3000,4000,6000,8000,65535);
      LevelTable : array[0..24] of integer = (-32768,
        -10,-5,0,5,10,15,20,25,30,35,40,45,50,55,60,65,70,75,80,85,90,95,100,32767);

const HASTable : array[0..9] of string8 = (
        '','Off ','6dB ','12dB','18dB','HFE ','OptC','OptB','OptA','');
      LeftOutputTable : array[0..5] of string8 = (
        '','Phone','Bone ','Spkr ','Rchan','');
      RightOutputTable : array[0..5] of string8 = (
        '','Phone','Bone ','Spkr ','Lchan','');
      LeftInputTable : array[0..9] of string8 = (
        '','Tone ','Mic  ','Ext  ','Lext ','Stng ','WhtN ','SpchN','NBN  ','');
      RightInputTable : array[0..9] of string8 = (
        '','Tone ','Mic  ','Ext  ','Rext ','Stng ','WhtN ','SpchN','NBN  ','');
      OnOffTable : array[0..3] of string8 = ('','Off','On ','');

var   LeftFreqLabel  : array[0..3] of string8;
      RightFreqLabel : array[0..3] of string8;
      Frame : array[0..1] of array[0..5] of char;

const
      LSbox = 1;
      LObox = 2;
      LIbox = 3;
      LLbox = 4;
      FLbox = 5;
      Fbox  = 6;
      FRbox = 7;
      RLbox = 8;
      RIbox = 9;
      RObox = 10;
      RSbox = 11;
      LastActiveBox = 11;

      LstimBox = 12;
      RstimBox = 13;
      LFNbox   = 14;
      RFNbox   = 15;
      LLNbox   = 16;
      RLNbox   = 17;
      WarbleBox= 18;
      PulseBox = 19;
      OutrevBox= 20;
      TlkfwdBox= 21;

      CmdBox   = 22;

      MsgBox   = 23;

      BackWard = false;
      Forward  = true;
      NoBorder     = 0;
      SingleBorder = 1;
      DualBorder   = 2;


implementation


  function AudObj.FreqIndexMatch(F,I:word):boolean;
  begin
    if (F >= FreqTable[I-1]+((FreqTable[I]-FreqTable[I-1]) shr 1))
      and (F < FreqTable[I]+((FreqTable[I+1]-FreqTable[I]) shr 1)) then
      FreqIndexMatch := true
    else
      FreqIndexMatch := false;
  end;

  function AudObj.LevelIndexMatch(L,I:word):boolean;
  begin
    if ((L+2000) div 100 >=  LevelTable[I-1]+((LevelTable[I]-LevelTable[I-1])shr 1)+20)
      and ((L+2000) div 100 < LevelTable[I]+((LevelTable[I+1]-LevelTable[I])shr 1)+20) then
      LevelIndexMatch := true
    else
      LevelIndexMatch := false;
  end;


  function AudObj.FreqIndex(F:integer):integer;
  var i : word;
  begin
    FreqIndex := 0;
    for i := 1 to Box[Fbox].bF do
    begin
      if (F >= FreqTable[I-1]+((FreqTable[I]-FreqTable[I-1]) shr 1))
        and (F < FreqTable[I]+((FreqTable[I+1]-FreqTable[I]) shr 1)) then
      begin
        FreqIndex := i;
        Exit;
      end;
    end;
  end;

  function AudObj.LevelIndex(L:integer):integer;
  var i : word;
  begin
    LevelIndex := 0;
    for i := 1 to Box[LLbox].bF do
    begin
    if ((L+2000) div 100 >=  LevelTable[I-1]+((LevelTable[I]-LevelTable[I-1])shr 1)+20)
      and ((L+2000) div 100 < LevelTable[I]+((LevelTable[I+1]-LevelTable[I])shr 1)+20) then
      begin
        LevelIndex := i;
        Exit;
      end;
    end;
  end;


procedure AudObj.GetCurPos(var X,Y:integer);
begin
  X := Cur.X;
  Y := Cur.Y;
end;

procedure AudObj.GotoBox(B:word);
begin
  If B < 1 then B := 1;
  if B > MaxBox then B := MaxBox;
  Cur.B := B;
  with Box[B] do
  begin
    Cur.F := Field;
    Cur.X := Fp[Cur.F].R.X1;
    Cur.Y := Fp[Cur.F].R.Y1;
  end;
end;


procedure AudObj.GotoField(F:word);
begin
  with Box[Cur.B] do
  begin
    If F < 1 then F := 1;
    if F > bF then F := Bf;
    OldField := Field;
    Field := F;
    Cur.F := F;
    Cur.X := Fp[Cur.F].R.X1;
    Cur.Y := Fp[Cur.F].R.Y1;
  end;
end;

procedure AudObj.UpdateBoxField(B,F:word);
begin
   if (B < 1) or (B > MaxBox) then Exit;
   with Box[B] do
   begin
     if F < 1 then Exit;
     if F > bF then exit;
     OldField := Field;
     Field := F;
   end;
end;

procedure AudObj.SetSecondaryField(B,F:word);
begin
   if (B < 1) or (B > MaxBox) then Exit;
   with Box[B] do
   begin
     if F > bF then exit;
     Field2 := F;
   end;
end;

procedure AudObj.LeftBox;
begin
  if Cur.B < 2 then Cur.B := 2;
  if Cur.B > LastActiveBox then Cur.B := succ(LastActiveBox);
  if pred(Cur.B) = FLbox then dec(Cur.B);
  if pred(Cur.B) = FRbox then dec(Cur.B);
  GotoBox(pred(Cur.B));
end;

procedure AudObj.RightBox;
begin
  if Cur.B < 1 then Cur.B := 0;
  if Cur.B >= LastActiveBox then Cur.B := pred(LastActiveBox);
  if succ(Cur.B) = FLbox then inc(Cur.B);
  if succ(Cur.B) = FRbox then inc(Cur.B);
  GotoBox(succ(Cur.B));
end;

procedure AudObj.UpField;
begin
  if Box[Cur.B].bD then
    GotoField(pred(Cur.F))
  else
    GotoField(succ(Cur.F));
end;

procedure AudObj.DownField;
begin
  if Box[Cur.B].bD then
    GotoField(succ(Cur.F))
  else
    GotoField(pred(Cur.F));
end;




procedure AudObj.SelectBox(B,Px,Py:word);
var Temp : word;
begin
  Cur.B := B;
  Temp := InField(B,Px,Py);
  if Temp > 0 then Cur.F := Temp;
  with Box[B] do
  begin
    OldField := Field;
    Field := Cur.F;
    Cur.X := Fp[Cur.F].R.X1;
    Cur.Y := Fp[Cur.F].R.Y1;
  end;
end;


{returns true if point hit is in box}
function AudObj.InBox(B,Px,Py:word):boolean;
begin
  with Box[B] do
  begin
    InBox := (Px >= Area.X1) and (Px <= Area.X2) and
             (Py >= Area.Y1) and (Py <= Area.Y2);
  end;
end;

{returns field pointer is pointing at. returns 0 if none}
function AudObj.InField(B,Px,Py:word):word;
var I : word;
begin
  InField := 0;
  with Box[B] do
  begin
    for I:= 1 to bF do
    begin
      if (Px >= Fp[i].R.X1) and (Px <= Fp[i].R.X2) and
         (Py >= Fp[i].R.Y1) and (Py <= Fp[i].R.Y2) then
      begin
        InField := I;
        Exit;
      end;
    end;
  end;
end;

{returns box hit was in if active box hit, else returns zero}
function AudObj.ActiveHit(Hx,Hy:word):word;
var i:word;
begin
   ActiveHit := 0;
   for i := 1 to MaxBox do
   begin
     if InBox(i,Hx,Hy) then
     begin
       ActiveHit := i;
       Exit;
     end;
   end;
end;


procedure AudObj.ToggleBox(B:word);
begin
   if B > MaxBox then Exit;
   if B < 1 then Exit;
   if Box[B].Field < 2 then UpdateBoxField(B,2)
     else UpdateBoxField(B,1);
end;



{b=box, X=start Xpos, Y=start Ypos, W=width, H=height,}
{D=field direction, F=border style}
{F=0 no border, F=1 single border, F=2 dual border}
procedure AudObj.InitBox(B,X,Y,W,H,F:integer; D:boolean);
(*
{$IFDEF WINDOWS}
const Frame : array[0..1] of array[0..5] of char = (
               (#32, #$2d,#32,#124,#32,#32),
               (#32,#$2d,#32,#124,#32,#32)     );
$ELSE}

const Frame : array[0..1] of array[0..5] of char = (
               (#218, #196,#191,#179,#192,#217),
               (#201,#205,#187,#186,#200,#188)     );
{--$ENDIF}
*)
  function Bsb(Id:integer):integer;
  begin
    if F = 0 then
      Bsb := Id
    else
      Bsb := Id+1;
  end;
  function Esb(Id:integer):integer;
  begin
    if F = 0 then
      Esb := Id-1
    else
      Esb := Id;
  end;

var i : word;
begin
   with Box[B] do
   begin
     sX := X;
     sY := Y;
     bW := W;
     bH := H;
     bF := H;
     bD := D;
     Area.X1 := Bsb(X);
     Area.Y1 := Bsb(Y);
     Area.X2 := Esb(X+W);
     Area.Y2 := Y+H;
     Field := 0;
     OldField := 0;
     if D=Forward then
     begin
       for i := 1 to bF do
       begin
         Fp[i].R.X1 := Bsb(X);
         Fp[i].R.Y1 := Y+i;
         Fp[i].R.X2 := Esb(X+W);
         Fp[i].R.Y2 := Y+i;
         Fp[i].Size := W;
       end;
     end
     else
     begin
       for i := 1 to bF do
       begin
         Fp[i].R.X1 := Bsb(X);
         Fp[i].R.Y1 := Y+succ(bF-i);
         Fp[i].R.X2 := Esb(X+W);
         Fp[i].R.Y2 := Y+succ(bF-i);
         Fp[i].Size := W;
       end;
     end;
   end;

   if F > 0 then
   begin
     gotoxy(X,Y);
     write(Frame[pred(F)][0]);
     for i := 1 to W do   {top box line}
     begin
       write(Frame[pred(F)][1]);
     end;
     write(Frame[pred(F)][2]);

     for i := 1 to H do   {right box side}
     begin
       gotoxy(X,Y+i);
       write(Frame[pred(F)][3]);
     end;
     gotoxy(X,Y+H+1);

     write(Frame[pred(F)][4]);
     for i := 1 to W do   {bot box line}
     begin
       write(Frame[pred(F)][1]);
     end;
     write(Frame[pred(F)][5]);

     for i := 1 to H do   {left box side}
     begin
       gotoxy(X+W+1,Y+i);
       write(Frame[pred(F)][3]);
     end;
   end;
end;


{B=box number, T=box type, A=array of box data }
{T=0 string array, T=1 int array, 2=freq label 3=integer, 4=level}
procedure AudObj.UpdateBox(B,T:word; var A);
var i : word;
    S : string8;
    Sa : array[0..30] of string8 absolute A;
    Ta : array[0..30] of integer absolute A;
    Ia : integer absolute A;
begin
  with Box[B] do
  begin
    for i := 1 to bF do
    begin
      if (Field <> i) and ((Field2 <> i) or (Field2 = 0)) then
        NormalText
      else
        if (B = Cur.B) and (Field = Cur.F) and (Field = i) then
          CursorText
        else
          InverseText;
      gotoxy(Fp[i].R.X1,Fp[i].R.Y1);
      case T of
       0: write(Sa[i]);
       1: write(Ta[i]:bW);
       2: if i = Field then write(Sa[1])
            else write(Sa[2]);
       3: write(Ia:bW);
       4: begin
            str(Ia div 10,S);
            inc(S[0]);
            S[length(S)] := S[pred(length(S))];
            S[pred(length(S))] := '.';
            write(S:bW);
          end;
      end;
    end;
  end;
end;


{write a msg in the msg box at line L position C}
procedure AudObj.WriteMsg(L,C:word; S:string80);
begin
  with Box[MsgBox] do
  begin
    if L < 1 then Exit;
    if L > bF then Exit;
    if C < 1 then Exit;
    if C > bW then Exit;
    gotoxy(Fp[l].R.X1+C,Fp[L].R.Y1);
    NormalText;
    write(S);
  end;
end;


  procedure AudObj.ErrMsg(S:string80);
  begin
    WriteMsg(Box[MsgBox].bF,1,S);
  end;



constructor AudObj.CreateAud;
begin
  fillchar(box,sizeof(box),0);
  Cur.B := 0;
  Cur.F := 0;
end;


begin
  Aud.CreateAud;

  if LineDrawFonts then
  begin
     LeftFreqLabel[0] := '';
     LeftFreqLabel[1] := 'L'+#186;
     LeftFreqLabel[2] := ' '+#186;
     LeftFreqLabel[3] := '';
     RightFreqLabel[0] := '';
     RightFreqLabel[1] := #186+'R';
     RightFreqLabel[2] := #186+' ';
     RightFreqLabel[3] := '';

     Frame[0] := #218#196#191#179#192#217;
     Frame[1] := #201#205#187#186#200#188;
  end
  else
  begin
     LeftFreqLabel[0] := '';
     LeftFreqLabel[1] := 'L'+#124;
     LeftFreqLabel[2] := ' '+#124;
     LeftFreqLabel[3] := '';
     RightFreqLabel[0] := '';
     RightFreqLabel[1] := #124+'R';
     RightFreqLabel[2] := #124+' ';
     RightFreqLabel[3] := '';
 
     Frame[0] := #32#$2d#32#124#32#32;
     Frame[1] := #32#$2d#32#124#32#32;
  end;

end.

