

{This is a simple terminal program for testing the Audiometer link}
{It is mainly here to make the documentation easier. There are much}
{better terminal programs available on the market. For Windows, you }
{could simply use the built in terminal program. The code is here}
{in case you want to expand on it for some reason. Keep in mind that}
{it plays some tricks to get things to work in polled mode.}
{and that it is really rather messy even in interrupt mode.}

{10 November 1992  written by Michael Day}
{Copyright 1992 Frye Electronics, Inc.}

program Term;
{$IFDEF WINDOWS}
  uses DosCrt,WinProcs,Strings,TermSub,VidSubs;
  {$DEFINE PMODE}
{$ELSE}
  uses Crt,Ticker,TermSub,VidSubs;
{$ENDIF}
{$IFDEF DPMI}
  {$DEFINE PMODE}
{$ENDIF}

{$I+,R+}

var done,ready: boolean;
    Rch,Kch : char;
    Pcnt,Err,i,X,Y: integer;
    s,Pstr: string;
    Ticket: longint;
    IOport,IRQn:word;

procedure ShowExitMsg;
begin
   SelectCursor(Off);
   X := WhereX;
   Y := WhereY;
   gotoxy(1,1);
   write('     -----> Press Ctrl X to exit this program <-----     ');
   gotoxy(X,Y);
   SelectCursor(On);
end;


procedure SendChar(What:char);
begin
   Ticket := GetTickCount+110;  {timeout after 1/4 sec}
   ready := false;
   while not ready do
   begin
     ready := PutStat;
     if ready then
       PutChar(ord(What))
     else
     begin
       If Ticket < GetTickCount then
          ready := true;          {give up if we timeout}
     end;
   end;
end;



procedure ShowData;
var Time : longint;
    done : boolean;

  procedure ReadChar;
  begin
    while true do
    begin
      if GetStat then
      begin
        Rch := GetChar;
        Exit;
      end;

      if FryersOK then  {if interrupt based we can return immediately}
      begin
        done := true;
        Exit;
      end;

      if Time < GetTickCount then   {on polled based, wait til data stops}
      begin
        done := true;
        Exit;
      end;
    end;
  end;

begin
   Rch := GetChar;
   done := false;
   while not(done) do
   begin
     Time := GetTickCount+110;
     if (Rch > #$1f) or (Rch = #10) or (Rch = #13) then
     begin
       S[succ(ord(S[0]))] := Rch;
       inc(S[0]);
     end
     else
     begin
       s[ord(succ(s[0]))] := '^';
       inc(s[0]);
       s[ord(succ(s[0]))] := char(ord(Rch)+$40);
       inc(s[0]);
     end;

     ReadChar;
   end;
   write(s);
   S := '';
   ShowExitMsg;
end;


{---------------------------------------------------------}
{program start}
begin
 {$IFDEF WINDOWS}
    ScreenSize.X := 80;
    ScreenSize.Y := 25;
    WindowSize.X := 1000 {639};
    WindowSize.Y := 800 {439};
    StrCopy(WindowTitle,'Audiometer Command Test');
    InitDosCrtWindow;
    AutoTracking := false;
 {$ENDIF}

  fryersOK := true;  {allow use of fryers if available}
  IOport := 0;
  IRQn := 0;
  pcnt := ParamCount;
  while Pcnt > 0 do
  begin
    PStr := ParamStr(Pcnt);
    case upcase(Pstr[1]) of
      '2': IOPort := 1;
      '3': IOPort := 2;
      '4': IOPort := 3;
      'P': FryersOK := false;  {if P, use polled, not interrupt}
      'I': begin
              while ((Pstr[1] < '0') or (Pstr[1] > '9')) and (length(Pstr) > 0) do
                delete(Pstr,1,1);
              while ((Pstr[length(Pstr)] < '0') or
                    (Pstr[length(Pstr)] > '9')) and (length(Pstr) > 0) do
                dec(Pstr[0]);
              val(Pstr,Irqn,Err);
              if (IrqN > 15) or (Err <> 0) then IrqN := 0;
           end;
    end;
    dec(Pcnt);
  end;

  clrscr;
  cport := IOport;
  IRQnum := IRQn;
  writeln;
  write('Initalizing RS232 Using Com port: ',succ(Cport));
  case InitPort(true) of
    1: begin
         writeln;
         writeln('Warning: FRYERS.COM not found');
         writeln;
         FryersOK := false;
       end;
    2: begin
         writeln;
         writeln('Warning: FRYERS rejected the specified port');
         writeln;
         FryersOK := false;
       end;
    else begin
           if FryersOK then writeln(' using IRQ',succ(IRQn))
             else writeln;
           writeln;
         end;
  end; {case}

  if not(FryersOK) then
  begin
    writeln('Switching to polled mode.');
    writeln('Note: Some data loss may occur (especially in Windows).');
    writeln;
  end;
  writeln('Terminal Program  Copyright 1992 Frye Electronics');
  writeln(' V1.30 as of 10 November 1992');
  writeln;
  ShowExitMsg;
  done := false;
  s := '';
  i := 0;
  SelectCursor(On);

  repeat
    if keypressed then
    begin
      Kch := ReadKey;
      if Kch = #0 then Kch := char(ord(ReadKey) or $80);
      if (Kch = ^X) or (Kch = ^Z) then
        Done := true
      else
        SendChar(Kch);
    end;

    if GetStat then
      ShowData;

  until done;
  closeport;
  gotoxy(1,25);
  writeln;

  {$IFDEF WINDOWS}
    DoneDosCrtWindow;
  {$ENDIF}
end.
