
{IO routines used for terminal emulation}
{10 November 1992 written by Michael Day }
{Copyright 1992 Frye Electronics}

{Warning: don't mix AudFIPP and TermSub unit usage in same program - they don't mix}

unit TermSub;
interface
{$IFDEF WINDOWS}
  uses DosCrt,WinDos,audsubs;
  {$DEFINE PMODE}
{$ELSE}
  uses crt,dos,audsubs,Ticker;
{$ENDIF}
{$IFDEF DPMI}
  {$DEFINE PMODE}
{$ENDIF}

{$I-,R-}

const cport : word = 0;
      IRQnum : byte= 4;
      portbase : word = $3f8;
      FryersOK : boolean = true; {true = use Fryers driver}

const On = true;
      Off = false;

function InitPort(UseInt:boolean):byte;  {init communications port}
procedure Packet(SetOn:boolean);
procedure ClosePort;        {turn off the lights please}

function GetStat:boolean;
function GetChar:char;
function PutStat:boolean;
procedure PutChar(What:byte);

{----------------------------------------------------------}
implementation

{declare the various variables used in the program}
var Perr : word;
    OldUart : array[0..15] of byte;

function GetStat:boolean;
begin
  asm
    mov al,[FryersOK]  {if fryers driver available, use it}
    or al,al
    jnz @Istat
    mov dx,[portbase]  {otherwise use polled IO}
    add dx,5
    in al,dx
    and al,1
    jmp @StatDone
   @Istat:
    mov ah,03
    mov dx,[cport]
    and dx,1
    int $14
    xchg al,ah
    and al,1
   @StatDone:
    mov @Result,al
  end;
end;

function GetChar:char;
begin
  asm
    mov al,[FryersOK]  {if fryers driver available, use it}
    or al,al
    jnz @IcGet
    mov dx,[portbase]  {otherwise use polled IO}
    in al,dx
    jmp @IcGetDone
   @IcGet:
    mov ah,02
    mov dx,[cport]
    and dx,1
    int $14
   @IcGetDone:
    mov @Result,al
  end;
end;

{returns NZ if ready for a char}
function PutStat:boolean;
begin
  asm
    mov al,[FryersOK]  {if fryers driver available, use it}
    or al,al
    jnz @Pstat
    mov dx,[portbase]  {otherwise use polled IO}
    add dx,5
    in al,dx
    and al,$20
    jmp @PStatDone
   @Pstat:
    mov ah,03
    mov dx,[cport]
    and dx,1
    int $14
    xchg al,ah
    and al,$20
   @PStatDone:
    or al,al
    jz @PstatExit
    mov al,1
   @PstatExit:
    mov @Result,al
  end;
end;

procedure PutChar(What:byte);
begin
  asm
    mov al,[FryersOK]  {if fryers driver available, use it}
    or al,al
    jnz @PcGet
    mov dx,[portbase]  {otherwise use polled IO}
    mov al,[what]
    out dx,al
    jmp @PcGetDone
   @PcGet:
    mov ah,01
    mov al,[what]
    mov dx,[cport]
    and dx,1
    int $14
   @PcGetDone:
  end;
end;


{returns 0 if all ok, 1 if fryers not found, 2 if port failure}
function InitPort(UseInt:boolean):byte;
var err : byte;
begin
  InitPort := 0;
  case cport of
    0: Portbase := $3f8;
    1: Portbase := $2f8;
    2: Portbase := $3e8;
    3: Portbase := $2e8;
    else Portbase := $3f8;
  end;

  {init uart for talking to the remote system - 9600 baud 8data, 1stop, no parity}
  ASM CLI; END;
    OldUart[3] := Port[PortBase+3]; {save old info}
    Port[PortBase+3] := $80;
    OldUart[8] := Port[PortBase];
    OldUart[9] := Port[PortBase+1];
    Port[PortBase+0] := 12;    {set uart to 9600 baud}
    Port[PortBase+1] := 0;
    Port[PortBase+3] := $03;
    OldUart[0] := Port[PortBase];
    OldUart[1] := Port[PortBase+1];
    Port[PortBase+1] := 0;          {disable uart interrupts}
    OldUart[4] := Port[PortBase+4];
    Port[PortBase+4] := $0B;   {8 bits no parity}
    OldUart[5] := Port[PortBase+5];
    OldUart[6] := Port[PortBase+6];
  ASM STI; END;

  asm
    mov ax,$ffff  {check if Fryers driver is out there}
    mov dx,0
    int $14
    cmp dx,$ffff
    jnz @notfry
    mov ax,$ff00  {make sure interrupt based input is off}
    mov dx,[Cport]
    and dx,1
    mov ch,$ff
    mov cl,0
    int $14
   @notfry:

    mov ax,$ffff  {check if Fryers driver is out there}
    mov dx,0
    int $14
    cmp dx,$ffff
    mov al,1
    jnz @done

    mov ax,$ff0a     {select the desired port to use}
    mov ch,$ff
    mov cl,[IRQnum]  {use the selected IRQ number}
    mov bx,[cport]
    shr bx,1         {select the uart to use}
    and bx,1
    mov dx,[cport]  {init the port}
    and dx,1
    INT $14
    cmp ah,$ff
    mov al,2
    jz @done

    mov al,[UseInt] {if don't use interrupt, don't turn it on}
    or al,al
    jz @notInt
    mov ax,$ff00
    mov dx,[Cport]  {if Fryers was found,}
    and dx,1
    mov ch,$ff     {make sure interrupt based input is on}
    mov cl,$ff
    int $14
   @notint:

    mov ax,$ff08  {disable CTS/RTS flow control}
    mov cx,$ff00
    mov dx,[Cport]
    and dx,1
    int $14

    mov ax,$ff05  {make sure dtr is on}
    mov cx,$ffff
    mov dx,[Cport]
    and dx,1
    int $14

    mov ax,$ff04  {make sure rts is on}
    mov cx,$ffff
    mov dx,[Cport]
    and dx,1
    int $14

    mov ah,$00     {init to 9600 baud, no parity, one stop}
    mov al,$e3
    mov dx,[Cport]
    and dx,1
    int $14

    mov al,0
   @done:
    mov [err],al
  end;

  InitPort := Err;
end;

procedure Packet(SetOn:boolean);
begin
  asm
    mov ax,$ff10
    mov dx,[Cport]
    and dx,1
    mov ch,$ff
    mov cl,$00     {default packet based op as off}
    mov bl,[SetOn] {if don't use packets, don't turn it on}
    or bl,bl
    jz @notPac
    mov cl,$ff     {make sure packet based op is on}
   @notPac:
    int $14
  end
end;

procedure ClosePort;
begin
  asm
    mov ax,$ff00  {make sure interrupt based input is off}
    mov dx,[Cport]
    and dx,1
    mov ch,$ff
    mov cl,0
    int $14
  end;

  ASM; CLI; END;
    Port[PortBase+3] := $80;
    Port[PortBase] := OldUart[8];  {restore old baudrate}
    Port[PortBase+1] := OldUart[9];
    Port[PortBase+3] := $03;
    Port[PortBase+1] := OldUart[1];  {and the rest of the stuff}
    Port[PortBase+4] := OldUart[4];
    Port[PortBase+3] := OldUart[3];
  ASM STI; END;

end;


{--------}
begin
  fillchar(OldUart,sizeof(OldUart),0);
end.
