{misc video routines}
{9 Nov 1992  written by Michael Day}
{Copyright 1992 Frye Electronics}


Unit VidSubs;

interface
{$IFDEF WINDOWS}
  uses DosCrt, WinProcs;
  {$DEFINE PMODE}
{$ELSE}
  uses crt;
{$ENDIF}
{$IFDEF DPMI}
  {$DEFINE PMODE}
{$ENDIF}
{$IFNDEF PMODE}
   const Seg0040 = $0040;  SegA000 = $A000;
         SegB000 = $B000;  SegB800 = $B800;
{$ENDIF}

{$IFNDEF WINDOWS}
  const LineDrawFonts : boolean = true;
{$ENDIF}

const mono = 7;
      On = true;
      Off = false;
      CursorCount : byte = 0;
      OldCur : word = 0;

var CrtMode : byte;

procedure InverseText;
procedure NormalText;
procedure BrightText;
procedure CursorText;
procedure IncCurCnt;
{$IFNDEF WINDOWS}
  procedure SelectCursor(CurOn:boolean);
{$ENDIF}

implementation

{+++++++++++++++++++++++++++++++++}
procedure InverseText;
begin
  if CrtMode = mono then
    TextAttr := $10
  else
    TextAttr := $70;
end;

procedure NormalText;
begin
  if CrtMode = mono then
    TextAttr := $01
  else
    TextAttr := $07;
end;

procedure BrightText;
begin
  TextAttr := TextAttr+$08;
end;

procedure CursorText;
begin
   if CursorCount = 0 then
     InverseText
   else
     Normaltext;
end;

procedure IncCurCnt;
begin
   inc(CursorCount);
   if CursorCount > 1 then
     CursorCount := 0;
end;

{$IFNDEF WINDOWS}
  procedure SelectCursor(CurOn:boolean);
  begin
    if CurOn then
    begin
      asm
        mov cx,[OldCur]
        mov ah,$01
        int $10
      end;
    end
    else
    begin
      asm
        mov ah,$03
        mov bx,0
        int $10
        mov [OldCur],cx

        mov ah,$01
        mov cx,$2000
        int $10
      end;
    end;
  end;
{$ENDIF}

{-----------------------------}
begin
  {$IFDEF WINDOWS}
     CrtMode := 3;
  {$ELSE}
     CrtMode := mem[Seg0040:$49];
  {$ENDIF}
end.
