
{Sample ASCII transmission test program for FA1x series audiometers}
{ Copyright 1992,1994,1997 Frye Electronics  -- writen by Michael Day }
{ V2.02 as of 30 Sept 1997 }
unit AudGram;
interface
{$I PLATFORM.INC}

{$IFDEF WIN16}
  {$R AUD.RES}
  uses DosCrt,WinTypes,strings,agsub,audsubs,VidSubs,TermSub;
{$ENDIF}
{$IFDEF ISDOS}
  uses crtx,agsub,audsubs,VidSubs,TermSub;
{$ENDIF}
{$IFDEF WIN32}
  uses Windows,agsub,audsubs,VidSubs,TermSub;
{$ENDIF}

procedure RunProgram;

const UsePort : word = 1;
const UseIRQ : word = 0;


{$I+,R+}
implementation


{-----------------------------------------------}
{Program exit procedure to restore things back like they should be}

var ExitSave:pointer;
{$F+} procedure PrgExit;
begin
  ExitProc := ExitSave;
  if PortOpen then
    ClosePort;
  SelectCursor(On);
 {$IFDEF WIN16}
   DoneDosCrtWindow;
 {$ENDIF}  
end;

{Show the copyright message}
procedure DoTitle;
begin
  gotoxy(70,1);
  write('Audiogram');
  gotoxy(70,2);
  write('V2.02');
  if DoASCII then write(' (A)') else write(' (P)');
  gotoxy(70,3);
  write('(C) 1997');
  gotoxy(70,4);
  write('Frye Elec');
  gotoxy(70,5);
  write('30 Sep 97');
end;


{-----------------------------------------------------------------}

procedure RunProgram;
var Pcnt : word;
    Pstr : str255;
    Err:integer;

begin
 {$IFDEF WIN16}           {init WinCrt stuff}
    ScreenSize.X := 80;
    ScreenSize.Y := 25;
    WindowSize.X := 1000 {639};  {make it as big as it will go}
    WindowSize.Y := 800 {439};
    StrCopy(WindowTitle,'AUDGRAM');
    DosCrtFont := OEM_FIXED_FONT;
    InitDosCrtWindow;
    AutoTracking := false;
 {$ENDIF}

   gotoxy(1,25);
   writeln;
   writeln;
   writeln('Audiogram  Copyright 1992,1997 Frye Electronics');
   writeln('Version 2.02  as of 30 Sept 1997');

  PatReq := false;
  DoASCII := true;

   {$IFDEF WIN32}
     SetConsoleCtrlHandler(nil,false);
     if not(LoadFryers) then
     begin
       writeln;
       writeln('Error: FRYERS32.DLL not loaded, or bad version.');
       Halt(1);
     end;
   {$ENDIF}

  ExitSave := ExitProc;
  ExitProc := @PrgExit;

  UsePort := 0;
  UseIRQ := 0;
  pcnt := ParamCount;
  while Pcnt > 0 do
  begin
    PStr := ParamStr(Pcnt);
    case upcase(Pstr[1]) of
     '1','2','3','4','5','6','7','8','9' : UsePort := ord(Pstr[1]) and $f;
     'R': PatReq := true;    {must press pat rsp switch to accept values}
     'P': DoASCII := false;   {use packet instead of ASCII mode}
     'I': begin
            while ((Pstr[1] < '0') or (Pstr[1] > '9')) and (length(Pstr) > 0) do
              delete(Pstr,1,1);
            while ((Pstr[length(Pstr)] < '0') or
                  (Pstr[length(Pstr)] > '9')) and (length(Pstr) > 0) do
              SetLength(Pstr,length(Pstr)-1);
            val(Pstr,UseIRQ,Err);
            if (UseIRQ> 15) or (Err <> 0) then UseIRQ:= 0;
          end; {case 'I'}
     'C': begin
            while ((Pstr[1] < '0') or (Pstr[1] > '9')) and (length(Pstr) > 0) do
              delete(Pstr,1,1);
            while ((Pstr[length(Pstr)] < '0') or
                  (Pstr[length(Pstr)] > '9')) and (length(Pstr) > 0) do
              SetLength(Pstr,length(Pstr)-1);
            val(Pstr,UsePort,Err);
            if (UsePort > 15) or (Err <> 0) then UsePort := 0;
          end; {case 'I'}
    end; {case}
    dec(Pcnt);
  end;
  if UsePort < 1 then UsePort := 1;
  {$IFDEF WIN32}
    if UsePort > 15 then UsePort := 1;
    cport := pred(UsePort);
  {$ELSE}
    if UsePort > 4 then UsePort := 1;
    cport := pred(UsePort) and 1;
  {$ENDIF}

   if DoASCII then
     writeln('ASCII transmission via COM',UsePort)
   else
     writeln('Packet transmission via COM',UsePort);

   FryersOK := true;   {default to fryers ok}
   writeln('Initializing port: COM',UsePort);
   if not InitAGPort(UsePort,UseIRQ) then
   begin
     FryersOK := false;
     {$IFNDEF WIN32}
       writeln('  ** Error : FRYERS.COM not found **');
     {$ELSE}
       writeln('  ** Error : FRYERS32.DLL not found **');
     {$ENDIF}
     writeln('Warning: Occasional data loss may occur');
     writeln;
     if DoASCII then
     begin
       {$IFNDEF WIN32}
         writeln('Warning: FRYERS.COM should be run before using this program');
         writeln('in ASCII mode to prevent possible data loss from the audiometer.');
       {$ELSE}
         writeln('Warning: FRYERS32.DLL was not found or the DLL could not open the port.');
         writeln('Using Polled IO. There may be possible data loss from the audiometer.');
       {$ENDIF}
       writeln;
       writeln(' --- Now switching to polled IO --- ');
       writeln;
       writeln('  >>  Press any key to continue  <<');
     end
     else
     begin
       {$IFNDEF WIN32}
         writeln('FRYERS.COM must be run before you can use this program.');
       {$ELSE}
         writeln('FRYERS32.DLL must be in the Windows directory before can use this program.');
       {$ENDIF}
       writeln('in FIPP packet mode');
       Halt(1);
     end;
     if getkey = #0 then if Getkey = #0 then {nop};
     {switch to polled io?}
   end;
   writeln;
   writeln('Port initialized');

   done := false;
   NormalText;
   clrscr;
   SelectCursor(Off);
   NormalText;
   InitGraph;       {init stuff}
   drawgraph;
   DoTitle;
   repeat
     DoSpin;        {blinking lights to show we are operational}
     chk := #255;
     GetPanel;      {grab a copy of the front panel state}
     Ltrg := false;
     Rtrg := false;
     if keywaiting then
     begin
       chk := GetKey;
       case chk of
        'L','l': begin                {no rsp or clear left chan}
                   Ltrg := true;
                   Ltgl := not(Ltgl);
                 end;
        'R','r': begin                {no rsp or clear right chan}
                   Rtrg := true;
                   Rtgl := not(Rtgl);
                 end;
       end;
     end;
     UpdateRegs;           {update internal audiogram registers}
     UpdateGraph;          {update the screen}
     case chk of
       #$1b,'Q','q': Done := true;   {quit?}
       'c','C': begin
                   clrscr;
                   NormalText;  {clear the screen and start over}
                   InitGraph;
                   drawgraph;
                   DoTitle;
                 end;
       't','T' : Trigger;  {(for ascii) forced request of front panel data}
     end; {case ch of}
   until done;
   RestorePacketMode;    {force audiometer back into packet mode}
   SelectCursor(On);
   ClosePort;            {turn off the lights when you leave}
   {$IFDEF WIN16}
     DoneDosCrtWindow;
   {$ENDIF}
end;

end.
