{misc routines used by AUDKEY program}
{09 November 1992  written by Michael Day}
{Copyright 1992 Frye Electronics, Inc.}

unit hets;
interface
{$I PLATFORM.INC}

{$IFDEF WIN16}
  uses DosCrt;
{$ENDIF}
{$IFDEF ISDOS}
  uses crtx;
{$ENDIF}
{$IFDEF WIN32}
{  uses Windows;}
{$ENDIF}

{;------------------------------------------------------- }
{;the following are sent out the rs232 port on request }
{;or recieved from serial port. }
type HeDataRec = packed record  {64 bytes}

    SNPWEN : word;     {sound control flags}
    DUMMY  : word;                {DUMMY MEMORY AREA TO FILL IT TO even}

    LEDIMG : array[0..1] of byte; {Keyboard LED output image}
    RFLCLK : array[0..2] of byte; {Right filter clock select image}
    LFLCLK : array[0..2] of byte; {Left filter clock select image}

    RFMA   : byte; {RFMA+0}       {;Right filter/attenuator port image}
    RDPW1  : byte; {RFMA+1}
    RDPW0  : byte; {RFMA+2}

    LFMA   : byte; {LFMA+0}       {Left filter/attenuator port image}
    LDPW1  : byte; {LFMA+1}
    LDPW0  : byte; {LFMA+2}

    RFSEL  : byte;                {;hi nib=dest mux, lo nib=gross atten}
    LFSEL  : byte;                {;hi nib=dest mux, lo nib=gross atten}

    RFMUX  : byte;                {;hi nib=src mux, lo nib=filter mode}
    LFMUX  : byte;         	  {;hi nib=src mux, lo nib=filter mode}

    SAAIMG : array[0..31] of byte;{;Sound chip control image registers}

    KEYIMG : array[0..5] of byte; {Keyboard port input image}

    TDUMMY  : ARRAY[0..3] OF byte; {TICK DUMMY MEMORY AREA TO make even}
    {TICKER : byte; }               {;10ms pre-counter}
    {TIMCNT : array[0..3] of byte;} {;10ms Clock timer register}

  end;

  HeMemArray = array[0..31] of word; {direct byte copy of HeDataRec}
  BMemArray = array[0..63] of byte; {direct byte copy of HeDataRec}

{;------------------------------------------------------- }
TYPE EEDATATYPE = array[0..63] of word;  {EEROM image}


var EEDATA : EEdataType;
    EEStatus : word;                {eerom status result}
    MEMIMG : HeDataRec;             {HE memory image}
    HEMAN  : HeMemArray absolute MEMIMG;
    BMAN   : BMemArray absolute MEMIMG;
    MIOIMG : byte;                  {Misc cpu io port image}

    TESTFLGS : byte;
    KEYS   : array[0..10] of byte;
    snpwfg : boolean;
    SFREQ  : word;

    ERCNT : integer;

type string8 = string[8];
type str255 = string[255];

procedure MakeKeys;
function bitswap(value:byte):byte;
function HexB(B:byte):string8;
function HexW(W:word):string8;


implementation
type HexType = array[0..15] of char;
const Hex : HexType = ('0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');

function HexB(B:byte):string8;
begin
  HexB := Hex[B shr 4] + Hex[B and $F];
end;

function HexW(W:word):string8;
begin
  HexW := HexB(W shr 8) + HexB(W and $FF);
end;


function bitswap(value:byte):byte;
var v,i : byte;
begin
  v := 0;
  for i := 0 to 7 do
    v := v shl 1 + ((value shr i) and 1);
  bitswap := v;
end;


function GreyConv(value:byte):byte;
begin
   case value of
    0: GreyConv := 0;
    1: GreyConv := 31;
    2: GreyConv := 15;
    3: GreyConv := 16;
    4: GreyConv := 7;
    5: GreyConv := 24;
    6: GreyConv := 8;
    7: GreyConv := 23;
    8: GreyConv := 3;
    9: GreyConv := 28;
    10: GreyConv := 12;
    11: GreyConv := 19;
    12: GreyConv := 4;
    13: GreyConv := 27;
    14: GreyConv := 11;
    15: GreyConv := 20;
    16: GreyConv := 1;
    17: GreyConv := 30;
    18: GreyConv := 14;
    19: GreyConv := 17;
    20: GreyConv := 6;
    21: GreyConv := 25;
    22: GreyConv := 9;
    23: GreyConv := 22;
    24: GreyConv := 2;
    25: GreyConv := 29;
    26: GreyConv := 13;
    27: GreyConv := 18;
    28: GreyConv := 5;
    29: GreyConv := 26;
    30: GreyConv := 10;
    31: GreyConv := 21;
   else GreyConv := 0; 
   end;
{  GreyConv := value; }
end;


procedure MakeKeys;
var ix : byte;
begin

  Keys[0] := ((Memimg.KeyImg[1] shr 4) and $0E)+
             (Memimg.KeyImg[3] and $E0);      {PB sw}
  Keys[1] := ((Memimg.KeyImg[2] shr 4) and $f)+
             (Memimg.KeyImg[5] and $f0);      {PB sw}

  Keys[2] := GreyConv(((Memimg.KeyImg[0] shr 5) and $7) shl 2); {rsim}
  Keys[3] := GreyConv(((Memimg.KeyImg[4] shr 5) and $7) shl 2); {lsim}
  Keys[4] := GreyConv(((Memimg.KeyImg[0] shr 3) and 3) shl 3);  {rdest}
  Keys[5] := GreyConv(((Memimg.KeyImg[4] shr 3) and 3) shl 3);  {ldest}
  Keys[6] := GreyConv((Memimg.KeyImg[2] and $f) shl 1);  {freq}
  Keys[7] := GreyConv( Memimg.KeyImg[1] and $1f);        {rlevel}
  Keys[8] := GreyConv((Memimg.KeyImg[0] and 7) shl 2);   {rsrc}
  Keys[9] := GreyConv( Memimg.KeyImg[3] and $1f);        {llevel}
  Keys[10]:= GreyConv((Memimg.KeyImg[4] and 7) shl 2);   {Lsrc}

  Keys[0] := memimg.Tdummy[0];
  Keys[1] := memimg.Tdummy[1];


end;

begin
  fillchar(eedata,sizeof(eedata),0);
  fillchar(memimg,sizeof(memimg),0);
  eestatus := 0;
  ercnt := 0;
  mioimg := 0;
  testflgs := 0;
  snpwfg := false;
  sfreq := 1000;
  memimg.SNPWEN := 0;

  testflgs := $10;
  memimg.LDPW0 := 128;
  memimg.LDPW1 := 128;
  memimg.RDPW0 := 128;
  memimg.RDPW1 := 128;
  memimg.saaimg[$1c] := 1;
  fillchar(keys,sizeof(keys),0);
end.
