

{This is a simple terminal program for testing the Audiometer link}
{It is mainly here to make the documentation easier. There are much}
{better terminal programs available on the market. For Windows, you }
{could simply use the built in terminal program. The code is here}
{in case you want to expand on it for some reason. Keep in mind that}
{it plays some tricks to get things to work in polled mode.}
{and that it is really rather messy even in interrupt mode.}

{30 Sept 1997  written by Michael Day}
{Copyright 1992,1997 Frye Electronics, Inc.}

unit TermUnit;
interface
{$I PLATFORM.INC}

{$IFDEF WIN16}
  uses DosCrt,WinProcs,Strings,TermSub,VidSubs,AudSubs;
{$ENDIF}
{$IFDEF ISDOS}
  uses Crtx,Ticker,TermSub,VidSubs,AudSubs;
{$ENDIF}
{$IFDEF WIN32}
  uses Windows,TermSub,VidSubs,AudSubs;
{$ENDIF}

procedure RunProgram;

const UsePort : word = 1;
const UseIRQ : word = 0;

{$I+,R+}
implementation

var done,ready: boolean;
    Rch,Kch : char;
    Pcnt,Err,i,X,Y: integer;
    s,Pstr: str255;
    Ticket: longint;


{-----------------------------------------------}
{Program exit procedure to restore things back like they should be}

var ExitSave:pointer;
{$F+} procedure PrgExit;
begin
  ExitProc := ExitSave;
  if PortOpen then
    ClosePort;
 {$IFDEF WIN16}
   DoneDosCrtWindow;
 {$ENDIF}  
end;

procedure ShowExitMsg;
begin
   SelectCursor(Off);
 {$IFDEF ISDOS}
   WhereXY(X,Y);
 {$ELSE}
   X := WhereX;
   Y := WhereY;
 {$ENDIF}
   gotoxy(1,1);
   write('     -----> Press Ctrl X to exit this program <-----     ');
   gotoxy(X,Y);
   SelectCursor(On);
end;


procedure SendChar(What:char);
begin
   Ticket := GetTickCount+110;  {timeout after 1/4 sec}
   ready := false;
   while not ready do
   begin
     ready := PutStat;
     if ready then
       PutChar(ord(What))
     else
     begin
       If Ticket < GetTickCount then
          ready := true;          {give up if we timeout}
     end;
   end;
end;



procedure ShowData;
var Time : longint;
    done : boolean;

  procedure ReadChar;
  begin
    while true do
    begin
      if GetStat then
      begin
        Rch := GetChar;
        Exit;
      end;

      if FryersOK then  {if interrupt based we can return immediately}
      begin
        done := true;
        Exit;
      end;

      if Time < GetTickCount then   {on polled based, wait til data stops}
      begin
        done := true;
        Exit;
      end;
    end;
  end;

begin
   Rch := GetChar;
   done := false;
   S := '';
   while not(done) do
   begin
     Time := GetTickCount+110;
     if (Rch > #$1f) or (Rch = #10) or (Rch = #13) then
     begin
       S := S+Rch;
     end
     else
     begin
       S := S+'^'+char(ord(Rch)+$40);
     end;

     ReadChar;
   end;
   write(s);
{//   S := '';}
   ShowExitMsg;
end;


{---------------------------------------------------------}
{program start}
procedure RunProgram;
begin
 {$IFDEF WIN16}
    ScreenSize.X := 80;
    ScreenSize.Y := 25;
    WindowSize.X := 1000 {639};
    WindowSize.Y := 800 {439};
    StrCopy(WindowTitle,'Audiometer Command Test');
    InitDosCrtWindow;
    AutoTracking := false;
 {$ENDIF}


    {$IFDEF WIN32}
     SetConsoleCtrlHandler(nil,false);
     if not(LoadFryers) then
     begin
       writeln;
       writeln('Error: FRYERS32.DLL not loaded, or bad version.');
       Halt(1);
     end;
   {$ENDIF}

  ExitSave := ExitProc;
  ExitProc := @PrgExit;

  fryersOK := true;  {allow use of fryers if available}
  UsePort := 0;
  UseIRQ := 0;
  pcnt := ParamCount;
  while Pcnt > 0 do
  begin
    PStr := ParamStr(Pcnt);
    case upcase(Pstr[1]) of
     '1','2','3','4','5','6','7','8','9' : UsePort := ord(Pstr[1]) and $f;
     'B': begin
            val(Pstr,baudrate,err);
          end;
     'P': FryersOK := false;  {if P, use polled, not interrupt}
     'I': begin
            while ((Pstr[1] < '0') or (Pstr[1] > '9')) and (length(Pstr) > 0) do
              delete(Pstr,1,1);
            while ((Pstr[length(Pstr)] < '0') or
                  (Pstr[length(Pstr)] > '9')) and (length(Pstr) > 0) do
              SetLength(Pstr,length(Pstr)-1);
            val(Pstr,UseIRQ,Err);
            if (UseIRQ > 15) or (Err <> 0) then UseIRQ := 0;
          end; {case 'I'}
     'C': begin
            while ((Pstr[1] < '0') or (Pstr[1] > '9')) and (length(Pstr) > 0) do
              delete(Pstr,1,1);
            while ((Pstr[length(Pstr)] < '0') or
                  (Pstr[length(Pstr)] > '9')) and (length(Pstr) > 0) do
              SetLength(Pstr,length(Pstr)-1);
            val(Pstr,UsePort,Err);
            if (UsePort > 15) or (Err <> 0) then UsePort := 0;
          end; {case 'I'}
    end; {case}
    dec(Pcnt);
  end;
  if UsePort < 1 then UsePort := 1;
  {$IFDEF WIN32}
    if UsePort > 15 then UsePort := 1;
    cport := pred(UsePort);
  {$ELSE}
    if UsePort > 4 then UsePort := 1;
    cport := pred(UsePort) and 1;
  {$ENDIF}

  clrscr;
  writeln;
  write('Initalizing RS232 Using COM',UsePort,' at ',Baudrate,' ');
  case InitPort(UsePort,UseIRQ,true) of
    1: begin
         writeln;
         writeln('Warning: FRYERS not found');
         writeln;
         FryersOK := false;
       end;
    2: begin
         writeln;
         writeln('Warning: FRYERS rejected the specified port');
         writeln;
         FryersOK := false;
       end;
    else begin
           {$IFNDEF WIN32}
           if FryersOK then writeln('with IRQ',IRQs)
             else writeln;
           {$ELSE}
             writeln;
           {$ENDIF}
           writeln;
         end;
  end; {case}

  if not(FryersOK) then
  begin
    writeln('Switching to polled mode.');
    writeln('Note: Some data loss may occur (especially in Windows).');
    writeln;
  end;
  writeln('Terminal Program  Copyright 1997 Frye Electronics');
  writeln(' V2.02 as of 30 Sept 1997');
  writeln;
  ShowExitMsg;
  done := false;
  s := '';
  i := 0;
  SelectCursor(On);

  repeat
    if keywaiting then
    begin
      Kch := GetKey;
      {$IFNDEF WIN32}
        if Kch = #0 then Kch := char(ord(getKey) or $80);
      {$ENDIF}
      if (Kch <> #0) and (Kch <> #255) then
      begin
        if (Kch = ^X) or (Kch = ^Z) then
          Done := true
        else
          SendChar(Kch);
      end;
    end;

    if GetStat then
      ShowData;

  until done;
  closeport;
  gotoxy(1,25);
  writeln;

  {$IFDEF WIN16}
    DoneDosCrtWindow;
  {$ENDIF}
end;

end.
