unit BumpUnit;
interface
uses
{$IFDEF WIN32}
  Windows,
{$ELSE}
  WinTypes,WinProcs,
{$ENDIF}
  Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,mmSystem, ExtCtrls, Spin;

{$I FRYEREGS.INC}

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Label1: TLabel;
    DoMeButton: TButton;
    StatusLabel: TLabel;
    Label3: TLabel;
    Edit2: TEdit;
    Label4: TLabel;
    Edit3: TEdit;
    Edit4: TEdit;
    Label5: TLabel;
    Edit5: TEdit;
    Label6: TLabel;
    TestType: TRadioGroup;
    SpinLabel: TLabel;
    Edit6: TEdit;
    Label2: TLabel;
    PollDelaySpinEdit: TSpinEdit;
    Label7: TLabel;
    EditAX: TEdit;
    EditBX: TEdit;
    EditCX: TEdit;
    EditDX: TEdit;
    EditSI: TEdit;
    EditDI: TEdit;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    DisplayStatus: TCheckBox;
    CmdCntEdit: TEdit;
    Label14: TLabel;
    SuccessEdit: TEdit;
    Label15: TLabel;
    Label16: TLabel;
    FailureRatioEdit: TEdit;
    NakEdit: TEdit;
    Label17: TLabel;
    ILLEdit: TEdit;
    Label18: TLabel;
    PollRspEdit: TEdit;
    Label19: TLabel;
    AckEdit: TEdit;
    Label20: TLabel;
    Timer1: TTimer;
    AbdErrorEdit: TEdit;
    PktRetryEdit: TEdit;
    PIflagsEdit: TEdit;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    TXinfoEdit: TEdit;
    Label24: TLabel;
    GenTimerEdit: TEdit;
    UartErrorEdit: TEdit;
    IStateEdit: TEdit;
    PollTimerEdit: TEdit;
    Label25: TLabel;
    Label26: TLabel;
    Label27: TLabel;
    Label28: TLabel;
    SeqErrEdit: TEdit;
    SeqCharEdit: TEdit;
    Label29: TLabel;
    Label30: TLabel;
    CheckSumEdit: TEdit;
    Label32: TLabel;
    RcvDataEdit: TEdit;
    Label33: TLabel;
    OneTimeButton: TButton;
    QTButton: TButton;
    BaudLabel: TLabel;
    SendLabel: TLabel;
    BeepLabel: TLabel;
    PortSelectOld: TRadioGroup;
    IRQSpinEdit: TSpinEdit;
    IRQLabel: TLabel;
    CloseButton: TButton;
    FstrLabel: TLabel;
    VerLabel: TLabel;
    QTflagsEdit: TEdit;
    Label34: TLabel;
    IRQused: TLabel;
    GraphBox: TPaintBox;
    ShowGraph: TCheckBox;
    Label35: TLabel;
    Label36: TLabel;
    Label37: TLabel;
    Label38: TLabel;
    Label39: TLabel;
    Label40: TLabel;
    Label41: TLabel;
    LastErrorLabel: TLabel;
    FastTestButton: TButton;
    EventReadSizeEdit: TEdit;
    EventReadSizeLabel: TLabel;
    PortEventWriteSizeEdit: TEdit;
    EventWriteSizeLabel: TLabel;
    GoodPollEdit: TEdit;
    BadPollEdit: TEdit;
    Label31: TLabel;
    Label42: TLabel;
    BadQTEdit: TEdit;
    AutoQTEdit: TEdit;
    Label45: TLabel;
    Label46: TLabel;
    ManQTEdit: TEdit;
    Label47: TLabel;
    CmdSendCountEdit: TEdit;
    Label48: TLabel;
    Bevel1: TBevel;
    NoBeepCheckBox: TCheckBox;
    TimerTickSpinEdit: TSpinEdit;
    Label43: TLabel;
    Bevel2: TBevel;
    DebRCntEdit: TEdit;
    DebWCntEdit: TEdit;
    DebRcntLabel: TLabel;
    DebWCntLabel: TLabel;
    DebRdEdit: TEdit;
    DebWrEdit: TEdit;
    eRLabel: TLabel;
    eWLabel: TLabel;
    DebugCheckBox: TCheckBox;
    CmdEdit: TEdit;
    eCmdLabel: TLabel;
    QuietCheckBox: TCheckBox;
    AutoBaudCheckBox: TCheckBox;
    CmdTimeLabel: TLabel;
    Label54: TLabel;
    PktTimeLabel: TLabel;
    PacketTimeLabel: TLabel;
    CmdDelaySpinEdit: TSpinEdit;
    Label56: TLabel;
    QcntSpinEdit: TSpinEdit;
    Label57: TLabel;
    WaitSleepSpinEdit: TSpinEdit;
    WaitSleepLabel: TLabel;
    FailCountLabel: TLabel;
    Label60: TLabel;
    RspFailEdit: TEdit;
    Label59: TLabel;
    Panel1: TPanel;
    LeftHLLabel: TLabel;
    RightHLLabel: TLabel;
    FreqLabel: TLabel;
    LeftOutLabel: TLabel;
    RightOutLabel: TLabel;
    LeftSrcLabel: TLabel;
    RightSrcLabel: TLabel;
    ReadFailCountEdit: TEdit;
    ReadPortCountEdit: TEdit;
    Label44: TLabel;
    Label52: TLabel;
    LstimulusLabel: TLabel;
    RstimulusLabel: TLabel;
    KillButton: TButton;
    HoldoffSpinEdit: TSpinEdit;
    Label49: TLabel;
    Label50: TLabel;
    Label51: TLabel;
    PortSelect: TComboBox;
    procedure DoMeButtonClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure Edit6DblClick(Sender: TObject);
    procedure PollDelaySpinEditChange(Sender: TObject);
    procedure PollDelaySpinEditDblClick(Sender: TObject);
    procedure NakEditDblClick(Sender: TObject);
    procedure ILLEditDblClick(Sender: TObject);
    procedure PollRspEditDblClick(Sender: TObject);
    procedure AckEditDblClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure PollTimerEditDblClick(Sender: TObject);
    procedure IStateEditDblClick(Sender: TObject);
    procedure UartErrorEditDblClick(Sender: TObject);
    procedure GenTimerEditDblClick(Sender: TObject);
    procedure SeqCharEditDblClick(Sender: TObject);
    procedure TXinfoEditDblClick(Sender: TObject);
    procedure PIflagsEditDblClick(Sender: TObject);
    procedure PktRetryEditDblClick(Sender: TObject);
    procedure AbdErrorEditDblClick(Sender: TObject);
    procedure SeqErrEditDblClick(Sender: TObject);
    procedure CheckSumEditDblClick(Sender: TObject);
    procedure RcvDataEditDblClick(Sender: TObject);
    procedure OneTimeButtonClick(Sender: TObject);
    procedure QTButtonClick(Sender: TObject);
    procedure PortSelectOldClick(Sender: TObject);
    procedure IRQSpinEditChange(Sender: TObject);
    procedure CloseButtonClick(Sender: TObject);
    procedure GraphBoxPaint(Sender: TObject);
    procedure FastTestButtonClick(Sender: TObject);
    procedure IdleTime(Sender: TObject; var Done: Boolean);
    procedure TimerTickSpinEditChange(Sender: TObject);
    procedure KillButtonClick(Sender: TObject);
    procedure HoldoffSpinEditChange(Sender: TObject);
    procedure HoldoffSpinEditDblClick(Sender: TObject);
    procedure PortSelectClick(Sender: TObject);
  private
    { Private declarations }
    Spin : integer;
    PollDelayTime : integer;
    procedure Spinner;
    procedure GetPollDelay;
    procedure UpdateDebugStatus;
    procedure StopMePlease;
  public
    procedure UpdateComPortList;
 {//   Regs : F_RegsType;}
    { Public declarations }
  end;

var
  Form1: TForm1;

var Debrs,Debws,DebCs : string[128];

const  NoShow = -32768;

const SlowTest = 1;
const FastTest = 2;
const Idle = 0;
const KillMe : boolean = false;
const Suicide : boolean = false;
const IamBusy : boolean = false;
const IamRunning : boolean = false;
const IamWorkingOnIt : boolean = false;
const Initialized : boolean = false;
const HoldoffAvailable : boolean = false;
const KillCount : integer = 0;
const comport : integer = 0;
const StartTime : integer = 0;
const Seq : array[0..9] of integer = (0,0,0,0,0,0,0,0,0,0);
const Temp : array[0..9] of integer = (0,0,0,0,0,0,0,0,0,0);
const Avg : array[0..9] of integer = (0,0,0,0,0,0,0,0,0,0);
const Count : integer = 0;
const MaxCount = 10;
type PArrayType = array[0..99] of word;
type RcvType = PArrayType;
type PAType = ^PArrayType;
const SndPtr : PAType = nil;
const ErrorCount : integer = 0;
const CommandCount : integer = 0;
const SuccessCount : integer = 0;
const NAKCount : integer = 0;
const ILLCount : integer = 0;
const ACKCount : integer = 0;
const POLCount : integer = 0;
const PIflags : integer = 0;
const AbdErr : integer = 0;
const PktRetry : integer = 0;
const SeqChar : integer = 0;
const SeqErr : integer = 0;
const TXinfo : integer = 0;
const GenTimer : integer = 0;
const UartError : integer = 0;
const IState : integer = 0;
const PollTimer : integer = 0;
const HoldoffTime : integer = 0;
const CheckSumData : integer = 0;
const Stv : integer = 0;
const Qterm : boolean = false;
const QTflags : byte = 0;
const baudrate : longint = 9600;
const CmdWas : integer = -1;
const FastModeOn : boolean = false;
const PortEventReadSize : integer = 0;
const PortEventWriteSize : integer = 0;
const ValidPollCount : integer = 0;
const FailedPollCount : integer = 0;
const AutoQTcount : integer = 0;
const ManQTcount : integer = 0;
const FailedQTcount : integer = 0;
const CmdSendCount : integer = 0;
const PacketTime : integer = 0;
const SendFail : integer = 0;
const SendBusy : boolean = false;
const RspFailCount : integer = 0;
const ReadPortCount : integer = 0;
const ReadFailCount : integer = 0;
const DoingACommand : boolean = false;

const NAKrsp : word = $FFFB;
const ACKrsp : word = $FFFC;
const ILLrsp : word = $FFFA;
const POLrsp : word = $FFFF;
const IRQnm : array[0..3] of byte = (4,3,4,3);
const ActualIRQ : word = 0;
const UseIOport : word = 1; {com1 = default}
const UseIRQ : word = 4;    {irq4 = default}
const FVer : word = 0;
const MAX_OLD_COM_PORT = 9; //we have 9 comports allowed in this application if old fryers (V5.18 or lower)
const MAX_NEW_COM_PORT = 99; //we have 99 comports allowed in this application if old fryers (V5.18 or lower)

type str255 = string[255];
const hex : array[0..15] of char = (
  '0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');

const FVersion : string = 'Fryers V??.?';
const FryersStr : string = 'Fryers Driver';

implementation

{$R *.DFM}

const VerCmd : array[0..1] of word = (
         $001C,  {;Version command (28)}
	 $0000);
const StatusCmd : array[0..1] of word = (
         $0021,  {;Version command (33)}
	 $0000);
const AudVerCmd : array[0..1] of word = (
         $101C,  {;audiometer Version command ($1000+28)}
	 $0000);
const AudStatusCmd : array[0..1] of word = (
         $1021,  {;audiometer Version command ($1000+33)}
	 $0000);

const GetCrvCmd : array[0..2] of word = (
         $0019,  {;get curve command (25)}
	 $0001,
         $0000);
const GetPanelCmd : array[0..1] of word = (
         $1005,  {;get panel command (?)}
         $0000);
const SetPollDelay1Cmd : array[0..2] of word = (
         $0049,  {;set poll delay command (73)}
	 $0001,
         50);
const SetPollDelay2Cmd : array[0..3] of word = (
         $0049,  {;set poll delay command (73)}
	 $0002,
         40,
         10);
const GetPollDelayCmd : array[0..1] of word = (
         $004A,  {;Get poll delay command (74)}
	 $0000);
const QTCmd : array[0..1] of word = (
         $7FFF,  {;do quick terminate (32767)}
	 $0000);

const MaxSize = 2000;
const CrvScale : integer = 0;
const PeakVal : integer = 0;
const poff : integer = 0;
var RcvData : array[0..MaxSize] of word;
var Cd : array[0..MaxSize] of word;
var pary1 : array[0..MaxSize] of smallint;

const BackColor = clBlack;
const CrvColor = clWhite;
const TextColor = clTeal;

var pary2 : array[1..1200] of smallint;
       {this plots the vertices to draw the graph with}
const xtab : array [0..79] of integer =
           (0, 36, 57, 72, 84, 93,102,108,114,120,
          125,129,134,137,141,144,148,151,153,156,
          159,161,163,165,168,170,172,173,175,177,
          179,180,182,184,185,187,188,189,191,192,
          193,195,196,197,198,199,200,202,203,204,
          205,206,207,208,209,210,210,211,212,213,
          214,215,216,216,217,218,219,219,220,221,
          222,222,223,224,225,225,226,227,227,228);

type BufPnlRecType = packed Record
       RspNum : WORD;
       Count  : WORD;
       PBSTAT : WORD;
       PBMISC : WORD;
       LFREQ  : SmallInt;
       LLEVEL : SmallInt;
       LSRC   : SmallInt;
       LDEST  : SmallInt;
       LSIM   : SmallInt;
       LLOFFS : SmallInt;
       RFREQ  : SmallInt;
       RLEVEL : SmallInt;
       RSRC   : SmallInt;
       RDEST  : SmallInt;
       RSIM   : SmallInt;
       RLOFFS : SmallInt;
     end;

  {we use the dynamic dll load method so that we can catch the Error}
  const LibHandle : integer = 0;

  var CallFryers : procedure(var FIregs:F_RegsType);
    {$IFDEF WIN32} stdcall; {$ENDIF}

  {try to load fryers32.dll}
  {returns false if cannot find Fryers}
  {this is only used in 32 bit mode}
  function LoadFryers:boolean;
  begin
    LoadFryers := true;
    if LibHandle > 0 then Exit;
    LoadFryers := false;
  {$IFDEF WIN32}
    LibHandle := LoadLibrary('fryers32.dll');
  {$ELSE}
    LibHandle := LoadLibrary('fryers16.dll');
  {$ENDIF}
    if LibHandle < 32 then
    begin
      {showmessage('Unable to load fryers32.dll');}
      Exit;
    end;
    @CallFryers := GetProcAddress(LibHandle,'CallFryers');
    if @CallFryers = nil then
    begin
     { showmessage('Failed to lookup CallFryers');}
      Exit;
    end;
    LoadFryers := true;
  end;

function FreeFryers:boolean;
begin
   FreeFryers := false;
   if LibHandle <= 0 then Exit;
   FreeLibrary(LibHandle);
   FreeFryers := true;
end;

procedure pause(Delay:integer);
var Start : integer;
begin
  if Delay < 1 then Delay := 1;
  if Delay > 10000 then Delay := 10000;
  Start := timeGetTime;
  while (timeGetTime-Start) < Delay do
   {nop};
end;


function HexB(B:integer):str255;
var s : string[8];
begin
  s[0] := char(2);
  s[1] := hex[(B shr 4) and $f];
  s[2] := hex[B and $f];
  hexb := s;
end;

function HexW(W:integer):str255;
var s : string[8];
begin
  s[0] := char(4);
  s[1] := hex[(W shr 12) and $f];
  s[2] := hex[(W shr 8) and $f];
  s[3] := hex[(W shr 4) and $f];
  s[4] := hex[W and $f];
  hexw := s;
end;

procedure UpdatePortEventCount;
var Regs:F_RegsType;
begin
  Regs.AX := integer($ff1F);
  Regs.DX := comport;
  CallFryers(Regs);
  PortEventReadSize := Regs.CX;
  PortEventWriteSize := Regs.DX;
  form1.EventReadSizeEdit.text := inttostr(PortEventReadSize);
  form1.PortEventWriteSizeEdit.text := inttostr(PortEventWriteSize);
end;

procedure ShowFlags;
const ChkCnt : word = 0;
begin
  if Form1.QcntSpinEdit.value > 2 then Exit;
{//  if Form1.QuietCheckBox.checked then Exit;}
  Form1.AbdErrorEdit.text := inttostr(AbdErr);
  Form1.PktRetryEdit.text := inttostr(PktRetry);
  Form1.PIflagsEdit.text := '$'+Hexw(PIflags);
  Form1.TXinfoEdit.text := '$'+HexW(TXinfo);
  Form1.GenTimerEdit.text := inttostr(GenTimer);
  Form1.UartErrorEdit.text := '$'+HexW(UartError);
  Form1.IStateEdit.text := inttostr(IState);
  Form1.PollTimerEdit.text := inttostr(PollTimer);
  Form1.RspFailEdit.text := inttostr(RspFailCount);
  Form1.SeqCharEdit.text := inttostr(SeqChar);
  Form1.SeqErrEdit.text := inttostr(SeqErr);
  Form1.CheckSumEdit.text := inttostr(CheckSumData);
  Form1.BaudLabel.caption := inttostr(baudrate);

  if ((PIflags and $0000FFFC) <> 0) then
  begin
    chkcnt := 0;
    form1.BeepLabel.caption := '$'+hexw(PIflags);
    form1.LastErrorLabel.caption := '$'+hexw(PIflags);
    {$IFDEF WIN32}
      if not form1.NoBeepCheckBox.checked then beep;
    {$ENDIF}
  end
  else
  begin
    inc(chkcnt);
    if chkcnt > 25 then
    begin
      form1.BeepLabel.caption := 'NoErr';
      ChkCnt := 1000;
    end;
  end;
  application.processmessages;
end;

procedure ShowQTflags;
var Regs:F_RegsType;
begin
  if Form1.QcntSpinEdit.value > 3 then Exit;
{//  if Form1.QuietCheckBox.checked then Exit;}
  Form1.QTflagsEdit.text := '$'+hexB(QTflags);
  if (QTflags and $01) = 0 then
  begin
    Qterm := false;
    Form1.QTbutton.caption := 'QT is off';
  end
  else
  begin
    QTerm := true;
    Form1.QTbutton.caption := 'QT is on';
  end;
  Form1.GoodPollEdit.text := inttostr(ValidPollCount);
  Form1.BadPollEdit.text := inttostr(FailedPollCount);
  Form1.AutoQTEdit.text := inttostr(AutoQTcount);
  Form1.ManQTEdit.text := inttostr(ManQTcount);
  Form1.BadQTEdit.text := inttostr(FailedQTCount);
  Form1.CmdSendCountEdit.text := inttostr(CmdSendCount);
end;

procedure GetQTflags;
var Regs:F_RegsType;
begin
  Regs.CX := 0;
  Regs.AX := integer($FF1A);
  Regs.DX := comport;
  CallFryers(Regs);
  if (Regs.AX < 0) then Exit; {if ax=-1, then command failed}
  QTflags := Regs.al;
  AutoQTcount := Regs.BX;
  ManQTcount := Regs.CX;
  FailedQTcount := Regs.DX;
  ValidPollCount := Regs.SI;
  FailedPollCount := Regs.DI;
end;

procedure UpdateQTflags;
begin
  GetQTFlags;
  ShowQTflags;
end;


{returns 0=ok, positive=new baudrate, negative=failed}
function AutoBaud:longint;
var Regs:F_RegsType;
begin
  Regs.ax := integer($FF1B);
  Regs.dx := comport;
  Regs.bx := 0;
  CallFryers(Regs);
  Form1.EditAX.text := hexw(Regs.AX);
  Form1.EditBX.text := hexw(Regs.BX);
  Form1.EditCX.text := hexw(Regs.CX);
  if Regs.BX <> 0 then
    AutoBaud := Regs.BX
  else if Regs.AX <> 0 then
    AutoBaud := Regs.AX
  else AutoBaud := 0;
end;

function GetCurrentBaudrate:longint;
var Regs:F_regstype;
begin
  Regs.AX := integer($FFFF);
  Regs.DX := comport;
  CallFryers(Regs);
  if Regs.DX = integer($FFFF) then
    GetCurrentBaudrate:= 115200 div Regs.DI
  else
    GetCurrentBaudrate := baudrate;
end;

function GetFryersVersion:longint;
var Regs:F_regstype;
begin
  Regs.AX := integer($FFFE);
  Regs.DX := 0;
  CallFryers(Regs);
  FVer := Regs.BX;
end;


function str2d(V:integer):string;
var t : string;
begin
  T := inttostr(V div 100)+'.';
  if v mod 100 > 9 then
    T := T+inttostr(v mod 100)
  else T := T+'0'+inttostr(v mod 100);
  str2d := t;
end;

{UsePort = 1-4 for com1-com4, UseIRQ=2-15 for irq2-irq15}
{0=Autoselect - doesn't work yet - current actual usage is 0-14 = comport}
function InitRS232(ThisPort,ThisIrq:word):boolean;
var Regs:F_RegsType;
var L,i:integer;
{//VAR Size,Ver : integer;}
var rbx: integer;
var T : string;
begin
   InitRs232 := false;
   if ThisPort < 0 then ThisPort := 0; //prevent bad port number
   if ThisPort > 99 then ThisPort := 99; //clip to ports 0-99
   {$IFDEF WIN32}
     comport := (ThisPort);
   {$ELSE}
     comport := (ThisPort) and 1;
   {$ENDIF}
   Regs.dx := comport;
   Regs.ax := integer($ffff);
   CallFryers(Regs);
   FVersion := 'Fryers V'+hex[regs.al shr 4]+'.'+hex[regs.al and $f]+'0';
   FVer := regs.al * 10;

   if (integer(Regs.dx and $ffff) <> integer($ffff)) or (Regs.al < $40) then
   begin
     {$IFNDEF WIN32}
       writeln('Cannot run program, FRYERS not found');
     {$ELSE}
       ShowMessage('Cannot run program, FRYERS not Found');
     {$ENDIF}
     Exit;
   end;

   rbx := 0;
   if regs.al >= 30 then
   begin
     Regs.ax := integer($fffe);
     Regs.bx := 0;
     Regs.dx := comport;
     Regs.cx := 0;
     Regs.si := 0;
     Regs.di := 0;
     CallFryers(Regs);
     rbx := regs.bx;
     FVer := regs.bx;
     FVersion := 'Fryers V'+str2d(rbx);
   end;
   form1.VerLabel.caption := FVersion;

   if rbx >= 400 then
   begin
     Regs.ax := integer($fffd);
     Regs.dx := comport;
     Regs.cx := 0;
     CallFryers(Regs);
     L := integer(regs.ax)-3;
     T := '';
     for i := 1 to L do
     begin
       Regs.ax := integer($fffd);
       Regs.dx := comport;
       Regs.cx := i;
       CallFryers(Regs);
       T := T+char(regs.al);
     end;
     FryersStr := T;
   end;
   form1.FstrLabel.caption := FryersStr;

   ActualIRQ := ThisIrq;
   Regs.ax := integer($ff00); {disable fryers interrupt procedure}
   Regs.cx := integer($ff00); {this makes sure everything is kosher}
   Regs.dx := comport;        {-->the Packet driver *must* be disabled}
   CallFryers(Regs);          {-->before you can configure the port}
   {$IFNDEF WIN32}
     if rbx >= 307 then
     begin
       Regs.ax := integer($ff0a);  {if Fryers supports it, and they are asking}
       Regs.ch := $ff;    {for com3 or com4, go select that stuff}
       Regs.cl := ThisIrq;
       Regs.dx := comport;  {virtual Fryers port to use 0 or 1}
       Regs.bx := (pred(ThisPort) shr 1) and $01; {select base or alt uart}
       CallFryers(Regs);                          {(0=1&2 or 1=3&4)}
       if Regs.ah = $ff then
       begin  {if failed, return to auto default}
         form1.PortSelect.ItemIndex := 0;
         form1.IRQSpinEdit.Value := 4;
         Regs.ax := integer($ff0a);  {if Fryers supports it, and they are asking}
         Regs.ch := $ff;    {for com3 or com4, go select that stuff}
         Regs.cl := 0; {use default irq}
         Regs.dx := 0; {use fryers virtual port 0}
         Regs.bx := 0; {select base uart 0}
         CallFryers(Regs);
         ActualIRQ := Regs.AH;
       end;
     end;
     Form1.IRQused.caption := '('+inttostr(ActualIRQ)+')';
   {$ENDIF}
   {$IFDEF WIN32}
     Form1.IRQused.caption := 'Win';
   {$ENDIF}

    Regs.ax := integer($ff00); {enable fryers interrupt procedure}
    Regs.cx := integer($ffff);
    Regs.dx := comport;
    CallFryers(Regs);
    if Regs.AL = 0 then
    begin
     {$IFNDEF WIN32}
       writeln('Could not initialize FRYERS, the port may not be available');
     {$ELSE}
       ShowMessage('Could not initialize FRYERS, the port may not be available');
     {$ENDIF}
     Exit;
    end;

    Regs.ax := integer($ff10); {enable fryers packet protocol}
    Regs.cx := integer($ffff);
    Regs.dx := comport;
    CallFryers(Regs);
    Regs.ax := $00e3;  {init to 9600 baud, no parity, 8 data bits}
    Regs.dx := comport;
    CallFryers(Regs);
    if Qterm then
      Regs.CL := $FF
    else Regs.CL := $00;
    Regs.CH := $FF;
    Regs.AX := integer($FF1A);
    Regs.DX := comport;
    CallFryers(Regs);
    QTflags := Regs.al;
    AutoQTcount := Regs.BX;
    ManQTcount := Regs.CX;
    FailedQTcount := Regs.DX;
    ValidPollCount := regs.si;
    FailedPollCount := regs.di;
    ShowQTflags;
    Form1.GetPollDelay;
  InitRs232 := true;
end;

procedure CloseRS232;
var Regs:F_RegsType;
begin
  Regs.ax := integer($ff00); {disable fryers interrupt procedure}
  Regs.cx := integer($ff00); {this makes sure everything is kosher}
  Regs.dx := comport;
  CallFryers(Regs);
  Initialized := false;
end;

function Sendwait:word;
var Regs:F_RegsType;
var ab,stop,start : integer;
begin
  ab := 0;
  start := timegettime;
  repeat
    Regs.ax := integer($0ff13);
    Regs.dx := comport;
    CallFryers(Regs);
    SendWait := WORD(Regs.AX);
    PIflags := Regs.AX;
    GenTimer := Regs.BX;
    TXinfo := Regs.CX;
    UartError := Regs.DL;
    IState := Regs.DH;

    if Form1.DisplayStatus.Checked then
    begin
      Form1.EditAX.text := '$'+Hexw(Regs.AX);
      Form1.EditBX.text := '$'+Hexw(Regs.BX);
      Form1.EditCX.text := '$'+Hexw(Regs.CX);
      Form1.EditDX.text := '$'+Hexw(Regs.DX);
      Form1.EditSI.text := '$'+Hexw(Regs.SI);
      Form1.EditDI.text := '$'+HexW(Regs.DI);
      application.processmessages;
    end
    else ShowFlags;
    stop := timegettime;
    if stop-start > 500 then
    begin
      inc(ab);
      if ab > 4 then
      begin
        SendWait := $0040;  {simulate no poll}
      end;
      start := timegettime;
    end;
    if {((Regs.ax and $0060) <> 0) or} KillMe then Exit;
    {$IFDEF WIN32}
      if (Regs.ax and $00FD) = 0 then
        if Form1.WaitSleepSpinEdit.value > 0 then
          sleep(Form1.WaitSleepSpinEdit.value);
    {$ENDIF}
  until ((Regs.ax and $00FD) <> 0);
end;
(*
//  form1.SendLabel.caption :=How+'Wait ';
//  form1.UpdateDebugStatus;
//  UpdatePortEventCount;
//    application.processmessages;
*)

function SendWaitFail:boolean;
begin
  SendWaitFail := true;
  if SendWait and $fffc <> 0 then Exit;
  SendWaitFail := false;
end;

function SendCommand(SndP:PAtype; var Rp:RcvType):boolean;
var Regs:F_RegsType;
var i : integer;
var Size : integer;
label ErrExit;
begin
  if SendBusy then
    Form1.FailCountLabel.font.color := clRed;
  SendBusy := true;
  if Form1.QcntSpinEdit.value > 1 then
{//  if Form1.QuietCheckBox.checked then}
  begin
    form1.SendLabel.caption :='Send';
    application.processmessages;
  end;
  SndPtr := SndP;
  SendCommand := false;
  Seq[1] := timeGetTime;
    for i := 2 to 5 do
      Seq[i] := Seq[1];
  if SendWaitFail then goto ErrExit;
  Seq[2] := timeGetTime;
  Size := SndPtr^[1]+2;
  if (Size >= MaxSize) or (Size < 2) then goto ErrExit;
  for i := 0 to pred(Size) do
  begin
    Regs.AX := integer($ff23);
    Regs.DX := comport;
    Regs.CX := i;
    Regs.BX := SndPtr^[i];
    CallFryers(Regs);
  end;
  Regs.AX := integer($ff15);
  Regs.DX := comport;
  CallFryers(Regs);

  inc(CommandCount);
  Seq[3] := timeGetTime;
  if SendWaitFail then goto ErrExit;

  Seq[4] := timeGetTime;
  if SndPtr^[0] <> QTcmd[0] then
  begin
    if Form1.QcntSpinEdit.value > 4 then
 {//   if Form1.QuietCheckbox.checked then}
    begin
      form1.SendLabel.caption := 'Recv';
      application.processmessages;
    end;
    CheckSumData := Regs.DX;
    Regs.AX := integer($ff26);  {get size}
    Regs.DX := comport;
    Regs.CX := 1;
    CallFryers(Regs);
    Size := Regs.CX+2;
    if (Size >= MaxSize) or (Size < 2) then goto ErrExit;
    for i := 0 to Size do
    begin
      Regs.AX := integer($ff26);
      Regs.DX := comport;
      Regs.CX := i;
      CallFryers(Regs);
      RcvData[i] := (Regs.DX and $ffff);
    end;
    CheckSumData := Regs.DX;
    Regs.AX := integer($ff16);
    Regs.DX := comport;
    CallFryers(Regs);
    Size := RcvData[1]+3;
    move(RcvData,Rp,Size*2);
    if (RcvData[0] and integer($FFFF)) = NAKrsp then
       inc(NAKCount);
    if (RcvData[0] and integer($FFFF)) = ACKrsp then
       inc(ACKCount);
    if (RcvData[0] and integer($FFFF)) = ILLrsp then
      inc(ILLCount);
    if (RcvData[0] and integer($FFFF)) = POLrsp then
      inc(POLCount);
  end;

  Size := SndPtr^[1]+3;
  move(SndPtr^,Cd,Size*2);
  Seq[5] := timeGetTime;
  inc(SuccessCount);
  SendCommand := true;
  form1.SendLabel.caption :='Ready';
  SendBusy := false;
  Exit;

ErrExit:
  form1.SendLabel.caption :='Fail';
  SendBusy := false;
  inc(SendFail);
    {clear any pending response}
    Regs.AX := integer($ff16);
    Regs.DX := comport;
    CallFryers(Regs);
end;

procedure ShowRcvData;
begin
  if Form1.QcntSpinEdit.value > 5 then Exit;
{//  if Form1.QuietCheckBox.Checked then Exit;}
  Form1.RcvDataEdit.text := hexw(RcvData[0])+':'+hexw(RcvData[1])+':'+
                            hexw(RcvData[2])+':'+hexw(RcvData[3])+':'+
                            hexw(RcvData[4])+':'+hexw(RcvData[5])+':'+
                            hexw(RcvData[6])+':'+hexw(RcvData[7]);
end;

procedure ShowTimes;
var Ccnt : single;
begin
  if Form1.QcntSpinEdit.value > 6 then Exit;
{//  if Form1.QuietCheckBox.Checked then Exit;}
  if RcvData[0] and integer($FFFF) = NAKrsp then
    form1.StatusLabel.caption := 'NAKrsp'
  else if RcvData[0] and integer($FFFF) = ACKrsp then
    form1.StatusLabel.caption := 'ACKrsp'
  else if RcvData[0] and integer($FFFF) = ILLrsp then
    form1.StatusLabel.caption := 'ILLcmd'
  else if RcvData[0] and integer($FFFF) = POLrsp then
    form1.StatusLabel.caption := 'Poll  '
  else if SndPtr <> nil then
  begin
    if RcvData[0] and $7FFF = SndPtr^[0] then
      form1.StatusLabel.caption := 'OK: $'+HexW(RcvData[0])
    else
      form1.StatusLabel.caption := 'Err: $'+HexW(RcvData[0])
  end
  else form1.StatusLabel.caption := '???: $'+HexW(RcvData[0]);

  Form1.Edit1.text := inttostr(Avg[0]);
  Form1.Edit2.text := inttostr(Avg[1]);
  Form1.Edit3.text := inttostr(Avg[2]);
  Form1.Edit4.text := inttostr(Avg[3]);
  Form1.Edit5.text := inttostr(Avg[4]);
  Form1.Edit6.text := inttostr(ErrorCount);
  Form1.CmdCntEdit.text := inttostr(CommandCount);
  Form1.SuccessEdit.text := inttostr(SuccessCount);
  if CommandCount > 0 then Ccnt := (CommandCount-SuccessCount)/CommandCount
    else Ccnt := 0;
    Form1.FailureRatioEdit.text := floattostr(Ccnt);
  Form1.NakEdit.text := inttostr(NAKCount);
  Form1.IllEdit.text := inttostr(ILLCount);
  Form1.PollRspEdit.text := inttostr(POLCount);
  Form1.AckEdit.text := inttostr(ACKCount);
  Form1.Spinner;
end;

procedure Tform1.UpdateDebugStatus;
var Regs:F_RegsType;
type bytearray = packed array[0..9999] of byte;
type byteptr = ^bytearray;
type intarray = packed array[0..9999] of integer;
type intptr = ^intarray;
var i,k : integer;
var dwp : intptr;
var drp : intptr;
begin
  if not DebugCheckBox.checked then Exit;
  begin
   debrs := ''; Debws := ''; Debcs := '';

    k := cd[1]+1; if k > 99 then k := 99;
    for i := 0 to k do
    begin
      DebCs := DebCs+hexw(cd[i]);
    end;
    Cmdedit.text := DebCs;
    Regs.AX := integer($ff19);
    Regs.DX := comport;
    CallFryers(Regs);
    SeqErrEdit.text := inttostr(Regs.dx shr 8)+':'+hexb(regs.dx and $ff);
  end;

  {$IFNDEF WIN32} Exit; {$ENDIF}  {not available in 16bit mode}
   Regs.AX := integer($ff1F);
   Regs.DX := comport;
   CallFryers(Regs);
   integer(drp) := regs.si;
   integer(dwp) := regs.di;
   DebRcntedit.text := inttostr(Regs.ax);
   DebWcntedit.text := inttostr(Regs.bx);
   k := Regs.ax;
   if k > 99 then
   begin
     k := 99;
     DebRs := '!';
   end;
   for i := 1 to k do
   begin
     if drp^[i-1] >= 0 then
       DebRs := DebRs+hexb(drp^[i-1])
     else DebRs := DebRs+inttostr(drp^[i-1])+'|';
   end;
   k := Regs.bx;
   if k > 99then
   begin
     k := 99;
     DebWs := '!';
   end;
   for i := 1 to (k div 2) do
   begin
     if dwp^[i-1] >= 0 then
       DebWs := DebWs+hexw(dwp^[i-1])
     else DebWs := DebWs+inttostr(dwp^[i-1])+'|';
   end;
   DebRdedit.text := DebRs;
   DebWredit.text := DebWs;
end;

procedure ComputeTime;
var i : integer;
begin
  inc(Count);
  if Count > MaxCount then Count := MaxCount;
  Temp[0] := Seq[0]-StartTime;
  Temp[1] := Seq[2]-Seq[1];
  Temp[2] := Seq[3]-Seq[1];
  Temp[3] := Seq[4]-Seq[1];
  Temp[4] := Seq[5]-Seq[1];

  Avg[0] := Temp[0];
  for i := 1 to 4 do
  begin
    Avg[i] := round((Avg[i]-(Avg[i]/count))+(Temp[i]/count))
  end;
end;

procedure GetPortStatus;
var Regs:F_RegsType;
begin
  Regs.AX := integer($ff19);
  Regs.DX := comport;
  Regs.CX := 0;
  CallFryers(Regs);
  ErrorCount := Regs.AX;
  ABDerr := Regs.BL;
  PktRetry := Regs.BH;
  SeqChar := Regs.DL;
  SeqErr := Regs.DH;
  CmdSendCount := Regs.SI;
  RspFailCount := Regs.DI;
end;

procedure ClearPortStatus;
var Regs:F_RegsType;
begin
  Regs.AX := integer($ff19);
  Regs.DX := comport;
  Regs.CX := integer($ffFF);
  Regs.BX := 0;
  CallFryers(Regs);
  ErrorCount := Regs.AX;
end;

procedure tForm1.GetPollDelay;
var Rcv : RcvType;
var OldRunning : boolean;
begin
  if IamRunning then
  begin
    Form1.StopMePlease;
    Exit;
    {while DoingACommand do
      application.processmessages;
    if KillMe then Exit;}
  end;
  if SendCommand(@GetPollDelayCmd,Rcv) then
  begin
    if word(Rcv[0]) = word(GetPollDelayCmd[0] or $8000) then
    begin
      PollDelayTime := Rcv[2];
      if Rcv[1] = 2 then
      begin
        HoldoffTime := Rcv[3];
        HoldoffAvailable := true;
      end
      else
      begin
        HoldoffTime := 0;
        HoldoffAvailable := false;
      end;
    end;
    PollDelaySpinEdit.value := PollDelayTime;
    HoldoffSpinEdit.Value := HoldoffTime;
  end;
  {IamRunning := OldRunning;}
end;

procedure SetPollDelay(DelayValue,Holdoff:integer);
var Regs:F_RegsType;
var Rcv:RcvType;
var OldRunning : boolean;
begin
  OldRunning := IamRunning;
  if IamRunning then
  begin
    Form1.StopMePlease;
    Exit;
    {while DoingACommand do
      application.processmessages;
    if KillMe then Exit;}
  end;
  if HoldOff < 0 then Holdoff := 10;
  if Holdoff > 500 then Holdoff := 500;
  if DelayValue < 2 then DelayValue := 2;
  if DelayValue > 1000 then DelayValue := 1000;
  SetPollDelay1Cmd[2] := DelayValue;
  SetPollDelay2Cmd[2] := DelayValue;
  SetPollDelay2Cmd[3] := Holdoff;
  if HoldoffAvailable = true then
  begin
    if not SendCommand(@SetPollDelay2Cmd,Rcv) then
    begin
      {if failed, backoff to single parameter version of the command}
      SendCommand(@SetPollDelay1Cmd,Rcv);
    end;
  end
  else
  begin
    SendCommand(@SetPollDelay1Cmd,Rcv);
  end;
  {IamRunning := OldRunning;}
end;

procedure ShowCommandTime;
var Regs:F_RegsType;
begin
  if Form1.QuietCheckBox.Checked then Exit;
  Form1.CmdTimeLabel.caption := inttostr(Seq[5]-Seq[1]);
  Regs.Dx := comport;
  Regs.cx := 0;
  Regs.AX := integer($0FF1C);
  CallFryers(Regs);
  PollTimer := Regs.BX;
  PacketTime := Regs.DX-Regs.CX;
  ReadPortCount := Regs.SI;
  ReadFailCount := Regs.DI;
  Form1.PacketTimeLabel.caption := inttostr(PacketTime);
  Form1.ReadPortCountEdit.text := inttostr(ReadPortCount);
  Form1.ReadFailCountEdit.text := inttostr(ReadFailCount);
end;

function DoRepeatCmd:boolean;
var Ps:PAType;
var Rcv:RcvType;
var Regs:F_RegsType;
var Chs : char;
begin
  DoRepeatCmd:= false;
  DoingACommand := true;
  Ps := nil;
  Chs := #0;
  case form1.TestType.itemindex of
   0: Ps := nil;
   1: Ps := @QTcmd;
   2: Ps := @VerCmd;
   3: Ps := @StatusCmd;
   4: Ps := @GetCrvCmd;
   5: Ps := @AudVerCmd;
   6: Ps := @AudStatusCmd;
   7: Ps := @GetPanelCmd;
  end;
  Seq[1] := 0;
  Seq[2] := 0;
  Seq[3] := 0;
  Seq[4] := 0;
  Seq[5] := 0;
  if Ps <> nil then
  begin
    CmdWas := ps^[0];
    if SendCommand(Ps,Rcv) then
      DoRepeatCmd := true;
    if Form1.QcntSpinEdit.value > 7 then
{//    if not(Form1.QuietCheckBox.checked) then}
      UpdatePortEventCount;
    Form1.UpdateDebugStatus; {handled separately}
{//    if Form1.QcntSpinEdit.value > 0 then}
    if not(Form1.QuietCheckBox.checked) then
      Form1.FailCountLabel.caption := inttostr(SendFail);
  end
  else
  begin
    if Chs <> #0 then
    begin
    end;
  end;
  ShowCommandTime;
  DoingACommand := false;
end;

procedure ShowPanel;
var ABPan : BufPnlRecType absolute RcvData;
begin
  if Form1.QcntSpinEdit.value > 11 then Exit;
{//  if Form1.QuietCheckBox.checked then Exit;}
  if (CmdWas = $1005) then
  begin
    form1.LeftHLlabel.caption := 'L'+inttostr(ABpan.Llevel div 100);
    form1.RightHLlabel.caption := 'R'+inttostr(ABpan.Rlevel div 100);
    form1.Freqlabel.caption := 'F'+inttostr(ABpan.LFreq);
    form1.LeftOutLabel.caption := 'L'+inttostr(ABpan.LDest);
    form1.RightOutLabel.caption := 'R'+inttostr(ABpan.RDest);
    form1.LeftSrcLabel.caption := 'L'+inttostr(ABpan.LSrc);
    form1.RightSrcLabel.caption := 'R'+inttostr(ABpan.RSrc);

    if ABpan.PBstat and $0001 = 0 then
    begin
      form1.LstimulusLabel.caption := 'off';
      form1.LstimulusLabel.font.color := clRed;
    end
    else
    begin
      form1.LstimulusLabel.caption := 'ON';
      form1.LstimulusLabel.font.color := clGreen;
    end;
    if ABpan.PBstat and $0100 = 0 then
    begin
      form1.RstimulusLabel.caption := 'off';
      form1.RstimulusLabel.font.color := clRed;
    end
    else
    begin
      form1.RstimulusLabel.caption := 'ON';
      form1.RstimulusLabel.font.color := clGreen;
    end;
  end;
end;

procedure InitGraphBox;
begin
    with form1.graphbox,canvas do
    begin
      brush.color := backcolor;
      pen.color := backcolor;
      rectangle(0,0,Width,Height);
      pen.color := textcolor;
    end;
end;

procedure DoGraphDots;
var i,ii:integer;
var q : single;
begin
    with form1.graphbox,canvas do
    begin
      q := 114 div 19;
      for i := 1 to 18 do
        for ii := 1 to 11 do
      begin
        pixels[round(i*q),ii*5] := clGray;
      end;
    end;
end;

{--------------------------------------------}
{plot a curve on screen, clip to only within box}
procedure dodraw(a,b,c,d:integer; color:Tcolor; ct:integer);
var  x1,y1,x2,y2,x,y,xstep,ystep,deltax,deltay,direction : integer;
begin
 {// Form1.GraphBox.Canvas.SetColor(color,BackColor);}
  x1 := a;
  x2 := c;
  if b > 190 then y1 := 190 else if b < 1 then y1 := 1 else y1 := b;
  if d > 190 then y2 := 190 else if d < 1 then y2 := 1 else y2 := d;
  x := x1;
  y := y1;
  if x1 = x2 then xstep := 0
  else
    if x1 > x2 then xstep := -1
    else
      xstep := 1;
  if y1 = y2 then ystep := 0
  else
    if y1 > y2 then ystep := -1
    else
      ystep := 1;
  deltax := abs(x2 - x1);
  deltay := abs(y2 - y1);
  if deltax = 0 then direction := -1
  else
    direction := 0;
  form1.GraphBox.canvas.Pixels[x,y] := color;   {plot first dot}

  repeat
    if direction < 0 then
    begin
      y := y + ystep;
      direction := direction + deltax;
      if ((direction >= 0) or (ct > 0)) then
        form1.GraphBox.canvas.Pixels[x,y] := color;   {plot first dot}
    end
    else
    begin
      x := x + xstep;
      direction := direction - deltay;
      if ((direction >= 0) or (ct > 1)) then
        form1.GraphBox.canvas.Pixels[x,y] := color;   {plot first dot}
    end;
  until ((y = y2) and (x = x2));
end;

Procedure DispCurve;
{//var ya,yb,dd:integer;}
var da,db,xa,xb,x,i : integer;
const lm = 32;  {left margin on graph}
  function GetPoint(i:integer):integer;
  var k : integer;
  begin
    k := i;
    while (pary1[k] = NoShow) and (k < 79) do
      inc(k);
    GetPoint := pary1[k];
  end;
begin
  for i := 0 to MaxSize do
    pary1[i] := smallint(RcvData[i]);
  i := 11; {start with 100hz plot}
  x := 0;
  while (pary1[i] = NoShow) and (i < 79) do
  begin
    inc(i);
    inc(x);
  end;
  repeat
    da := GetPoint(i);
    db := GetPoint(i+1);
    if not(da = NoShow) then
      da := poff - (da div 100);
    if not (db = NoShow) then
      db := poff - (db div 100);
{//    if da < 0 then
//      dd := da;

//    ya := pary2[i];
//    yb := pary2[i+1];}
    pary2[i] := da;
    xa := xtab[x] div 2{+lm};
    xb := xtab[x+1] div 2{+lm};
    i := i + 1;
    x := x + 1;
    if xa = xb then   { skip next when xa = xb }
    begin
      i := i + 1;
      x := x + 1;
    end;
{//    if not((xa = NoShow) or (xb = NoShow)) then}
{//      dodraw(xa,ya,xb,yb,BackColor,0); }{undraw}
    if not((da = NoShow) or (db = NoShow)) then
      dodraw(xa,da,xb,db,crvcolor,0); {draw new one}
  until x > 78;
  pary2[i] := db;
end;

procedure FindScale;
var CrvPeak : integer;
begin
  CrvPeak := (pary1[8] div 100);
  CrvScale := ((CrvPeak div 20)*20) + 10;
  poff := {form1.graphbox.height+}CrvScale;
end;

procedure ShowGraph;
var PeakStr,scaleStr : string;
begin
  if Form1.QcntSpinEdit.value > 8 then Exit;
{//  if Form1.QuietCheckBox.checked then Exit;}
  if (CmdWas = 25) and (RcvData[0] = $8000+25) and
      form1.ShowGraph.checked then
  begin
    InitGraphBox;
    DoGraphDots;
    FindScale;
    ScaleStr := inttostr(CrvScale);
    PeakVal := pary1[8];
    if PeakVal mod 100  < 10 then
    begin
      PeakStr := inttostr(Peakval div 100)+'.0'+inttostr(PeakVal mod 100);
    end
    else PeakStr := inttostr(PeakVal div 100)+'.'+inttostr(PeakVal mod 100);

    with form1.graphbox,canvas do
    begin
      font.color := textcolor;
  {//    textout(0,0,PeakStr);}
      textout(0,Height-textHeight('X'),ScaleStr);

 (*
      q := 114 div 19;
      for i := 1 to 18 do
        for ii := 1 to 11 do
      begin
        pixels[round(i*q),ii*5] := clGray;
      end;
  *)

    end;
    DispCurve;
  end;
end;

function DoMe:boolean;
begin
  DoMe := false;

  if IamWorkingOnIt then Exit;
  IamWorkingOnIt := true;
  StartTime := timeGetTime;
  if not(Initialized) then
  begin
    InitGraphBox;
    DoGraphDots;
    UseIOport := form1.PortSelect.ItemIndex;
    UseIRQ := IRQnm[(form1.PortSelect.ItemIndex) and $03];
    if not InitRS232(UseIOport,UseIRQ) then
    begin
      Form1.StopMePlease;
      IamWorkingOnIt := false;
      KillMe := true;
      Exit;
    end;
    Form1.UpdateComPortList();
    KillMe := false;
    Initialized := true;
  end;

  if Form1.AutoBaudCheckBox.checked then
  begin
    baudrate := AutoBaud;
    if baudrate = 0 then
      baudrate := GetCurrentBaudrate;
  end;

  begin
    Seq[0] := timeGetTime;
    DoRepeatCmd;
    ComputeTime;
    GetPortStatus;
    UpdateQTflags;
    ShowTimes;
    ShowRcvData;
    ShowFlags;
    ShowGraph;
    ShowPanel;
  end;
  pause(Form1.CmdDelaySpinEdit.value);

  IamWorkingOnIt := false;
  DoMe := true;
end;

procedure TForm1.StopMePlease;
begin
   IamRunning := false;
   Form1.DoMeButton.Caption := 'Let''s do it!';
   Form1.FailCountLabel.font.color := clblack;
end;

procedure TForm1.DoMeButtonClick(Sender: TObject);
begin
  if IamRunning then
  begin
    Form1.StopMePlease;
  end
  else
  begin
    form1.DoMeButton.Caption := 'Stop Me!';
    IamRunning := true;
  end;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  KillMe := true;
  if FastModeOn then
    FastTestButtonClick(Sender);
  application.processmessages;
  if IamRunning then
    DoMeButtonClick(Sender);
  application.processmessages;
{//  DoMe(Idle);}
  While IamBusy do
  begin
    Application.ProcessMessages;
  end;
  CloseRS232;
end;


{--------------------------------------------------------------}
{This updates the com port item list to have the proper number of}
{comport items depending on the fryrers driver found}
procedure TForm1.UpdateComPortList;
var  i,Max:integer;
var SavedIndex:integer;
var ComStr : AnsiString;
begin
  SavedIndex := PortSelect.ItemIndex;
  if (FVer < 520) then
  begin
    Max := MAX_OLD_COM_PORT; //we have 9 comports allowed in this application if old fryers (V5.18 or lower)
  end
  else
  begin
    Max := MAX_NEW_COM_PORT; //we have 32 comports allowed in this application if new Fryers (V5.20 or above)
  end;
  PortSelect.Items.Clear();
  {PortSelect.Items.Add('Auto');}  //first item [0] is always "Auto"
  for i:=1 to Max do
  begin
    ComStr := 'COM'+IntToStr(i);
    PortSelect.Items.Add(ComStr);
  end;
  if (SavedIndex > PortSelect.Items.Count) or (SavedIndex < 0) then SavedIndex := 0;
  PortSelect.ItemIndex := SavedIndex;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  LoadFryers;
  GetFryersVersion;
  Form1.PortSelect.ItemIndex := 0;
  {$IFDEF WIN32}
    IRQSpinEdit.enabled := false;
    IRQlabel.enabled := false;
    EventReadSizeLabel.enabled := true;
    EventWriteSizeLabel.enabled := true;
    Form1.Caption := 'Stress Test for 32 bit Windows';
  {$ELSE}
    DebRcntedit.enabled := false;
    DebWcntedit.enabled := false;
    DebRcntLabel.enabled := false;
    DebWcntLabel.enabled := false;
    DebRdedit.enabled := false;
    DebWredit.enabled := false;
    eRLabel.enabled := false;
    eWLabel.enabled := false;
    EventReadSizeEdit.enabled := false;
    PortEventWriteSizeEdit.enabled := false;
    PktTimeLabel.enabled := false;
    PacketTimeLabel.enabled := false;
    WaitSleepLabel.enabled := false;
    WaitSleepSpinEdit.enabled := false;
    Form1.Caption := 'Stress Test for 16 bit Windows';
  {$ENDIF}
  UpdateComPortList();
  Application.OnIdle := IdleTime;
  TimerTickSpinEdit.value := Timer1.interval;
end;

procedure TForm1.Spinner;
begin
  Spin := succ(Spin) and $3;
  case Spin of
   0: SpinLabel.caption := '|';
   1: SpinLabel.caption := '/';
   2: SpinLabel.caption := '--';
   3: SpinLabel.caption := '\';
  end;
end;


procedure TForm1.Edit6DblClick(Sender: TObject);
begin
  ClearPortStatus;
end;

procedure TForm1.PollDelaySpinEditChange(Sender: TObject);
begin
  SetPollDelay(PollDelaySpinEdit.Value,HoldoffSpinEdit.Value);
end;

procedure TForm1.PollDelaySpinEditDblClick(Sender: TObject);
begin
  GetPollDelay;
end;

procedure TForm1.NakEditDblClick(Sender: TObject);
begin
  NakCount := 0;
end;

procedure TForm1.ILLEditDblClick(Sender: TObject);
begin
  ILLcount := 0;
end;

procedure TForm1.PollRspEditDblClick(Sender: TObject);
begin
  POLCount := 0;
end;

procedure TForm1.AckEditDblClick(Sender: TObject);
begin
  ACKCount := 0;
end;

procedure TForm1.IdleTime(Sender: TObject; var Done: Boolean);
var Regs:F_RegsType;
begin
  if Suicide then
  begin
    done := true;
    Exit;
  end;

  if IamRunning then
  begin
    DoMe;
  end
  else
  begin
    GetPortStatus;
    Regs.ax := integer($0ff13);
    Regs.dx := comport;
    CallFryers(Regs);
    if not Form1.QuietCheckBox.checked then
    begin
      if Regs.AX = -1 then form1.VerLabel.font.color := clblack
      else if Regs.AX = 0 then form1.VerLabel.font.color := clyellow
      else if Regs.AX and $fffc <> 0 then form1.VerLabel.font.color := clred
      else if Regs.AX = 1 then form1.VerLabel.font.color := clgreen
      else form1.VerLabel.font.color := clblue;
    end;
    if Form1.DisplayStatus.Checked then
    begin
      Form1.EditAX.text := '$'+Hexw(Regs.AX);
      Form1.EditBX.text := '$'+Hexw(Regs.BX);
      Form1.EditCX.text := '$'+Hexw(Regs.CX);
      Form1.EditDX.text := '$'+Hexw(Regs.DX);
      Form1.EditSI.text := '$'+Hexw(Regs.SI);
      Form1.EditDI.text := '$'+HexW(Regs.DI);
      UpdateQTflags;
    end;
  end;
  done := true;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var Regs:F_RegsType;
begin
  KillCount := KillCount + Timer1.interval;
  if Suicide then Close;
  if Form1.QcntSpinEdit.value > 9 then Exit;
{//  if QuietCheckBox.checked then Exit;}
    GetPortStatus;
    Regs.ax := integer($0ff13);
    Regs.dx := comport;
    CallFryers(Regs);
    if not Form1.QuietCheckBox.checked then
    begin
      if Regs.AX = -1 then form1.VerLabel.font.color := clblack
      else if Regs.AX = 0 then form1.VerLabel.font.color := clyellow
      else if Regs.AX and $fffc <> 0 then form1.VerLabel.font.color := clred
      else if Regs.AX = 1 then form1.VerLabel.font.color := clgreen
      else form1.VerLabel.font.color := clblue;
    end;
    if Form1.DisplayStatus.Checked then
    begin
      Form1.EditAX.text := '$'+Hexw(Regs.AX);
      Form1.EditBX.text := '$'+Hexw(Regs.BX);
      Form1.EditCX.text := '$'+Hexw(Regs.CX);
      Form1.EditDX.text := '$'+Hexw(Regs.DX);
      Form1.EditSI.text := '$'+Hexw(Regs.SI);
      Form1.EditDI.text := '$'+HexW(Regs.DI);
      UpdateQTflags;
    end;
end;

procedure TForm1.PollTimerEditDblClick(Sender: TObject);
begin
  PollTimer := 0;
end;

procedure TForm1.IStateEditDblClick(Sender: TObject);
begin
  IState := 0;
end;

procedure TForm1.UartErrorEditDblClick(Sender: TObject);
begin
  UartError := 0;
end;

procedure TForm1.GenTimerEditDblClick(Sender: TObject);
begin
  GenTimer := 0;
end;

procedure TForm1.SeqCharEditDblClick(Sender: TObject);
begin
  SeqChar := 0;
end;

procedure TForm1.TXinfoEditDblClick(Sender: TObject);
begin
   TXinfo := 0;
end;

procedure TForm1.PIflagsEditDblClick(Sender: TObject);
begin
  PIflags := 0;
end;

procedure TForm1.PktRetryEditDblClick(Sender: TObject);
begin
   PktRetry := 0;
end;

procedure TForm1.AbdErrorEditDblClick(Sender: TObject);
begin
   AbdErr := 0;
end;

procedure TForm1.SeqErrEditDblClick(Sender: TObject);
begin
  SeqErr := 0;
end;

procedure TForm1.CheckSumEditDblClick(Sender: TObject);
begin
   CheckSumData := 0;
end;

procedure TForm1.RcvDataEditDblClick(Sender: TObject);
begin
  RcvDataEdit.text := '';
end;

procedure TForm1.OneTimeButtonClick(Sender: TObject);
begin
  if not(KillMe) and not(IamRunning) then
    DoMe;
end;

procedure TForm1.QTButtonClick(Sender: TObject);
var Regs:F_RegsType;
begin
  Qterm := not(Qterm);
  if QTerm then
    Regs.CX := integer($FFFF)
  else Regs.CX := integer($FF00);
  Regs.AX := integer($FF1A);
  Regs.DX := comport;
  CallFryers(Regs);
  QTflags := Regs.al;
  AutoQTcount := Regs.BX;
  ManQTcount := Regs.CX;
  FailedQTcount := Regs.DX;
  ValidPollCount := regs.si;
  Failedpollcount := regs.di;
  ShowQTflags;
end;

procedure KillThePort;
begin
  KillMe := true;
  KillCount := 0;
  while IamWorkingOnIt do
  begin
    if KillCount > 5000 then
      IamWorkingOnIt := false;
    Application.ProcessMessages;
  end;
  form1.DoMeButton.Caption := 'Let''s do it!';
  CloseRS232;
  KillMe := false;
end;

procedure TForm1.PortSelectOldClick(Sender: TObject);
begin
  KillThePort;
  IRQSpinEdit.Value := IRQnm[(form1.PortSelect.ItemIndex) and $03];
end;

procedure TForm1.PortSelectClick(Sender: TObject);
begin
  KillThePort;
  IRQSpinEdit.Value := IRQnm[(form1.PortSelect.ItemIndex) and $03];
end;

procedure TForm1.IRQSpinEditChange(Sender: TObject);
var V :integer;
const OldV : integer = 0;
begin
  V := IRQSpinEdit.Value;
  if V > 15 then V := 2;  {V in[2,3,4,5,7,9,10,11,12,15]}
  if V < 2 then V := 15;
  if (V = 6) and (OldV = 5) then V := 7;   {limit what V can be}
  if (V = 6) and (OldV = 7) then V := 5;
  if (V = 8) and (OldV = 7) then V := 9;   {limit what V can be}
  if (V = 8) and (OldV = 9) then V := 7;
  if (V = 14) then V := 12;
  if (V = 13) then V := 15;
  IRQSpinEdit.Value := V;
  OldV := V;
  if IRQnm[(form1.PortSelect.ItemIndex) and $03] = V then Exit;
  KillThePort;
  IRQnm[(form1.PortSelect.ItemIndex) and $03] := V;
end;

procedure TForm1.CloseButtonClick(Sender: TObject);
begin
  Close;
end;

procedure TForm1.GraphBoxPaint(Sender: TObject);
begin
  InitGraphBox;
  DoGraphDots;
end;

procedure TForm1.FastTestButtonClick(Sender: TObject);
var count : integer;
begin
  if FastModeOn or KillMe then
  begin
    {FastTestButton.Caption := 'Do Fast Test';}
    FastModeOn := false;
    Exit;
  end;
  if IamRunning then
  begin
    StopMePlease;
    while DoingACommand do
      application.processmessages;
  end;
  if KillMe then Exit;

  FastTestButton.Caption := 'End FastTest';
  FastModeOn := true;
  while FastModeOn do
  begin
    for Count := 0 to 100 do
      if not KillMe then
        DoRepeatCmd;
    application.processmessages;
  end;

  FastTestButton.Caption := 'Do Fast Test';
  FastModeOn := false;
end;

procedure TForm1.TimerTickSpinEditChange(Sender: TObject);
begin
  Timer1.interval := TimerTickSpinEdit.value;
end;

procedure TForm1.KillButtonClick(Sender: TObject);
var Regs : F_RegsType;
begin
   KillThePort;
   regs.ax := integer($ff0f);
   regs.dx := comport;
   CallFryers(Regs);
end;

procedure TForm1.HoldoffSpinEditChange(Sender: TObject);
begin
  SetPollDelay(PollDelaySpinEdit.Value,HoldoffSpinEdit.Value);
end;

procedure TForm1.HoldoffSpinEditDblClick(Sender: TObject);
begin
  GetPollDelay;
end;


end.
