unit QTunit;
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, MMSystem;

type
  TForm1 = class(TForm)
    GoButton: TButton;
    DisplayStatus: TCheckBox;
    EditAX: TEdit;
    EditBX: TEdit;
    EditCX: TEdit;
    EditDX: TEdit;
    EditSI: TEdit;
    EditDI: TEdit;
    VerLabel: TLabel;
    FStrLabel: TLabel;
    PortSelect: TRadioGroup;
    TestType: TRadioGroup;
    CloseButton: TButton;
    BaudRateLabel: TLabel;
    LoopSpinLabel: TLabel;
    CmdSpinLabel: TLabel;
    SpinStateLabel: TLabel;
    CmdNumLabel: TLabel;
    QTButton: TButton;
    ErrSpinLabel: TLabel;
    RcvErrSpinLabel: TLabel;
    DebRdEdit: TEdit;
    DebWrEdit: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    DebRcntEdit: TEdit;
    DebWcntEdit: TEdit;
    StatusLabel: TLabel;
    SeqNmEdit: TEdit;
    Label3: TLabel;
    SndDataEdit: TEdit;
    SndCntEdit: TEdit;
    Label4: TLabel;
    MonitorButton: TButton;
    CmdTimeLabel: TLabel;
    Label5: TLabel;
    MonType: TRadioGroup;
    AutoBaudCheckBox: TCheckBox;
    BaudLabel: TLabel;
    procedure GoButtonClick(Sender: TObject);
    procedure CloseButtonClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure QTButtonClick(Sender: TObject);
    procedure MonitorButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    QTflags : byte;
    LSpin : integer;
    CSpin : integer;
    Espin : integer;
    RSpin : integer;
    procedure Spinner(var SpinLabel:TLabel; Var spin:integer);
    procedure ShowQTflags;
    procedure UpdateDebugStatus;
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
uses QTunit2;

{$R *.DFM}

var CmdWas : integer = -1;
var Doit:boolean = false;
var bd : integer = 9600;
var Debrs,Debws : string[128];
const stopmonitoring : boolean = false;

procedure TForm1.Spinner(var SpinLabel:TLabel; Var spin:integer);
begin
  Spin := succ(Spin) and $3;
  case Spin of
   0: SpinLabel.caption := '|';
   1: SpinLabel.caption := '/';
   2: SpinLabel.caption := '--';
   3: SpinLabel.caption := '\';
  end;
end;

procedure TForm1.ShowQTflags;
begin
//  Form1.QTflagsEdit.text := '$'+hexB(QTflags);
  if (QTflags and $01) = 0 then
  begin
    Qterm := false;
    Form1.QTbutton.caption := 'AutoQT OFF';
  end
  else
  begin
    QTerm := true;
    Form1.QTbutton.caption := 'AutoQT ON';
  end;
end;

procedure Tform1.UpdateDebugStatus;
type bytearray = packed array[0..9999] of byte;
type byteptr = ^bytearray;
type intarray = packed array[0..9999] of word;
type intptr = ^intarray;
var i,k : integer;
var wp : intptr;
var rp : intptr;
begin
      Regs.AX := integer($ff1F);
      Regs.DX := comport;
      CallFryers(Regs);
   DebRcntedit.text := inttostr(Regs.ax);
   DebWcntedit.text := inttostr(Regs.bx);
   integer(rp) := regs.si;
   integer(wp) := regs.di;
   debrs := ''; Debws := '';
   k := Regs.ax; if k > 127 then k := 127;
   if rp <> nil then
   begin
//     for i := 1 to k do
//       DebRs := DebRs+hexb(rp^[i-1]);
   end;
   k := regs.bx;
   if wp <> nil then
   begin
//     for i := 1 to k do
//       DebWs := DebWs+hexb(wp^[i-1]);
   end;    
   DebRdedit.text := DebRs;
   DebWredit.text := DebWs;

    Regs.AX := integer($ff19);
    Regs.DX := comport;
    CallFryers(Regs);
   SeqNmEdit.text := inttostr(Regs.dx shr 8)+':'+hexb(regs.dx and $ff);
end;

procedure DoRepeatCmd;
var Ps:PAType;
//var Rcv:RcvType;
begin
  form1.statuslabel.caption := 'starting cmd';
  application.processmessages;
  form1.SpinStateLabel.caption := '1';
  form1.Spinner(form1.LoopSpinLabel,form1.LSpin);
  Ps := nil;
  case form1.TestType.itemindex of
   0: PS := nil;
   1: Ps := @VerCmd;
   2: Ps := @StatusCmd;
   3: Ps := @GetPanelCmd;
   4: Ps := @GetCrvCmd;
   5: Ps := @QTcmd;
   6: Ps := @AudVerCmd;
   7: Ps := @AudStatusCmd;
  end;
  if ps = nil then Exit;
    CmdWas := ps^[0];
    form1.CmdNumLabel.caption := inttostr(CmdWas);
    if SendCommand(ps) then
    begin
      form1.Spinner(form1.CmdSpinLabel,form1.CSpin);
      form1.statuslabel.caption := 'doing rcv';
      application.processmessages;
      if not RcvCommand then
        form1.Spinner(form1.RcvErrSpinLabel,form1.RSpin);
    end
    else
    begin
      form1.Spinner(form1.ErrSpinLabel,form1.ESpin);
      form1.statuslabel.caption := 'send cmd failed';
      application.processmessages;
    end;
end;

procedure TForm1.GoButtonClick(Sender: TObject);
var Start,Stop : integer;
begin
  if not(PortInitialized) then
  begin
    if not InitRS232(succ(PortSelect.itemindex)) then
    begin
      ShowMessage('Cannot open port: '+inttostr(succ(PortSelect.itemindex)));
      StatusLabel.caption := 'Failed Initialization';
      application.processmessages;
      Exit;
    end
    else StatusLabel.caption := 'Initialize Done';
    application.processmessages;
  end;

  if Doit then
  begin
    KillMe := true;
    Exit;
  end;

  GoButton.Caption := 'Stop';
  Doit := true;
  while not(KillMe) do
  begin
    Start := timeGetTime;
    DoRepeatCmd;
    Stop := timeGetTime;
    CmdTimeLabel.caption := inttostr(Stop-Start);
    UpdateDebugStatus;
//    Bd := autobaud;
//    if bd > 0 then
//      baudrate := bd;
//    BaudRateLabel.Caption := inttostr(baudrate);
    application.processmessages;
  end;
  Doit := false;
  KillMe := false;
  GoButton.Caption := 'Go';
end;

procedure TForm1.CloseButtonClick(Sender: TObject);
begin
  Killme := true;
//  while doit do
    application.processmessages;
  Close;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   CloseRS232;
   FreeFryers;
end;



procedure TForm1.QTButtonClick(Sender: TObject);
begin
  Qterm := not(Qterm);
  if QTerm then
    Regs.CX := integer($FFFF)
  else Regs.CX := integer($FF00);
  Regs.AX := integer($FF1A);
  Regs.DX := comport;
  if LibHandle <> 0 then
    CallFryers(Regs);
  if (regs.ax = -1) or (Regs.AX = $FF1A) then
    ShowMessage('QT Call failed');
  QTflags := Regs.al;
//  AutoQTcount := Regs.BX;
//  ManQTcount := Regs.CX;
//  FailedQTcount := Regs.DX;
//  ValidPollCount := regs.si;
//  Failedpollcount := regs.di;
  ShowQTflags;
end;

 procedure ShowStatus;
  begin
    form1.EditAX.text := hexW(StatAX);
    form1.EditBX.text := hexW(StatBX);
    form1.EditCX.text := hexW(StatCX);
    form1.EditDX.text := hexW(StatDX);
  //        ' Packet:',hexW(FIPPrec.PacketError) );
       application.processmessages;
  end;

  function WaitForIt:boolean;
  begin
     while (PacketStatus and 1 = 0) and not(KillMe) and Not(StopMonitoring) do
     begin
       ShowStatus;
     end;
     WaitForIt := KillMe;
  end;

procedure TForm1.MonitorButtonClick(Sender: TObject);
const monitoring : boolean = false;
var Ab,Stop,Start:integer;
begin
  if monitoring then
  begin
    MonitorButton.caption := 'Mon-Stoping';
    stopmonitoring := true;
    Exit;
  end;

  Ab := GetCurrentBaudRate;
  BaudLabel.caption := inttostr(Ab);
  MonitorButton.caption := 'Stop Monitor';
  monitoring := true;
    while not(KillMe) and not(stopmonitoring) do
    begin
      ShowStatus;
      Start := timeGetTime;
      if WaitForIt then Exit;
      DiscardResponse;
        if MonType.ItemIndex = 1 then
          SendArray[0] := QuickTermCmd
        else SendArray[0] := GetCmdStatusCmd;
      SendArray[1] := 0;
      if MonType.ItemIndex <> 0 then
      begin
        if SendPacket then
        begin
          if WaitForIt then Exit;
          if not(ReceivePacketOK) then {nop};
          if not(GetRcvPacket) then {nop};
        end;
      end;
      Stop := timeGetTime;
      if AutoBaudCheckBox.checked then
      begin
        Ab := AutoBaud;
        if Ab > 0 then
          BaudLabel.caption := inttostr(Ab);
      end;
      CmdTimeLabel.caption := inttostr(Stop-Start);
    end;
  monitoring := false;
  stopmonitoring := false;
  MonitorButton.caption := 'Monitor';
end;

end.
