unit QTUnit2;
interface
uses forms,dialogs,Windows,MMsystem,SysUtils;

type PArrayType = array[0..99] of word;
type RcvType = PArrayType;
type PAType = ^PArrayType;
type str255 = string[255];

function LoadFryers:boolean;
function FreeFryers:boolean;
function InitRS232(ThisPort:word):boolean;
procedure CloseRS232;
function Sendwait(State:char):boolean;
function SendCommand(Data:PAtype):boolean;
function RcvCommand:boolean;
function GetCurrentBaudrate:longint;
function AutoBaud:longint;
function HexB(B:integer):str255;

var PortInitialized : boolean = false;
var baudrate : integer = 9600;
var comport : integer = 0;
var QTerm : boolean = false;
{$I FRYEREGS.INC}
var Regs : F_RegsType;

  const LibHandle : integer = 0;
  var CallFryers : procedure(var FIregs:F_RegsType); stdcall;

var KillMe : boolean = false;
var NAKCount : integer = 0;
var ACKCount : integer = 0;
var ILLCount : integer = 0;
var POLCount : integer = 0;

const NAKrsp : word = $FFFB;
const ACKrsp : word = $FFFC;
const ILLrsp : word = $FFFA;
const POLrsp : word = $FFFF;

const hex : array[0..15] of char = (
  '0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');

const MaxSize = 2000;
const FVersion : string = 'Fryers V??.?';
const FryersStr : string = 'Fryers Driver';
var RcvData : array[0..MaxSize] of word;
var SndData : array[0..MaxSize] of word;

const VerCmd : array[0..1] of word = (
         $001C,  {;Version command (28)}
	 $0000);
const StatusCmd : array[0..1] of word = (
         $0021,  {;Version command (33)}
	 $0000);
const AudVerCmd : array[0..1] of word = (
         $101C,  {;audiometer Version command ($1000+28)}
	 $0000);
const AudStatusCmd : array[0..1] of word = (
         $1021,  {;audiometer Version command ($1000+33)}
	 $0000);

const GetCrvCmd : array[0..2] of word = (
         $0019,  {;get curve command (25)}
	 $0001,
         $0000);
const GetPanelCmd : array[0..1] of word = (
         $1006,  {;get panel command (?)}
         $0000);
const SetPollDelayCmd : array[0..2] of word = (
         $0049,  {;set poll delay command (73)}
	 $0001,
         50);
const GetPollDelayCmd : array[0..1] of word = (
         $004A,  {;Get poll delay command (74)}
	 $0000);
const QTCmd : array[0..1] of word = (
         $7FFF,  {;do quick terminate (32767)}
	 $0000);

implementation
uses QTunit;


function str2d(V:integer):string;
var t : string;
begin
  T := inttostr(V div 100)+'.';
  if v mod 100 > 9 then
    T := T+inttostr(v mod 100)
  else T := T+'0'+inttostr(v mod 100);
  str2d := t;
end;
function HexB(B:integer):str255;
var s : string[8];
begin
  s[0] := char(2);
  s[1] := hex[(B shr 4) and $f];
  s[2] := hex[B and $f];
  hexb := s;
end;

function HexW(W:integer):str255;
var s : string[8];
begin
  s[0] := char(4);
  s[1] := hex[(W shr 12) and $f];
  s[2] := hex[(W shr 8) and $f];
  s[3] := hex[(W shr 4) and $f];
  s[4] := hex[W and $f];
  hexw := s;
end;

{returns 0=ok, positive=new baudrate, negative=failed}
function AutoBaud:longint;
begin
  AutoBaud := 0;
  if LibHandle = 0 then Exit;
  Regs.ax := integer($FF1B);
  Regs.dx := comport;
  Regs.bx := 0;
  CallFryers(Regs);
//  Form1.EditAX.text := hexw(Regs.AX);
//  Form1.EditBX.text := hexw(Regs.BX);
//  Form1.EditCX.text := hexw(Regs.CX);
  if Regs.BX <> 0 then
    AutoBaud := Regs.BX
  else if Regs.AX <> 0 then
    AutoBaud := Regs.AX
  else AutoBaud := 0;
end;

function GetCurrentBaudrate:longint;
begin
  GetCurrentbaudRate := 0;
  if LibHandle = 0 then Exit;
  Regs.AX := integer($FFFF);
  Regs.DX := comport;
  CallFryers(Regs);
  if Regs.DX = integer($FFFF) then
    GetCurrentBaudrate:= 115200 div Regs.DI
  else
    GetCurrentBaudrate := baudrate;
end;

{UsePort = 1-4 for com1-com4, UseIRQ=2-15 for irq2-irq15}
function InitRS232(ThisPort:word):boolean;
var L,i:integer;
var rbx: integer;
var T : string;
begin
   InitRs232 := false;
   if not(LoadFryers) then Exit;

   if ThisPort = 0 then ThisPort := 1;
   if ThisPort > 15 then
   begin
     MessageBox(0,'Cannot use the requested port','Fryers32 Error',MB_OK);
     Exit;
   end;

   Regs.dx := 0;
   Regs.ax := integer($ffff);
   CallFryers(Regs);
   FVersion := 'Fryers V'+hex[regs.al shr 4]+'.'+hex[regs.al and $f]+'0';
   if (integer(Regs.dx and $ffff) <> integer($ffff)) or (Regs.al < $40) then
   begin
     MessageBox(0,'Requested port not available','Fryers32 Error',MB_OK);
     Exit;
   end;

   Regs.ax := integer($fffe);
   Regs.bx := 0;
   Regs.dx := 0;
   Regs.cx := 0;
   Regs.si := 0;
   Regs.di := 0;
   CallFryers(Regs);
   rbx := regs.bx;
   FVersion := 'Fryers V'+str2d(rbx);
   form1.VerLabel.caption := FVersion;

   Regs.ax := integer($fffd);
   Regs.dx := 0;
   Regs.cx := 0;
   CallFryers(Regs);
   L := regs.ax-3;
   T := '';
   for i := 1 to L do
   begin
     Regs.ax := integer($fffd);
     Regs.dx := 0;
     Regs.cx := i;
     CallFryers(Regs);
     T := T+char(regs.al);
   end;
   FryersStr := T;
   form1.FstrLabel.caption := FryersStr;

   comport := pred(ThisPort);
   Regs.ax := integer($ff00); {disable fryers interrupt procedure}
   Regs.cx := integer($ff00); {this makes sure everything is kosher}
   Regs.dx := comport;        {-->the Packet driver *must* be disabled}
   CallFryers(Regs);          {-->before you can configure the port}

    Regs.ax := integer($ff00); {enable fryers interrupt procedure}
    Regs.cx := integer($ffff);
    Regs.dx := comport;
    CallFryers(Regs);

    Regs.ax := integer($ff10); {enable fryers packet protocol}
    Regs.cx := integer($ffff);
    Regs.dx := comport;
    CallFryers(Regs);

    Regs.ax := $00e3;  {init to 9600 baud, no parity, 8 data bits}
    Regs.dx := comport;
    CallFryers(Regs);

    if Qterm then
      Regs.CL := $FF
    else Regs.CL := $00;
    Regs.CH := $FF;
    Regs.AX := integer($FF1A);
    Regs.DX := comport;
    CallFryers(Regs);
  PortInitialized := true;
  InitRs232 := true;
end;

procedure CloseRS232;
begin
  if LibHandle = 0 then Exit;
  Regs.ax := integer($ff00); {disable fryers interrupt procedure}
  Regs.cx := integer($ff00); {this makes sure everything is kosher}
  Regs.dx := comport;
  CallFryers(Regs);
  PortInitialized := false;
end;

  //  form1.SpinStateLabel.caption := State+'1';
  // below is from $ff13 response
//    PIflags := Regs.AX;
//    GenTimer := Regs.BX;
//    TXinfo := Regs.CX;
//    UartError := Regs.DL;
//    IState := Regs.DH;
//    PollTimer := Regs.SI;
//  start := timegettime;
//  ab := 0;
//var ab,stop,start : integer;
function Sendwait(State:Char):boolean;
begin
  SendWait := false;
  if LibHandle = 0 then Exit;
  repeat
    if KillMe then Exit;
//    sleep(0);
//    form1.SpinStateLabel.caption := State+'3';
//    form1.SpinStateLabel.caption := State+'4';

    Regs.ax := integer($0ff13);
    Regs.dx := comport;
    CallFryers(Regs);
    if regs.ax and $fffc <> 0 then
      Form1.EditAX.text := '$'+Hexw(Regs.AX);
    if regs.cx and $C1A0 <> 0 then
      Form1.EditCX.text := '$'+Hexw(Regs.CX);
  until ((Regs.ax and $0001) <> 0);
  SendWait := true;
end;
//    if ((Regs.ax and $0060) <> 0) or KillMe then Exit;

//    if Form1.DisplayStatus.Checked then
//    begin
//      Form1.EditAX.text := '$'+Hexw(Regs.AX);
//      Form1.EditBX.text := '$'+Hexw(Regs.BX);
//      Form1.EditCX.text := '$'+Hexw(Regs.CX);
//      Form1.EditDX.text := '$'+Hexw(Regs.DX);
//      Form1.EditSI.text := '$'+Hexw(Regs.SI);
//      Form1.EditDI.text := '$'+HexW(Regs.DI);
//    end;

//    form1.SpinStateLabel.caption := State+'2';
//    stop := timegettime;
//    if stop-start > 500 then
//    begin
//      inc(ab);
//      if ab > 4 then Exit;
//      start := timegettime;
//    end;
//    form1.SpinStateLabel.caption := State+'5';

function SendCommand(Data:PAtype):boolean;
var i : integer;
var SendSize,Size : integer;
label ErrExit;
begin
  SendCommand := false;
  if LibHandle = 0 then Exit;
//  form1.SpinStateLabel.caption := '2';
  if not(SendWait('S')) then Exit;
  SendSize := (Data^[1]+2)*2;
  move(Data^,SndData,SendSize);
  Size := SndData[1]+2;
//  form1.SpinStateLabel.caption := '3';
  if (Size >= MaxSize) or (Size < 2) then Exit;
//  form1.SpinStateLabel.caption := '4';

    form1.statuslabel.caption := 'loading cmd data';
    application.processmessages;

    for i := 0 to pred(Size) do
    begin
      Regs.AX := integer($ff23);
      Regs.DX := comport;
      Regs.CX := i;
      Regs.BX := SndData[i];
      CallFryers(Regs);
    end;

    form1.statuslabel.caption := 'requesting send';
    application.processmessages;

//  form1.SpinStateLabel.caption := '5';
    Regs.AX := integer($ff15);
    Regs.DX := comport;
    CallFryers(Regs);

    form1.statuslabel.caption := 'send req done';
    application.processmessages;

  SendCommand := true;
end;

function RcvCommand:boolean;
var Size,i : integer;
begin
  RcvCommand := false;
  if LibHandle = 0 then Exit;

   form1.statuslabel.caption := 'wait for rcv';
   application.processmessages;

  if not(SendWait('R')) then Exit;
  
   form1.statuslabel.caption := 'getting rcv size';
   application.processmessages;

  if SndData[0] <> QTcmd[0] then
  begin
//  form1.SpinStateLabel.caption := '6';
    Regs.AX := integer($ff26);  {get size}
    Regs.DX := comport;
    Regs.CX := 1;
    CallFryers(Regs);
    Size := Regs.CX+2;
    if (Size >= MaxSize) or (Size < 2) then Exit;
 // form1.SpinStateLabel.caption := '7';

   form1.statuslabel.caption := 'getting rcv data: '+inttostr(Size);
   application.processmessages;

    for i := 0 to pred(Size) do
    begin
      Regs.AX := integer($ff26);
      Regs.DX := comport;
      Regs.CX := i;
      CallFryers(Regs);
      RcvData[i] := Regs.DX;
    end;

   form1.statuslabel.caption := 'rcv done';
   application.processmessages;

    Regs.AX := integer($ff16);
    Regs.DX := comport;
    CallFryers(Regs);
  end;

   form1.statuslabel.caption := 'that''s all';
   application.processmessages;

//  Size := RcvData[1]+3;
//  move(RcvData,Rp,Size*2);
  if (RcvData[0] and integer($FFFF)) = NAKrsp then
     inc(NAKCount);
  if (RcvData[0] and integer($FFFF)) = ACKrsp then
     inc(ACKCount);
  if (RcvData[0] and integer($FFFF)) = ILLrsp then
    inc(ILLCount);
  if (RcvData[0] and integer($FFFF)) = POLrsp then
    inc(POLCount);
  RcvCommand := true;
end;

  {we use the dynamic dll load method so that we can catch the Error}

  {try to load fryers32.dll}
  {returns false if cannot find Fryers}
  {this is only used in 32 bit mode}
  function LoadFryers:boolean;
  begin
    LoadFryers := true;
    if LibHandle > 0 then Exit;
    LoadFryers := false;
    LibHandle := LoadLibrary('fryers32.dll');
    if LibHandle < 32 then
    begin
      showmessage('Unable to load fryers32.dll');
      Exit;
    end;
    @CallFryers := GetProcAddress(LibHandle,'CallFryers');
    if @CallFryers = nil then
    begin
      showmessage('Failed to lookup CallFryers');
      Exit;
    end;
    LoadFryers := true;
  end;

function FreeFryers:boolean;
begin
   FreeFryers := false;
   if LibHandle <= 0 then Exit;
   FreeLibrary(LibHandle);
   FreeFryers := true;
end;


end.

