unit QTunit;
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    GoButton: TButton;
    DisplayStatus: TCheckBox;
    EditAX: TEdit;
    EditBX: TEdit;
    EditCX: TEdit;
    EditDX: TEdit;
    EditSI: TEdit;
    EditDI: TEdit;
    VerLabel: TLabel;
    FStrLabel: TLabel;
    PortSelect: TRadioGroup;
    TestType: TRadioGroup;
    CloseButton: TButton;
    BaudRateLabel: TLabel;
    LoopSpinLabel: TLabel;
    CmdSpinLabel: TLabel;
    SpinStateLabel: TLabel;
    CmdNumLabel: TLabel;
    QTButton: TButton;
    ErrSpinLabel: TLabel;
    RcvErrSpinLabel: TLabel;
    DebRdEdit: TEdit;
    DebWrEdit: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    DebRcntEdit: TEdit;
    DebWcntEdit: TEdit;
    StatusLabel: TLabel;
    procedure GoButtonClick(Sender: TObject);
    procedure CloseButtonClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure QTButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    QTflags : byte;
    LSpin : integer;
    CSpin : integer;
    Espin : integer;
    RSpin : integer;
    procedure Spinner(var SpinLabel:TLabel; Var spin:integer);
    procedure ShowQTflags;
    procedure UpdateDebugStatus;
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
uses QTunit2;

{$R *.DFM}

var CmdWas : integer = -1;
var Doit:boolean = false;
var bd : integer = 9600;
var Debrs,Debws : string[128];

procedure TForm1.Spinner(var SpinLabel:TLabel; Var spin:integer);
begin
  Spin := succ(Spin) and $3;
  case Spin of
   0: SpinLabel.caption := '|';
   1: SpinLabel.caption := '/';
   2: SpinLabel.caption := '--';
   3: SpinLabel.caption := '\';
  end;
end;

procedure TForm1.ShowQTflags;
begin
//  Form1.QTflagsEdit.text := '$'+hexB(QTflags);
  if (QTflags and $01) = 0 then
  begin
    Qterm := false;
    Form1.QTbutton.caption := 'AutoQT OFF';
  end
  else
  begin
    QTerm := true;
    Form1.QTbutton.caption := 'AutoQT ON';
  end;
end;

procedure Tform1.UpdateDebugStatus;
type bytearray = packed array[0..9999] of byte;
type byteptr = ^bytearray;
var i,k : integer;
var rp,wp : byteptr;
begin
Exit;
   DebRcntedit.text := inttostr(Regs.ax);
   DebWcntedit.text := inttostr(Regs.bx);
   rp := pointer(regs.si);
   wp := pointer(regs.di);
   debrs := ''; Debws := '';
   k := Regs.ax; if k > 127 then k := 127;
   for i := 1 to k do
     DebRs := DebRs+hexb(rp^[i-1]);
   for i := 1 to k do
     DebWs := DebWs+hexb(wp^[i-1]);
   DebRdedit.text := DebRs;
   DebWredit.text := DebWs;
end;

procedure DoRepeatCmd;
var Ps:PAType;
//var Rcv:RcvType;
begin
  form1.statuslabel.caption := 'starting cmd';
  application.processmessages;
  form1.SpinStateLabel.caption := '1';
  form1.Spinner(form1.LoopSpinLabel,form1.LSpin);
  Ps := nil;
  case form1.TestType.itemindex of
   0: PS := nil;
   1: Ps := @VerCmd;
   2: Ps := @StatusCmd;
   3: Ps := @GetPanelCmd;
   4: Ps := @GetCrvCmd;
   5: Ps := @QTcmd;
   6: Ps := @AudVerCmd;
   7: Ps := @AudStatusCmd;
  end;
  if ps = nil then Exit;
    CmdWas := ps^[0];
    form1.CmdNumLabel.caption := inttostr(CmdWas);
    if SendCommand(ps) then
    begin
      form1.Spinner(form1.CmdSpinLabel,form1.CSpin);
      form1.statuslabel.caption := 'doing rcv';
      application.processmessages;
      if not RcvCommand then
        form1.Spinner(form1.RcvErrSpinLabel,form1.RSpin);
    end
    else
    begin
      form1.Spinner(form1.ErrSpinLabel,form1.ESpin);
      form1.statuslabel.caption := 'send cmd failed';
      application.processmessages;
    end;
end;

procedure TForm1.GoButtonClick(Sender: TObject);
begin
  if not(PortInitialized) then
  begin
    if not InitRS232(succ(PortSelect.itemindex)) then
    begin
      ShowMessage('Cannot open port: '+inttostr(succ(PortSelect.itemindex)));
      StatusLabel.caption := 'Failed Initialization';
      application.processmessages;
      Exit;
    end
    else StatusLabel.caption := 'Initialize Done';
    application.processmessages;
  end;

  if Doit then
  begin
    KillMe := true;
    Exit;
  end;

  GoButton.Caption := 'Stop';
  Doit := true;
  while not(KillMe) do
  begin
    DoRepeatCmd;
    UpdateDebugStatus;
//    Bd := autobaud;
//    if bd > 0 then
//      baudrate := bd;
//    BaudRateLabel.Caption := inttostr(baudrate);
    application.processmessages;
  end;
  Doit := false;
  KillMe := false;
  GoButton.Caption := 'Go';
end;

procedure TForm1.CloseButtonClick(Sender: TObject);
begin
  Killme := true;
 // while doit do
 //   application.processmessages;
  Close;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   CloseRS232;
   FreeFryers;
end;



procedure TForm1.QTButtonClick(Sender: TObject);
begin
  Qterm := not(Qterm);
  if QTerm then
    Regs.CX := integer($FFFF)
  else Regs.CX := integer($FF00);
  Regs.AX := integer($FF1A);
  Regs.DX := comport;
  if LibHandle <> 0 then
    CallFryers(Regs);
  if (regs.ax = -1) or (Regs.AX = $FF1A) then
    ShowMessage('QT Call failed');
  QTflags := Regs.al;
//  AutoQTcount := Regs.BX;
//  ManQTcount := Regs.CX;
//  FailedQTcount := Regs.DX;
//  ValidPollCount := regs.si;
//  Failedpollcount := regs.di;
  ShowQTflags;
end;

end.
