
{This DLL library requires Delphi 1.0 to compile}
{FRYERS16.DLL as of 6 March 1997 by Michael Day}
{Copyright 1997 Frye Electronics, Inc.}

{This DLL has two calls (Indexs 1 and 2). It simulates an INT14}
{call for compilers that don't support the INT14 call,}
{but do support DLL calls. The first call at index 1 provides a}
{far pascal interface for programs that need that calling convention.}
{The second call at index 2 provides a cdecl calling convention for}
{programs that need the C calling convention.}

{Note: because Fryers.com is a real mode dos tsr, segment translation}
{is not supported by the Fryers16 DLL. Function calls that use segment}
{registers to pass information should not be used since they won't work.}
{Only register based calls should be made. It is possible to use the DPMI}
{interface to perform the translation between segments and selectors,}
{but since Fryers can be used without segment references (it has purely}
{register based alternate calls), there is no real need to do the }
{translation via the DPMI.}

library Fryers16;
uses WinTypes;
{$F+}
type tFRegs = packed record   {register structure to use with Fryers}
       case integer of
         0: (RegAX:word;
             RegBX:word;
             RegCX:word;
             RegDX:word;
             RegDI:word;
             RegSI:word);
         1: (RegAL,RegAH:byte;
             RegBL,RegBH:byte;
             RegCL,RegCH:byte;
             RegDL,RegDH:byte);
     end; {tFRegs}

{FRegs is a pointer to an eight word structure of type tFRegs}
{see tFRegs above for the structure format}
{This uses the default far pascal calling convention}
procedure CallFryers(var FRegs:tFRegs); export;
begin
  asm
    push es
    pusha
    les si,[FRegs]
    mov ax,es:[si].tFRegs.RegAX
    mov bx,es:[si].tFRegs.RegBX
    mov cx,es:[si].tFRegs.RegCX
    mov dx,es:[si].tFRegs.RegDX
    mov di,es:[si].tFRegs.RegDI
    mov si,es:[si].tFRegs.RegSI
    push ds
    int $14
    pop ds
    push si
    les si,[FRegs]
    mov es:[si].tFRegs.RegAX,ax
    mov es:[si].tFRegs.RegBX,bx
    mov es:[si].tFRegs.RegCX,cx
    mov es:[si].tFRegs.RegDX,dx
    mov es:[si].tFRegs.RegDI,di
    pop ax
    mov es:[si].tFRegs.RegSI,ax
    popa
    pop es
  end;
end;

{Iregs is a pointer to an eight word structure of type tFRegs}
{see tFRegs above for the structure format}
{This uses the far cdecl calling convention}
procedure CallFryers_C(var FRegs:tFRegs); cdecl; export;
begin
  asm
    push es
    pusha
    les si,[FRegs]
    mov ax,es:[si].tFRegs.RegAX
    mov bx,es:[si].tFRegs.RegBX
    mov cx,es:[si].tFRegs.RegCX
    mov dx,es:[si].tFRegs.RegDX
    mov di,es:[si].tFRegs.RegDI
    mov si,es:[si].tFRegs.RegSI
    push ds
    int $14
    pop ds
    push si
    les si,[FRegs]
    mov es:[si].tFRegs.RegAX,ax
    mov es:[si].tFRegs.RegBX,bx
    mov es:[si].tFRegs.RegCX,cx
    mov es:[si].tFRegs.RegDX,dx
    mov es:[si].tFRegs.RegDI,di
    pop ax
    mov es:[si].tFRegs.RegSI,ax
    popa
    pop es
  end;
end;

exports
  CallFryers index 1,
  CallFryers_C index 2;

begin
end.


