//this stuff below is set by typing ^O^O
{$A+,B-,C+,D-,E-,F-,G+,H+,I-,J+,K-,L-,M-,N+,O+,P+,Q-,R-,S-,T-,U-,V+,W-,X+,Y-,Z1}

//Fryers 32bit DLL library unit for Win95 and WinNT
// Began 4 Dec 1996 by Michael Day
// Last version 12 Dec 1997 by Michael day
// Current version as of 16 Jun 2000 by Michael Day - fixed for Delphi V3.0/V5.0

library Fryers32;

{ Important note about DLL memory management: ShareMem must be the
  first unit in your library's USES clause AND your project's (select
  View-Project Source) USES clause if your DLL exports any procedures or
  functions that pass strings as parameters or function results. This
  applies to all strings passed to and from your DLL--even those that
  are nested in records and classes. ShareMem is the interface unit to
  the DELPHIMM.DLL shared memory manager, which must be deployed along
  with your DLL. To avoid using DELPHIMM.DLL, pass string information
  using PChar or ShortString parameters. }

uses
//  SysUtils,
 // Classes,
 // Windows,
  FService in 'FService.pas',
  FryerDef in 'FryerDef.pas',
  TimeThrd in 'TimeThrd.pas',
  PortThrd in 'portthrd.pas';

var SaveExit : pointer;

procedure LibExit; far;
var i : integer;
begin
  for i := 0 to F_MaxPort do
    ReleaseFryers(i);
  ExitProc := SaveExit;
end;

procedure LibEnter;
var i : integer;
begin
  for i := 0 to F_MaxPort do
  begin
    FryersIO[i] := nil;
    RequestRelease[i] := false;
  end;
  SaveExit := ExitProc;
  ExitProc := @LibExit;
end;

{-----------------------------------------------------------}
  //stdcall calling convention version
  procedure CallFryers(var IRegs:F_RegsType); stdcall export;
  begin
    ServiceFryers(IRegs);
  end;

  //C calling convention version
  procedure CallFryers_C(var IRegs:F_RegsType); cdecl export;
  begin
    ServiceFryers(IRegs);
  end;

  exports
    CallFryers index 1,
    CallFryers_C index 2;

begin
  IsMultiThread := true;
  LibEnter;
end.

