{Example Fryers interface unit for Pascal}
{This example will compile under any version of Delphi}
{or any version of Borland/Turbo Pascal from 5.0 to 7.0}
{Copyright 2000 Frye Electronics, Inc.}
{Written by Michael Day as of 5 July 2000 }
{Used by FP32test.dpr and FP16test.pas}
{Note: if you are using Delphi 2.0 or above,}
{see FSAMPLES for FryersP.PAS or FryersC.CPP which are more}
{extensive Fryers interfaces for Win32 applications.}

{$O-,F+,I-}
unit FryersPE;
interface
{$IFDEF DPMI}
  {$DEFINE ISDOS} {protected mode MSDOS - BP7.0}
  uses Dos;
{$ENDIF}
{$IFDEF MSDOS}
  {$DEFINE ISDOS} {real mode MSDOS - TP 5.0->7.0 or BP7.0}
  uses Dos;
{$ENDIF}
{$IFNDEF ISDOS}  {must be windows}
  {$IFDEF WIN32}
    uses Windows; {Win9x/WinNT/Win2K - Delphi 2.0 and above}
  {$ELSE}
    {$DEFINE WIN16}
    uses WinProcs,WinTypes; {Win31 - Delphi 1.0}
  {$ENDIF}
  {$I FRYEREGS.INC}
{$ELSE}
  type F_RegsType = Registers;
  var FRegs : F_RegsType;
{$ENDIF}
{WIN32 = Windows 95/98/WinNT/Win2K}

function FryersLoaded:boolean;
function ReleaseFryers:boolean;
function GetFryersVersion:integer;

{$IFNDEF ISDOS}
  {we use the dynamic dll load method so that we can catch the Error}
  var CallFryers : procedure(var FIregs:F_RegsType);
  {$IFDEF WIN32} stdcall; {$ENDIF}
{$ELSE}
  procedure CallFryers(var FRegs:F_RegsType);
{$ENDIF}

implementation

const FryersLibHandle : integer = 0;

{-----------------------------------------------------------------}
{$IFDEF ISDOS}
  procedure CallFryers(var FRegs:F_RegsType);
  begin
    INTR($14,FRegs); {MsDos uses this calling method}
  end;
{$ELSE}
  {this defines the call to the FRYERS32.DLL for static dll load }
  {however, we will use dynamic loading so as to catch the error}
  {So this is not used here in Windows - see declaration in Interface above}
  {procedure CallFryers(var FRegs:F_RegsType); stdcall external 'Fryers32.DLL'}
{$ENDIF}


{-----------------------------------------------------------------}
{try to load fryers.dll if not loaded (windows), }
{or check if Fryers.com is there (msdos)}
{returns false if cannot find Fryers}
function FryersLoaded:boolean;
{$IFDEF ISDOS}
  var RegDX,RegAX:integer;
{$ENDIF}
begin
  FryersLoaded := true;
  if FryersLibHandle > 0 then Exit;
  FryersLoaded := false;
  {$IFDEF WIN32}
    FryersLibHandle := LoadLibrary('fryers32.dll');
  {$ENDIF}
  {$IFDEF WIN16}
    FryersLibHandle := LoadLibrary('fryers16.dll');
  {$ENDIF}
  {$IFDEF ISDOS}
   FRegs.AX := word($ffff);
   FRegs.DX := 0;
   CallFryers(FRegs);
   if not(integer(FRegs.DX) = integer($ffff)) then Exit;
   if not((FRegs.AX > $24) and (FRegs.AX < $99)) then Exit;
   FryersLibHandle := 32;
  {$ENDIF}
  if FryersLibHandle < 32 then
  begin
    {showmessage('Unable to load fryers32.dll');}
    Exit;
  end;

  {$IFNDEF ISDOS}
   @CallFryers := GetProcAddress(FryersLibHandle,'CallFryers');
   if @CallFryers = nil then
   begin
    { showmessage('Failed to lookup CallFryers');}
     Exit;
   end;
  {$ENDIF}
  FryersLoaded := true;
 end;

{This is an Example only - Don't call ReleaseFryers}
{MsDos doesn't need it, and Windows will take care of it in a}
{graceful manner when the program shuts down.}
function ReleaseFryers:boolean;
begin
   ReleaseFryers := false;
   if FryersLibHandle <= 0 then Exit;
  {$IFDEF ISDOS}
    FryersLibHandle := 0;
  {$ELSE}
    FreeLibrary(FryersLibHandle);
  {$ENDIF}
   ReleaseFryers := true;
end;

{--------------------------------------------}
{Example call to return Fryers version number}
function GetFryersVersion:integer;
var R : F_RegsType;
begin
  GetFryersVersion := -1;
  if (FryersLibHandle = 0) then
  begin
    if not(FryersLoaded) then Exit;
  end;
  {$IFDEF ISDOS}
    R.AX := word($FFFF);
  {$ELSE}
    R.AX := integer($FFFF);
  {$ENDIF}
  R.DX := 0;
  R.CX := 0;
  CallFryers(R);
  if ((R.DX and $0FFFF) <> $0FFFF) then
    R.AL := 0;
  GetFryersVersion := R.AL;
end;

end.

