

{program to convert FRYERS.COM to a BIN loader format}
program mfb;

type bytearray = array[0..64000] of byte;
var fi,fo: file;
    si,so:string;
    size:word;
    Err:word;
    Check1:word;
    Check2:word;
    Data : ^bytearray;
    HdrPtr : pointer;

{const Hdr : array[0..2] of byte = ($E9,$05,$01);}  {Jmp $108}

procedure Header; far; External;
{$L HDR.OBJ}

begin
  writeln('Converting FRYERS.COM to FRYERS.BIN');
  new(Data);
  HdrPtr := @Header;
  si := 'FRYERS.COM';
  assign(fi,si);
  reset(fi,1);
  size := filesize(fi);
  if IOresult <> 0 then
  begin
    writeln('Error opening FRYERS.COM');
    Halt(1);
  end;
  blockread(fi,Data^,Size,Err);
  close(fi);
  if IOresult <> 0 then
  begin
    write('Error reading FRYERS.COM');
    halt(1);
  end;

  Check1 := (word(Data^[4])*256) + word(Data^[3]);
  Check2 := (word(Data^[6])*256) + word(Data^[5]);
  if (Check1 < $31) or (Check1 > $999) or
     (Check2 < 308) or (Check2 > 9999) then
  begin
    writeln('Error - Wrong fryers version ',(Check2/100):6:2);
    halt(1);
  end;
  Data^[7] := $02;  {mark the file as a BIN program}

  so := 'FRYERS.BIN';
  assign(fo,so);
  rewrite(fo,1);
  if IOresult <> 0 then
  begin
    writeln('Error creating FRYERS.BIN');
    Halt(1);
  end;
  blockwrite(fo,HdrPtr^,256,Err);
  blockwrite(fo,Data^,Size,Err);
  close(fo);
  if IOresult <> 0 then
  begin
    writeln('Error writing FRYERS.BIN');
    halt(1);
  end;

  writeln('FRYERS.BIN created');
end.

