program SetPort;

{Bug fix from V1.00. V1.00 would not properly set up COM3 or COM4 unless}
{absolute addressing was used (U:$2E8)}

var irqval : byte;
    rah,ral,rdh,rdl:byte;
    rbx,rdi,rsi:word;
    portval:byte;
    comval:byte;
    uartaddr:integer;
    irqnum:byte;
    i : integer;
    baseaddr : word;
    fport : byte;

const Hex : array[0..15] of char =
      ('0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');

function HexW(w:word):string;
var s:string;
begin
  S[1] := Hex[hi(w) shr 4];
  S[2] := Hex[hi(w) and $f];
  S[3] := Hex[lo(w) shr 4];
  S[4] := Hex[lo(w) and $f];
  S[0] := #4;
  HexW := S;
end;

function FryersOK:integer;
var rax,rdx:word;
begin
   asm
     mov ax,$ffff
     mov dl,0
     int $14
     mov rax,ax
     mov rdx,dx
   end;

   if rdx <> $ffff then
   begin
     writeln(lo(rax));
     FryersOK := 1;  {not a valid fryers driver out there}
     Exit;
   end;
   if rax < $30 then
   begin
     writeln(rax);
     FryersOK := 2;  {port setup not available in this version of fryers}
     Exit;
   end;
   FryersOK := 0;    {all ok}
end;

function GetValue(S:string; Min,Max:word; var who:word):boolean;
var index,err : integer;
    Ts:string;
    What:longint;
begin
  GetValue := false;
  index := succ(pos(':',S));
  if index = 0 then
  begin
    index := pos(' ',S);
    if index = 0 then
      index := 2;
  end;
  if index > length(s) then exit;
  Ts := copy(S,index,length(S));
    Val(Ts,What,Err);
  if Err > 0 then Exit;
  if What > 65536 then Exit;
  if What < Min then Exit;
  if What > Max then Exit;
  Who := What;
  GetValue := true;
end;

function Setit(S:string):integer;
var what : word;
begin
  Setit := 5;
  if S = '' then Exit;
  case upcase(S[1]) of
   'P': begin
          if not(GetValue(S,1,2,what)) then Exit;
          portval := what
        end;
   'C': begin
          if not(GetValue(S,1,4,what)) then Exit;
          comval := what;
        end;
   'U': begin
          if not(GetValue(S,5,65535,what)) then Exit;
          uartaddr := what;
        end;
   'I': begin
          if not(GetValue(S,0,15,what)) then Exit;
          irqval := what;
        end;
   else Exit;
  end; {case}
  Setit := 0;
end;

begin
  writeln;
  writeln('Fryers port configuartion program, V1.03 - 02 May 97');
  writeln('Copyright 1993-1997 Frye Electronics, Inc.');
  if ParamCount < 1 then
  begin
    writeln('Format is: SETPORT [P:port#] [C:com# or U:uartaddr] [I:irq#]');
    writeln;
    Halt;
  end;

  case FryersOK of
    1: begin
         writeln('Error: Valid Fryers driver not found. Must be version 3.07 or higher.');
         writeln;
         halt(1);
       end;
    2: begin
         writeln('Error: Fryers driver version not able to configure ports');
         writeln('       Must be version 3.07 or higher.');
         writeln;
         Halt(2);
       end;
  end; {case}

  portval := 0;    {preset the values}
  comval := 0;
  uartaddr := 0;
  irqval := 0;

  for i := 1 to ParamCount do
  begin
     if SetIt(ParamStr(i)) <> 0 then
     begin
        writeln('Error: Invalid parameter: ',ParamStr(i));
        writeln;
        Halt(3);
     end;
  end;

  if (portval < 1) or (portval > 2) then
    portval := 1;
  fport := pred(portval);

  case comval of
    1: uartaddr := $3f8;
    2: uartaddr := $2f8;
    3: uartaddr := $3e8;
    4: uartaddr := $2e8;
   else begin
          comval := 0;
          uartaddr := 0;
        end;
  end;
  baseaddr := uartaddr;

  case uartaddr of
    $3f8: comval := 1;
    $2f8: comval := 2;
    $3e8: comval := 3;
    $2e8: comval := 4;
  end;

  if irqval = 0 then
  begin
    case comval of
      0: irqval := 0;
      1: irqval := 4;
      2: irqval := 3;
      3: irqval := 4;
      4: irqval := 3;
      else irqval := 0;
    end;
  end;


  asm
    mov ax,$ff00    {turn off fryers stuff}
    mov cx,$ff00
    mov dl,[fport]
    int $14

    mov ax,$ff0a
    mov ch,$ff       {select new port config}
    mov cl,[irqval]
    mov bx,[baseaddr]
    mov dl,[fport]
    int $14
    mov rah,ah
    mov ral,al
    mov rbx,bx
    mov rdh,dh
    mov rdl,dl
    mov rdi,di
    mov rsi,si
  end;

  case rbx of
   0: baseaddr := $3f8;
   1: baseaddr := $2f8;
   2: baseaddr := $3e8;
   3: baseaddr := $2e8;
   else baseaddr := rbx;
  end;

  if rah = $ff then
  begin
    writeln('Error: Invalid parameters: port:',portval,' com:',comval,
            ' irqval:',irqval,' baseaddr:$',hexw(baseaddr));
    writeln;
    halt(4);
  end;

  write('Port Configured: port:',portval);
  if comval <> 0 then write(' com:',comval);
  writeln(' irqval:',rah,' baseaddr:$',hexw(baseaddr));
  writeln;
end.

