
{This is a program to fake the existance of a Fonix instrument}
{that has RS232. It can be used to test the operation of Fryers.COM}
{or Fryers.DLL when an instrument is not available, or if you }
{want to create a virtual instrument that can do things a real}
{instrument can't do, such as different timing, or different baudrate}
{Written by Michael Day V1.02 as of 2 Dec 1997}

{it is expected that this program will be constantly hacked on and}
{in a current state of flux. As such, be sure to keep copies of}
{a working version so you can go back to it when you screw up.}

program Faker;
uses dos,crtx;

var ExitSave : pointer;
var OldInt1C : pointer;
var FakerClock : packed record
      USclk  :word;
      SysClk :word;
    end;
var FakerTime : longint absolute FakerClock;

var SysClock : word absolute $40:$6c;
var DlyCnt : longint;
var fo : file;
type ByteArray = array[0..65520] of byte;
var SendData : ^ByteArray;
var i,Count : integer;

const IOport : byte = 1;          {1 or 2}
const comport : integer = 0;      {0 or 1}
const baudrate : longint = 9600;  {see baud table}
const InitP : byte = $E3;         {see init table}
const PollDelayTime : longint = 0;  {delay time in ms}
const DeviceType : word = 0;
const Qterm : boolean = true; {false;}
const Silent : boolean = false;   {true = don't show status (faster polls)}
const ImmediatePoll : boolean = false; {true= do imm poll after cmd sent}

type DataType = packed record
            case integer of
             0:(LO,HI:byte);
             1:(W : word);
             2:(I : integer);
     end;

(*const RspTimeout : word = ?; {rsp (startup) timeout in 1ms inc}*)
const RcvTimeout : word = 100; {rcv timeout in 1ms inc}
const SendChkSum : word = 0;
const CmdChkSum  : word = 0;
const TmpChkSum  : word = 0;
const Error : word = 0;
const SendTimeOut : word = 5; {send timeout time in sysclk ticks (55ms ea)}
const FirstTime : boolean = true;
{const StartTime : longint = 0;}
var PollStartTime : longint;
var PollCountTime : longint;
var PollStopTime : longint;
var FileName : string[255];

const VerNum = 100;
{-------------------------------------------------}
const NoRsp   : array[0..3] of word = (0,0,0,0);
const NULLmsg : array[0..2] of word = (0,0,0);
const POLLmsg : array[0..2] of word = ($FFFF,0,0);
const StatRsp : array[0..2] of word = (($8000+33),1,0);
const VerRsp  : array[0..7] of word = (($8000+28),6,VerNum,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF);
const NAKrsp  : array[0..1] of word = ($FFFB,0);
const ILLrsp  : array[0..1] of word = ($FFFA,0);
const ACKrsp  : array[0..1] of word = ($FFFC,0);
const AStatRsp : array[0..2] of word = (($9000+33),1,0);
const AVerRsp  : array[0..7] of word = (($9000+28),6,VerNum,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF);
const APanRsp  : array[0..15] of word = (($9000+5),15,0,0,1000,5000,0,1,0,0,1000,5000,0,1,0,0);
const ABPanRsp  : array[0..16] of word = (($9000+6),16,1,0,0,1000,5000,0,1,0,0,1000,5000,0,1,0,0);

const MaxSize = 1999;
type  DataArrayType = array[0..MaxSize] of DataType;
type  WordArrayType = array[0..MaxSize] of Word;
const Rsp     : ^WordArrayType = @NULLMsg;
var   Cmd     : DataArrayType;

const Curve1Base : array[0..90] of integer = ( -32743, 89, 0,
  1697, 512, 6645, -31098, 7000, 4555, 6060, 4,

   600,1100,1100,1100,1480,3180,3560,3760,3980,4200,
  4280,4420,4420,4530,4600,4650,4690,4760,4770,4890,
  4970,5060,5170,5340,5450,5590,5680,5660,5540,5380,
  5210,5040,4900,4770,4650,4560,4480,4390,4300,4230,
  4180,4170,4100,4060,3970,3950,3970,3920,3920,3920,
  3900,3880,3820,3710,3660,3560,3430,3220,3120,3030,
  2830,2600,2460,2350,2350,1910,1960,1850,1570,1510,
  1510,1440,0770,0630,0770,0770,0980,0560,0490,0080);


procedure LoadResponse;
var C : word;
begin
  C := Cmd[0].W;
  if (C and $8000) <> 0 then
  begin
    Rsp := @ILLrsp;
    Exit;
  end;
  if CmdChkSum <> TmpChkSum then
  begin
    Rsp := @NAKrsp;
    Exit;
  end;
  case C of
   25: Rsp := @Curve1Base;
   28: Rsp := @VerRsp;
   33: Rsp := @StatRsp;
   $1000+5 : Rsp := @APanRsp;
   $1000+6 : Rsp := @ABPanRsp;
   $1000+28: Rsp := @AVerRsp;
   $1000+33: Rsp := @AStatRsp;
   $7fff: Rsp := @ILLrsp;
   else Rsp := @ILLrsp;
  end;
end;


{$F+}
procedure FakerTimeInt; interrupt;
begin
  FakerClock.SysClk := succ(FakerClock.SysClk) and $7fff;
  inline($9C/$FF/$1E/OldInt1C);
end;


{-------------------------------------------------}

function USTick:longint; assembler;
asm
  cli
  mov al,0
  mov dx,$43
  out dx,al
  mov dx,$40
  jmp @d1
@d1:
  jmp @d2
@d2:
  in al,dx
  mov ah,al
  in al,dx
  xchg al,ah
  sti
end;

function MStick:longint;
begin
  FakerClock.USClk := USTick;
  MSTick := FakerTime;
{  MStick := longint(FakerTime) shr 6;}
end;


type str12 = string[12];
const Hex : array[0..15] of char = (
        '0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');
function HexW(W:word):str12;
var s : str12;
begin
  s[0] := #4;
  s[1] := Hex[(W shr 12) and $f];
  s[2] := Hex[(W shr 8) and $f];
  s[3] := Hex[(W shr 4) and $f];
  s[4] := Hex[W and $f];
  Hexw := s;
end;
type str20 = string[20];
function fstr(L:longint):str20;
var s : str20;
begin
  str(L,s);
  fstr := s;
end;


function GetParams:boolean;
var pcnt : integer;
var Pstr : string[255];
var TL : longint;
var err : integer;
begin
  GetParams := false;
  pcnt := ParamCount;
  if pcnt = 0 then Exit;

  while Pcnt > 0 do
  begin
    PStr := ParamStr(Pcnt);
    if upcase(Pstr[1]) = 'C' then
    begin
      if (Pstr[2] >= '0') or (Pstr[2] <= '9') then
        IOport := ord(Pstr[2]) and $f
      else IOport := 0;
    end
    else
    begin
    case upcase(Pstr[1]) of
      '6': if upcase(Pstr[2]) = '5' then
             DeviceType := 0
           else if upcase(Pstr[2]) = '4' then
             DeviceType := 1;
      'F': if (upcase(Pstr[2]) = 'P') then
           begin
             if upcase(Pstr[3]) = '4' then
               DeviceType := 40
             else if upcase(Pstr[3]) = '3' then
               DeviceType := 35;
           end
           else if (upcase(Pstr[2]) = 'A') then
           begin
             if (upcase(Pstr[3]) = '1') and (upcase(Pstr[4]) = '0') then
               DeviceType := 100
             else if (upcase(Pstr[3]) = '1') and (upcase(Pstr[4]) = '2') then
               DeviceType := 102
             else if (upcase(Pstr[3]) = '1') and (upcase(Pstr[4]) = '8') then
               DeviceType := 108;
           end;
      'B': begin
             delete(Pstr,1,1);
             val(Pstr,TL,Err);
             case TL div 10 of
               480  : Baudrate := 4800;
               960  : Baudrate := 9600;
               1920 : Baudrate := 19200;
               2880 : Baudrate := 28800;
               3840 : Baudrate := 38400;
               5760 : Baudrate := 57600;
               11520: Baudrate := 115200;
               else Baudrate := 9600;
             end;
           end;
      'F': begin
             delete(Pstr,1,1);
             FileName := Pstr;
           end;
      'Q': QTerm := not(QTerm);
      'R': begin
             delete(Pstr,1,1);
             val(Pstr,TL,Err);
             PollDelayTime := TL;
           end;
      'Z': Silent := not(Silent);
      'I' : ImmediatePoll := true;
     end;
   end;
   dec(Pcnt);
  end;
  GetParams := true;
end;

function FryersOK:boolean;
var rax,rdx : word;
begin
  FryersOK := false;
  asm
    mov ax,$ffff
    mov dx,[comport]
    int $14
    mov [rdx],dx
    mov [rax],ax
  end;
  if (rdx = $ffff) and (rax >= $40) and (rax < $7fff) then
    FryersOK := true;
end;

function PortOK:boolean;
begin
  PortOK := false;
  if (IOport > 2) or (IOport < 1) then Exit;
  comport := pred(IOport);
  PortOK := true;
end;

function InitRS232:boolean;
begin
  InitRS232 := false;
  case (baudrate div 10) of
     480: InitP := $C3;
     960: InitP := $E3;
    1920: InitP := $03;
    2880: InitP := $23;
    3840: InitP := $43;
    5760: InitP := $63;
   11520: InitP := $83;
  end;

  asm
    mov ax,$FF00 {make use fryers is off}
    mov cx,$FF00
    mov dx,[comport]
    int $14
    mov ax,$FF00  {now set interrupt based character mode}
    mov cx,$FFFF
    mov dx,[comport]
    int $14
    mov al,[Initp] {and init the port to the desired baudrate}
    mov ah,0
    mov dx,[comport]
    int $14
    mov ax,$FF04  {turn on RTS}
    mov cx,$ffff
    mov dx,[comport]
    int $14
    mov ax,$FF05  {turn on DTR}
    mov cx,$ffff
    mov dx,[comport]
    int $14
    mov ax,$FF08  {turn off CTS}
    mov cx,$ff00
    mov dx,[comport]
    int $14
  end;
  InitRS232 := true;
end;

procedure CloseRS232;
begin
  asm
    mov ax,$FF00   {kill fryers}
    mov cx,$FF00
    mov dx,[comport]
    int $14
  end;
end;

function GetTick:word; assembler;
asm
  mov ax,$ff17
  mov ch,3
  mov cl,0
  mov dx,[comport]
  int $14
end;

{------------------------------------}
{ service the commands}

procedure FlushPort; assembler;
asm
  mov ax,$ff06
  mov dx,[comport]
  int $14
end;

function RcvIt:byte; assembler;
asm
  mov ah,2
  mov dx,[comport]
  int $14
end;
function RcvReady:boolean; assembler;
asm
  mov ah,03
  mov dx,[comport]
  int $14
  mov al,ah
  and al,$01
end;

function GetByte(var What:byte):boolean;
begin
  GetByte := false;
  PollStartTime := 0;
  PollCountTime := DlyCnt;
  if FirstTime then PollStopTime := PollDelayTime
    else PollStopTime := RcvTimeOut;
  while not(RcvReady) do
  begin
    dec(PollCountTime);
    if PollCountTime = 0 then
    begin
      inc(PollStartTime);
      if PollStartTime > PollStopTime then Exit;
      PollCountTime := DlyCnt;
    end;
  end;
  What := RcvIt;
  FirstTime := false;
  GetByte := true;
end;

function GetData(var What:DataType):boolean;
begin
  GetData := false;
  if not(GetByte(What.LO)) then Exit;
  if not(GetByte(What.HI)) then Exit;
  GetData := true;
end;

{---------------------------------------------}
function SendReady:boolean; assembler;
asm
  mov ah,03
  mov dx,[comport]
  int $14
  mov al,0
  and ah,$20
  jz @done
  mov al,1
 @done:
end;
procedure SendIt(What:byte); assembler;
asm
  mov al,[what]
  mov ah,01
  mov dx,[comport]
  int $14
end;
function SendByte(What:byte):boolean;
var StartClk : word;
begin
  SendByte := false;
  StartClk := SysClock;
  while not(SendReady) do
  begin
    if SysClock-StartClk > SendTimeOut then Exit;
  end;
  SendIt(What);
  SendByte := true;
end;
function SendWord(What:word):boolean;
begin
  SendWord := false;
  if not(SendByte(lo(What))) then Exit;
  if not(SendByte(hi(What))) then Exit;
  SendWord := true;
end;
function SendPoll:boolean;
begin
  SendPoll := false;   Error := $100;
  if not SendWord(POLLMsg[0]) then Exit; Error := $100+1;
  if not SendWord(POLLMsg[1]) then Exit; Error := $100+2;
  if not SendWord(POLLmsg[2]) then Exit; Error := $100+3;
  SendPoll := true;
end;
{-------------------------------------------------------}

function GotCmd:boolean;
var i,Size : integer;
begin
  GotCmd := false; Error := $200;
  TmpChkSum := 0;
  FirstTime := true;
  if not(GetData(Cmd[0])) then Exit; Error := $200+1;
  TmpChkSum := TmpChkSum+Cmd[0].W;
  if not(GetData(Cmd[1])) then Exit; Error := $200+2;
  TmpChkSum := TmpChkSum+Cmd[1].W;
  Size := Cmd[1].W+2;
  I := 2;
  if (Size > pred(MaxSize)) then Exit; Error := $200+3;
  while i < Size do
  begin
    if not(GetData(Cmd[i])) then Exit; Error := $200+4;
    TmpChkSum := TmpChkSum+Cmd[i].W;
    inc(i);
  end;
  CmdChkSum := not(TmpChkSum);
  if not(GetData(Cmd[i])) then Exit; Error := $200+5;
  TmpChkSum := Cmd[i].W;
  GotCmd := true;
end;

function SendResponse:boolean;
var i,C : integer;
begin
  SendResponse := false;
  Error := $300;
{  Rsp := @NoRsp; }
  if not(Qterm) or (Qterm and (Cmd[0].W <> $7fff)) then
  begin
    LoadResponse;
    SendChkSum := 0;
    C := Rsp^[1]+2;
    if C > MaxSize then Exit; Error := $300+1;
    i := 0;
    While i < C do
    begin
      if not SendWord(Rsp^[i]) then Exit; Error := $300+2;
      SendChkSum := SendChkSum+Rsp^[i];
      inc(i);
    end;
    SendChkSum := not(SendChkSum);
    if not SendWord(SendChkSum) then Exit; Error := $300+3;
  end;
  SendResponse := true;
end;

procedure DoPollDelay;
begin
  PollStartTime := 0;
  PollCountTime := DlyCnt;
  PollStopTime := PollDelayTime;
  while true do
  begin
    if RcvReady then {nop};
    dec(PollCountTime);
    if PollCountTime = 0 then
    begin
      inc(PollStartTime);
      if PollStartTime > PollStopTime then Exit;
      PollCountTime := DlyCnt;
    end;
  end;
end;

procedure CalibrateFakerTime;
var StartTick:word;
label Done;
begin
  DlyCnt :=0;
  StartTick := SysClock;
  while StartTick = SysClock do {nop};
  StartTick := SysClock;
  while true do
  begin
    if RcvReady then {nop};
    if SysClock-StartTick >= 10 then goto Done;
    inc(DlyCnt);
  end;
Done:
  DlyCnt := DlyCnt div (55*10);
end;

procedure ServiceCommands;
begin
  FlushPort;
  Error := 0;
  if not SendPoll then Exit;
  if GotCmd then
  begin
    if not SendResponse then Exit;
    if not ImmediatePoll then
      DoPollDelay;
  end;
  Error := 0;
end;

procedure FakerExit; far;
begin
  ExitProc := ExitSave;
  SetIntVec($1C,OldInt1C);
end;


{-----------------}
{main}
begin
  Test8086 := 0; {turn off 32bit math}
  GetIntVec($1C,OldInt1C);
  ExitSave := ExitProc;
  ExitProc := @FakerExit;
  FakerTime := 0;
  SetIntVec($1C,@FakerTimeInt);
  FileName := '';
  new(SendData);

  fillchar(Cmd,sizeof(cmd),0);
  Writeln('Fake Fonix V1.02 as of 2 Dec 1997 -med');
  if not(FryersOK) then
  begin
    Writeln('LOAD ERROR:');
    Writeln(' This MSDOS program requires that FRYERS.COM V4.0');
    Writeln(' or better to be loaded in the computer.');
    Halt(1);
  end;

  if not GetParams then
  begin
    Writeln('COMMAND ERROR:');
    Writeln(' The Format is: FAKER Cn Bn ...whatever...');
    Writeln('Cn : C1 - Select Port 1 (Port 1 = default)');
    Writeln('Bn : B9600 - Select 9600 baud (9600 = default)');
    Writeln('Rn : R50 - Poll delay wait time in ms (50ms = default)');
    Writeln('I  : Do an Immediate poll after command send');
    Writeln('Q  : Disallow Quick Terminate operation');
    Writeln('Z  : Silent running (don''t show status)');
    Writeln('Ffilename : Send a binary file out the port');
    Halt(2);
  end;

  if not PortOK then
  begin
    Writeln('PORT ERROR:');
    Writeln(' Invalid PORT selected. Use either 1 or 2');
    Writeln(' If you have special needs, see the SetPort program');
    Writeln(' in order to modify the operation of Fryers.com');
    Halt(3);
  end;

  if not InitRS232 then
  begin
    writeln('PARAMETER ERROR:');
    Writeln('  Invalid baudrate selected. ');
    Writeln('  Only the following are allowed:');
    Writeln('   4800, 9600, 19200, 28800, 38400, 57600, 115200');
    Halt(4);
  end;

  if length(Filename) > 0 then
  begin
    assign(fo,Filename);
    reset(fo,1);
    blockread(fo,SendData,sizeof(SendData),Count);
    for i := 0 to Count do
    begin
      if SendByte(SendData^[i]) = TRUE then {};
    end;
    CloseRS232;
  end;

  Writeln;
  CalibrateFakerTime;
  While not KeyPressed do
  begin
    ServiceCommands;
    if not Silent then
    begin
      write('Cmd:'+hexW(Cmd[0].W)+':'+hexW(Cmd[1].W)+':'+hexW(Cmd[2].W)+
           ' Rsp:'+hexW(Rsp^[0])+':'+HexW(Rsp^[1])+':'+HexW(Rsp^[2])+
           ' Err:'+hexW(Error)+':Rs'+hexW(SendChkSum)+':Cs'+hexW(CmdChkSum)+':Ts'+hexW(TmpChkSum)+
           'U'+fstr(FakerTime));
      write(#13);
    end;
  end;

  CloseRS232;
end.
