unit Dc2form;
interface
uses FryersP,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls,DC2unit, StdCtrls;

type
  TForm1 = class(TForm)
    PaintBox: TPaintBox;
    Label1: TLabel;
    BaudrateLabel: TLabel;
    ComRadioGroup: TRadioGroup;
    StartStopButton: TButton;
    PawsButton: TButton;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure ComRadioGroupClick(Sender: TObject);
    procedure PawsButtonClick(Sender: TObject);
    procedure StartStopButtonClick(Sender: TObject);
  private
    { Private declarations }
   // procedure AppIdle(Sender: TObject; var Done: Boolean);
  public
    { Public declarations }
     tw : integer;
     th : integer;
     MemImage : TBitmap;
     procedure RefreshBitMap;
     procedure WritePixel(x,y:integer; c:tcolor);
  end;

var
  Form1: TForm1;


procedure StartGraph;
procedure Plot(x,y:word; c:Tcolor);
procedure SetPixelColor(FColor,BColor:Tcolor);
procedure xyWrite(x,y:word; s:string; color:TColor);


implementation

{$R *.DFM}

{-----------------------------------------------------------------------}
{ set screen to graphic mode}
procedure StartGraph;
begin
  Form1.tw := 8; {Form1.PaintBox.canvas.textwidth('X'); }
  Form1.th := 8; {Form1.PaintBox.canvas.textheight('X');}
  with Form1.MemImage,Canvas do
  begin
    Font := Form1.PaintBox.Font;
    Pen.Color := BackColor;
    Brush.Color := BackColor;
    Rectangle(0,0,Width,Height);
  end;
end;

{-----------------------------------------------------------}
procedure Plot(x,y:word; c:Tcolor);
begin
  Form1.WritePixel(x,y,c);
end;

procedure SetPixelColor(FColor,BColor:Tcolor);
begin
  Form1.MemImage.Canvas.Pen.Color := FColor;
end;

{-----------------------------------------------------------}
procedure xyWrite(x,y:word; s:string; color:TColor);
var x1,y1,x2,y2:integer;
begin
  x1 := pred(x)*Form1.tw;
  y1 := pred(y)*Form1.th;
  x2 := x1+(length(s)*Form1.tw);
  y2 := y1+Form1.th;
  with Form1.MemImage.Canvas do
  begin
    Pen.Color := BackColor;
    Brush.Color := BackColor;
    Rectangle(x1,y1,x2,y2);
    Font.Color := color;
    TextOut(x1,y1,s);
  end;
end;

{-----------------------------------------------------------}
procedure TForm1.RefreshBitMap;
begin
  Form1.PaintBox.Canvas.CopyMode := cmSrcCopy;
  Form1.PaintBox.Canvas.StretchDraw(Form1.PaintBox.Canvas.ClipRect,Form1.MemImage);
end;

procedure TForm1.WritePixel(x,y:integer; c:TColor);
begin
   MemImage.Canvas.Pixels[x,y] := c;
end;

//procedure TForm1.AppIdle(Sender: TObject; var Done: Boolean);
//begin
{//  Done := true;}
//end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  IamRunning := false;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
{//  Application.OnIdle := AppIdle;}
  SerialPort := ComRadioGroup.ItemIndex+1;
  LoadFryers;
  form1.MemImage := TBitmap.Create;
  form1.MemImage.Width := Form1.PaintBox.Width;
  form1.MemImage.Height := Form1.PaintBox.Height;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  RefreshBitmap;
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  RefreshBitMap;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
   Refreshbitmap;
end;

procedure TForm1.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if (Key = #$1B) or (Key = ^C) then
    Close;
end;

procedure TForm1.ComRadioGroupClick(Sender: TObject);
begin
  IamRunning := false;
  while (IamBusy = true) do
    Application.ProcessMessages;
  SerialPort := ComRadioGroup.ItemIndex+1;
end;

procedure TForm1.PawsButtonClick(Sender: TObject);
begin
   if (Paws = true) then
   begin
     PawsButton.Caption := 'Pause';
     Paws := false;
   end
   else
   begin
     PawsButton.Caption := 'Run';
     Paws := true;
   end;
end;

procedure TForm1.StartStopButtonClick(Sender: TObject);
begin
  if (IamRunning = true) then
  begin
    IamRunning := false;
    Exit;
  end
  else
  begin
    IamRunning := true;
    StartStopButton.Caption := 'Stop';
  end;
  Application.ProcessMessages;
  Form1.BaudrateLabel.Caption := 'Initializing';
  if (StartMeUp = false) then
  begin
    IamRunning := false;
    BaudrateLabel.Caption := 'Port Init Failed';
    StartStopButton.Caption := 'Start';
  end
  else
  begin
    GetBaudrate;
    Form1.BaudrateLabel.Caption := BaudrateString;
  end;
  Form1.Label1.Caption := FryersVersionString;
  Application.ProcessMessages;

  while (IamRunning = true) do
  begin
    if (DoMe = false) then
    begin
      IamRunning := false;
    end
    else
    begin
      GetBaudrate;
      Form1.BaudrateLabel.Caption := BaudrateString;
      Form1.RefreshBitmap;
    end;
    Application.ProcessMessages;
  end;

  CloseRS232;
  StartStopButton.Caption := 'Start';
  BaudrateLabel.Caption := 'Press Start to begin';
end;

end.
