rem TBCURVE.BAS  writen by Michael Day - 11/02/87  updated 06/30/89
rem Copyright 1987,1989   Frye Electronics, Inc.
rem Sample Turbo Basic  program to show usage of the
rem Frye Instrument Packet Protocol interface program - FRYERS.COM
rem  NOTE - you *must* have the latest version (1987 or later)
rem  of FRYERS.COM loaded to use this program
rem program derived from Turbo Pascal version
rem development time - 3 hours
rem init all variables and arrays before going to main

  defint a-z
  ax = 1 : bx = 2 : cx = 3 : dx = 4 : si = 5 : di = 6 : ds = 8
  i=0:ii=0:lm=0:x=0:da=0:db=0:x1=0:x2=0:y1=0:y2=0:hexwrd=0
  h$="" : c$="C1"
  true = 1 : false = 0
  debug = true       : rem init stuff
  tcolor = 3  : rem  {text color}
  bcolor = 2  : rem  {box color}
  ccolor = 1  : rem  {curve color}
  black = 0   : rem  {background color}
  comport = 0 : rem  {COM port to use - 0 or 1 }
  scale = 120 : rem used to print numbers on left of box
  ts = 120    : rem temp scaling value
  poff = (scale*2)+10 : rem offset used to plot starting at bottom of box
  dim xtab[100]
  dim sary[1200]       : rem dimension all the arrays
  dim raryx[1200]
  dim pary[1200,2]

  restore xtabdata : rem read in the xtab data
  for i = 0 to 79
    read xtab[i]
  next i

  gosub clrarys
  goto main : rem go run the program

rem  this is used to plot the vertices to draw the graph
xtabdata:
  data   0, 36, 57, 72, 84, 93,102,108,114,120
  data 125,129,134,137,141,144,148,151,153,156
  data 159,161,163,165,168,170,172,173,175,177
  data 179,180,182,184,185,187,188,189,191,192
  data 193,195,196,197,198,199,200,202,203,204
  data 205,206,207,208,209,210,210,211,212,213
  data 214,215,216,216,217,218,219,219,220,221
  data 222,222,223,224,225,225,226,227,227,228

rem {----------------------------------------------------}
rem {convert an integer word to hex string}

hexword:
    h$ = hex$(hexwrd)
    while len(h$) < 4
       h$ = "0"+h$
    wend
return

rem {-----------------------------------------------------------------}
rem {this displays debug informaton while waiting for response}

showregs:
    if debug = false then return

    locate 19,34,0
    print "STATUS";
    locate 20,34,0
    hexwrd = reg (ax) : gosub hexword : print "AX:"+h$;
    locate 21,34,0
    hexwrd = reg (bx) : gosub hexword : print "BX:"+h$;
    locate 22,34,0
    hexwrd = reg (cx) : gosub hexword : print "CX:"+h$;
    locate 23,34,0
    hexwrd = reg (dx) : gosub hexword : print "DX:"+h$;

    locate 2,6,0
    if (reg (ax) and &hff9c) <> 0 then print "ERROR  ";
    locate 2,6,0
    if (reg (ax) and &h0040) <> 0 then print "NO POLL";
return

rem {------------------------------------------------}
rem {init screen to proper graphic mode}

initgraph:
    key off
    screen 1
    color black, 0
return

rem {--------------------------------------------------------------------}
rem { This procedure enables the RS232 comport for use with the software. }
rem { we'll assume that fryers is loaded already. }

initRS232:
    reg ax, &hff00 : rem {disable fryers interrupt procedure}
    reg cx, &hff00 : rem {this makes sure everything is kosher}
    reg dx, comport
    call interrupt &H14
    reg ax, &hff00 : rem {enable fryers interrupt procedure}
    reg cx, &hffff
    reg dx, comport
    call interrupt &H14
    reg ax, &hff10 : rem {enable fryers packet protocol}
    reg cx, &hffff
    reg dx, comport
    call interrupt &H14
    reg ax, &hffff : rem {check on version number}
    reg dx, comport
    call interrupt &H14
    if (reg (ax) and &hff) > &h20 then goto AutoBaud
      reg ax, &h00e3 : rem {init to 9600 baud, no parity, 8 data bits}
      reg dx, comport : rem {no autobaud}
      call interrupt &H14
      return
AutoBaud:
      reg ax, &h00f3 : rem {init to 9600 baud, no parity, 8 data bits}
      reg dx, comport : rem {with autobaud}
      call interrupt &H14
      return 

rem {---------------------------------------------------------------------}
rem { kills the fryers packets and returns the port to normal operation}
closeRS232:
    reg ax, &hff00 : rem {disable fryers interrupt procedure}
    reg cx, &hff00 : rem {this makes sure everything is kosher}
    reg dx, comport
    call interrupt &H14
    return

rem {---------------------------------------------------------------------}
rem { waits for int14 to be ready to accept send cmd}

sendwait:
    reg ax, &h0ff13
    reg dx, comport
    call interrupt &H14
    k$=k$+inkey$
    if ((reg (ax) and &h0001) = 0) and (len(k$)=0) then goto sendwait
return

rem {--------------------------------------------------------------------}
rem { sends a cmd to target via the rs232 port}

sendcmd:
    gosub sendwait
    reg ds, varseg(sary[1])
    reg bx, varptr(sary[1])
    reg ax, &hff11
    reg dx, comport
    call interrupt &H14
return

rem {------------------------------------}
rem {wait for a reponse from target}

rspwait:
    reg ax, &hff13
    reg dx, comport
    call interrupt &H14
    gosub showregs
    k$ = k$+inkey$
    if ((reg (ax) and &h0001) <> 1) and (len(k$)=0) then goto rspwait
return

rem {----------------------------------------------------------------------}
rem { gets a response packet of integers from the rs232 comport. }

getresponse:
    gosub rspwait
    reg ax, &Hff12
    reg ds, varseg(raryx[1])
    reg bx, varptr(raryx[1])
    reg dx, comport
    call interrupt &H14
    for i = 1 to 100
      pary[i,1] = raryx[i] : rem { convert rsp to plot format}
    next i
    raryx[2] = 0
return

rem {----------------------------------------------------------------}
rem {draw the fixed stuff on the screen}

dobox:
    c$ = str$(bcolor)
    if len(c$) > 1 then c$ = mid$(c$,2,1)
    c$ = "C"+c$

    draw c$+"BM30,186 M262,186"
    draw c$+"BM262,186 M262,0"
    draw c$+"BM262,0 M30,0"
    draw c$+"BM30,0 M30,186"

    for i = 1 to 18
      ii = i * 10
      def seg = varseg(ii)
      draw c$+"BM25,="+varptr$(ii)+" M29,="+varptr$(ii)
    next i

    for i = 1 to 19
      ii = (i * 12) + 31
      def seg = varseg(ii)
      draw c$+"BM="+varptr$(ii)+",187 M="+varptr$(ii)+",190"
    next i

    locate 25,5,0 :  print".12";
    locate 25,9,0 :  print".25";
    locate 25,14,0:  print".5";
    locate 25,19,0:  print"1";
    locate 25,24,0:  print"2";
    locate 25,28,0:  print"4";
    locate 25,33,0:  print"8";

    locate 1,34,0 : print "SOURCE";
    locate 4,34,0 : print "RMS OUT";
    locate 7,34,0 : print "TOP VAL";
    locate 10,34,0: print "N.R.";
    locate 13,34,0: print "FLAGS";
return

rem {------------------------------------------------------}
rem {update the numbers for the curve}

miscinfo:
    locate 2,34,0
    print "      ";
    locate 2,34,0 : rem {source}
    h$ = str$(pary[8,1])
    if len(h$) > 1 then h$ = right$(h$,len(h$)-1)
    if pary[8,1] = 0 then print "OFF"; else print h$;

    locate 5,34,0
    print "      ";
    locate 5,34,0 : rem {rms out}
    h$ = str$(pary[10,1])
    if len(h$) > 1 then h$ = right$(h$,len(h$)-1)
    print h$;

    locate 8,34,0
    print "      ";
    locate 8,34,0 : rem {top val}
    h$ = str$(pary[9,1])
    if len(h$) > 1 then h$ = right$(h$,len(h$)-1)
    print h$;

    locate 11,34,0
    print "      ";
    locate 11,34,0 : rem {noise reduction}
    h$ = str$(pary[11,1])
    if len(h$) > 1 then h$ = right$(h$,len(h$)-1)
    if pary[11,1] = 0 then print "OFF" else print h$;

    locate 14,34,0
    print "      ";
    locate 14,34,0 :  rem {flags a}
    hexwrd = pary[4,1] : gosub hexword : print h$;

    locate 15,34,0
    print "      ";
    locate 15,34,0 : rem {flags b}
    hexwrd = pary[5,1] : gosub hexword : print h$;
return

rem {-------------------------}
rem {figure out what the scale is and show it on the graph}

findscale:
    ts = int(pary[9,1] / 100)
    scale = (int(ts / 20)*20) + 20
    if scale < 0 then scale = 0
    if scale > 185 then scale = 185
    poff = (scale*2)+10

    locate 2,6,0 : rem check if power or gain curve
    if (pary[4,1] and &h4000) = 0 then print  "dBSPL   "; else print "GAIN   ";
    locate 2,6,0
    if pary[4,1] = &h0400 then print "INVALID"; : rem bad curve
    locate 2,6,0
    if (pary[1,1] and &h4000) <> 0 then print "BAD RSP"; : rem unexpected rsp

    h$ = str$(scale+00)
    if len(h$) > 3 then h$ = right$(h$,len(h$)-1)
    locate 2,1 : while len(h$)<3:h$=" "+h$:wend: print h$;
    h$ = str$(scale-20)
    if len(h$) > 3 then h$ = right$(h$,len(h$)-1)
    locate 7,1 : while len(h$)<3:h$=" "+h$:wend: print h$;
    h$ = str$(scale-40)
    if len(h$) > 3 then h$ = right$(h$,len(h$)-1)
    locate 12,1: while len(h$)<3:h$=" "+h$:wend: print h$;
    h$ = str$(scale-60)
    if len(h$) > 3 then h$ = right$(h$,len(h$)-1)
    locate 17,1: while len(h$)<3:h$=" "+h$:wend: print h$;
    h$ = str$(scale-80)
    if len(h$) > 3 then h$ = right$(h$,len(h$)-1)
    locate 22,1: while len(h$)<3:h$=" "+h$:wend: print h$;
return

rem {------------------------------------------------}
rem {display the curve we just receieved}

dispcurve:
  lm = 32 : rem  {left margin on graph}
  i = 12  : rem  {start with 100hz plot}
  x = 0

dispcloop:
  rem get x,y points (draw and undraw)
  da = poff - (pary[i,1] / 50)
  if da>185 then da=185 else if da<1 then da=1
  db = poff - (pary[i+1,1] / 50)
  if db>185 then db=185 else if db<1 then db=1
  y1 = pary[i,2]
  y2 = pary[i+1,2]
  pary[i,2] = da
  x1 = xtab[x]+lm
  x2 = xtab[x+1]+lm
  i = i + 1
  x = x + 1
  rem skip next when xa = xb
  if x1<x2 then goto noadj
  i = i + 1
  x = x + 1
noadj:
  rem undraw old curve
  c$ = str$(black)
  if len(c$) > 1 then c$ = mid$(c$,2,1)
  c$ = "C"+c$
  def seg = varseg(x1)
  draw c$+"BM="+varptr$(x1)+",="+varptr$(y1)+" M="+varptr$(x2)+",="+varptr$(y2)

  rem now draw new curve
  c$ = str$(ccolor)
  if len(c$) > 1 then c$ = mid$(c$,2,1)
  c$ = "C"+c$
  rem get new y points to draw new line with (we still have current x points)
  y1 = da
  y2 = db
  def seg = varseg(x1)
  draw c$+"BM="+varptr$(x1)+",="+varptr$(y1)+" M="+varptr$(x2)+",="+varptr$(y2)

  if x < 79 then goto dispcloop
  pary[i,2] = db
  gosub miscinfo
return

rem {--------------------------------------------}
rem {set the arrays at start up to a known value}

clrarys:
    for i = 1 to 100
      pary[i,1] = 2000
      pary[2,1] = 89
    next i
    for i = 1 to 100
      pary[i,2] = 2000
      pary[2,2] = 89
    next i
    for i = 1 to 100
      raryx[i] = 2000
      raryx[2] = 89
    next i
return

rem {-----------------------------------------------}
rem {main program starts here}

main:
   gosub initgraph
   gosub initRS232

prgloop:
   gosub dobox        : rem draw the box on the screen
   sary[1] = 25
   sary[2] = 1
   sary[3] = 0        : rem   {ask for curve 0}
   gosub sendcmd
   gosub getresponse  : rem {get the response}
   gosub findscale    : rem {figure out scaling}
   gosub dispcurve    : rem {now show the curve}
   k$=k$+inkey$
   if len(k$) < 1 then goto prgloop : rem if key pressed abort the program

   screen 2 : rem set 80 col mode
   screen 0 : rem set textmode
   gosub closeRS232
end
