
/*  CCURVE.C   writen by Michael Day - 11/09/87  */
/*  Copyright 1987 Frye Electronics, Inc.  */
/*  Sample C program to show usage of the  */
/*  Frye Instrument Packet Protocol interface program - FRYERS.COM  */
/*  NOTE - you *must* have the latest version (1987 or later)  */
/*  of FRYERS.COM loaded in the computer to use this program   */
/*  Program development time - 10+ hours  */

/* Turbo C include files */
#include <stdio.h>
#include <bios.h>
#include <dos.h>

/* ------------------------- */
/* Local function prototypes */

void hexword(int wrd);          /* convert a word to hex string */
void gotoxy(int col, int row);  /* goto specified text xy position */
void showregs();                /* display the returned status registers */
void initgraph();               /* init screen to graphics mode */
void initRS232();               /* init rs232 port to packet mode */
void closeRS232();              /* close rs232 port to packet mode */
void sendwait();                /* wait till port is ready to send */
void sendcmd();                 /* send a command to target */
void rspwait();                 /* wait for a response from target */
void getresponse();             /* read in received response */
void plot(int x, int y, int color); /* plot a dot on the screen at x,y */
void dodraw(int x1, int y1, int x2, int y2, int color); /* draw curve line */
void ldraw(int x1, int y1, int x2, int y2, int lcolor); /* straight line */
void dobox();                   /* draw display box */
void miscinfo();                /* update misc info on screen */
void findscale();               /* figure out scale of curve */
void dispcurve();               /* display the curve we picked up */
void clrarys();                 /* clear the arrays */

/* ----------------------------------------------- */
/* misc definitions */

#define false    0     /* true and false definitions */
#define true     1

#define cltype   0     /* curve line type - 0=dot/x, 1=x&y, 2=smth x&y */
#define tcolor   3     /* text color */
#define bcolor   2     /* box color */
#define ccolor   1     /* curve color */
#define black    0     /* background color */
#define comport  0     /* COM port to use - 0 or 1  */
#define COMM     0x14  /* rs232 int 14h - used to access fryers.com */
#define VIDEO    0x10  /* video int 10h - used to access BIOS video */
#define palette  0     /* cga palette to use -- 0 = rgy  1 = brw */

/* ------------------------------------------------------------------- */
/* variables and constants */

/* ---------------------------------------------- */
/* this plots the vertices to draw the graph with */

    static int  xtab[80] =
           {0,  36,  57,  72, 84,  93,  102, 108, 114, 120,
          125, 129, 134, 137, 141, 144, 148, 151, 153, 156,
          159, 161, 163, 165, 168, 170, 172, 173, 175, 177,
          179, 180, 182, 184, 185, 187, 188, 189, 191, 192,
          193, 195, 196, 197, 198, 199, 200, 202, 203, 204,
          205, 206, 207, 208, 209, 210, 210, 211, 212, 213,
          214, 215, 216, 216, 217, 218, 219, 219, 220, 221,
          222, 222, 223, 224, 225, 225, 226, 227, 227, 228};

    static char Hex[16] = "0123456789ABCDEF";
    char  hexstring[5];

    union    REGS  regs, vregs;
    struct   SREGS  segregs;

    typedef  int  ioarray[1200];

    int      sary[200];
    ioarray  raryx;
    ioarray  pary1;
    ioarray  pary2;
    char     debug;
    int      ts;
    int      scale;
    int      poff;

/* scale = used to print numbers on left of box */
/* poff = offset used to plot starting at bottom of box */

/* -------------------------- */
/* convert a word to hex */

void hexword (int wrd)
{
    hexstring[0] = Hex[(wrd >> 12) & 15];
    hexstring[1] = Hex[(wrd >>  8) & 15];
    hexstring[2] = Hex[(wrd >>  4) & 15];
    hexstring[3] = Hex[ wrd        & 15];
    hexstring[4] = 0;
}

/* ----------------------------------------------*/
/* move text cursor to desired position */

void gotoxy(int col, int row)
{
     vregs.h.bh = 0;
     vregs.h.dh = row - 1;
     vregs.h.dl = col - 1;
     vregs.h.ah = 0x02;
     int86(VIDEO, &vregs, &vregs);
}

/* ----------------------------------------------------------------- */
/* this displays debug informaton while waiting for response */

void showregs()
{
   if (debug)
   {
     gotoxy(34, 19);
     printf("STATUS");
     gotoxy(34, 20);
     hexword(regs.x.ax);
     printf("AX:");
     printf(hexstring);
     gotoxy(34, 21);
     hexword(regs.x.bx);
     printf("BX:");
     printf(hexstring);
     gotoxy(34, 22);
     hexword(regs.x.cx);
     printf("CX:");
     printf(hexstring);
     gotoxy(34, 23);
     hexword(regs.x.dx);
     printf("DX:");
     printf(hexstring);

     gotoxy(6, 2);
      if ((regs.x.ax & 0x0040) != 0) printf("NO POLL");
      else
       if ((regs.x.ax & 0x0ff9c) != 0) printf("ERROR  ");
   }
}

/* ----------------------------------------------------------------------- */
/*  set screen to graphic mode */

void initgraph()
{
     regs.x.ax = 0x04;        /* cga mode */
/*   regs.x.ax = 0x10;  */    /* ega mode */
     int86(VIDEO, &regs, &regs);   /* select video mode */

     regs.x.ax = 0x0b00;
     regs.h.bh = 0;
     regs.h.bl = black;
     int86(VIDEO, &regs, &regs);   /* set background color */

     regs.x.ax = 0x0b00;
     regs.h.bh = 01;
     regs.h.bl = palette;
     int86(VIDEO, &regs, &regs);   /* select color palette */
}

/* ----------------------------------------------------------------------- */
/*  This procedure enables the RS232 port1 for use with the software.  */

void initRS232()
{
     regs.x.ax = 0xff00;   /* disable fryers interrupt procedure */
     regs.x.cx = 0xff00;   /* this makes sure everything is kosher */
     regs.x.dx = comport;
     int86(COMM, &regs, &regs);

     regs.x.ax = 0xff00;   /* enable fryers interrupt procedure */
     regs.x.cx = 0xffff;
     regs.x.dx = comport;
     int86(COMM, &regs, &regs);

     regs.x.ax = 0x00e3;   /* init to 9600 baud, no parity, 8 data bits */
     regs.x.dx = comport;
     int86(COMM, &regs, &regs);

     regs.x.ax = 0xff10;   /* enable fryers packet protocol */
     regs.x.cx = 0xffff;
     regs.x.dx = comport;
     int86(COMM, &regs, &regs);
}

/* ----------------------------------------------------------------------- */
/*  This procedure closes the RS232 port1 for use with the software.  */

void closeRS232()
{
     regs.x.ax = 0xff00;   /* disable fryers interrupt procedure */
     regs.x.cx = 0xff00;   /* this makes sure everything is kosher */
     regs.x.dx = comport;
     int86(COMM, &regs, &regs);
}

/* ----------------------------------------------------------------------- */
/*  waits for int14 to be ready to accept send cmd */

void sendwait()
{
   do
   {
     regs.x.ax = 0x0ff13;
     regs.x.dx = comport;
     int86(COMM, &regs, &regs);
   }
   while ((regs.x.ax & 0x0001) == 0);
}

/* ----------------------------------------------------------------------- */
/*  sends a cmd to target via the rs232 port */

void sendcmd()
{
   static ioarray far *sptr = &sary[1];

     sendwait();
     regs.x.ax = 0xff11;
     regs.x.dx = comport;
     regs.x.bx = FP_OFF(sptr);
     segregs.ds = FP_SEG(sptr);
     int86x(COMM, &regs, &regs, &segregs);
}

/* ----------------------------------------------------------------------- */
/*  waits for response from target */

void rspwait()
{
   do
   {
     regs.x.ax = 0x0ff13;
     regs.x.dx = comport;
     int86(COMM, &regs, &regs);
     showregs();
   }
   while ((regs.x.ax & 0x0001) == 0) ;
}

/* ----------------------------------------------------------------------- */
/*  gets a response packet of integers from the rs232 port1.  */

void getresponse()
{
   static ioarray far *rptr = &raryx[1];
   int  i;

     rspwait();
     regs.x.ax = 0xff12;
     regs.x.dx = comport;
     regs.x.bx = FP_OFF(rptr);
     segregs.ds = FP_SEG(rptr);
     int86x(COMM, &regs, &regs, &segregs);
     for (i = 1; i <= 100; i++)
       pary1[i] = raryx[i];   /*  convert rsp to plot format */
     raryx[2] = 0;
}

/* ----------------------------------------------------- */
/* plot a dot on the screen at x,y  in the specified color */

void plot(int x, int y, int color)
{
     regs.h.ah = 12;
     regs.h.al = color;
     regs.x.bx = 0;
     regs.x.cx = x;
     regs.x.dx = y;
     int86(VIDEO, &regs, &regs);   /* plot dot */
}

/* -------------------------------------------- */
/* plot a line on screen, clip to only within box */

void dodraw(int x1, int y1, int x2, int y2, int color)
{
    int x;
    int y;
    int xstep;
    int ystep;
    int deltax;
    int deltay;
    int direction;

    if (y1 > 185) y1 = 185;    /* clip to boundry */
    if (y1 < 1) y1 = 1;
    if (y2 > 185) y2 = 185;
    if (y2 < 1) y2 = 1;

    x = x1;
    y = y1;

    if (x1 == x2) xstep = 0;
    else
      if (x1 > x2) xstep = -1;
      else
        xstep = 1;

    if (y1 == y2) ystep = 0;
    else
      if (y1 > y2) ystep = -1;
      else
        ystep = 1;

    deltax = abs(x2 - x1);
    deltay = abs(y2 - y1);
    if (deltax == 0) direction = -1;
    else
      direction = 0;

    plot(x,y,color);
    do
    {
      if (direction < 0)
      {
        y = y + ystep;
        direction = direction + deltax;
        if ((direction >= 0) || (cltype > 0)) plot(x, y, color);
      }
      else
      {
        x = x + xstep;
        direction = direction - deltay;
        if ((direction >= 0) || (cltype > 1)) plot(x, y, color);
      }
    }
    while (!(( x == x2 ) && ( y == y2 )));
}

/* ------------------------------------------------- */
/* draw a straight line between the indicated points */

void ldraw(int x1, int y1, int x2, int y2, int lcolor)
{
  int x;
  int y;
  x = x1;
  y = y1;
  do
  {
     plot(x,y,lcolor);
     if (x > x2) x--;
     if (x < x2) x++;
     if (y > y2) y--;
     if (y < y2) y++;
  }
  while (!(( x == x2 ) && ( y == y2 )));
}
/* -------------------------------------------- */
/* draw the fixed stuff on the screen */

void dobox()
{
  int  i;

  ldraw(30, 186, 262, 186, bcolor);
  ldraw(262, 186, 262, 0, bcolor);
  ldraw(262, 0, 30, 0, bcolor);
  ldraw(30, 0, 30, 186, bcolor);

  for (i = 1; i <= 18; i++)
  {
    ldraw(25, (i * 10), 29, (i * 10), bcolor);
  }

  for (i = 1; i <= 19; i++)
  {
    ldraw((i * 12) + 31, 187, (i * 12) + 31, 190, bcolor);
  }

  gotoxy(5, 25);  printf(".12");
  gotoxy(9, 25);  printf(".25");
  gotoxy(14, 25); printf(".5");
  gotoxy(19, 25); printf("1");
  gotoxy(24, 25); printf("2");
  gotoxy(28, 25); printf("4");
  gotoxy(33, 25); printf("8");

  gotoxy(34, 1);  printf("SOURCE");
  gotoxy(34, 4);  printf("RMS OUT");
  gotoxy(34, 7);  printf("TOP SPL");
  gotoxy(34, 10); printf("N.R.");
  gotoxy(34, 13); printf("FLAGS");
}

/* ------------------------------------------------------ */
/* update the numbers for the curve */

void miscinfo()
{
  gotoxy(34, 2);
  printf("      ");
  gotoxy(34, 2);                     /* source */
  if (pary1[8] == 0) printf("OFF");
  else printf("%d",pary1[8]);

  gotoxy(34, 5);
  printf("      ");
  gotoxy(34, 5);                     /* rms out */
  printf("%d",pary1[10]);

  gotoxy(34, 8);
  printf("      ");
  gotoxy(34, 8);                     /* top val */
  printf("%d",pary1[9]);

  gotoxy(34, 11);
  printf("      ");                 /* noise reduction */
  gotoxy(34, 11);
  if (pary1[11] == 0) printf("OFF");
  else printf("%d",pary1[11]);

  gotoxy(34, 14);
  printf("      ");
  gotoxy(34, 14);                   /* flags a */
  hexword(pary1[4]);
  printf(hexstring);

  gotoxy(34, 15);
  printf("      ");                 /* flags b */
  gotoxy(34, 15);
  hexword(pary1[5]);
  printf(hexstring);
}

/* ------------------------- */
/* figure out what the scale is and show it on the graph */

void findscale()
{
  ts = (pary1[9] / 100);
  scale = (ts / 20) * 20 + 20;
  if (scale < 0) scale = 0;
  if (scale > 180) scale = 180;
  poff = (scale * 2) + 10;

  gotoxy(6, 2);
  if ((pary1[1] & 0x4000) != 0)       /* unexpected response */
     printf("BAD RSP");
  else
    if (pary1[4] == 0x0400)            /* bad curve */
      printf("INVALID");
    else
      if ((pary1[4] & 0x4000) == 0)   /* power curve */
        printf("dBSPL  ");
      else
        printf("GAIN   ");    /* none of the above, so must be gain */

  gotoxy(1, 2); printf("%3d",scale + 00);
  gotoxy(1, 7); printf("%3d",scale - 20);
  gotoxy(1, 12); printf("%3d",scale - 40);
  gotoxy(1, 17); printf("%3d",scale - 60);
  gotoxy(1, 22); printf("%3d",scale - 80);
}

/* -------------------------------------- */
/* display the curve that we picked up */

void dispcurve()
{
  int da;
  int db;
  int xa;
  int xb;
  int ya;
  int yb;
  int x;
  int i;

  #define lm  32     /* left margin on graph */
  i = 12;            /* start with 100hz plot */
  x = 0;
  do
  {
    da = poff - (pary1[i] / 50);
    db = poff - (pary1[i + 1] / 50);
    ya = pary2[i];
    yb = pary2[i + 1];
    pary2[i] = da;
    xa = xtab[x] + lm;
    xb = xtab[x + 1] + lm;
    i++; x++;
    if (xa == xb) { i++; x++; } /* skip next when xa = xb */
    dodraw(xa, ya, xb, yb, black);  /* undraw */
    dodraw(xa, da, xb, db, ccolor); /* draw new one */
  }
  while (x < 79);
  pary2[i] = db;
  miscinfo();
}

/* -------------------------------------------- */
/* set the arrays at start up to a known value */

void clrarys()
{
  int  i;

  for (i = 1; i <= 100; i++) pary1[i] = 2000;
  pary1[2] = 89;

  for (i = 1; i <= 100; i++) pary2[i] = 0;
  pary2[2] = 89;

  for (i = 1; i <= 100; i++) raryx[i] = 2000;
  raryx[2] = 89;
}

/* ----------------------------------------------- */
/* main program starts here */

main()
{
  debug = true;
  initgraph();
  initRS232();
  scale = 120;
  clrarys();

  do
  {
    dobox();       /* put the fixed stuff on the screen */
    sary[1] = 25;
    sary[2] = 1;
    sary[3] = 0;   /* ask for curve 0 */
    sendcmd();
    getresponse(); /* get the response */
    findscale();   /* figure out scaling */
    dispcurve();   /* now show the curve */
  }
  while (!(kbhit())) ;   /* if key pressed abort the program */

  regs.x.ax = 0x02;
  int86(VIDEO, &regs, &regs);   /* restore screen to 80x25 bw text */
  closeRS232();
}
/* That's all folks!  Go home! */
