//Fryers DLL interface unit for C++
//This will compile under any version of Borland BCB
//Copyright 2001 Frye Electronics, Inc.
//Written by Michael Day as of 22 June 2001
//Note: see FSAMPLES for FryersP.PAS or FryersC.CPP which are more
//extensive Fryers interfaces for Win32 applications.
//----------------------------------------------------
//If you have experience with the older MSDOS based Fryers TSR
//you will find this calling interface to the Fryers driver to be
//exactly the same. It was done this way on purpose to allow easy
//upgrading of old programs and to minimize the learning time
//to upgrading old systems up to Win32.

//#include <stdio.h>
#include <windows.h>  //used to get the DLL calling API from Windows
#include "fryedllc.h" //Fryers register definitions

//The call interface in the DLL looks like this
//typedef void __stdcall (*tCallFryers)(F_RegsType* IRegs);

bool FryersActive = false;
HINSTANCE FryersLibHandle = NULL;
tCallFryers CallFryersProc = NULL;
char FRYERS32_DLL_NAME[] = "fryers32.dll";

//----------------------------------------------------
//This is a wrapper to make the DLL call safe. It also eliminates the
//need to manage the DLL in your program since it is automatically managed here
//If this is a first time caller, the Fryers32.DLL is searched for on the normal
//search path for the computer. If found, the driver is loaded into memory and
//the CallFryers interface is looked for. If found, the procedure pointer is
//updated and the call to the Fryers driver is made. Note: The call to initialize
//the Fryers dll will take up to 200ms to perform. Also if you change the baudrate
//there may be a 200ms delay as Windows does it's thing (I have no control over that).
//Returns FRYERS_FILE_NOT_FOUND if the DLL was not found on the search path.
//returns FRYERS_ENTRY_NOT_FOUND if the CallFryers procedure call was not found.
int __stdcall CallFryers(F_RegsType* pIRegs) {
  FryersActive = true;
  if (FryersLibHandle == NULL) {
    CallFryersProc = NULL;
    FryersLibHandle = LoadLibrary(FRYERS32_DLL_NAME);
    if (FryersLibHandle == NULL) {
      strcpy(ErrorFilename,FRYERS32_DLL_NAME);
      FryersActive = false;
      return(FRYERS_FILE_NOT_FOUND);
    }
  }
  if (CallFryersProc == NULL) {
    CallFryersProc = (tCallFryers)GetProcAddress(FryersLibHandle, "CallFryers");
    if (CallFryersProc == NULL) {       //check if we found the procedure we want
      FreeLibrary(FryersLibHandle); //release the DLL
      FryersLibHandle = NULL;       //and kill the variable
      strcpy(ErrorFilename,FRYERS32_DLL_NAME);
      FryersActive = false;
      return(FRYERS_ENTRY_NOT_FOUND);
    }//endif(CallFryersProc==NULL)
  }//endif(CallFryersProc==NULL)
  CallFryersProc(pIRegs);
  FryersActive = false;
  return(FRYERS_SUCCESS);
};

/*
//Don't use this, the DLL will automatically be unloaded when your program shuts down.
//----------------------------------------------
//For example only. Normally you should not call this.
//Windows till release the DLL properly when the program shuts down.
bool ReleaseFryers(void) {
  bool fFreeResult = FreeLibrary(FryersLibHandle);
  return(fFreeResult);
};
*/

//-------------------------------------------------
// Example call to return Fryers version number
// Here is an example of calling the Fryers driver.
// See the documentaiton and sample code for a detailed
//explaination on using the Fryers driver.
int GetFryersVersion(void) {
  F_RegsType R;
  R.AX = 0x0FFFF;
  R.DX = 0;
  R.CX = 0;
  if (CallFryers(&R) != FRYERS_SUCCESS) return(-1);
  if ((R.DX & 0x0FFFF) != 0x0FFFF)
    R.AL = 0;
  return(R.AL);
}

