
{Unit to convert from Windows BMP format to Frye instrument graphics format}
{V1.00 as of 8-9-99 -med}

unit FryeBmp;
interface
{$I PLATFORM.INC}
{$IFDEF MSDOS}
  uses TestSubs,Dos;
  type F_RegsType = Registers;
  type SmallInt = integer;
{$ENDIF}
{$IFDEF PMDOS}
  uses TestSubs,Dos;
  type F_RegsType = Registers;
  type SmallInt = integer;
{$ENDIF}
{$IFDEF WIN16}
  uses TestSubs,WinDos;
  type F_RegsType = tRegisters;
  type SmallInt = integer;
{$ENDIF}
{$IFDEF WIN32}
   uses Windows,TestSubs,SysUtils;
  {$I FRYEREGS.INC}
{$ENDIF}

{------------------------------------------------------}
{Windows BMP file declaration stuff}
type BmpHeaderType = packed record
       {file header}
       id              : word;   {must be "BM" ($4D42)}
       Filesize        : longint; {ignore}
       reserved        : longint; {ignore}
       HeaderSize      : longint; {ignore}
       {dib header}
       InfoSize        : longint; {ignore}
       Width           : longint; {size in pixels}
       Height          : longint; {size in pixels}
       biPlanes        : word;    {is always 1}
       Bits            : word;    {color bits mono=1}
       biCompression   : longint; {ignore}
       biSizeImage     : longint; {ignore}
       biXPelsPermeter : longint; {ignore}
       biYPelsPermeter : longint; {ignore}
       biClrUsed       : longint; {ignore}
       biClrImportant  : longint; {ignore}
     end;
var BmpHeader : BmpHeaderType;

type BmpPaletteType = packed record
       Item : array[0..1] of longint;
     end;
var BmpPalette : BmpPaletteType;

{note: dib image size = (((Width * Bits) + 31) and not($001F))*Height }
const MaxWinBitmap = 1023; {max allowed bitmap size in dwords}
type WinBitmapType = array[0..MaxWinBitmap] of longint;
     WinBitmapPtr = ^WinBitmapType;
var WinBitmapSize : word;
var WinBitmap : WinBitmapPtr;
{---------------------------------------------------}
{Frye bitmap data declaration stuff}
const MaxFryeBitmap = 1023; {max allowed bitmap size in words}
type FryeBitmapType = array[0..MaxFryeBitmap] of word;
     FryeBitmapPtr = ^FryeBitmapType;
var FryeBitmap : FryeBitmapPtr;
var FryeBitmapSize : word;
var FryeBitmapDataSize : word;

function GetBitmapFile(what:str255):integer;
function ConvertBmpToFrye:integer;

implementation

type too = array[0..100] of char;

function f02(const p00: too; const p01: Char; p02: Integer): Integer;
begin
  repeat Inc(p02);
  until p00[p02] = p01;
  f02 := p02;
end;

{=====================================================}
{convert from Windows BMP format to fp35 bitmap format}
function ConvertBmpToFrye:integer;
const StartOfs = 10;
var k,w,h,x,y,i:integer;
var Data,Tmp : Lval;
var style : integer;
var L : longint;
begin
  ConvertBmpToFrye := -1;  {assume failure}
  style := 2;           {currently only monochrome allowed}
  w := BmpHeader.Width;
  h := BmpHeader.Height;
  if (h <= 0) or (w <= 0) then
  begin
    writeln('Error: Bitmap error (no data found)');
    Exit;
  end;
  w := (BmpHeader.Width div 32);   {BMP is in DWORD format}
  if (BmpHeader.Width mod 32) <> 0 then inc(w);
  i := 0;
  for y := 0 to h-1 do
  begin
    k := ((h-1)-y)*w;
    for x := 0 to w-1 do
    begin
      if ((StartOfs+i)*2) >= sizeof(FryeBitmap^) then
      begin
        writeln('Error: Bitmap error (image too big)');
        ConvertBmpToFrye := -2;
        Exit;
      end;
      {PrinterLabelBitmap^[StartOfs+i] := LabelFileBitmap^[k+x];}
      Data := Lval(WinBitmap^[k+x]);
      L := longint(Data);
      if (BmpPalette.Item[0] = 0) then
        L := not(L);  {pal[0]=black so need to invert the image}
      Data := Lval(L); 
      Tmp.b0 := BitReverse[Data.b0 xor $FF];
      Tmp.b1 := BitReverse[Data.b1 xor $FF];
      Tmp.b2 := BitReverse[Data.b2 xor $FF];
      Tmp.b3 := BitReverse[Data.b3 xor $FF];
      {Need to read the palette to determine black and white pixel settings}
      FryeBitmap^[StartOfs+i] := Dval(Tmp).Lw;
      inc(i);
      FryeBitmap^[StartOfs+i] := Dval(Tmp).Hw;
      inc(i);
    end;
  end;
  FryeBitmapSize := i+StartOfs; {total bitmap size in words}
  FryeBitmapDataSize := i*2;    {bitmap data size in bytes}
  FryeBitmap^[0] := 96;  {printer label bitmap}
  FryeBitmap^[1] := FryeBitmapSize;  {header+data-1 size in words}
  FryeBitmap^[2] := Style;  {mono(2)/color(16)}
  FryeBitmap^[3] := 0;    {xpos}
  FryeBitmap^[4] := 160;  {ypos}
  FryeBitmap^[5] := BmpHeader.Width;  {width}
  FryeBitmap^[6] := BmpHeader.Height; {height}
  FryeBitmap^[7] := 0;    {page}
  FryeBitmap^[8] := FryeBitmapDataSize; {image size in bytes}
  FryeBitmap^[9] := StartOfs; {bitmap data start index (in words)}
  ConvertBmpToFrye := 0;  {success!}
end;

function GetBitmapFile(what:str255):integer;
var Size:integer;
var Err:integer;
var fb:file;
begin
  GetBitmapFile := -1;  {assume failure}
  if not FileExists(What) then
  begin
    writeln('File not found: ',What); {didn't find it}
    Exit;
  end;

  BmpPalette.Item[0] := 0;  {Init default palette entries}
  BmpPalette.Item[1] := $00ffffff;

  assign(fb,What);
  reset(fb,1);
  BlockRead(fb,BmpHeader,sizeof(BmpHeader),Err);
  if ((Err <> sizeof(BmpHeader)) or (BmpHeader.id <> $4D42)) then
  begin
    writeln('Error: Bitmap format error'); {bad bitmap file }
    GetBitmapFile := -2;
    Close(fb);
    Exit;
  end;
  if BmpHeader.HeaderSize >= (sizeof(BmpHeader) + 8) then
  begin
    BlockRead(fb,BmpPalette,sizeof(BmpPalette),Err);
    if Err <> sizeof(BmpPalette) then
    begin
      writeln('Error: Bitmap format error (palette)');
      GetBitmapFile := -2;
      Close(fb);
      Exit;
    end;
  end;

  Seek(fb,BmpHeader.HeaderSize);
  Size := BmpHeader.biSizeImage;
  if (BmpHeader.Bits <> 1) or (FileSize(fb) <> BmpHeader.FileSize) then
  begin
    writeln('Error: Bitmap format error (it needs to be a monochrome BMP file)');
    GetBitmapFile := -3; {bad format}
    Close(fb);
    Exit;
  end;
  if (Size > MaxWinBitmap) then
  begin
    writeln('Error: Bitmap image is too big to send');
    GetBitmapFile := -4; {bad size }
    Close(fb);
    Exit;
  end;
  fillchar(WinBitmap^,sizeof(WinBitmap^),0);
  WinBitmapSize := 0;
  BlockRead(fb,WinBitmap^,Size,Err);
  if Err <> Size then
  begin
    writeln('Error: Bitmap format error'); {bad bitmap file }
    GetBitmapFile := -5;
    Close(fb);
    Exit;
  end;
  WinBitmapSize := Size;
  Close(fb);
  GetBitmapFile := 0;  {success!}
end;

begin
  new(WinBitmap);
  WinBitmapSize := 0;
  new(FryeBitmap);
  FryeBitmapSize := 0;
  FryeBitmapDataSize := 0;
end.
