{$M 32000,0,0}
{$I-}

PROGRAM INSTALL;
uses crti,DOS;

CONST srcdrv   : string = '';
      destdrv  : string = '';
      dpath    : string = '';
      destpath : string = '';
      instfile : string = '';

VAR fi:text;
    ts:string;
    error:integer;
    ch : char;
    result : integer;


procedure upstring(var S:string);
var i : word;
begin
  for i := 1 to length(S) do
  begin
    s[i] := upcase(s[i]);
  end;
end;

procedure makedp(var s:string);
begin
  if length(dpath) = 0 then Exit;
  if length(s) = 0 then
  begin
    s := dpath;
    Exit;
  end;
  if dpath[length(dpath)] = '\' then
    s := dpath+s
  else
    s := dpath+'\'+s;
end;

function Loadfile(s:string):boolean;
var ds,ns : string;
    error:integer;
begin
  LoadFile := false;
  ns := s;
  repeat
    close(fi);
    error := IOresult;
    writeln('Insert ',ns,' into disk drive ',srcdrv);
    writeln('Press any key to continue...');
    while keypressed do ch := readkey;
    ch := readkey;
    if ch = #0 then ch := char(ord(readkey)+$80);
    if (ch = ^C) or (ch = #$1b) then Exit;

    assign(fi,srcdrv+ns);
    reset(fi);
    error := IOresult;
    if error = 0 then
    begin
      readln(fi,ds);
          writeln('found:',ds);
      Error := IOResult;
      if Error = 0 then
        if ds <> ns then error := 1;
    end;
  until error = 0;
  instfile := ns;
  LoadFile := true;
end;

function cmdok(s:string):integer;
var i : integer;
    gs : string;
begin
  cmdok := 9;
  if length(s) = 0 then Exit;
  gs := s;
  delete(gs,1,5);
  if length(gs) = 0 then
  begin
    cmdok := 0;
    exit;
  end;
  s[0] := #4;
  for i := 1 to 4 do
    s[i] := upcase(s[i]);
  if s = ':REM' then Exit;
  if s = ':NEW' then
  begin
    if not LoadFile(gs) then
    begin
      cmdok := 1; {request to read a new disk failed}
    end;
    Exit;
  end;
  if s = ':DST' then
  begin
    makedp(gs);
    destpath := gs;
    Exit;
  end;
  if s = ':DRV' then
  begin
    destdrv := gs;
    Exit;
  end;
  if s = ':SRC' then
  begin
    srcdrv := gs;
    Exit;
  end;
  cmdok := 0;
end;

procedure fixup(var s:string);
var t : string;
    i : integer;
begin
  t := '';
  i := 0;
  while i < length(s) do
  begin
    inc(i);
    if s[i] <> '%' then
    begin
      inc(t[0]);
      t[ord(t[0])] := s[i];
    end
    else
    begin
      inc(i);
      case s[i] of
        '1': t := t+srcdrv;
        '2': t := t+destdrv;
        '3': t := t+destpath;
        else t := t+'%'+s[i];
      end;
    end;
  end;
  s := t;
end;

function drvok(var s:string):boolean;
begin
  drvok := false;
  if length(s) < 2 then Exit;
  if s[2] <> ':' then Exit;
  if upcase(s[1]) < 'A' then Exit;
  if upcase(s[1]) > 'Z' then Exit;
  drvok := true;
end;

procedure pathok(var s:string);
begin
  if length(s) < 1 then Exit; {empty path is ok}
  if (s[length(s)] = '\') and (length(s) > 1) then
    dec(s[0]);    {remove any trailing backslash except for root}
end;

label ErrExit0,ErrExit1,ErrExit2,ErrExit3,ErrExit4,ErrExit5,ErrExit6,ErrExit7;
BEGIN
  checkbreak := true;
  if paramcount = 0 then goto errexit0;
  if paramcount > 1 then goto errexit1;
  ts := paramstr(1);
  upstring(ts);
  if not drvok(ts) then goto errexit3; {must be a valid drive spec}
  destdrv := ts;     {copy drive spec to destdrv}
  destdrv[0] := #2;  {force length to 2}
  delete(ts,1,2);
  pathok(ts);
  dpath := ts;

  srcdrv := ParamStr(0);
  if (SrcDrv = '') or (srcdrv[2] <> ':') then
    GetDir(0,srcdrv);
  if (length(srcdrv) < 2) then goto ErrExit2;
  srcdrv[0] := #2;

  result := IOresult;
  instfile := 'DISK1';
  assign(fi,instfile);
  reset(fi);
  result := IOresult;
  if result <> 0 then goto ErrExit4;
  readln(fi,ts);                           {the first line in the file}
  if ts <> instfile then goto ErrExit5;    {must be the filename}
  readln(fi,ts);                           {the second line must be the}
  makedp(ts);                              {destination path (can be '')}
  destpath := ts;

  writeln('Installing Frye RS232 Technical Support reference');
  writeln('Copyright 1995 Frye Electronics, Inc.  - 11 Jan 94');
  writeln('Installing from ',srcdrv,' to ',destdrv+destpath);
  while not(eof(fi)) do
  begin
    readln(fi,ts);
    result := cmdok(ts);
    case result of
      0 : begin
            fixup(ts);
            writeln(ts);
            EXEC(GetEnv('COMSPEC'),'/C '+ts);  {C:\COMMAND.COM'}
            if DosError <> 0 then
            begin
              case DosError of
                2 : writeln('Error: COMMAND.COM not found');
                8 : writeln('Error: out of memory');
                10: writeln('Error: Invalid enviornment');
                11: writeln('Error: Invalid format');
                else writeln('Dos Error:',DosError);
              end;
              goto ErrExit6;
            end;
          end;
      1 : goto ErrExit2;
      else {ignore};
    end; {case}
    if keypressed then
    begin
      ch := readkey;
      if ch = #0 then ch := char(ord(readkey)+$80);
      if (ch = #$1b) or (ch = ^C) then
      begin
        writeln('Install aborted by operator');
        halt(10);
      end;
    end;
  end;
  halt(0);


ErrExit0:
  writeln('Format is:  INSTALL D:');
  writeln('where D: is the destination hard disk');
  halt(1);

ErrExit1:
  writeln('Error: Invalid parameter list');
  halt(2);

ErrExit2:
  writeln('Error: Invalid source drive');
  halt(3);

ErrExit3:
  writeln('Error: Invalid destination drive');
  halt(4);

ErrExit4:
  writeln('Error: ',instfile,' not found - unable to install');
  halt(5);

ErrExit5:
  writeln('Error: ',instfile,' invalid - unable to install');
  halt(6);

ErrExit6:
  halt(7);
END.
