{ Test is a program used to test audiometer FIPP communications}
{ Version 2.02   as of 30 Sept 97 }
{ Copyright 1992,1993,1994,1997 Frye Electronics, Inc.' }
{ Written by Michael Day }

unit AudTest;
interface
{$I PLATFORM.INC}

{$IFDEF WIN16}
  {$R AUD.RES}
  uses DosCrt,Strings,WinProcs,WinDos,AudFipp,AudSubs;
{$ENDIF}
{$IFDEF ISDOS}
  uses Ticker,dos,AudFipp,AudSubs;
{$ENDIF}
{$IFDEF WIN32}
  uses Windows,AudFipp,AudSubs;
{$ENDIF}


procedure RunProgram;

const UsePort : word = 1;
const UseIRQ : word = 0;

{$I+,R+}
implementation

type string8 = string[8];

const datpath : str255 = 'DAT';

var pfunerr,num : integer;
    temp,Err : integer;
    ch : char;
    tmps:str255;
    CurPath:str255;
    pt:boolean;
    maxf : integer;
    Pstr : str255;
    pcnt : word;
    InputString : str255;

const KillMe : boolean = false;

{-----------------------------------------------}
{Program exit procedure to restore things back like they should be}

var ExitSave:pointer;
{$F+} procedure PrgExit;
begin
  ExitProc := ExitSave;
  if AudCom^.D.PortOpen then
    AudCom^.CloseRS232;
end;

{-------------------------------------------------}
function Spin(Count:word):char;
begin
  case Count and 3 of
   0:Spin := '/';
   1:Spin := '-';
   2:Spin := '\';
   3:Spin := '|';
   else Spin := '?';
  end;
end;

{------------------------------------------------}
function onoff(value:integer):string8;
var temp : string8;
begin
  str(value,temp);
  case value of
    0 : onoff := 'OFF (0)';
    1 : onoff := 'ON  (1)';
  else
    onoff := temp;
  end;
end;

function FverStr:str255;
var s:str255;
begin
  with AudCom^.D do
  begin
    s := fstr(Fversion div 100) + '.';
    if Fversion mod 100 < 10 then s := s + '0';
    S := s + fstr(Fversion mod 100);
    if (Fversion div 100) < 3 then s[length(s)] := 'x';
    Fverstr := s;
  end;
end;
(*
    s := fstr(D.Fversion div 100) + '.';
    if D.Fversion mod 100 < 10 then
      s := s + '0';
    s := s + fstr(D.Fversion mod 100);
    {$IFDEF PMODE}
      if D.Fversion < 306 then
        s[length(s)] := 'x';
    {$ELSE}
      if D.Fversion < 270 then
        s[length(s)] := 'x';
    {$ENDIF}
*)

{------------------------------------------------}
procedure PackErr;
begin
    writeln;
    write('** Packet error ** ',AudCom^.D.FailError,' -> ');
    writeln(AudCom^.FailMsg);

    writeln('send[0]=',AudCom^.D.sbuf[0],'  Send[1]=',AudCom^.D.sbuf[1],
            '  Send[2]=',AudCom^.D.sbuf[2]);
    write('Rcv[0]=[',hexW(AudCom^.D.rbuf[0]),']');
    if AudCom^.D.rbuf[0] > word($7fff) then write('(',integer(AudCom^.D.rbuf[0]),')');
    WRITE(AudCom^.D.rbuf[0]);
    writeln('  Rcv[1]=',AudCom^.D.rbuf[1],
            '  Rcv[2]=',AudCom^.D.rbuf[2]);
end;


procedure DoTerminal;
begin
  writeln('Entering Terminal Mode  - Press "Ctrl X" or "Ctrl Z" to exit');
  with AudCom^ do
  begin
    if EnableTerminalMode then
    begin
      Terminal;
    end
    else
    begin
      writeln('Error: could not enter terminal mode - check audiometer');
    end;
  end;
end;

{****************************************************************************}

{------------------------------------------------}
{ *** available on development machine only *** }
procedure dof0;   {return to debug monitor }
begin
 {$IFDEF DEBUG}
   AudCom^.Cmd(GotoMonitor);
   if AudCom^.Fail then Exit;

   writeln('Now in monitor mode.');
   writeln('Exit this program since it is no longer functional.');
 {$ELSE}
   writeln('Invalid function');
 {$ENDIF}
   pfunerr := 0;
end;

{-----------------------------------------------}
  procedure DisplayRegisters(Which:PnlRecTypePtr);
  begin
    with Which^ do
    begin
      writeln('    PBstat : ',hexW(PBstat),'        |       PBmisc : ',hexW(PBmisc));
      writeln('----------------------------------------------------');
      writeln('        Left',   '','             |         Right');
      writeln('    Freq : ',       Lfreq:5, ' Hz      |      Freq : ',Rfreq:5,' Hz');
      writeln('   Level : ',Llevel/100:5:1,  ' dBHL    |     Level : ',RLevel/100:5:1,' dBHL');
      writeln('     Src : ',        LSrc:3,'           |       Src : ',Rsrc:3);
      writeln('    Dest : ',       Ldest:3,'           |      Dest : ',Rdest:3);
      writeln('     Sim : ',        LSim:3,'           |       Sim : ',Rsim:3);
      writeln('  Offset : ',Lloffs/100:5:1,  ' dB      |    Offset : ',Rloffs/100:5:1,' dB');
    end;
  end;

procedure dof1;  {get control image}
var fs:str255;
    fc:text;
begin
  writeln;
  AudCom^.Cmd(GetXPNimg);
  if AudCom^.Fail then Exit;

  writeln('          Current Control Registers');
  DisplayRegisters(@AudCom^.D.XpnRec);

{$I-}
  fs := DatPath+'CPANEL.DAT';
  assign(fc,fs);
  rewrite(fc);
  with AudCom^.D.XpnRec do
  begin
    writeln(fc,PBstat);
    writeln(fc,PBmisc);
    writeln(fc,LFreq);
    writeln(fc,LLevel);
    writeln(fc,LSrc);
    writeln(fc,LDest);
    writeln(fc,LSim);
    writeln(fc,LLoffs);
    writeln(fc,RFreq);
    writeln(fc,RLevel);
    writeln(fc,RSrc);
    writeln(fc,RDest);
    writeln(fc,RSim);
    writeln(fc,RLoffs);
  end;
  close(fc);

  if IOresult <> 0 then
    writeln('Error writing file: ')
  else
    writeln('Control registers saved to file: ');
  writeln(fs);
{$I+}

  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof2;   {set control registers}
var temp2:word;
    fc:text;
    fs:str255;
begin

{$I-}
  fs := DatPath+'WPANEL.DAT';
  assign(fc,fs);
  reset(fc);
  fillchar(AudCom^.D.XpnRec,sizeof(AudCom^.D.XpnRec),0);
  with AudCom^.D.XpnRec do
  begin
    readln(fc,PBstat);
    readln(fc,PBmisc);
    readln(fc,LFreq);
    readln(fc,LLevel);
    readln(fc,LSrc);
    readln(fc,LDest);
    readln(fc,LSim);
    readln(fc,LLoffs);
    readln(fc,RFreq);
    readln(fc,RLevel);
    readln(fc,RSrc);
    readln(fc,RDest);
    readln(fc,RSim);
    readln(fc,RLoffs);
  end;
  close(fc);
  if IOresult <> 0 then
  begin
    writeln('Function failed');
    writeln('Error reading file: ');
    writeln(fs);
  end;
{$I+}

  AudCom^.Cmd(SetXpnImg);
  if AudCom^.Fail then Exit;
  writeln;
  writeln('Panel registers loaded from file: ');
  writeln(fs);

  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof3;    {get latched patient response registers}
var fs:str255;
    fc:text;
    P:PnlRecTypePtr;
begin
  writeln;
  AudCom^.Cmd(GetPRLimg);
  if AudCom^.Fail then Exit;
  write('Current Latched Patient Response Registers -- (Index:',lo(AudCom^.D.PrlRec.Index),')');
  if HI(AudCom^.D.PrlRec.Index) and $80 > 0 then
    write(' *OVERFLOW*');
  writeln;
  P := @AudCom^.D.PrlRec.PBstat;
  DisplayRegisters(P);

{$I-}
  fs := DatPath+'LPANEL'+fstr(AudCom^.D.PrlRec.Index and $f)+'.DAT';
  assign(fc,fs);
  rewrite(fc);
  with AudCom^.D.PrlRec do
  begin
    writeln(fc,PBstat);
    writeln(fc,PBmisc);
    writeln(fc,LFreq);
    writeln(fc,LLevel);
    writeln(fc,LSrc);
    writeln(fc,LDest);
    writeln(fc,LSim);
    writeln(fc,LLoffs);
    writeln(fc,RFreq);
    writeln(fc,RLevel);
    writeln(fc,RSrc);
    writeln(fc,RDest);
    writeln(fc,RSim);
    writeln(fc,RLoffs);
  end;
  close(fc);

  if IOresult <> 0 then
    writeln('Error writing file: ')
  else
    writeln('Latched patient response registers saved to file: ');
  writeln(fs);
{$I+}
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof4;     {get latched panel counter}
begin
  AudCom^.Cmd(GetPLCount);
  if AudCom^.Fail then Exit;

  writeln('Current Latched Patient Response Count: ',LO(AudCom^.D.PLCount));
  if hi(AudCom^.D.PLCount) and $80 > 0 then
    writeln('** WARNING: BUFFER OVERFLOW **');
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof5;  {get front panel image}
var fs:str255;
    fc:text;
begin
  writeln;
  AudCom^.Cmd(GetFPNimg);
  if AudCom^.Fail then Exit;

  writeln('          Current Front Panel Registers');
  DisplayRegisters(@AudCom^.D.FpnRec);

{$I-}
  fs := DatPath+'FPANEL.DAT';
  assign(fc,fs);
  rewrite(fc);
  with AudCom^.D.FpnRec do
  begin
    writeln(fc,PBstat);
    writeln(fc,PBmisc);
    writeln(fc,LFreq);
    writeln(fc,LLevel);
    writeln(fc,LSrc);
    writeln(fc,LDest);
    writeln(fc,LSim);
    writeln(fc,LLoffs);
    writeln(fc,RFreq);
    writeln(fc,RLevel);
    writeln(fc,RSrc);
    writeln(fc,RDest);
    writeln(fc,RSim);
    writeln(fc,RLoffs);
  end;
  close(fc);

  if IOresult <> 0 then
    writeln('Error writing file: ')
  else
    writeln('Front panel registers saved to file: ');
  writeln(fs);
{$I+}

  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof6;  {get buffered panel image}
var fs:str255;
    fc:text;
    P:PnlRecTypePtr;
begin
  writeln;
  AudCom^.Cmd(GetBufPanImg);
  if AudCom^.Fail then Exit;

  write('Current Buffered Front Panel Registers - (Index:',LO(AudCom^.D.BufFpnRec.Index),')');
  if HI(AudCom^.D.BufFpnRec.Index) and $80 > 0 then
    write(' *OVERFLOW*');
  writeln;
  P := @AudCom^.D.BufFpnRec.PBstat;
  DisplayRegisters(P);

{$I-}
  fs := DatPath+'BPANEL'+fstr(AudCom^.D.BufFpnRec.Index and $f)+'.DAT';
  assign(fc,fs);
  rewrite(fc);
  with AudCom^.D.BufFpnRec do
  begin
    writeln(fc,PBstat);
    writeln(fc,PBmisc);
    writeln(fc,LFreq);
    writeln(fc,LLevel);
    writeln(fc,LSrc);
    writeln(fc,LDest);
    writeln(fc,LSim);
    writeln(fc,LLoffs);
    writeln(fc,RFreq);
    writeln(fc,RLevel);
    writeln(fc,RSrc);
    writeln(fc,RDest);
    writeln(fc,RSim);
    writeln(fc,RLoffs);
  end;
  close(fc);
  if IOresult <> 0 then
    writeln('Error writing file: ')
  else
    writeln('Buffered Front Panel registers saved to file: ');
  writeln(fs);
{$I+}

  pfunerr := 0;
end;


{-----------------------------------------------}
procedure dof7;     {get buffered panel counter}
begin
  AudCom^.Cmd(GetBPCount);
  if AudCom^.Fail then Exit;

  writeln('Current Buffered Front Panel Count : ',LO(AudCom^.D.BPCount));
  if hi(AudCom^.D.BPCount) and $80 > 0 then
    writeln('** WARNING: BUFFER OVERFLOW **');
  pfunerr := 0;
end;



{-----------------------------------------------}
procedure dof8;       {get system status registers}
begin
  writeln;
  AudCom^.Cmd(GetSysStatus);
  if AudCom^.Fail then Exit;

  writeln('          Current System Status Registers');
  with AudCom^.D.SSTrec do
  begin
    writeln('      PBstat : ',   hexW(PBstat),'              PBmisc : ',hexW(PBmisc));
    writeln(' Misc Status : ', hexW(MiscStat),'          Cal Status : ',hexW(CalStat));
    writeln('RS232 Status : ',hexW(RS232Stat),'             Spare 1 : ',hexW(STSpare1));
    writeln('     Spare 2 : ',hexW(STSpare2) ,'             Spare 3 : ',hexW(StSpare3));
  end;

  pfunerr := 0;
end;

{-------}
procedure dof9;    {get keyboard input registers}
var i : word;
begin
  writeln;
  AudCom^.Cmd(GetKeyImg);
  if AudCom^.Fail then Exit;

  writeln('Current Keyboard Registers:');
  with AudCom^.D.KeyRec do
  begin
    writeln('Push Buttons : ',hexW(KEYPBD),'    Patient Switch : ',hexB(PATSW),'    Error : ',KeyErr);
    writeln('Rotory Switchs :  Freq:[0]=',ROTSWT[0]);
    writeln('     Left              Right');
    writeln('Level:[5]=',ROTSWT[5]:3,'     Level:[1]=',ROTSWT[1]:3);
    writeln('   In:[6]=',ROTSWT[6]:3,'        In:[2]=',ROTSWT[2]:3);
    writeln('  Out:[7]=',ROTSWT[7]:3,'       Out:[3]=',ROTSWT[3]:3);
    writeln('  Sim:[8]=',ROTSWT[8]:3,'       Sim:[4]=',ROTSWT[4]:3);
  end;

  pfunerr := 0;
end;


{-----}
procedure dof10;  {get cal flags}
begin
  AudCom^.Cmd(GetCalFLags);
  if AudCom^.Fail then Exit;
  writeln('Current Calibration Flags : $',hexw(AudCom^.D.CalFlags));
  pfunerr := 0;
end;

{------}
procedure dof11;    {set cal flags}
var wtemp : word;
begin
  AudCom^.Cmd(GetCalFLags);
  if AudCom^.Fail then Exit;
  writeln('Current Calibration Flags : $',hexw(AudCom^.D.CalFlags));

  write('Enter new Calibration Flags value: ');
  readln(wtemp);
  AudCom^.D.CalFlags := word(wtemp);
  AudCom^.Cmd(SetCalFlags);
  if AudCom^.Fail then Exit;

  AudCom^.Cmd(GetCalFLags);
  if AudCom^.Fail then Exit;
  writeln('New Calibration Flags : $',hexw(AudCom^.D.CalFlags));

  pfunerr := 0;
end;

{-----}
procedure dof12;       {get cal data}
var i : word;
    fc : text;
    fs:str255;
begin
  writeln;
  with AudCom^,D do
  begin
    Cmd(GetCalData);
    if Fail then Exit;

    writeln('                  Current calibration table values');
    writeln('    Tone    125  250  500  750 1000 1500 2000 3000 4000 6000 8000  12K  16K');
    writeln('----------------------------------------------------------------------------');
    write(' Left EarA:');
    for i := 2 to 14 do
    begin
      write(CalRec[i]:4,' ');
    end;
    writeln;
    write('Right EarA:');
    for i := 15 to 27 do
    begin
      write(CalRec[i]:4,' ');
    end;
    writeln;
    write(' Left EarB:');
    for i := 28 to 40 do
    begin
      write(CalRec[i]:4,' ');
    end;
    writeln;
    write('Right EarB:');
    for i := 41 to 53 do
    begin
      write(CalRec[i]:4,' ');
    end;
    writeln;
    write(' Left Spkr:');
    for i := 54 to 66 do
    begin
      write(CalRec[i]:4,' ');
    end;
    writeln;
    write('Right Spkr:');
    for i := 67 to 79 do
    begin
      write(CalRec[i]:4,' ');
    end;
    writeln;
    write('      Bone:');
    for i := 80 to 90 do
    begin
      write(CalRec[i]:4,' ');
    end;
    write('   X    X ');
    writeln;
    writeln('----------------------------------------------------------------------------');

    writeln('              L EarA | R EarA | L EarB | R EarB | L Spkr | R Spkr |  Bone  |');

    write('    NB Noise:');
    for i := 93 to 99 do
    begin
      write(CalRec[i]:6,'  |');
    end;
    writeln;
    write('WN Tone Mask:');
    for i := 100 to 106 do
    begin
      write(CalRec[i]:6,'  |');
    end;
    writeln;
    write('WN Spch Mask:');
    for i := 107 to 113 do
    begin
      write(CalRec[i]:6,'  |');
    end;
    writeln;
    write('Speech Noise:');
    for i := 114 to 120 do
    begin
      write(CalRec[i]:6,'  |');
    end;
    writeln;
    write('     Ext/Mic:');
    for i := 121 to 127 do
    begin
      write(CalRec[i]:6,'  |');
    end;
    writeln;
    writeln('Spare1 (91) :',CalRec[91]:6);
    writeln('Spare2 (92) :',CalRec[92]:6);

{$I-}
    fs := DatPath+'RDCAL.DAT';
    assign(fc,fs);
    rewrite(fc);
    for i := 0 to 127 do
    begin
      writeln(fc,CalRec[i]);
    end;
    close(fc);
    writeln;
    if IOresult <> 0 then
      writeln('Error writing file: ')
    else
      writeln('Calibration Table saved to file: ');
    writeln(fs);
{$I-}
  end;

  pfunerr := 0;
end;

{-------}
procedure dof13; {set cal data}
var fc:text;
    fs:str255;
    i : integer;
begin
  writeln;
  with AudCom^,D do
  begin
{$I-}
    fs := DatPath+'WRCAL.DAT';
    assign(fc,fs);
    reset(fc);
    fillchar(CalRec,sizeof(CalRec),0);

      for i := 0 to 127 do
      begin
        readln(fc,CalRec[i]);
      end;

    close(fc);
  if IOresult <> 0 then
  begin
    writeln('Function failed');
    writeln('Error reading file: ');
    writeln(fs);
    Exit;
  end;
{$I+}

    Cmd(SetCalData);
    if Fail then Exit;

    writeln('Calibration table loaded from file: ');
    writeln(fs);
  end;
  pfunerr := 0;
end;

{--------}
procedure dof14;            {read eerom}
begin
   write('Enter EEROM table to read: ');
   readln(temp);
   if (temp > 4) or (temp < 0) then
   begin
     writeln('Error: Invalid table number');
     Exit;
   end;
   AudCom^.D.EEROMtable := temp;
   AudCom^.Cmd(DoReadEEROM);
   if AudCom^.Fail then Exit;

   AudCom^.Cmd(GetCalFLags);
   if AudCom^.Fail then Exit;
   writeln('Calibration Status Flags : ',AudCom^.D.CalFlags);
   pfunerr := 0;
end;

{-------}
procedure dof15;   {write eerom}
begin
   write('Enter EEROM table to write: ');
   readln(temp);
   if (temp > 3) or (temp < 0) then
   begin
     writeln('Error: Invalid table number');
     Exit;
   end;
   AudCom^.D.EEROMtable := temp;

   AudCom^.Cmd(DoWriteEEROM);
   if AudCom^.Fail then Exit;

   AudCom^.Cmd(GetCalFLags);
   if AudCom^.Fail then Exit;
   writeln('Calibration Status Flags : ',AudCom^.D.CalFlags);
   pfunerr := 0;
end;

{-------}
procedure dof16; {Get Warble Table}
var fc:text;
    fs:str255;
var i : integer;
begin
  write('Select Warble Table to get (0=Left 1=Right) : ');
  readln(temp);
  AudCom^.D.WarbleRec.Buffer := temp;

  AudCom^.Cmd(GetWarbleData);
  if AudCom^.Fail then Exit;
  writeln('Warble Data: ',AudCom^.D.WarbleRec.Buffer,'  Size: ',AudCom^.D.WarbleRec.Count);

  if pred(AudCom^.D.WarbleRec.Count) > 127 then
  begin
    writeln('Error: warble count exceeds limit - clipping to 127 entries');
    AudCom^.D.WarbleRec.Count := 127;
  end;

  if AudCom^.D.WarbleRec.Count > 0 then
  begin
    for i := 0 to pred(AudCom^.D.WarbleRec.Count) do
    begin
      if (i and 7 = 0) and (i > 0) then writeln;
      write(AudCom^.D.WarbleRec.Data[i*2]:3,':',AudCom^.D.WarbleRec.Data[(i*2)+1]:3,' ');
    end;
  end;
  writeln;

{$I-}
  if AudCom^.D.WarbleRec.Buffer = 0 then
    fs := DatPath+'RDWARBL0.DAT'
  else
    fs := DatPath+'RDWARBL1.DAT';
  assign(fc,fs);
  rewrite(fc);
  writeln(fc,AudCom^.D.WarbleRec.Buffer);
  writeln(fc,AudCom^.D.WarbleRec.Count);

  if AudCom^.D.WarbleRec.Count > 0 then
  begin
    for i := 0 to pred(AudCom^.D.WarbleRec.Count) do
    begin
      writeln(fc,AudCom^.D.WarbleRec.Data[i*2],' ',AudCom^.D.WarbleRec.Data[(i*2)+1]);
    end;
  end;
  close(fc);

  if IOresult <> 0 then
    writeln('Error writing file: ')
  else
    writeln('Warble table saved to file: ');
  writeln(fs);
{$I+}

  pfunerr := 0;
end;

{------}
procedure dof17;  {set warble table}
var temp2:word;
    fc:text;
    fs:str255;
    i : integer;
begin
  write('Select Warble Table to set (0=Left 1=Right) : ');
  readln(temp);
  AudCom^.D.WarbleRec.Buffer := temp;

{$I-}
  if temp = 0 then
    fs := DatPath+'WRWARBL0.DAT'
  else
    fs := DatPath+'WRWARBL1.DAT';
  assign(fc,fs);
  reset(fc);
  fillchar(AudCom^.D.WarbleRec,sizeof(AudCom^.D.WarbleRec),0);
  readln(fc,AudCom^.D.WarbleRec.Buffer);
  readln(fc,AudCom^.D.WarbleRec.Count);

  if pred(AudCom^.D.WarbleRec.Count) < 4 then
  begin
    writeln('Error: warble count under limit - unable to continue');
    close(fc);
    exit;
  end;
  if pred(AudCom^.D.WarbleRec.Count) > 124 then
  begin
    writeln('Error: warble count exceeds limit - unable to continue');
    close(fc);
    exit;
  end;

  if AudCom^.D.WarbleRec.Count > 0 then
  begin
    for i := 0 to pred(AudCom^.D.WarbleRec.Count) do
    begin
      readln(fc,AudCom^.D.WarbleRec.Data[i*2],AudCom^.D.WarbleRec.Data[(i*2)+1]);
    end;
  end;
  close(fc);
  if IOresult <> 0 then
  begin
    writeln('Function failed');
    writeln('Error reading file: ');
    writeln(fs);
    Exit;
  end;
{$I+}

  AudCom^.Cmd(SetWarbleData);
  if AudCom^.Fail then Exit;

  writeln;
  writeln('Warble table loaded from file: ');
  writeln(fs);

  pfunerr := 0;
end;

{-----------------------------------------------}

  procedure ShowWPC;
  begin
    with AudCom^,D do
    begin
      writeln('  Variable           (Allowed) : Current Setting');
      writeln('Pulse  on Time        (6-7500) : (',WPCrec[0],')  ',WPCrec[0]*8,'mS');
      writeln('Pulse off Time        (6-7500) : (',WPCrec[1],')  ',WPCrec[1]*8,'mS');

      writeln('Left  Warble Freq Dev (10-250) : (',WPCrec[3],')  +-',(100/WPCrec[3]):5:2,'%');
      writeln('Right Warble Freq Dev (10-250) : (',WPCrec[5],')  +-',(100/WPCrec[5]):5:2,'%');

      writeln('Left  Warble Step Rate  (4-60) : (',WPCrec[2],')  ',
                                                (100/WPCrec[3]/(WPCrec[2]/2)):5:2,'%  ',
	    		  	                '(',WPCrec[2]*8,'mS total)',
                                                1/(WPCrec[2]*0.008):5:1,'Hz' );
      writeln('Right Warble Step Rate  (4-60) : (',WPCrec[4],')  ',
                                                (100/WPCrec[5]/(WPCrec[4]/2)):5:2,'%  ',
	                                        '(',WPCrec[4]*8,'mS total)',
                                                1/(WPCrec[4]*0.008):5:1,'Hz' );
      writeln('ABLB/MLB On  Time      (6-250) : (',WPCrec[6],')  ',WPCrec[4]*8,'mS total');
      writeln('ABLB/MLB Off Time      (6-250) : (',WPCrec[7],')  ',WPCrec[7]*8,'mS total');
      writeln('SISI On  Time         (6-7500) : (',WPCrec[8],')  ',WPCrec[8]*8,'mS total');
      writeln('SISI Off Time         (6-7500) : (',WPCrec[9],')  ',WPCrec[9]*8,'mS total');
    end;
  end;

procedure dof18;   {get warble/pulse control regs}
var fc:text;
    fs:str255;
var i : integer;
begin
  writeln;
  AudCom^.Cmd(GetWPcontrol);
  if AudCom^.Fail then Exit;
  ShowWPC;

{$I-}
  fs := DatPath+'RDWPC.DAT';
  assign(fc,fs);
  rewrite(fc);
  for i := 0 to 9 do
  begin
    writeln(fc,AudCom^.D.WPCrec[i]);
  end;
  close(fc);

  writeln;

  if IOresult <> 0 then
    writeln('Error writing file: ')
  else
    writeln('Warble/Pulse control registers saved to file: ');
  writeln(fs);
{$I+}

  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof19;     {set warble/pulse control regs}
var fc:text;
    fs:str255;
    i : integer;
begin
  writeln;
{$I-}
  fs := DatPath+'WRWPC.DAT';
  assign(fc,fs);
  reset(fc);
  fillchar(AudCom^.D.WPCrec,sizeof(AudCom^.D.WPCrec),0);
  for i := 0 to 9 do
  begin
    readln(fc,AudCom^.D.WPCrec[i]);
  end;
  close(fc);
  if IOresult <> 0 then
  begin
    writeln('Function failed');
    writeln('Error reading file: ');
    writeln(fs);
    Exit;
  end;
{$I+}

  AudCom^.Cmd(SetWPcontrol);
  if AudCom^.Fail then Exit;

  ShowWPC;
  writeln;
  writeln('Warble/Pulse control registers loaded from file: ');
  writeln(fs);
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof20;     {Get seq data}
var fc:text;
    fs:str255;
    i : integer;
begin
  with AudCom^,D do
  begin
    write('Select Sequencer to get (0=Left 1=Right) : ');
    readln(temp);
    SeqRec.Hdr.Buffer := temp;
    write('Enter starting index to get (0-255) : ');
    readln(temp);
    SeqRec.Hdr.Index := temp;
    write('Enter data length to get (1-99) : ');
    readln(temp);
    SeqRec.Hdr.Count := temp;

    Cmd(GetSeqData);
    if Fail then Exit;
    writeln('Sequencer Data -  Buf:',SeqRec.Hdr.Buffer);

    if SeqRec.Hdr.Count > 0 then
    begin
      for i := 0 to pred(SeqRec.Hdr.Count) do
      begin
        if (i and $f = 0) and (i > 0) then
        begin
          writeln;
        end;
        write(SeqRec.Data[i]:4);
      end;
    end;
    writeln;

{$I-}
    if SeqRec.Hdr.Buffer = 0 then
      fs := DatPath+'RDSQDAT0.DAT'
    else
      fs := DatPath+'RDSQDAT1.DAT';

    assign(fc,fs);
    rewrite(fc);
    writeln(fc,SeqRec.Hdr.Buffer);
    writeln(fc,SeqRec.Hdr.Index);
    writeln(fc,SeqRec.Hdr.Count);

    if SeqRec.Hdr.Count > 0 then
    begin
      for i := 0 to pred(SeqRec.Hdr.Count) do
      begin
        writeln(fc,SeqRec.Data[i]);
      end;
    end;
    close(fc);
    writeln;

    if IOresult <> 0 then
      writeln('Error writing file: ')
    else
      writeln('Sequencer data saved to file: ');
    writeln(fs);
{$I+}
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof21; {set seq data}
var i:word;
    fc:text;
    fs:str255;
begin
  with AudCom^,D do
  begin
    write('Enter name of sequencer file to read: ');
{$I-}
    readln(fs);
    assign(fc,fs);
    reset(fc);
    fillchar(SeqRec.Hdr,sizeof(SeqRec.Hdr),0);
    readln(fc,SeqRec.Hdr.Buffer);
    readln(fc,SeqRec.Hdr.Index);
    readln(fc,SeqRec.Hdr.Count);

    if SeqRec.Hdr.Count > 0 then
    begin
      for i := 0 to pred(SeqRec.Hdr.Count) do
      begin
        readln(fc,SeqRec.Data[i]);
      end;
    end;
    close(fc);
    if IOresult <> 0 then
    begin
      writeln('Function failed');
      writeln('Error reading file: ');
      writeln(fs);
      Exit;
    end;
{$I+}

    Cmd(SetSeqData);
    if Fail then Exit;
    writeln('Sequencer Data loaded from file: ');
    writeln(fs);
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof22;   {get sequencer index}
begin
  write('Select Sequencer to get (0=Left 1=Right) : ');
  readln(temp);
  AudCom^.D.SeqIndexRec.Buffer := temp;
  AudCom^.Cmd(GetSeqIndex);
  if AudCom^.Fail then Exit;
  writeln('Current Sequencer Index = ',AudCom^.D.SeqIndexRec.Index);

  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof23;     {set sequencer index}
begin
  write('Select Sequencer to get (0=Left 1=Right) : ');
  readln(temp);
  AudCom^.D.SeqIndexRec.Buffer := temp;
  AudCom^.Cmd(GetSeqIndex);
  if AudCom^.Fail then Exit;
  writeln('Current Sequencer Index = ',AudCom^.D.SeqIndexRec.Index);

  write('Enter new Sequencer Index (0-255) : ');
  readln(temp);
  AudCom^.D.SeqIndexRec.Index := temp;
  AudCom^.Cmd(SetSeqIndex);
  if AudCom^.Fail then Exit;
  writeln('New Sequencer index = ',AudCom^.D.SeqIndexRec.Index);

  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof24;      {Get Seq Enable State}
begin
  AudCom^.Cmd(GetSeqEnable);
  if AudCom^.Fail then Exit;
  writeln('Current Sequencer Enable Flags = ',(AudCom^.D.SeqEnRec.Flags));

  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof25;        {set seq enable}
begin
  AudCom^.Cmd(GetSeqEnable);
  if AudCom^.Fail then Exit;
  writeln('Current Sequencer Enable Flags = ',(AudCom^.D.SeqEnRec.Flags));

  write('Enter Sequencer Enable Mask (0-3) : ');
  readln(temp);
  if (temp > 3) or (temp < 0) then
  begin
    writeln('Error: Invalid number entered');
    Exit;
  end;
  AudCom^.D.SeqEnRec.Mask := temp;

  write('Enter New Sequencer Enable Flags (0-3) : ');
  readln(temp);
  if (temp > 3) or (temp < 0) then
  begin
    writeln('Error: Invalid number entered');
    Exit;
  end;
  AudCom^.D.SeqEnRec.Flags := temp;

  AudCom^.D.SeqEnRec.Flags := temp;
  AudCom^.Cmd(SetSeqEnable);
  if AudCom^.Fail then Exit;

  AudCom^.Cmd(GetSeqEnable);
  if AudCom^.Fail then Exit;
  writeln('New Sequencer Flags = ',(AudCom^.D.SeqEnRec.Flags));

  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof26;         {get seq control}
var fc:text;
    fs:str255;
    i : integer;
begin
  write('Select Sequencer to get (0=Left 1=Right) : ');
  readln(temp);
  AudCom^.D.SeqCtrlRec.Buffer := temp;
  AudCom^.Cmd(GetSeqControl);
  if AudCom^.Fail then Exit;
  writeln('Sequencer Control:   Buffer=',AudCom^.D.SeqCtrlRec.Buffer);

  for i := 0 to 63 do
  begin
    if (i and 7 = 0) and (i > 0) then
    begin
      writeln;
    end;
    write(AudCom^.D.SeqCtrlRec.Data[i]:4);
  end;
  writeln;

{$I-}
  if AudCom^.D.SeqCtrlRec.Buffer = 0 then
    fs := DatPath+'RDSQCTL0.DAT'
  else
    fs := DatPath+'RDSQCTL1.DAT';

  assign(fc,fs);
  rewrite(fc);
  writeln(fc,AudCom^.D.SeqCtrlRec.Buffer);
  for i := 0 to pred(sizeof(AudCom^.D.SeqCtrlRec.Data)) do
  begin
    writeln(fc,AudCom^.D.SeqCtrlRec.Data[i]);
  end;
  close(fc);
  writeln;
  if IOresult <> 0 then
    writeln('Error writing file: ')
  else
    writeln('Sequence control table saved to file: ');
  writeln(fs);
{$I+}

  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof27;         {Get seq activity}
begin
  AudCom^.Cmd(GetSeqActivity);
  if AudCom^.Fail then Exit;
  writeln('Current Sequencer Activity');
  writeln('Enables: $',hexB(AudCom^.D.SeqActRec.Enables) );
  writeln('Left   Index: ',AudCom^.D.SeqActRec.Index0:3,'     Control: $',hexB(AudCom^.D.SeqActRec.Ctrl0) );
  writeln('Right  Index: ',AudCom^.D.SeqActRec.Index1:3,'     Control: $',hexB(AudCom^.D.SeqActRec.Ctrl1) );

  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof28;    {version}
var s:str255;
begin
  with AudCom^ do
  begin
    Cmd(GetVersion);
    if Fail then Exit;
    writeln;
    writeln('Version: ',D.verrec.Version/100:4:2);
    writeln('Options: $',hexL(D.verrec.Option));
    writeln('Custom : $',hexL(D.verrec.Custom));
      write('Model  : ',D.verrec.Model);
    if D.verrec.Model = 0 then
      write('  (6500)');
    if D.verrec.Model = 1 then
      write('  (6400)');
    if D.verrec.Model = 40 then
      write('  (FP40)');
    if (D.verrec.Model >= 100) and (D.verrec.Model < 200) then
      write('  (FA',D.verrec.Model-90,')');
    writeln;
    writeln('--------------------');

    UpdateFryersInfo;

    write('Fryers V',FverStr);
    write('  using COM',succ(D.comport));
    {$IFNDEF WIN32}
      write('  with IRQ',D.IRQnum[D.comport]);
    {$ENDIF}
    write('  at ',D.TrueBaudRate,' Baud');

    if AudCom^.QTon then
      write(' (Q)');
    writeln;
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof29;       {get IO port image}
var i,ii : integer;
    fc:text;
    fs:str255;
begin
  with AudCom^,D do
  begin
    Cmd(GetPortIORegs);
    if Fail then Exit;
    writeln('Current Port Image');
    writeln('AIOFLG: $',HexB(PortIOrec[0]),HexB(PortIOrec[1]));
    writeln('SNPWEN: $',HexB(PortIOrec[2]),HexB(PortIOrec[3]));
    writeln('LEDIMG: $',HexB(PortIOrec[4]),HexB(PortIOrec[5]));
    writeln('RFCLK: ',PortIOrec[6]:4,' ',PortIOrec[7]:4,' ',PortIOrec[8]:4);
    writeln('LFCLK: ',PortIOrec[9]:4,' ',PortIOrec[10]:4,' ',PortIOrec[11]:4);
    writeln('RDpot: ',PortIOrec[12]:4,' ',PortIOrec[13]:4,' ',PortIOrec[14]:4);
    writeln('LDpot: ',PortIOrec[15]:4,' ',PortIOrec[16]:4,' ',PortIOrec[17]:4);
    writeln('RFSEL: $',HexB(PortIOrec[18]));
    writeln('LFSEL: $',HexB(PortIOrec[19]));
    writeln('RFMUX: $',HexB(PortIOrec[20]));
    writeln('LFMUX: $',HexB(PortIOrec[21]));
    write('SAA1099: ');
    for i := 0 to 31 do
    begin
      if (i and 7 = 0) and (i > 0) then
      begin
        writeln;
        write('         ');
      end;
      write(PortIOrec[i+22]:4);
    end;
    writeln;
    write('KEYIMG: ');
    for i := 0 to 5 do
    begin
      write(PortIOrec[i+22+32]:4);
    end;
    writeln;

{$I-}
    fs := DatPath+'PORTIMG.DAT';
    assign(fc,fs);
    rewrite(fc);
    for i := 0 to pred(sizeof(PortIOrec)) do
    begin
      writeln(fc,PortIOrec[i]);
    end;
    close(fc);
    writeln;

    if IOresult <> 0 then
      writeln('Error writing file: ')
    else
      writeln('IO port image saved to file: ');
    writeln(fs);
{I+}

  end;
  pfunerr := 0;
end;


{-----------------------------------------------}
procedure dof30;    {set ascii mode}
var  pstat: byte;
begin
  with AudCom^ do
  begin
    D.Regs.ax := $ff10;
    D.Regs.cx := 0;
    D.Regs.dx := D.comport;
    CallFryers(D.Regs);
    pstat := D.Regs.al;
    if pstat = 0 then
      writeln('Interface appears to already be in ASCII mode');
    Cmd(SetAsciiMode);
    if AudCom^.Fail then {nop};
    if EnableTerminalMode then
      Writeln('ASCII mode enabled')
    else
      Writeln('Error: could not enter ASCII mode - check audiometer');
  end;

  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof31;   {flush latched panel buffer}
begin
  AudCom^.Cmd(DoPrlFlush);
  if AudCom^.Fail then Exit;
  writeln('Latched Patient Response storage has been flushed');

  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof32;   {flush buffered panel buffer}
begin
  AudCom^.Cmd(DoBufPanFlush);
  if AudCom^.Fail then Exit;
  writeln('Buffered Front Panel storage has been flushed');

  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof33;    {get cmd status}
begin
  AudCom^.Cmd(GetCmdStatus);
  if AudCom^.Fail then Exit;
  writeln('Command Result Status = ',AudCom^.D.CmdStatus);

  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof37;      {enable boost flags}
begin
  writeln;
  AudCom^.Cmd(GetSysStatus);
  if AudCom^.Fail then Exit;
  writeln('Current Boost Enable Flags: ',(hi(AudCom^.D.SSTrec.RS232Stat) shr 2) and 3);

  write('Enter New Boost Flags value (0=off, 1=left, 2=right, 3=both) : ');
  readln(temp);
  if (temp > 4) or (temp < 0) then
  begin
    writeln('Error: Invalid number');
    Exit;
  end;
  AudCom^.D.BstEnable := temp;
  AudCom^.Cmd(SetBstEnable);
  if AudCom^.Fail then Exit;
  writeln('New Boost Enable Flags: ',AudCom^.D.BstEnable);

  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof38;    {do reset}
begin
  AudCom^.Cmd(DoReset);
  if AudCom^.Fail then Exit;
  writeln('Reset has been performed');

  pfunerr := 0;
end;


{-----------------------------------------------}
procedure dof73;     {set poll delay time}
begin
  AudCom^.Cmd(GetPollDelay);
  if AudCom^.Fail then Exit;

  writeln('Current Poll Delay Time : ',LO(AudCom^.D.PollDelayTime),' Ms');

  write('Enter new Poll Delay Time in Milliseconds (10-255) : ');
  readln(temp);
  AudCom^.D.PollDelayTime := temp;
  AudCom^.Cmd(SetPollDelay);
  if AudCom^.Fail then Exit;

  writeln('New Poll Delay Time : ',LO(AudCom^.D.PollDelayTime),' Ms');

  pfunerr := 0;
end;


{-----------------------------------------------}
procedure dof74;     {get poll delay time}
begin
  AudCom^.Cmd(GetPollDelay);
  if AudCom^.Fail then Exit;

  writeln('Current Poll Delay Time : ',LO(AudCom^.D.PollDelayTime),' Ms');
  pfunerr := 0;
end;


{------------------------------------------------}
{print out the saved disk buffers}
PROCEDURE DOF80;
VAR I : WORD;
    FS:STR255;
    FC:TEXT;
BEGIN

  assign(output,'PRN');
  rewrite(output);

{$I-}
 FOR I := 0 TO 16 DO
 BEGIN
  fs := DatPath+'BPANEL'+FSTR(I)+'.DAT';
  assign(fc,fs);
  reset(fc);
  if IOresult = 0 then
  begin
    with AudCom^.D.XpnRec do
    begin
      READLN(fc,PBstat);
      READLN(fc,PBmisc);
      READLN(fc,LFreq);
      READLN(fc,LLevel);
      READLN(fc,LSrc);
      READLN(fc,LDest);
      READLN(fc,LSim);
      READLN(fc,LLoffs);
      READLN(fc,RFreq);
      READLN(fc,RLevel);
      READLN(fc,RSrc);
      READLN(fc,RDest);
      READLN(fc,RSim);
      READLN(fc,RLoffs);
    end;
    close(fc);
    if IOresult = 0 then {nop};

    writeln('Buffered Front Panel Registers: Index - ',I);
    DisplayRegisters(@AudCom^.D.XpnRec);
  end
  else
  begin
    close(fc);
    if IOresult = 0 then {nop};
    writeln('Error READING file: ',FS);
  end;

  writeln;
  writeln;
 END;
{$I+}

  assign(Output,'');
  rewrite(output);

END;

{-----------------------------------------------}
procedure dof91;    {ASCII terminal mode}
var cp: word;
    pstat: byte;
begin
  AudCom^.Cmd(SetAsciiMode);
  if AudCom^.Fail then {nop};
  DoTerminal;
  if not AudCom^.ExitASCIImode then
    writeln('** Error: Unable to exit ASCII mode ***');
  if not AudCom^.EnablePacketMode then
  begin
    writeln;
    writeln('*** Error unable to switch back to packet mode ***');
  end
  else
  begin
    writeln;
    writeln('Returning to Packet mode operation');
  end;

  pfunerr := 0;
end;


{-----------}
{switch to packet mode}
procedure dof92;
begin
  write('Exiting ASCII mode ');
  if AudCom^.ExitASCIImode then {nop};
  writeln;
  if AudCom^.EnablePacketMode then
     writeln('Packet mode selected')
  else
     writeln('*** Error unable to switch to packet mode ***');
  pfunerr := 0;
end;

{------------}
{dumb terminal mode}
procedure dof93;
var pstat: byte;
begin
  writeln;
  with AudCom^ do
  begin
    D.Regs.ax := $ff10;
    D.Regs.cx := 0;
    D.Regs.dx := D.comport;
    CallFryers(D.Regs);
    pstat :=  D.Regs.al;
  end;
  DoTerminal;
  if pstat <> 0 then
    if not AudCom^.EnablePacketMode then
      writeln('Error: Unable to switch back to packet mode');
  pfunerr := 0;
end;


{--------------------------------------}
{$I-}
procedure monseq; {dof94;}
var chx : char;
begin
  writeln('Press ESC key to exit');
  chx := #13;
  while chx <> #3 do
  begin
     AudCom^.Cmd(GetSeqActivity);
     if AudCom^.Fail then Exit;
     write('Enables: $',hexB(AudCom^.D.SeqActRec.Enables) );
     write( ',  Left Index:',AudCom^.D.SeqActRec.Index0:3,',  Ctrl: $',hexB(AudCom^.D.SeqActRec.Ctrl0) );
     write(',  Right Index:',AudCom^.D.SeqActRec.Index1:3,',  Ctrl: $',hexB(AudCom^.D.SeqActRec.Ctrl1) );
     write(#13);
     if keywaiting then chx := getkey;
     if chx = #$1b then chx := #3;
     if (chx = 'q') or (chx = 'Q') then chx := #3;
  end;
  writeln;

  pfunerr := 0;
end;


{-----------------------------------------------}
procedure dobuild; {dof95;}
var t,i : integer;
begin
  write('Enter command number: ');
  readln(temp);
  AudCom^.D.Sbuf[0] := temp {or $1000};
  write('Enter data count: ');
  readln(temp);
  AudCom^.D.Sbuf[1] := temp;
  if AudCom^.D.Sbuf[1] > 0 then
  begin
    for i := 2 to AudCom^.D.Sbuf[1]+1 do
    begin
      write('Enter data word: ');
      readln(temp);
      AudCom^.D.Sbuf[i] := temp;
    end;
  end;
  write('Sending: ');
  write('[',HEXW(AudCom^.D.Sbuf[0]),']  ',AudCom^.D.Sbuf[1],'  ');
  if AudCom^.D.Sbuf[1] > 0 then
  begin
    for i := 2 to AudCom^.D.Sbuf[1]+1 do
    begin
      write(AudCom^.D.Sbuf[i],'  ');
    end;
  end;
  writeln;

  if word(AudCom^.D.Sbuf[0]) = word($7fff) then
    writeln('Quick Terminate');

  if not(AudCom^.BlindSend(@AudCom^.D.Sbuf,@AudCom^.D.Rbuf)) then
  begin
    writeln('Error - StatAX:',hexW(StatAX),
                  '  StatCX:',hexW(StatCX),
                  '  StatDX:',hexW(StatDX),
                  '  Error :',hexW(AudCom^.D.RsErr) );
    writeln(AudCom^.FailMsg);
    Exit;
  end;
  if AudCom^.Fail then
  begin
    writeln(AudCom^.FailMsg);
    Exit;
  end;

  if word(AudCom^.D.Sbuf[0]) <> word($7fff) then
  begin
    write('Response: ');
    write('Rbuf[0]=[',hexW(AudCom^.D.Rbuf[0]),']');
    if AudCom^.D.Rbuf[0] > word($7fff) then write('(',integer(AudCom^.D.Rbuf[0]),')');
    WRITE(AudCom^.D.Rbuf[0]);
    t := integer(AudCom^.D.Rbuf[0]);
    T := ABS(T);
    case t of
      0:write(' POLrsp ');
      4:write(' ACKrsp ');
      5:write(' NAKrsp ');
      6:write(' ILLrsp ');
    end;
    writeln(' Rbuf[1] = ',AudCom^.D.Rbuf[1]);

    if AudCom^.D.Rbuf[1] > 0 then
    begin
      write('Data = ');
      for i := 2 to AudCom^.D.Rbuf[1]+1 do
      begin
        write(AudCom^.D.Rbuf[i],', ');
      end;
    end;
  end;
  writeln;
  pfunerr := 0;

end;


{-----------------------------------------------}
{$I-}
procedure domon; {dof96;}
var chx : char;
    Y : integer;
  procedure ShowStatus;
  begin
     {$IFDEF WIN16}
       Y := wherey;
     {$ENDIF}
     write(Spin(GetTickCount and 3));
     write('StatAX:',hexW(StatAX),
          ' StatCX:',hexW(StatCX),
          ' StatDX:',hexW(StatDX),
          ' Error :',hexW(AudCom^.D.RsErr) );
     write(#13);
     {$IFDEF WIN16}
       gotoxy(1,Y);
     {$ELSE}
       write(#13);
     {$ENDIF}
  end;
begin
  writeln('Press ESC key to exit');
  chx := #13;
  while chx <> #3 do
  begin
     ShowStatus;
     AudCom^.Cmd(GetCmdStatus);
     while {(AudCom^.GetPacketStatus and 1 = 0) and}
           (chx <> #3) do
     begin
       ShowStatus;
       if keywaiting then chx := getkey;
       if chx = #$1b then chx := #3;
       if (chx = 'q') or (chx = 'Q') then chx := #3;
     end;
  end;
  writeln(' ');
  if AudCom^.Fail then Exit;
end;


{-----------------------------------------------}
procedure dof97;
var chx : char;
    Result : word;
 {   x,y:integer; }
begin
  writeln('Press ESC key to exit');
  chx := #13;
   {  X := wherex;
     Y := wherey; }
  while chx <> #3 do
  begin
     Result := AudCom^.GetPacketStatus;
     write('StatAX:',hexW(StatAX),
           '  StatCX:',hexW(StatCX),
           '  StatDX:',hexW(StatDX),
           '  Error :',hexW(AudCom^.D.RsErr) );
   {  gotoxy(1,y); }
     write(#13);
     if keywaiting then chx := getkey;
     if chx = #$1b then chx := #3;
     if (chx = 'q') or (chx = 'Q') then chx := #3;
  end;
  writeln;
  if AudCom^.Fail then Exit;
end;


{-----------------------------------------------}
{show help info}
procedure dohelp; {dof90}{(var pfunerr:integer)}
begin
  writeln;
  begin
            { x                          x                          x                   e'}
{1} writeln(' 1=Get Control Regs         10=Get Cal Flags           20=Get Seq Data      ');
{2} writeln(' 2=Set Control Regs         11=Set Cal Flags           21=Set Seq Data      ');
{3} writeln(' 3=Get PatRsp Latch Regs    12=Get Cal Data            22=Get Seq Index     ');
{4} writeln(' 4=Get PatRsp Latch Count   13=Set Cal Data            23=Set Seq Index     ');
{5} writeln(' 5=Get Front Panel Regs     14=Do EEROM Read           24=Get Seq Enable    ');
{6} writeln(' 6=Get Buff Panel Regs      15=Do EEROM Write          25=Set Seq Enable    ');
{7} writeln(' 7=Get Buff Panel Count                                26=Get Seq Control   ');
{8} writeln(' 8=Get System Status        16=Get Warble Table        27=Get Seq Activity  ');
{9} writeln('31=Do PatRsp Latch Flush    17=Set Warble Table                             ');
{10}writeln('32=Do Buff Panel Flush      18=Get W/P Control Regs    73=Set Poll Delay    ');
{11}writeln('37=Set Boost Enables        19=Set W/P Control Regs    74=Get Poll Delay    ');
{12}writeln('                                                                            ');
{13}writeln(' 9=Get Keyboard Regs        30=Set ASCII mode          28=Get Version       ');
{14}writeln('29=Get IOport Image         91=ASCII Terminal          33=Get Command Status');
{15}writeln('                            92=Select Packet Mode      38=Do Reset          ');
{16}writeln('                                                                            ');
{17}writeln('"H"=Help  "X"=Exit  "B"=Build Cmd  "M"=Monitor port  "S"=Monitor sequencer  ');
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure docmd;
begin
  case InputString[1] of
    'X','Q': begin
               killme := true;
               pfunerr := 0;
             end;
    'H','?': dohelp;
    'M': domon;
    'B': dobuild;
    'S': monseq;

  {  'T': dopolltime;}
{    'D': dodebug;}
  end;
end;


{-----------------------------------------------}
{returns true if it is a number otherwise returns false}
function Cleanup(var Data:str255):boolean;
var i : integer;
var UseHex : boolean;
  function ValidNum:boolean;
  begin
    ValidNum := true;
    if Data[i] in['0','1','2','3','4','5','6','7','8','9','0','-','+','.'] then Exit;
    if UseHex then
      if Data[i] in ['A','B','C','D','E','F'] then Exit;
    ValidNum := false;
  end;
begin
  CleanUp := false;
  if length(Data) = 0 then Exit;
  while Data[1] < '!' do
  begin
    delete(Data,1,1);
    if length(Data) = 0 then Exit;
  end;
  for i := 1 to length(Data) do
    Data[i] := upcase(Data[i]);
  if not(Data[1] in['0','1','2','3','4','5','6','7','8','9','0','$']) then Exit;
  if Data[1] = '$' then
    UseHex := true
  else UseHex := false;

  if length(Data) > 1 then
  begin
    i := 2;
    while ValidNum do
      inc(i);
    if length(Data) > pred(i) then
      Data[0] := char(pred(i));
  end;
  CleanUp := true;
end;

procedure RunProgram;
begin

 {$IFDEF WIN16}
    ScreenSize.X := 80;
    ScreenSize.Y := 25;
    WindowSize.X := 1000 {639};
    WindowSize.Y := 800 {439};
    StrCopy(WindowTitle,'Audiometer Command Test');
    InitDosCrtWindow;
    AutoTracking := false;
    SelectCursor(SetOn);
 {$ENDIF}
 {$IFDEF ISDOS}
    assign(Input,'');  {make sure input comes from DOS}
    reset(Input);
    assign(Output,''); {output too}
    rewrite(Output);
 {$ENDIF}

   {$IFDEF WIN32}
     SetConsoleCtrlHandler(nil,false);
     if not(LoadFryers) then
     begin
       writeln;
       writeln('Error: FRYERS32.DLL not loaded, or bad version.');
       Halt(1);
     end;
   {$ENDIF}

  ExitSave := ExitProc;
  ExitProc := @PrgExit;

  writeln('Audiometer RS232 Test  - Version 2.02 as of 30 Sept 1997');
  writeln('Copyright 1992,1997 Frye Electronics, Inc.');

  UsePort := 0;
  UseIRQ := 0;
  pcnt := ParamCount;
  while Pcnt > 0 do
  begin
    PStr := ParamStr(Pcnt);
    case upcase(Pstr[1]) of
     '1','2','3','4','5','6','7','8','9' : UsePort := ord(Pstr[1]) and $f;
     'I': begin
            while ((Pstr[1] < '0') or (Pstr[1] > '9')) and (length(Pstr) > 0) do
              delete(Pstr,1,1);
            while ((Pstr[length(Pstr)] < '0') or
                  (Pstr[length(Pstr)] > '9')) and (length(Pstr) > 0) do
              SetLength(Pstr,length(Pstr)-1);
            val(Pstr,UseIRQ,Err);
            if (UseIRQ > 15) or (Err <> 0) then UseIRQ := 0;
          end; {case 'I'}
     'C': begin
            while ((Pstr[1] < '0') or (Pstr[1] > '9')) and (length(Pstr) > 0) do
              delete(Pstr,1,1);
            while ((Pstr[length(Pstr)] < '0') or
                  (Pstr[length(Pstr)] > '9')) and (length(Pstr) > 0) do
              SetLength(Pstr,length(Pstr)-1);
            val(Pstr,UsePort,Err);
            if (UsePort > 15) or (Err <> 0) then UsePort := 0;
          end; {case 'I'}
    end; {case}
    dec(Pcnt);
  end;
  if UsePort = 0 then UsePort := 1;

  if not(AudCom^.InitRS232(UsePort,UseIRQ)) then
  begin
    writeln('Error: FRYERS driver not loaded');
    Halt(1);
  end;
    write('Fryers V',FverStr);
    write('  Using COM',succ(AudCom^.D.comport));
   {$IFNDEF WIN32}
     write('  with IRQ',AudCom^.D.IRQnum[AudCom^.D.comport]);
   {$ENDIF}
    write('  at ',AudCom^.D.TrueBaudRate,' Baud');
    if AudCom^.QTon then
      write(' (Q)');
    writeln;


  {$I-}
    if IOresult = 0 then {nop};
    GetDir(0,CurPath);
    DatPath := 'DAT';
    ChDir(DatPath);     {does dat path already exist?}
    if IOresult <> 0 then
    begin
      MkDir(DatPath);   {dat path doesn't exist, try to make it}
      if IOresult <> 0 then
        DatPath := '';   {bummer, can't make it, so use current path}
    end
    else
    begin
      ChDir(CurPath);    {path exists, so return to old position}
      DatPath := CurPath+'\'+DatPath+'\'; {make data path valid selector}
    end;
  {$I+}

  writeln;

  repeat
    write('Enter function to perform ("H" for help) : ');
    readln(InputString);
    if Cleanup(InputString) then
    begin
      val(InputString,Num,err);
      if err <> 0 then num := -199;
    end
    else num := -1;

    killme := false;
    pfunerr := succ(num);
    begin
      case num of
       -1 : docmd;
        0 : dof0;
        1 : dof1;
        2 : dof2;
        3 : dof3;
        4 : dof4;
        5 : dof5;
        6 : dof6;
        7 : dof7;
        8 : dof8;
        9 : dof9;
        10 : dof10;
        11 : dof11;
        12 : dof12;
        13 : dof13;
        14 : dof14;
        15 : dof15;
        16 : dof16;
        17 : dof17;
        18 : dof18;
        19 : dof19;
        20 : dof20;
        21 : dof21;
        22 : dof22;
        23 : dof23;
        24 : dof24;
        25 : dof25;
        26 : dof26;
        27 : dof27;
        28 : dof28;
        29 : dof29;
        30 : dof30;
        31 : dof31;
        32 : dof32;
        33 : dof33;
        37 : dof37;
        38 : dof38;

        73 : dof73;
        74 : dof74;

        80 : DOF80;
        90 : dohelp; {dof90;}
        91 : dof91;
        92 : dof92;
        93 : dof93;
        94 : monseq; {dof94;}
        95 : dobuild; {dof95;}
        96 : domon; {dof96;}
        97 : dof97;
        99 : begin {nop} killme := true; pfunerr := 0; end; {end program}
       199 : begin {nop} killme := true; pfunerr := 0; end; {end program}
      else
        writeln('Invalid function');
      end;
    end;
    maxf := 80;
    if (pfunerr > 0) and (num < succ(maxf)) then
      PackErr;

    writeln;
  until killme or (num > 98);

  AudCom^.CloseRS232;

  {$IFDEF WIN16}
     DoneDosCrtWindow;
  {$ENDIF}
end;

end.


