//---------------------------------------------------------------------------
//BCB Sample Fryers/Fryecom DLL application program
//as of 09/07/10 - by Michael Day
//---------------------------------------------------------------------------
//This application was written using Borland BCB V3.0
//It requires the use of the Borland VCL libraries.
//Only this unit and the inireg file require the Borland libraries.
//The other files are generic C++ files and should be able to be compiled
//with most other C compilers.
//This application is intended to be an example of how to use the
//Frye Electronics FryeCom DLL interface examples.
//Note: See FComDefs.h to select whether you want to use static or dynamic DLL loading
//---------------------------------------------------------------------------
//The order of processing is as shown below.
//BCform.CPP -> Fipp.CPP -> FryeComD.CPP or FryeComS.CPP -> FryeCom.DLL
//Support files are are also used.
// FryeDefs.CPP : Used by
//   BCform.CPP, Fipp.CPP, FryeComD.CPP, FryeComS.CPP, FryeStr.CPP, FryeTools.CPP
// FComDefs.h : Used by
//   BCform.CPP, Fipp.CPP, FryeComD.CPP, FryeComS.CPP
// FryeStr.CPP : Used by
//   BCform.CPP, Fipp.CPP, FryeTools.CPP
// FryeTools.CPP : Used by
//   BCform.CPP, Fipp.CPP
// FryeRegs.h : Used by
//   FryeComD.CPP, FryeComS.CPP
// IniReg.CPP : Used by
//   BCform.CPP
//---------------------------------------------------------------------------

#include <vcl\vcl.h>
#pragma hdrstop

#include <windows.h>
#include "FryeDefs.h"
#include "FComDefs.h"
#include "FippCore.h"
#include "FryeTools.h"
#include "FryeStr.h"
#include "FCErrMsg.h"
#include "BCoreForm.h"
#include <stdlib.h>

char AppTitle[] = "Fryers Core Demo V3.01 - 19 Jul 2011";

#define ACTION_PANEL 1  //status update panel selections
#define STATUS_PANEL 2
#define ERROR_PANEL 3

tCurveFrame DispData; //Data for graph
tCurveFrame OldData;  //Previous graph data (for undraw)

TColor TextColor = clLime;  //{text color}
TColor BoxColor = clAqua;  //{box color}
TColor CrvColor = clYellow;  //{curve color}
TColor BackColor = clBlack;  //{background color}
TColor ForeColor = clWhite;  //{foreGround color}
//int cltype  = 0;  //{0=dot/x, 1=x&y, 2=x&y smoothed}

//{this plots the vertices to draw the graph with}
int Xtab[80] = {
            0, 36, 57, 72, 84, 93,102,108,114,120,
          125,129,134,137,141,144,148,151,153,156,
          159,161,163,165,168,170,172,173,175,177,
          179,180,182,184,185,187,188,189,191,192,
          193,195,196,197,198,199,200,202,203,204,
          205,206,207,208,209,210,210,211,212,213,
          214,215,216,216,217,218,219,219,220,221,
          222,222,223,224,225,225,226,227,227,228};

TclsFippCore *FippCore = NULL;     //declare the Fryers FIPP object for this port


//---------------------------------------------------------------------------
//This is the comport callback service routine
int __stdcall FryeComCallback(int Value) {

  if (FD_CallBackActive == false) {  //prevent re-entrancy issues
    FD_CallBackActive = true;
    Application->ProcessMessages();
    FCOM_GetPortStatus(Value,&FippCore->PortStatus);
    Form1->UpdateFryersStatus();
  }

  FD_CallBackActive = false;
  if (FD_CancelOperation == true)
    return(FIPP_CANCEL);
  else return(FIPP_SUCCESS);
};

//---------------------------------------------------------------------------
//Activity spinner - Yes, I'm doing something
void DoSpin(void) {
  Form1->SpinCount++;
  Form1->SpinCount &= 0x1;
  switch(Form1->SpinCount) {
    case 0: Form1->Spinner->Caption = "\\"; break;
    case 1: Form1->Spinner->Caption = "/"; break;
  }//endswitch
};

//---------------------------------------------------------------------------
//Update the Fryers status info
//Warning: This is accessed via a callback in InitPort,
//so be careful about re-entrancy issues.
bool FryersStatusBusy = false;
void __fastcall TForm1::UpdateFryersStatus(void) {
  char sTemp[256];
  char sTemp1[256];
  char sPortString[256] = "COM";
  FD_tCalDate FComDate;
  AnsiString aPort;

  //Show the version of Fryers we are using
  if (FippCore->FcomVersion > 0)
    FS_GetVersionString(FippCore->FcomVersion,2,sTemp1);
  else FS_SCopy(sTemp1,"?.??");
  FS_SCopy3(sTemp,"V",sTemp1,0);
  FryersVersionLabel->Caption = sTemp;

  FT_UnpackCalDate(FippCore->PortStatus.FcomDate,&FComDate);
  FS_Znum(FComDate.Year, -4, sTemp, "/");
  FS_Znum(FComDate.Month, -2, sTemp1, "/");
  FS_SCat(sTemp,sTemp1);
  FS_Znum(FComDate.Day, -2, sTemp1, NULL);
  FS_SCat(sTemp,sTemp1);
  DateLabel->Caption = sTemp;

  //Show PortStatus and PortControl flags useful for debugging
  if (FryersStatusBusy == true) return;
  FryersStatusBusy = true;
  FS_WordToHex(FippCore->PortStatus.PacketStatus,sTemp1);  //regax
  FS_SCopy3(sTemp,"ax:",sTemp1,NULL);
  AXstatusLabel->Caption = sTemp;
  FS_WordToHex(FippCore->PortStatus.PacketControl,sTemp1); //regcx
  FS_SCopy3(sTemp,"cx:",sTemp1,NULL);
  CXstatusLabel->Caption = sTemp;

  //show which com port we are using
  FS_Inum(FippCore->ThisComPort+1,0,sTemp,0);
  FS_SCat(sPortString,sTemp);
  aPort = sTemp;
  PortLabel->Caption = sPortString;

  //show port activity status
  if ((FippCore->PortStatus.SeekState & 3) == 1) {        //1=port seek
    FStatLabel->Caption = "<P seek " + aPort + ">";
  }else if ((FippCore->PortStatus.SeekState & 2) == 2) {  //2or3=baud seek
    FStatLabel->Caption = "<B seek " + aPort + ">";
  }else if (FippCore->PortInitialized == false) {
    FStatLabel->Caption = "Not Active";
  }else if ((FippCore->PortStatus.PacketStatus & F_NOPOLL) != 0) {
    FStatLabel->Caption = "No Poll <" + aPort + ">";
  }else{
    FStatLabel->Caption = "Active <" + aPort + ">";
  }

  //Show the baudrate the port is operating at
  if (FippCore->PortStatus.Baudrate > 0)
    FS_Inum(FippCore->PortStatus.Baudrate,0,sTemp,0);
  else if (LastKnownBaudrate > 0)
    FS_Inum(LastKnownBaudrate,0,sTemp,0);
  else FS_SCopy(sTemp,"?");
  BaudrateLabel->Caption = sTemp;

  //show the last known command and response sequence
  FS_WordToHex(FippCore->PortStatus.LastCommand,sTemp);
  FS_WordToHex(FippCore->PortStatus.LastCommandSize,sTemp1);
  FS_SCat3(sTemp,"  (",sTemp1,")");
  SendStatusLabel->Caption = sTemp;
  FS_WordToHex(FippCore->PortStatus.LastResponse,sTemp);
  FS_WordToHex(FippCore->PortStatus.LastResponseSize,sTemp1);
  FS_SCat3(sTemp,"  (",sTemp1,")");
  RecvStatusLabel->Caption = sTemp;

  DoSpin(); //Spinner shows that something is happening

  //Application->ProcessMessages();  //make it all happen on the display
  FryersStatusBusy = false;
};

//---------------------------------------------------------------------------
void __fastcall TForm1::SBar(int Where, char* Msg, TColor PanelColor, bool DoUpdate) {
  if (Where == STATUS_PANEL)
    StatusLabel->Caption = Msg;
  else ErrorLabel->Caption = Msg;
  StatusPanel->Color = PanelColor;
  if (DoUpdate == true) {
    Application->ProcessMessages();
  }
};



//===============================================================================
// Cheap Graphing routines
//===============================================================================

//{-----------------------------------------------------------}
void __fastcall TForm1::StartGraph(void) {
  TextW = 8; //{Form1.PaintBox.canvas.textwidth('X'); }
  TextH = 8; //{Form1.PaintBox.canvas.textheight('X');}
  MemImage->Canvas->Font = Form1->PaintBox->Font;
  MemImage->Canvas->Pen->Color = BackColor;
  MemImage->Canvas->Brush->Color = BackColor;
  MemImage->Canvas->Rectangle(0,0,Form1->MemImage->Width,Form1->MemImage->Height);
  GraphStarted = true;
};

//{-----------------------------------------------------------}
void __fastcall TForm1::Plot(int x, int y, TColor c) {
  Form1->WritePixel(x,y,c);
};

//{-----------------------------------------------------------}
void __fastcall TForm1::SetPixelColor(TColor FColor, TColor BColor) {
  Form1->MemImage->Canvas->Pen->Color = FColor;
};

//{-----------------------------------------------------------}
void __fastcall TForm1::xyWrite(int x, int y, char* s1, char* s2, TColor Color) {
  int x1,y1,x2,y2;
  char Str[40] = "";
  if (s1 != NULL) strcat(Str,s1);
  if (s2 != NULL) strcat(Str,s2);
  x1 = (x-1) * TextW;
  y1 = (y-1) * TextH;
  x2 = x1+(strlen(Str) * TextW);
  y2 = y1 + TextH;
  MemImage->Canvas->Pen->Color = BackColor;
  MemImage->Canvas->Brush->Color = BackColor;
  MemImage->Canvas->Rectangle(x1,y1,x2,y2);
  MemImage->Canvas->Font->Color = Color;
  MemImage->Canvas->TextOut(x1,y1,Str);
};

//{-----------------------------------------------------------}
void __fastcall TForm1::xsWrite(int x, int y, int Val, BYTE Len, TColor Color) {
  int k;
  char Str[20];
  itoa(Val,Str,10);
  k = strlen(Str);
  while (k < Len) {
    Str[k] = ' ';
    k++;
  }
  Str[k] = 0;
  xyWrite(x,y,Str,0,Color);
};

//--------------------------------------------
//plot a line on screen, clip to only within box
void __fastcall TForm1::DoDraw(int x1, int y1, int x2, int y2, TColor color, int cltype) {
    int x;
    int y;
    int xstep;
    int ystep;
    int deltax;
    int deltay;
    int direction;

    if (y1 > 185) y1 = 185;    // clip to boundry
    if (y1 < 1) y1 = 1;
    if (y2 > 185) y2 = 185;
    if (y2 < 1) y2 = 1;

    x = x1;
    y = y1;

    if (x1 == x2) xstep = 0;
    else
      if (x1 > x2) xstep = -1;
      else
        xstep = 1;

    if (y1 == y2) ystep = 0;
    else
      if (y1 > y2) ystep = -1;
      else
        ystep = 1;

    deltax = abs(x2 - x1);
    deltay = abs(y2 - y1);
    if (deltax == 0) direction = -1;
    else
      direction = 0;

    Plot(x,y,color);
    do
    {
      if (direction < 0)
      {
        y = y + ystep;
        direction = direction + deltax;
        if ((direction >= 0) || (cltype > 0)) Plot(x, y, color);
      }
      else
      {
        x = x + xstep;
        direction = direction - deltay;
        if ((direction >= 0) || (cltype > 1)) Plot(x, y, color);
      }
    }
    while (!(( x == x2 ) && ( y == y2 )));
}

//----------------------------------------------------
//draw the fixed stuff of the screen
void __fastcall TForm1::DoBox(void) {
  int i;
  if (GraphStarted == false) return;
  
  DoDraw(30,186,262,186,BoxColor,1);
  DoDraw(262,186,262,0,BoxColor,1);
  DoDraw(262,0,30,0,BoxColor,1);
  DoDraw(30,0,30,186,BoxColor,1);

  for (i=1; i<=18; i++) {
    DoDraw(25+1,(i*10),29,(i*10),BoxColor,1);
  }

  for (i=1; i<=19; i++) {
    DoDraw((i*12)+31,187,(i*12)+31,190,BoxColor,1);
  }

  xyWrite(5,25,".12",0,TextColor);
  xyWrite(9,25,".25",0,TextColor);
  xyWrite(14,25,".5",0,TextColor);
  xyWrite(19,25,"1",0,TextColor);
  xyWrite(24,25,"2",0,TextColor);
  xyWrite(28,25,"4",0,TextColor);
  xyWrite(33,25,"8",0,TextColor);

  xyWrite(34,1,"SOURCE",0,TextColor);
  xyWrite(34,4,"RMS OUT",0,TextColor);
  xyWrite(34,7,"TOP SPL",0,TextColor);
  xyWrite(34,10,"N.R.",0,TextColor);
  xyWrite(34,13,"FLAGS",0,TextColor);
};


//{-------------------------}
//{figure out what the scale is and show it on the graph}

void __fastcall TForm1::FindScale(void) {
  int ts = (DispData.Peak / 100);
  int Scale = (ts / 20)*20 + 20;
  Poff = (Scale*2)+10;
  if (GraphStarted == false) return;

  if (GotError == false) {
    if ((DispData.Flags & CURVE_FRAME_TYPE_FLAGS) != CURVE_FRAME_TYPE_80_FLAGS) {
      xyWrite(6,2,"INVALID",0,TextColor);  //{bad curve}
    }else{
      if ((DispData.Flags & CURVE_FRAME_GAIN_FLAG) == 0) {
        xyWrite(6,2,"dBSPL  ",0,TextColor); //{power curve}
      }else{
        xyWrite(6,2,"GAIN   ",0,TextColor);  //{none of the above, so must be gain}
      }
    }
  }//endif(GotError)

  xsWrite(1,2,Scale+00,3,TextColor);
  xsWrite(1,7,Scale-20,3,TextColor);
  xsWrite(1,12,Scale-40,3,TextColor);
  xsWrite(1,17,Scale-60,3,TextColor);
  xsWrite(1,22,Scale-80,3,TextColor);
};

//{-------------------------}
int __fastcall TForm1::GetPoint(int i) {
  int k = i;
  while ((DispData.Data[k] == INVALID_DATA16) && (k < 79)) {
    k++;
  }
  return(DispData.Data[k]);
};

//{-------------------------}
void __fastcall TForm1::DispCurve(void) {
  int da,db,xa,xb,ya,yb,x,i;
  int lm = 32;  //{left margin on graph}

  i = 0; //11; //{start with 100hz plot}
  x = 0;
  while ((DispData.Data[i] == INVALID_DATA16) & (i < 79)) {
    i++;
    x++;
  }
  do {
    da = GetPoint(i);
    db = GetPoint(i+1);
    if (da != INVALID_DATA16)
      da = Poff - (da / 50);
    if (db != INVALID_DATA16)
      db = Poff - (db / 50);
//    if (da < 0)
//      dd = da;

    ya = OldData.Data[i];
    yb = OldData.Data[i+1];
    OldData.Data[i] = (INT16)da;
    xa = Xtab[x]+lm;
    xb = Xtab[x+1]+lm;
    i = i + 1;
    x = x + 1;
    if (xa == xb) {  //{ skip next when xa = xb }
      i = i + 1;
      x = x + 1;
    }
    if ((xa != INVALID_DATA16) && (xb != INVALID_DATA16))
      DoDraw(xa,ya,xb,yb,BackColor,0); //{undraw}
    if ((da != INVALID_DATA16) && (db != INVALID_DATA16))
      DoDraw(xa,da,xb,db,CrvColor,0); //{draw new one}
  }while(x <= 78);
  OldData.Data[i] = (INT16)db;
  MiscInfo();
};

//------------------------------------------------------
//update the numbers for the curve
void __fastcall TForm1::MiscInfo(void) {
  char s[20];

  if (GraphStarted == false) return;

  xyWrite(34,2,"      ",0,TextColor); //{src}
  if (DispData.Source == 0) {
    xyWrite(34,2,"OFF",0,TextColor);
  }else{
    FS_Rnum(DispData.Source, 2, 1, s, "dB");
    //itoa(DispData.Source,s,10);
    xyWrite(34,2,s,0,TextColor);
  }
  xyWrite(34,5,"      ",0,TextColor);
  FS_Rnum(DispData.Output, 2, 1, s, "dB");
  //itoa(DispData.Output,s,10);
  xyWrite(34,5,s,0,TextColor);//{rms out}

  xyWrite(34,8,"      ",0,TextColor);
  FS_Rnum(DispData.Peak, 2, 1, s, "dB");
  //itoa(DispData.Peak,s,10);
  xyWrite(34,8,s,0,TextColor); //{top val}

  xyWrite(34,11,"      ",0,TextColor);    //{noise reduction}
  if (DispData.NoiseReduction == 0) {
    xyWrite(34,11,"OFF",0,TextColor);
  }else{
    itoa(DispData.NoiseReduction,s,10);
    xyWrite(34,11,s,0,TextColor);
  }
  xyWrite(34,14,"      ",0,TextColor);
  FS_WordToHex(DispData.Flags & 0xFFFF,s);
  xyWrite(34,14,s,0,TextColor); //{flags a}

  xyWrite(34,15,"      ",0,TextColor); //{flags b}
  FS_WordToHex(DispData.Flags >> 16,s);
  xyWrite(34,15,s,0,TextColor);
};

//===========================================================================
//Communications routines
//===========================================================================


//--------------------------------------------------------------
//This updates the com port item list to have the proper number of
//comport items depending on the fryrers driver found
void __fastcall TForm1::UpdateComPortList(void) {
  int i;
  int Result;
  int MaxPort;
  AnsiString ComStr;
  Result = FCOM_MaxComPort(&MaxPort);
  if (Result != FIPP_SUCCESS) MaxPort = 0;
  PortSelect->Items->Clear();
  PortSelect->Items->Add("Auto");  //first item [0] is always "Auto"
  for (i=1; i<=MaxPort; i++) {
    ComStr = "COM"+IntToStr(i);
    PortSelect->Items->Add(ComStr);
  }
};

//---------------------------------------------------------------------------
//This opens the com port and establishes communications
//if the port is already open, it just makes sure that it can talk.
//When/if the port is open, update all info about the instrument.
//If AUTO is selected, (and port is not open) an attempt is made to try to find
//the com port in use. Auto Seek starts with the last known port usage found in
//the registry. If nothing is in the registry, the search starts with COM1.
//If a specific port is selected, we only try to open that com port.
//This expects the instrument to be plugged in and running so the software
//can find it. Returns FIPP_SUCCESS if all ok, or the error code if it fails.
//Errors: SendCmd errors.
int __fastcall TForm1::OpenComPort(void) {
  int AutoSeek;
  int Result;
  int PortSelect;
  int StartPort;
  int StopPort;
  int RawComPort;
  int StartBaud;
  int MaxRetry = 3; //try three times then give up

  Form1->SBar(STATUS_PANEL,"Seeking COM Port", ACTION_COLOR, true);

  //check if Fryers driver is out there
  Result = FippCore->UpdateFcomVersion();
  if (Result != SUCCESS) return(Result); //if port not there, return with failure
  AutoSeek = FCOM_USE_BAUD_SEEK;  //always seek the baudrate
  StartBaud = LastKnownBaudrate;           //starting at last known baudrate
  //clean up port selector if not properly configured
  if (Form1->PortSelect->ItemIndex < 0) Form1->PortSelect->ItemIndex = 0;
  PortSelect = Form1->PortSelect->ItemIndex;
  if (PortSelect <= 0) {
    AutoSeek |= FCOM_USE_PORT_SEEK; //port selection[0] is auto port seek
    PortSelect = LastKnownPort;   //if autoseek, always start with last known port
  }

  RawComPort = PortSelect - 1;        //API comport is selected port-1;
  StartPort = 0;                      //we will always restart at com1 for autoseek
  StopPort = -1;                      //search through all possible available com ports
  FD_CancelOperation = false;         //pre-clear callback cancel flag.
  Result = FippCore->InitPort(AutoSeek,RawComPort,StartPort,StopPort,MaxRetry,StartBaud,FryeComCallback);

  if ((Result == FCOM_SUCCESS)&&(FippCore->PortInitialized == true)) {
    Form1->SBar(STATUS_PANEL,"Active",ACTION_COLOR,true);
    Form1->HintLabel->Caption = "Press Stop to pause";
  }
  FCOM_GetPortStatus(FippCore->ThisComPort,&FippCore->PortStatus);
  UpdateFryersStatus();
  return(Result);
};

//--------------------------------------------------------
void __fastcall TForm1::CloseComPort(void) {
  Form1->LastKnownBaudrate = FippCore->PortStatus.Baudrate;
  Form1->LastKnownPort = FippCore->PortStatus.ComPort+1;
  FippCore->ClosePort();
  Form1->UpdateFryersStatus();
};

//---------------------------------------------------------
//copy curve frame data from the response array.
void __fastcall TForm1::ReadRsp(void) {
  int Size = FippCore->RspArray.Size * 2;
  if (Size > sizeof(tCurveFrame)) Size = sizeof(tCurveFrame);
  FD_ByteCopy(&DispData,&FippCore->RspArray.Data[1],Size);  //copy curve to local buffer
};

//--------------------------------------------------------
//Sends a cmd to target via FryeCom}
int DoCmd(INT16 scmd, INT16 scnt, INT16 sdat) {
  int Result;
  FippCore->CmdArray.Cmd = scmd;
  FippCore->CmdArray.Size = scnt;
  FippCore->CmdArray.Data[0] = sdat;
  Result = FippCore->DoCmd(FCOM_NO_ACK,FIPP_STD_POLL_TIMEOUT, &FippCore->CmdArray, &FippCore->RspArray, FryeComCallback);
  return(Result);
};


//{-----------------------------------------------}
//{main program starts here}

bool __fastcall TForm1::StartMeUp(TObject *Sender) {
  //try to open the com port
  FComError = OpenComPort();
  if (FComError != FIPP_SUCCESS) {
    return(false);  //failed
  }
  //opened the port, so now start the graph
  Form1->StartGraph();
  Scale = 120;
  return(true);
};


void __fastcall TForm1::ShowCurveStatus(void) {
  char sMsg[1999];
  if (FComError == 0) {
    FEM_GetErrorMsg(FComError,sMsg);  //This clears out error if all ok
    Form1->SBar(ERROR_PANEL,sMsg,ACTION_COLOR,true);
  }else{
    FEM_GetErrorMsg(FComError,sMsg);
    Form1->SBar(ERROR_PANEL,sMsg,WARNING_COLOR,true);
  }
};

//---------------------------------------------------
//do a run on the Fonix instrument
bool __fastcall TForm1::DoMe(TObject *Sender) {
  int Result;
  IamBusy = true;
  DoBox();        //put the fixed stuff on the screen
  Result = DoCmd(25,1,0);  //get data for curve #1 (crv[0])
  if (Result == FIPP_CANCEL) {
    IamBusy = false;
    ShowCurveStatus();
    return(false);  //if user canceld, return false;

  }else if (Result == SUCCESS) {
    //Success(0) means the command was successful
    GotError = false;
    ReadRsp();              //copy the curve data to the display array
    FindScale();            //{figure out scaling and errors}
    DispCurve();            //{now show the curve}
    ShowCurveStatus();
    Form1->SBar(ERROR_PANEL,"",ACTION_COLOR,true);
    FippCore->QuickTerminate(NULL);
    Sleep(1);
  }else if (Result < 0) {
    //a negative response means the cmd failed
    GotError = true;
    ShowCurveStatus();
    FippCore->QuickTerminate(NULL);
    Sleep(1);
  }else{
    ShowCurveStatus();
    // a positive response means we are not ready yet
  }
  IamBusy = false;
  return(true); //return true if processed ok
};


//---------------------------------------------------
//This runs the loop continuously to update the display
//with the curve data from the analyzer
void __fastcall TForm1::CmdLoop(TObject *Sender) {

  while (IamRunning == true) {
    DoMe(Sender);
    UpdateFryersStatus();
    Form1->RefreshBitmap();
    Sleep(1);
    Application->ProcessMessages();
  }

};

//===========================================================================
// Top level Form handling code
//===========================================================================

//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}

void __fastcall TForm1::RefreshBitmap()
{
  Form1->PaintBox->Canvas->CopyMode = cmSrcCopy;
  Form1->PaintBox->Canvas->StretchDraw(Form1->PaintBox->Canvas->ClipRect,Form1->MemImage);
}

void __fastcall TForm1::WritePixel(int x, int y, TColor c)
{
  Form1->MemImage->Canvas->Pixels[x][y] = c;
}


//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  AnsiString aTemp;

  StatusLabel->Caption = "";
  ErrorLabel->Caption = "";
  PortSelect->Text = "Auto";
  FComError = -1;

  Form1->ClientWidth = MasterBevel->Width;
  Form1->ClientHeight = MasterBevel->Height;
  Form1->ClientHeight = MasterBevel->Height + StatusPanel->Height;
  Form1->Caption = AppTitle;
  FippCore = ::new(TclsFippCore);
  IamRunning = false;
  IamBusy = false;
  GotError = false;
  GraphStarted = false;
  LastKnownBaudrate = 9600;  //always start first time at 9600 baud
  LastKnownPort = 1;  //always start autoport seek at COM1
  FD_WordFill(&DispData,sizeof(DispData),INVALID_DATA16);
  FD_WordFill(&OldData,sizeof(DispData),INVALID_DATA16);

  Form1->MemImage = new Graphics::TBitmap;
  Form1->MemImage->Width = Form1->PaintBox->Width;
  Form1->MemImage->Height = Form1->PaintBox->Height;
  UpdateComPortList();

}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormKeyPress(TObject *Sender, char &Key)
{
  if ((Key == 0x1B) || (Key == 0x03))
    Close();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormPaint(TObject *Sender)
{
  RefreshBitmap();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormResize(TObject *Sender)
{
  RefreshBitmap();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormShow(TObject *Sender)
{
  RefreshBitmap();
}

//---------------------------------------------------------------------------
void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
  FD_CancelOperation = true;  //clear any command in progress
  IamRunning = false;
}

//============================================================================
// Button handling code
//============================================================================

//---------------------------------------------------------------------------
void __fastcall TForm1::StartStopButtonClick(TObject *Sender)
{
  char sMsg[1999];

  //---- Stop button ----
  //determine start or stop operation of the button
  if (IamRunning == true) {
    //The start button was already pushed Frank
    IamRunning = false;  //we were runnning, so stop now
    FD_CancelOperation = true;  //clear any command in progress
    StartStopButton->Caption = "Start";
    Form1->HintLabel->Caption = "Press Start to continue";
    Form1->SBar(STATUS_PANEL,"Paused",ACTION_COLOR,true);
    return;
  }

  //----- Start button ----
  //not running yet, so start things going
  IamRunning = true;   //we were stopped, so start running
  FD_CancelOperation = false;  //init cmd cancel flag
  StartStopButton->Caption = "Stop";
  Form1->HintLabel->Caption = "Press Stop to pause";
  Form1->SBar(STATUS_PANEL,"Starting",ACTION_COLOR,true);
  Form1->SBar(ERROR_PANEL,"",ACTION_COLOR,false);

  //now find the com port and start things going
  if (StartMeUp(Sender) == false) {
    //if failed, say so
    IamRunning = false;
    if (FComError < 0) {
      FEM_GetErrorMsg(FComError,sMsg);
      Form1->SBar(ERROR_PANEL,sMsg,WARNING_COLOR,true);
    }
    StartStopButton->Caption = "Start";
    Form1->HintLabel->Caption = "Press Start to continue";
  }else{
    //got it going, so set the buttons for the new state of affairs.
      StartStopButton->Caption = "Stop";
    Form1->HintLabel->Caption = "Press Stop to pause";
    Form1->SBar(STATUS_PANEL,"Active",ACTION_COLOR,true);
    IamRunning = true; //set runing flag to true (we stop when it goes false
    //main processing loop
    CmdLoop(Sender); //loop continuously until told to stop

  }

  if (FD_CancelOperation == true) {
    Form1->SBar(ERROR_PANEL,"Operation Canceled",WARNING_COLOR,false);
  }
  Application->ProcessMessages(); //make sure form data is updated

  CloseComPort();                 //close up shop
  StartStopButton->Caption = "Start"; //restore start button on exit
  Form1->HintLabel->Caption = "Press Start to continue";
}
//-----------------------------------------------------------

void __fastcall TForm1::ExitButtonClick(TObject *Sender)
{
   FD_CancelOperation = true;  //clear any command in progress
   IamRunning = false;
   Close();   //now exit the application regardless of the state
}

//---------------------------------------------------------------------------
void __fastcall TForm1::PortSelectChange(TObject *Sender)
{
  FD_CancelOperation = true;   //request that the action be stopped
  IamRunning = false;  //stop running
  IamBusy = false;
  CloseComPort();
  UpdateFryersStatus();
};

//<eof>

