//---------------------------------------------------------------------------
#ifndef BCform32H
#define BCform32H
//---------------------------------------------------------------------------
#include <vcl\Classes.hpp>
#include <vcl\Controls.hpp>
#include <vcl\StdCtrls.hpp>
#include <vcl\Forms.hpp>
#include <vcl\ExtCtrls.hpp>
//---------------------------------------------------------------------------

extern int __stdcall FryeComCallback(int Value);

class TForm1 : public TForm
{
__published:	// IDE-managed Components
        TPaintBox *PaintBox;
        TLabel *HintLabel;
	TButton *StartStopButton;
        TComboBox *PortSelect;
        TPanel *StatusPanel;
        TBevel *MasterBevel;
        TSplitter *Splitter2;
        TLabel *StatusLabel;
        TLabel *ErrorLabel;
        TGroupBox *CommunicationStatusBox;
        TLabel *Label33;
        TLabel *FryersVersionLabel;
        TLabel *Label36;
        TLabel *BaudrateLabel;
        TLabel *SendStatusLabel;
        TLabel *FStatLabel;
        TLabel *Spinner;
        TLabel *RecvStatusLabel;
        TLabel *Label37;
        TLabel *Label38;
        TLabel *AXstatusLabel;
        TLabel *CXstatusLabel;
        TLabel *Label5;
        TButton *ExitButton;
        TLabel *DateLabel;
        TLabel *PortLabel;
        void __fastcall FormCreate(TObject *Sender);

        void __fastcall FormKeyPress(TObject *Sender, char &Key);
        void __fastcall FormPaint(TObject *Sender);
        void __fastcall FormResize(TObject *Sender);
        void __fastcall FormShow(TObject *Sender);
	void __fastcall StartStopButtonClick(TObject *Sender);
	void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
	void __fastcall ExitButtonClick(TObject *Sender);
        void __fastcall PortSelectChange(TObject *Sender);

private:	// User declarations
     void __fastcall GetDefaultComPortAndBaudrate(int* pAutoSeek, int* pPortSelect, int* pStartBaud);
     int __fastcall FindComPort(int WhichPort, int MaxPort, int MaxRetry);
     void __fastcall MyIdleHandler(TObject *Sender, bool &Done);
     void __fastcall UpdateComPortList(void);
     int __fastcall OpenComPort(void);
     void __fastcall CloseComPort(void);

public:		// User declarations
     int Poff;
     int Scale;
     int TextW;
     int TextH;

     int MaxPort;
     int LastKnownBaudrate;
     int LastKnownPort;
     int SpinCount;
     int RspResult;
     int SendResult;
     int FComError;
     bool GotError;
     bool IamRunning;
     bool IamBusy;
     bool ReadResponse;

     int ThisInstrument;

     Graphics::TBitmap *MemImage;

     __fastcall TForm1(TComponent* Owner);
     void __fastcall RefreshBitmap(void);
     void __fastcall WritePixel(int x, int y, TColor c);
     void __fastcall UpdateFryersStatus(void);
     void __fastcall SBar(int Where, char* Msg, TColor PanelColor, bool DoUpdate);
     void __fastcall ShowCurveStatus(TObject *Sender);

    //int __fastcall SendReady(void);
    //int __fastcall RspReady(void);
    //int __fastcall SendCmd(INT16 scmd, INT16 scnt, INT16 sdat);
    //int __fastcall GetCrvRsp(void);
    //int __fastcall QuickTerm(void);

    void __fastcall CmdLoop(TObject *Sender);
    bool __fastcall StartMeUp(TObject *Sender);
    bool __fastcall DoMe(TObject *Sender);
    void __fastcall ReadRspData(void);

    void __fastcall xyWrite(int x, int y, char* s1, char* s2, TColor Color);
    void __fastcall StartGraph(void);
    void __fastcall Plot(int x, int y, TColor c);
    void __fastcall SetPixelColor(TColor FColor, TColor BColor);
    void __fastcall xsWrite(int x, int y, int Val, BYTE Len, TColor Color);
    void __fastcall DoDraw(int x1, int y1, int x2, int y2, TColor color, int cltype);
    void __fastcall DoBox(void);
    void __fastcall FindScale(void);
    int __fastcall GetPoint(int i);
    void __fastcall DispCurve(void);
    void __fastcall MiscInfo(void);
   int __fastcall GetDeviceInfo( bool IgnoreLabelError, bool IgnoreMicError, bool IgnoreInstInfoError);

};
//---------------------------------------------------------------------------
extern TForm1 *Form1;
//---------------------------------------------------------------------------
#endif
