//---------------------------------------------------------------------------
//Bit Reverse map
//Copyright 2010 Frye Electronics, Inc.
//Written by Michael Day as of 30 Aug 2010
//You may use this code for any lawful purpose without fees or royalties.
//This code is intended as an example showing how to communicate with Fonix
//equipment using the Fryers32 or FryeCom device driver on the Windows operating system.
//No warranties are express or implied in the use of this code.
//---------------------------------------------------------------------------

unit BitRev;

interface

//common bit defines
const BIT0 = $0001;
const BIT1 = $0002;
const BIT2 = $0004;
const BIT3 = $0008;
const BIT4 = $0010;
const BIT5 = $0020;
const BIT6 = $0040;
const BIT7 = $0080;
const BIT8 = 40100;
const BIT9 = $0200;
const BIT10 = $0400;
const BIT11 = $0800;
const BIT12 = $1000;
const BIT13 = $2000;
const BIT14 = $4000;
const BIT15 = $8000;

const BitReverse : array[0..255] of byte = (
   $00,$80,$40,$C0,  {//;00H - 03H}
   $20,$A0,$60,$E0,  {//;04H - 07H}
   $10,$90,$50,$D0,  {//;08H - 0BH}
   $30,$B0,$70,$F0,  {//;0CH - 0FH}
   $08,$88,$48,$C8,  {//;10H - 13H}
   $28,$A8,$68,$E8,  {//;14H - 17H}
   $18,$98,$58,$D8,  {//;18H - 1BH}
   $38,$B8,$78,$F8,  {//;1CH - 1FH}
   $04,$84,$44,$C4,  {//;20H - 23H}
   $24,$A4,$64,$E4,  {//;24H - 27H}
   $14,$94,$54,$D4,  {//;28H - 2BH}
   $34,$B4,$74,$F4,  {//;2CH - 2FH}
   $0C,$8C,$4C,$CC,  {//;30H - 33H}
   $2C,$AC,$6C,$EC,  {//;34H - 37H}
   $1C,$9C,$5C,$DC,  {//;38H - 3BH}
   $3C,$BC,$7C,$FC,  {//;3CH - 3FH}
   $02,$82,$42,$C2,  {//;40H - 43H}
   $22,$A2,$62,$E2,  {//;44H - 47H}
   $12,$92,$52,$D2,  {//;48H - 4BH}
   $32,$B2,$72,$F2,  {//;4CH - 4FH}
   $0A,$8A,$4A,$CA,  {//;50H - 53H}
   $2A,$AA,$6A,$EA,  {//;54H - 57H}
   $1A,$9A,$5A,$DA,  {//;58H - 5BH}
   $3A,$BA,$7A,$FA,  {//;5CH - 5FH}
   $06,$86,$46,$C6,  {//;60H - 63H}
   $26,$A6,$66,$E6,  {//;64H - 67H}
   $16,$96,$56,$D6,  {//;68H - 6BH}
   $36,$B6,$76,$F6,  {//;6CH - 6FH}
   $0E,$8E,$4E,$CE,  {//;70H - 73H}
   $2E,$AE,$6E,$EE,  {//;74H - 77H}
   $1E,$9E,$5E,$DE,  {//;78H - 7BH}
   $3E,$BE,$7E,$FE,  {//;7CH - 7FH}
   $01,$81,$41,$C1,  {//;80H - 83H}
   $21,$A1,$61,$E1,  {//;84H - 87H}
   $11,$91,$51,$D1,  {//;88H - 8BH}
   $31,$B1,$71,$F1,  {//;8CH - 8FH}
   $09,$89,$49,$C9,  {//;90H - 93H}
   $29,$A9,$69,$E9,  {//;94H - 97H}
   $19,$99,$59,$D9,  {//;98H - 9BH}
   $39,$B9,$79,$F9,  {//;9CH - 9FH}
   $05,$85,$45,$C5,  {//;A0H - A3H}
   $25,$A5,$65,$E5,  {//;A4H - A7H}
   $15,$95,$55,$D5,  {//;A8H - ABH}
   $35,$B5,$75,$F5,  {//;ACH - AFH}
   $0D,$8D,$4D,$CD,  {//;B0H - B3H}
   $2D,$AD,$6D,$ED,  {//;B4H - B7H}
   $1D,$9D,$5D,$DD,  {//;B8H - BBH}
   $3D,$BD,$7D,$FD,  {//;BCH - BFH}
   $03,$83,$43,$C3,  {//;COH - C3H}
   $23,$A3,$63,$E3,  {//;C4H - C7H}
   $13,$93,$53,$D3,  {//;C8H - CBH}
   $33,$B3,$73,$F3,  {//;CCH - CFH}
   $0B,$8B,$4B,$CB,  {//;D0H - D3H}
   $2B,$AB,$6B,$EB,  {//;D4H - D7H}
   $1B,$9B,$5B,$DB,  {//;D8H - DBH}
   $3B,$BB,$7B,$FB,  {//;DCH - DFH}
   $07,$87,$47,$C7,  {//;E0H - E3H}
   $27,$A7,$67,$E7,  {//;E4H - E7H}
   $17,$97,$57,$D7,  {//;E8H - EBH}
   $37,$B7,$77,$F7,  {//;ECH - EFH}
   $0F,$8F,$4F,$CF,  {//;F0H - F3H}
   $2F,$AF,$6F,$EF,  {//;F4H - F7H}
   $1F,$9F,$5F,$DF,  {//;F8H - FBH}
   $3F,$BF,$7F,$FF); {//;FCH - FFH}

implementation

end.
