//FryeCom Error Message strings unit
//Copyright 2010 Frye Electronics, Inc.
//Written by Michael Day as of 9 Sept 2010
//You may use this code for any lawful purpose without fees or royalties.
//No warranties are express or implied in the use of this code.
//This will compile under any version of Borland BCB (written using BCB V3.00)
//This code uses only C specific code so it should compile with most c compilers.
//----------------------------------------------------

#include "FComDefs.h"
#include "FryeStr.h"
#include "FCErrMsg.h"

//---------------------------------------------------------------------------

//Returns the error message string for the indicated error number
char* FEM_GetErrorMsg(int Error, char* sMsg) {
  char sTemp[256];

  switch(Error) {
    case FCOM_SUCCESS:  //0 = no error
      FS_SCopy(sMsg,"");  //blank message if no error
      break;
    //FryeCom/Fryers Errors are -1000 series numbers
    case FCOM_GENERIC_ERROR: // -1000   //unknown fryecom error - something bad happened
      FS_Upper((char*)FCOM_DLL_NAME,sTemp);
      FS_SCopy3(sMsg,"Unknown ",sTemp," Access Error");
      break;
    case FCOM_FILE_NOT_FOUND: // -1001  //device driver file not found
      FS_Upper((char*)FCOM_DLL_NAME,sTemp);
      FS_SCopy3(sMsg,"Error ",sTemp," Not Found");
      break;
    case FCOM_ENTRY_NOT_FOUND: // -1002 //entry point to fryecom driver not found
      FS_Upper((char*)FCOM_DLL_NAME,sTemp);
      FS_SCopy3(sMsg,"Error ",sTemp," Procedure ");
      FS_IntToStr(FCOM_ProcedureNumber,sTemp);
      FS_SCat3(sMsg,sTemp," Not Found",NULL);
      break;
    case FCOM_BAD_DRIVER: // -1003      //unknown internal problem encountered in the Driver
      FS_Upper((char*)FCOM_DLL_NAME,sTemp);
      FS_SCopy3(sMsg,"Error ",sTemp," Invalid");
      break;

    //common FCOM packet errors use the -9000 series
    case FCOM_PACKET_ERROR: // -9000      //generic unknown packet error
      FS_SCopy(sMsg,"Error: Com Failure");
      break;
    case FCOM_PORT_RANGE_ERROR: // -9001  //not a valid comport selection (out of range)
      FS_SCopy(sMsg,"Error: Invalid Port Selection");
      break;
    case FCOM_PORT_NOT_FOUND: // -9002    //Requested port not available
      FS_SCopy(sMsg,"Error: Port Not Found");
      break;
    case FCOM_PORT_NOT_OPEN: // -9003     //Requested port not open for communication
      FS_SCopy(sMsg,"Error: Port Not Open");
      break;
    case FCOM_AUTOBAUD_FAILED: // -9004   //could not find baudrate
      FS_SCopy(sMsg,"Error: Could not find baudrate");
      break;

    case FCOM_NO_POLL: // -9010           //no polls from the instrument
      FS_SCopy(sMsg,"Error: No Poll");
      break;
    case FCOM_SEND_OVERRUN: // -9011      //trying to send another command before old one done.
      FS_SCopy(sMsg,"Error: Send Overrun");
      break;
    case FCOM_SEND_ERROR: // -9012        //error while trying to send the command
      FS_SCopy(sMsg,"Error: Send Failure");
      break;

    case FCOM_NO_RESPONSE: // -9020       //no response received
      FS_SCopy(sMsg,"Error: No Response");
      break;
    case FCOM_RESPONSE_ERROR: // -9021    //error while receiveing the response
      FS_SCopy(sMsg,"Error: Response Failure");
      break;
    case FCOM_RESPONSE_OVERRUN: // -9022  //current response overwrote previous response
      FS_SCopy(sMsg,"Error: Response Overrun");
      break;
    case FCOM_NAK_RESPONSE: // -9023       //NAK rcvd as a respond
      FS_SCopy(sMsg,"Error: NAK Response");
      break;
    case FCOM_ILL_RESPONSE: // -9024      //illegal command rcvd as a response
      FS_SCopy(sMsg,"Error: ILL Response");
      break;
    case FCOM_POLL_RESPONSE: // -9025     //poll rcvd as a response
      FS_SCopy(sMsg,"Error: Poll Response");
      break;
    case FCOM_CMD_FAIL: // -9026          //unexpected response to a command
      FS_SCopy(sMsg,"Error: Command Failure");
      break;
    case FCOM_UNEXPECTED_ACK: // -9027    //got ACK response when wasn't supposed to
      FS_SCopy(sMsg,"Error: Unexpected ACK");
      break;

    case FCOM_INVALID_FORMAT: // -9999    //The passed format is invalid (missing pointer?)
      FS_SCopy(sMsg,"Error: Invalid Command Format");
      break;

    default:
      FS_IntToStr(FCOM_ProcedureNumber,sTemp);
      FS_SCopy3(sMsg,"Error: Unknown (",sTemp,")");
      break;
  };//endswitch(Error)

  return(sMsg);
};

