// Fryers interface register definitions  for C++
//Copyright 2010 Frye Electronics, Inc.
//Written by Michael Day as of 30 Aug 2010
//You may use this code for any lawful purpose without fees or royalties.
//This code is intended as an example showing how to communicate with Fonix
//equipment using the Fryers32 device driver interface.
//No warranties are expressed or implied in the use of this code.
//This will compile under any version of Borland BCB (written using BCB V3.00)
//This code uses only C specific code so it should compile with most c compilers.
//You will only need to include this header if your code makes calls to the
//low-level CallFryers interface. F_RegsType describes the record structure
//that is used in the CallFryers procedure call.

// Fryers interface register definitions  for C++
//-----------------File FryeRegs.h-------------------------------
#ifndef FryeRegsH
#define FryeRegsH
#pragma anon_struct on  //allow anonymous union structures
#pragma pack(push, 1)   //make sure data is byte aligned

//register structure to use with Fryers
//Note: these are 32 bit values,
//*NOT* 16bit as with the 16 bit version of Fryers
//* WARNING* You *MUST* compile this with BYTE alignment.
//  failure to use byte alignment will cause all sorts of problems.
struct F_RegsType { 
         union { 
           struct { 
             int EAX;
             int EBX;
             int ECX;
             int EDX;
             int EDI;
             int ESI; 
	         };//end_struct(32bit ref)
           struct { 
             unsigned char AL;
             unsigned char AH;
             unsigned char EAL;
             unsigned char EAH;
             unsigned char BL;
             unsigned char BH;
             unsigned char EBL;
             unsigned char EBH;
             unsigned char CL;
             unsigned char CH;
             unsigned char ECL;
             unsigned char ECH;
             unsigned char DL;
             unsigned char DH;
             unsigned char EDL;
             unsigned char EDH;
             int RDI;
             int RSI; 
           };//end_struct(8bit ref)
           struct {
             int AX;
             int BX;
             int CX;
             int DX;
             int DI;
             int SI; 
           };//end_struct(16bit ref)
         };//end_union
};//end_struct

//===========================================================================
//You only need to worry about the following flag definions if you use
//the old style CallFryers() interface call method. If you only use the
//Newer FryeCom calls to talk via the FIPP protocol to a Fonix instrument,
//you don't need to worry about this stuff. These flags and the
//CallFryers interface are more fully described in the Fryers.TXT and
//FCMDS.txt description files.

//**************************************************************
//;PACKET FLAG DEFINITIONS
//;THESE FLAGS ARE USED TO CONTROL THE PACKET TRANSFER
//;THE FLAG CONDITIONS CAN BE CHECKED BY THE HIGH-LEVEL PROGRAM
//;BY ISSUING A STATUS CALL (0FF13H) TO THE CallFryers PROCEDURE
//Call 0FF13H : AX returns PIFLAGS, CX returns TXINFO.

//--------------------------------------------------------------
//;PACKET STATUS CONDITION FLAG DEFINITIONS  (PIFLAGS low byte)
//;THESE ARE RETURNED IN REGISTER AL
//;WHEN ASKED FOR WITH THE STATUS COMMAND
#define F_SNDRDY 0x0001 //Ready to accept send command
#define F_RCVRDY 0x0002 //Data waiting in buffer to be read
#define F_SNDOVR 0x0004 //New cmd given before old cmd sent
#define F_SNDOVF 0x0008 //Data size given too large to send
#define F_RCVOVR 0x0010 //New response overwrote old one
#define F_NOPKEN 0x0020 //Packet driver is not enabled
#define F_NOPOLL 0x0040 //Polls are not being received from target
#define F_TXEROR 0x0080 //Bad or no response from target machine

//PACKET ERROR CONDITION FLAG DEFINITIONS  (PIFLAGS high byte)
//THESE ARE RETURNED IN REGISTER AH
//WHEN ASKED FOR WITH STATUS COMMAND
#define F_CHKERR 0x0100 //Bad checksum receiving data
#define F_POLRSP 0x0200 //Poll request received as a response
#define F_NAKRSP 0x0400 //NAK receive as a response
#define F_RCVOVF 0x0800 //Received data too long for buffer
#define F_RCVTOT 0x1000 //Time-out receiving data
#define F_RSPTOT 0x2000 //Time-out waiting for response
#define F_IOEROR 0x4000 //Communications link failure
#define F_RTYERR 0x8000 //Time-out on retrying to transfer

//;STATE CONTROL FLAG DEFINITIONS  (TXINFO low byte)
//;THESE ARE RETURNED IN REGISTER CL
//;WHEN ASKED FOR WITH STATUS COMMAND
#define F_POLSYN 0x0001 //Receiving poll request sync packet
#define F_POLACT 0x0002 //Poll frame is active
#define F_SNDPAK 0x0004 //Sending a packet
#define F_AWTRSP 0x0008 //Waiting for response
#define F_RCVRSP 0x0010 //Receiving the response packet
#define F_AUTOBD 0x0020 //Baudrate failure detect
#define F_AUTOQT 0x0040 //Quick Terminate active
#define F_IABORT 0x0080 //Transfer was aborted

//;STATE CONTROL FLAG DEFINITIONS   (TXINFO high byte)
//;THESE ARE RETURNED IN REGISTER CH
//;WHEN ASKED FOR WITH STATUS COMMAND
//;*NOTE: This is a change from versions prior to V4.00
//;versions earlier than V4.00 returned the retry count in reg CH
#define F_BDSEEK 0x0100 //Seeking poll sync after baudrate change
#define F_PKFLSH 0x0200 //Flushing data stream
#define F_SKPOLL 0x0400 //Skip poll status flag (0=poll done)
#define F_FPSEEK 0x0800 //seeking first poll after init (0=done - got poll)
#define F_RCVUND 0x1000 //reading response buffer when there is no response
#define F_PLSERR 0x2000 //initial poll rsp rcvd (out of sync poll)

#define F_QTFAIL 0x4000 //a quick terminate request failed
#define F_SENDTO 0x8000 //timeout sending a packet

//--------
//F_BDSEEK : This is used to indicate that a baudrate seek change is in process.
//it is set to ON when an autobaud baudrate change occurs (AUTOBD=1, BDSEEK=0)
//it is also set ON when a port is killed or packet reset is called
//It is cleared when a poll failure occurs (beyond the set threshold of allowed failures).
//It is also cleared when a valid POLL[6] char is received
//It is also cleared on packet enable
//--------
//F_AUTOBD : This is used to request a baudrate change.
//It is set set when a poll failure occurs (beyond the set threshold of allowed failures).
//It is cleared when a valid POLL[6] character is received.
//It is also cleared when Packet enable is called.
//Note: AUTOBD will be clear at first even though the baudrate may not yet be in sync

//--------
//BDSEEK and AUTOBD work in concert to manage the autobaud feature.
//When both are cleared, the baudrate is assumed to be good.
//When AUTOBD is high, it means that the poll failure threshold has been passed
//and that a new baudrate is being requested.
//It is reset to low when a valid poll[6] character is received even if the
//baudrate was not changed.
//When the autobaud routine changes the baudrate, it sets BDSEEK high to indicate
//that a change is being processed. This prevents the autobaud from changing the
//baudrate again until either it is determined that the baudrate is good
//or enough errors have occured that Fryers decides another baudrate is to be tried.
//------
//if both AUTOBD and BDSEEK are low, it indicates that either the baudrate is
//good, or that it has not yet known to be bad (just after packet enable being called.
//if either one is high, it means that the baudrate was determined to be wrong
//If only AUTOBD is high, then DoAutoBaud needs to be called to change the baudrate.
//if BDSEEK is high, it means that the driver is activly trying to sync to a new baudrate.
//----
//note: A side effect of BDSEEK is used by the Packet Reset call. It sets
//BDSEEK to high to disable the autobaud until either a valid poll is recieved
//or enough errors have occured to retrigger the autobaud.
//PacketFail clears BDSEEK and sets AUTOBD, which is the new baudrate trigger.
//receipt of a good Poll[6] clears both flags which indicates a good baudrate.

//===========================================================================
//Port modes
#define F_DEMAND_MODE 2
#define F_POLL_MODE 1
#define F_CHAR_MODE 0

//===========================================================================
//Port state information returned by $FFFC command (V6.00) in reg CX
//Also used by FryeCom in the PortState variable of PortStatus record
#define F_PORT_DEAD 0       //port is dead (not in use)
#define F_PORT_ALLOCATED 1  //port resources allocated
#define F_PORT_ACTIVE 2     //port is activated
#define F_PACKET_ACTIVE 3   //packet send in progress
#define F_PACKET_ENABLED 4  //polled packet mode enabled
#define F_DEMAND_ENABLED 5  //Demand packet mode enabled

#pragma pack(pop)  //restore default alignment method
#endif  //FryeRegsH

