
//==============================================================================
// --*** DO NOT EDIT THIS FILE! ***--
//This is a copy of the definition file used by the DLL.
//If you need to declare new definitions, put them someplace else.
//If you need to redefine something, use a wrapper.
// --*** DO NOT EDIT THIS FILE! ***--
//==============================================================================

//===========================================================================
//Fryers32 registers and constants

type F_RegsType = packed record   {register structure to use with Fryers}
       case integer of
         0: (AX:integer; {Note: these are 32 bit values,}
             BX:integer; {*NOT* 16bit as with the 16 bit version of Fryers}
             CX:integer;
             DX:integer;
             DI:integer;
             SI:integer);
         1: (AL,AH,EAL,EAH:byte;
             BL,BH,EBL,EBH:byte;
             CL,CH,ECL,ECH:byte;
             DL,DH,EDL,EDH:byte;
             RDI:integer;
             RSI:integer);
         2: (EAX:integer;
             EBX:integer;
             ECX:integer;
             EDX:integer;
             EDI:integer;
             ESI:integer);
     end;

//===========================================================================
//You only need to worry about the following flag definions if you use
//the old style CallFryers() interface call method. If you only use the
//Newer FryeCom calls to talk via the FIPP protocol to a Fonix instrument,
//you don't need to worry about this stuff. These flags and the
//CallFryers interface are more fully described in the Fryers.TXT and
//FCMDS.txt description files.

//**************************************************************
//;PACKET FLAG DEFINITIONS
//;THESE FLAGS ARE USED TO CONTROL THE PACKET TRANSFER
//;THE FLAG CONDITIONS CAN BE CHECKED BY THE HIGH-LEVEL PROGRAM
//;BY ISSUING A STATUS CALL (0FF13H) TO THE CallFryers PROCEDURE
//Call 0FF13H : AX returns PIFLAGS, CX returns TXINFO.

//--------------------------------------------------------------
//;PACKET STATUS CONDITION FLAG DEFINITIONS  (PIFLAGS low byte)
//;THESE ARE RETURNED IN REGISTER AL
//;WHEN ASKED FOR WITH THE STATUS COMMAND
const F_SNDRDY = $0001; //Ready to accept send command
const F_RCVRDY = $0002; //Data waiting in buffer to be read
const F_SNDOVR = $0004; //New cmd given before old cmd sent
const F_SNDOVF = $0008; //Data size given too large to send
const F_RCVOVR = $0010; //New response overwrote old one
const F_NOPKEN = $0020; //Packet driver is not enabled
const F_NOPOLL = $0040; //Polls are not being received from target
const F_TXEROR = $0080; //Bad or no response from target machine

//PACKET ERROR CONDITION FLAG DEFINITIONS  (PIFLAGS high byte)
//THESE ARE RETURNED IN REGISTER AH
//WHEN ASKED FOR WITH STATUS COMMAND
const F_CHKERR = $0100; //Bad checksum receiving data
const F_POLRSP = $0200; //Poll request received as a response
const F_NAKRSP = $0400; //NAK receive as a response
const F_RCVOVF = $0800; //Received data too long for buffer
const F_RCVTOT = $1000; //Time-out receiving data
const F_RSPTOT = $2000; //Time-out waiting for response
const F_IOEROR = $4000; //Communications link failure
const F_RTYERR = $8000; //Time-out on retrying to transfer

//;STATE CONTROL FLAG DEFINITIONS  (TXINFO low byte)
//;THESE ARE RETURNED IN REGISTER CL
//;WHEN ASKED FOR WITH STATUS COMMAND
const F_POLSYN = $0001; //Receiving poll request sync packet
const F_PKTACT = $0002; //Packet frame is active (was Poll frame active)
const F_SNDPAK = $0004; //Sending a packet
const F_AWTRSP = $0008; //Waiting for response
const F_RCVRSP = $0010; //Receiving the response packet
const F_AUTOBD = $0020; //Baudrate failure detect
const F_AUTOQT = $0040; //Quick release active
const F_IABORT = $0080; //Transfer was aborted
const F_POLACT = F_PKTACT; //Packet active is same as active poll packet (PKTACT=new def)

//;STATE CONTROL FLAG DEFINITIONS   (TXINFO high byte)
//;THESE ARE RETURNED IN REGISTER CH
//;WHEN ASKED FOR WITH STATUS COMMAND
//;*NOTE: This is a change from versions prior to V4.00
//;versions earlier than V4.00 returned the retry count in reg CH
const F_BDSEEK = $0100; //Seeking poll sync after baudrate change
const F_PKFLSH = $0200; //Flushing data stream
const F_SKPOLL = $0400; //Skip poll status flag (0=poll done)
const F_FPSEEK = $0800; //seeking first poll after init (0=done - got poll)
const F_RCVUND = $1000; //reading response buffer when there is no response
const F_PLSERR = $2000; //poll sync error (poll rcvd as a response)

const F_QTFAIL = $4000; //a quick release request failed
const F_SENDTO = $8000; //timeout sending a packet

//--------
//F_BDSEEK : This is used to indicate that a baudrate seek change is in process.
//it is set to ON when an autobaud baudrate change occurs (AUTOBD=1, BDSEEK=0)
//it is also set ON when a port is killed or packet reset is called
//It is cleared when a poll failure occurs (beyond the set threshold of allowed failures).
//It is also cleared when a valid POLL[6] char is received
//It is also cleared on packet enable
//--------
//F_AUTOBD : This is used to request a baudrate change.
//It is set set when a poll failure occurs (beyond the set threshold of allowed failures).
//It is cleared when a valid POLL[6] character is received.
//It is also cleared when Packet enable is called.
//Note: AUTOBD will be clear at first even though the baudrate may not yet be in sync

//--------
//BDSEEK and AUTOBD work in concert to manage the autobaud feature.
//When both are cleared, the baudrate is assumed to be good.
//When AUTOBD is high, it means that the poll failure threshold has been passed
//and that a new baudrate is being requested.
//It is reset to low when a valid poll[6] character is received even if the
//baudrate was not changed.
//When the autobaud routine changes the baudrate, it sets BDSEEK high to indicate
//that a change is being processed. This prevents the autobaud from changing the
//baudrate again until either it is determined that the baudrate is good
//or enough errors have occured that Fryers decides another baudrate is to be tried.
//------
//if both AUTOBD and BDSEEK are low, it indicates that either the baudrate is
//good, or that it has not yet known to be bad (just after packet enable being called.
//if either one is high, it means that the baudrate was determined to be wrong
//If only AUTOBD is high, then DoAutoBaud needs to be called to change the baudrate.
//if BDSEEK is high, it means that the driver is activly trying to sync to a new baudrate.
//----
//note: A side effect of BDSEEK is used by the Packet Reset call. It sets
//BDSEEK to high to disable the autobaud until either a valid poll is recieved
//or enough errors have occured to retrigger the autobaud.
//PacketFail clears BDSEEK and sets AUTOBD, which is the new baudrate trigger.
//receipt of a good Poll[6] clears both flags which indicates a good baudrate.

const F_DEMAND_MODE = 2;
const F_POLL_MODE = 1;
const F_CHAR_MODE = 0;

//===========================================================================
//Port state information returned by $FFFC command (V6.00) in reg CX
//Also used by FryeCom in the PortState variable of PortStatus record
const F_PORT_DEAD = 0;       //port is dead (not in use)
const F_PORT_ALLOCATED = 1;  //port resources allocated
const F_PORT_ACTIVE = 2;     //port is activated
const F_PACKET_ACTIVE = 3;   //packet send in progress
const F_PACKET_ENABLED = 4;  //polled packet mode enabled
const F_DEMAND_ENABLED = 5;   //Demand packet mode enabled
//<eof : fryeregs.inc>

