
//Fryers Interface definition header file for FryeCom.DLL
//Copyright 2010 Frye Electronics, Inc.
//Written by Michael Day as of 13 Aug 2010
//You may use this code for any lawful purpose without fees or royalties.
//This code is intended as an example showing how to communicate with Fonix
//equipment using the FryeCom.DLL device driver on the Windows operating system.
//No warranties are express or implied in the use of this code.
//This will compile under any version of Borland BCB (written using BCB V3.00)
//This code uses only C specific code so it should compile with most c compilers.

//----------------------------------------------
#ifndef FComDefsH
#define FComDefsH

#include "FryeDefs.h" //Common Frye program defs.
#include "Fryers.h"   //Common defs for Fryers DLLs.

//Select whether to use the dynamic loaded DLL or Static loaded DLL method
//(comment out the unused method).
//Be sure to also include the associated FryeComX file in your project.
//If using the static loaded versin you must also include the FryeCom.LIB
//file in libraries portion of the project make file (see FryeComS.CPP).
#define USE_DYNAMIC_DLL
//#define USE_STATIC_DLL

#ifdef USE_DYNAMIC_DLL
  #define FryeComHeader "FryeComD.h"
#else if USE_STATIC_DLL
  #define FryeComHeader "FryeComS.h"
#endif
//Note: the actual FryeCom header include is located at the bottom of this file.

//---------------------------------------------------------------------------

//===============================================================================================
//Common status return definitions
#define FCOM_SUCCESS SUCCESS //same as shorter SUCCESS
#define FCOM_CANCEL CANCEL   //my cancel always = -1
#define FCOM_BUSY 4          //port not ready yet (waiting on send ready or rsp ready packet)
#define FCOM_NOT_READY FCOM_BUSY //same defintion as FCOM_BUSY

//----------------------------------------------------------------------------
//Port open control selections
#define FCOM_USE_NO_SEEK 0     //not seeking port - inactive, or no port was found
#define FCOM_USE_PORT_SEEK 1   //seek com port
#define FCOM_USE_BAUD_SEEK 2   //seek baudrate
#define FCOM_USE_DEMAND_PORT 4 //demand packet port mode
#define FCOM_USE_CHAR_PORT 8   //character port mode (not currently supported)
//Note: cannot use PORT_SEEK or BAUD_SEEK with DEMAND_PORT or CHAR_PORT
//Port is opened as a Packet port unless otherwise selected
//The _USE_ tag was added to clarify the use of these control values.

//----------------------------------------------------------------------------
//Once the port has been opened, you can switch operating mode using $FF10
//with one of the following selections.
#define FCOM_MODE_CHAR 0   //use character mode (not currently available - Use Fryers32 calls)
#define FCOM_MODE_POLLED 1 //use polled packet mode (allows use of port seek and autobaud)
#define FCOM_MODE_DEMAND 2 //use demand packet mode (non-restrictive timing)
//Normal operation with Fonix equipment is to open the port with BAUD_SEEK and PORT_SEEK
//so that the Fonix instrument can be found and the baudrate synced on both ends.
//All Fonix instruments default to Polled Packet operation at power on.
//if required, you can switch to Demand packet mode after the port is opened.
//If you need character mode, then you should open the port in character mode
//providing the port and baudrate that you need (cannot autosync in char mode)
#define FCOM_MAX_PORT_MODE 2 //max available port mode selection

//===========================================================================
//Ack response control defs
#define FCOM_ACK_OK  0    //ok to get an ack response
#define FCOM_NO_ACK  1    //ack response not allowed


//===========================================================================
//Port state information returned in PortStatus record
#define FCOM_PORT_DEAD      F_PORT_DEAD       //port is dead (not in use)
#define FCOM_PORT_ALLOCATED F_PORT_ALLOCATED  //port resources allocated
#define FCOM_PORT_ACTIVE    F_PORT_ACTIVE     //port is activated
#define FCOM_PACKET_ACTIVE  F_PACKET_ACTIVE   //packet send in progress
#define FCOM_PACKET_ENABLED F_PACKET_ENABLED  //polled packet mode enabled
#define FCOM_DEMAND_ENABLED F_DEMAND_ENABLED  //Demand packet mode enabled
//Note: PortState will also return other values depending on the current state of the port
//If the PortState Value is less than zero, then the port is not open and there is
//an error condition. If the PortState is zero, then it is not currently activated.
//If PortState is greater than zero, then it is active.
//===============================================================================================
//PortState will conatins either one of the following negative errors
//if there was a failure, or it will contain the SyncSeek state if busy
//trying to sync to the port, or it will contain the command busy status
//if no error and not trying to sync the port. If there is no error, the port
//is synchronize and it is not busy transferring data, PortState will
//contain 0 (FCOM_SUCCESS).
//===============================================================================================
//Possible errors that might be returned

//common FCOM packet errors use the 9000 series
#define FCOM_PACKET_ERROR -9000      //generic unknown packet error
#define FCOM_PORT_RANGE_ERROR -9001  //not a valid comport selection (out of range)
#define FCOM_PORT_NOT_FOUND -9002    //Requested port not available
#define FCOM_PORT_NOT_OPEN -9003     //Requested port not open for communication
#define FCOM_AUTOBAUD_FAILED -9004   //could not find baudrate

#define FCOM_NO_POLL -9010           //no polls from the instrument
#define FCOM_SEND_OVERRUN -9011      //trying to send another command before old one done.
#define FCOM_SEND_ERROR -9012        //error while trying to send the command

#define FCOM_NO_RESPONSE -9020       //no response received
#define FCOM_RESPONSE_ERROR -9021    //error while receiveing the response
#define FCOM_RESPONSE_OVERRUN -9022  //current response overwrote previous response
#define FCOM_NAK_RESPONSE -9023       //NAK rcvd as a respond
#define FCOM_ILL_RESPONSE -9024      //illegal command rcvd as a response
#define FCOM_POLL_RESPONSE -9025     //poll rcvd as a response
#define FCOM_CMD_FAIL -9026          //unexpected response to a command
#define FCOM_UNEXPECTED_ACK -9027    //got ACK response when wasn't supposed to

#define FCOM_INVALID_FORMAT -9999    //The passed format is invalid (missing pointer?)

//------------------------------------------------------------------------------
//various timeout values
#define FCOM_DEFAULT_NO_POLL_TIMEOUT 5500 //default poll timeout = 5.5 sec
#define FCOM_DEFAULT_RSP_TIMEOUT 2500     //default response timeout = 2.5sec (was 1.1 second)
#define FCOM_DEFAULT_RCV_TIMEOUT 2500     //default receive timeout = 2.5sec (was 1.1 second)
#define FCOM_MIN_NO_POLL_TIMEOUT 500      //Timeout less than 500ms are not allowed
#define FCOM_STD_NO_POLL_TIMEOUT 5000         //std=5sec  //msecs
#define FCOM_LONG_NO_POLL_TIMEOUT 15000       //long=15sec
#define FCOM_EXTRA_LONG_NO_POLL_TIMEOUT 30000 //exlong=30sec
#define FCOM_SUPER_LONG_NO_POLL_TIMEOUT 60000 //superlong=1min
#define FCOM_SHORT_NO_POLL_TIMEOUT 1000       //short=1sec

//------------------------------------------------------------------------------
//Fryers data structure definitions

#pragma pack(push, 1)   //make sure data is byte aligned

//Data record returned by PortStatus call
typedef struct {
  int ComPort;       //this com port
  int PortState;     //>=0 Comport is active, neg=inactive
  int FComVersion;   //FryeCom version number
  DWORD FcomDate;    //FryeCom version date (Packed Frye Date format)
  int MaxPort;       //Maximum available comport
  int SeekState;     //2=seeking baudrate, 1=Attempting to sync to the port, 0=not seeking
  int PortMode;      //0=char, 1=polled packet, 2=demand packet
  int Baudrate;      //Current active baudrate
  int NoPollTimeout; //current No Poll timeout setting in milliseconds
  int PacketStatus;  //current PacketStatus of Fryers driver see Regs.AX
  int PacketControl; //current PacketControl of Fryers driver see Regs.CX
  int PacketState;   //current PacketState of Fryers driver ses Regs.DX
  int Timer;         //curent Packet timer value see Regs.BX in $FF13
  int LastCommand;   //last known Fryers command number that was sent
  int LastResponse;  //last known Fryers response number that was received
  int LastCommandSize;  //size of last known Fryers command that was sent
  int LastResponseSize; //size of last known Fryers response that was received
  int Spare1;          //spare unused parameter
  int Spare2;          //spare unused parameter
  int Spare3;          //spare unused parameter
}FCOM_tPortStatusRec;

//Data record returned by DebugStatus call
typedef struct {
  int ComPort;       //this com port
  int PortState;     //>=0 Comport is active, neg=inactive
  int Handle;        //Windows comport resource handle
  int ReadPortCount;   //Number of port accesses since port was opened
  int ReadFailCount;   //Number of failed port reads since port was opened
  int CmdSendCount;    //Number of commands sent since port was opened
  int FailedRspCount;  //Number of failed responses since port was opened
  int ValidPollCount;  //Number of successful polls since port was opened
  int FailedPollCount; //Number of failed polls since port was opened
  int TotalBytesRead;  //Number of successful bytes read since port was opened
  int DebugState;      //used to passback state conditions during debugging
  int PortOpenControl; //mode port was opened with - see OpenPort()} //was PortMode
  int Spare2;          //spare unused parameter
  int Spare3;          //spare unused parameter
  int Spare4;          //spare unused parameter
  int Spare5;          //spare unused parameter
}FCOM_tDebugStatusRec;

//Buffer to hold the results acquired from the analyzer
#define FCOM_MAX_DATA 2100 //maximum RESTYPE buffer size in words.
struct FCOM_TfcArray {
  union {
    struct {
      INT16 Cmd;
      INT16 Size;
      INT16 Data[FCOM_MAX_DATA];      //unsigned short
    };
    struct {
      INT16 Raw[FCOM_MAX_DATA+2];
    };
  };
};
#pragma pack(pop)  //restore default alignment method

//---------------------------------------------------------------------------------
//When a callback occurs from within the Fryers driver, it passes the Com port handle
//(which is the com port number) as the Parameter value so that you will know which
//port is performing the callback. When you return from the callback, you must pass back
//status control information. Currently there are only two valid return values specified.
//FCOM_SUCCESS indicates that the callback was successful and nothing needs to be done.
//FCOM_CANCEL indicates that the current operation should be canceled can control
//returned back to the application. The driver will return the FCOM_CANCEL in this situation.
typedef __stdcall int(*FCOM_TfcCallback)(int Parameter);  //callback function declaration with one parameter


//===============================================================================================
#include FryeComHeader
//===============================================================================================


#endif
