
//this stuff below is set by typing ^O^O
{$A+,B-,C+,D-,E-,F-,G+,H+,I-,J+,K-,L-,M-,N+,O+,P+,Q-,R-,S-,T-,U-,V+,W-,X+,Y-,Z1}

//Fryers Interface definition file for FryeCom.pas
//Copyright 2010, 2011 Frye Electronics, Inc.
//Originally Written by Michael Day as of 13 Aug 2010
//Note: See FryersDef.pas for the Fryers32 specific definitions
//Fryecom is a superset of the Fryers32.dll
//It consists of a wrapper around the original Fryers32 DLL code.
//It is done this way because Fryers32 is rock solid stable.
//So we don't want to mess with it, but customers have been
//asking for a new api interface that is simpler and easier to use.
//I have also been writting it such that we can easily adapt this to
//use an ethernet interface instead of a serial com.

unit FcomDefs;
interface
uses FryeDefs, Fryers;

//==============================================================================
// --*** DO NOT EDIT THIS UNIT! ***--
//This is a copy of the definition file used by the DLL.
//If you need to declare new definitions, put them someplace else.
//If you need to redefine something, use a wrapper.
// --*** DO NOT EDIT THIS UNIT! ***--
//==============================================================================

//---------------------------------------------------------------------------------
//FcomDefs is the common definition file for constants and data structures
//used in the FryeCom DLL. This file is published to the outside world
//for others to import into their programs, so don't change anything
//in the file. It has to be stable. You can add things, but be very careful.
//You should add a "FC_" for data, or FCOM_ for constants to the start of
//anything that refers to the FryeCom unit data, or a "F_" to anything that
//refers to the underlaying Fryers DLL data.
//This should help prevent conflicts with the user's own program definitions.

//---------------------------------------------------------------------------------
//Note: while technically you can change the buffer size by calling through to the low-level Fryers interface,
//nobody ever does, and it wouldn't work anyway since the attached instruments only have 2K buffers.
const FCOM_MAX_DATA_SIZE = 2100; //max of 2100 words for buffer sizes

type FC_tCmdArray = packed record   {command structure to use with Fryers}
       case integer of
         0: (Cmd:INT16;
             Size:INT16;
             Data:array[0..FCOM_MAX_DATA_SIZE-2] of INT16;
             );
         1: (Raw : array[0..FCOM_MAX_DATA_SIZE] of INT16;  //tFArray : array[0..FCOM_MAX_DATA_SIZE] of INT16;
             );
         2: (DataByte : array[0..(FCOM_MAX_DATA_SIZE*2)] of BYTE;  //tFArray : array[0..FCOM_MAX_DATA_SIZE] of INT16;
             );
       end;

type FC_pCmdArray = ^FC_tCmdArray;
type FC_pRspArray = ^FC_tCmdArray;

//---------------------------------------------------------------------------------
//When a callback occurs from within the Fryers driver, it passes the Com port handle
//(which is the com port number) as the parameter Value so that you will know which
//port is performing the callback. When you return from the callback, you must pass back
//status control information. Currently there are only two valid return values specified.
//FCOM_SUCCESS indicates that the callback was successful and nothing needs to be done.
//FCOM_CANCEL indicates that the current operation should be canceled can control
//returned back to the application. The driver will return the FCOM_CANCEL in this situation.
type FC_tCallback = function(Value:integer):integer; stdcall;

//---------------------------------------------------------------------------
//Frye Packed Date format is a DWORD formated with the following nibbles:
//dd:ee:yyy:m - where "dd"=day(31-24), "ee"=expire(23-16)
//"yyy" = year(bits 15-4), "m"=month(3-0), (year=0->4095)
//Note: Borland doesn't have an explict unsigned 32bit Dword type.
//They call unsigned types Cardinals, but it can be 16bit or 32bit.
//The only way to insure a 32bit type is to use the longint and deal with
//the sign issues in the code.
type FC_tPackedDate = longint;    //A packed date is formated as a Dword

//---------------------------------------------------------------------------
//Note: Keep these values as all integers in a packed record.
//That way if the user's program cannot handle packed records,
//they can map it as an array of integers instead.
type FC_tPortStatusRec = packed record
  ComPort : integer;       {this com port}
  PortState : integer;     {>=0 port active, neg=inactive}
  FcomVersion : integer;   {FryeCom version number}
  FcomDate : FC_tPackedDate; {FryeCom release date - Packed Frye date format}
  MaxPort : integer;       {maximum available com port}
  SeekState : integer;     {1=Attempting to sync to the port, 2=seeking baudrate, 0=not seeking}
  PortMode : integer;      {0=char, 1=polled packet, 2=demand packet}
  Baudrate : integer;      {Current active baudrate}
  NoPollTimeout : integer; {current No Poll timeout setting in milliseconds}
  PacketStatus : integer;  {current PacketStatus of Fryers driver see Regs.AX}
  PacketControl : integer; {current PacketControl of Fryers driver see Regs.CX}
  PacketState : integer;   {current PacketState of Fryers driver ses Regs.DX}
  Timer : integer;         {curent Packet timer value see Regs.BX in $FF13}
  LastCommand : integer;      {last known Fryers command number that was sent}
  LastResponse : integer;     {last known Fryers response number that was received}
  LastCommandSize : integer;  {size of last known Fryers command that was sent}
  LastResponseSize : integer; {size of last known Fryers response that was received}
  Spare1 : integer;         {spare unused parameter - for future use}
  Spare2 : integer;         {spare unused parameter - for future use}
  Spare3 : integer;         {spare unused parameter - for future use}
end;


//---------------------------------------------------------------------------
//The Debug sttaus is like Port status, but returns more detailed info.
//Note: Keep these values as all integers in a packed record.
//That way if the user's program cannot handle packed records,
//they can map it as an array of integers instead.
type FC_tDebugStatusRec = packed record
  ComPort : integer;       {this com port}
  PortState : integer;     {Status of the selected com port - see PortStatus.PortState}
  Handle : integer;         {Windows comport resource handle}
  ReadPortCount : integer;   {Number of port accesses since port was opened}
  ReadFailCount : integer;   {Number of failed port reads since port was opened}
  CmdSendCount : integer;    {Number of commands sent since port was opened}
  FailedRspCount : integer;  {Number of failed responses since port was opened}
  ValidPollCount : integer;  {Number of successful polls since port was opened}
  FailedPollCount : integer; {Number of failed polls since port was opened}
  TotalBytesRead : integer;  {total number of bytes read since port was opened}
  DebugState : integer;      {used to passback state conditions during debugging}
  PortOpenControl : integer;  {mode port was opened with - see OpenPort()} //was PortMode
  Spare2 : integer;           {spare unused parameter - for future use}
  Spare3 : integer;           {spare unused parameter - for future use}
  Spare4 : integer;           {spare unused parameter - for future use}
  Spare5 : integer;           {spare unused parameter - for future use}
end;

//---------------------------------------------------------------------------
const FCOM_ACK  : INT16 = INT16($FFFC); //-4
const FCOM_NAK  : INT16 = INT16($FFFB); //-5
const FCOM_ILL  : INT16 = INT16($FFFA); //-6
const FCOM_POLL : INT16 = INT16($FFFF); //-1
const FCOM_QRC  : INT16 = INT16($7FFF); //32767

//===============================================================================================
//Common status return definitions
const SUCCESS = 0;       //my success always = 0
const FCOM_SUCCESS = 0;  //same as shorter SUCCESS
const FCOM_CANCEL = -1;  //my cancel always = -1
const FCOM_BUSY = 4;     //port not ready yet (waiting on send ready or rsp ready packet)
const FCOM_NOT_READY = FCOM_BUSY; //Not_Ready is same as Busy


//Port open control selections
const FCOM_USE_NO_SEEK = 0;     //not seeking port - inactive, or no port was found
const FCOM_USE_PORT_SEEK = 1;   //seek com port
const FCOM_USE_BAUD_SEEK = 2;   //seek baudrate
const FCOM_USE_DEMAND_PORT = 4; //demand packet port mode
const FCOM_USE_CHAR_PORT = 8;   //character port mode (not currently supported)
//Note: cannot use PORT_SEEK or BAUD_SEEK with DEMAND_PORT or CHAR_PORT
//Port is opened as a Packet port unless otherwise selected
//The _USE_ tag was added to clarify the use of these control values.

//Once the port has been opened, you can switch operating mode using $FF10
//with one of the following selections.
const FCOM_MODE_DEAD = -1;  //port has not been opened
const FCOM_MODE_CHAR = 0;   //use character mode (not currently available - Use Fryers32 calls)
const FCOM_MODE_POLLED = 1; //use polled packet mode (allows use of port seek and autobaud)
const FCOM_MODE_DEMAND = 2; //use demand packet mode (non-restrictive timing)
//Normal operation with Fonix equipment is to open the port with BAUD_SEEK and PORT_SEEK
//so that the Fonix instrument can be found and the baudrate synced on both ends.
//All Fonix instruments default to Polled Packet operation at power on.
//if required, you can switch to Demand packet mode after the port is opened.
//If you need character mode, then you should open the port in character mode
//providing the port and baudrate that you need (cannot autosync in char mode)
const FCOM_MAX_PORT_MODE = 2; //max available port mode selection

//===========================================================================
//Port state information returned in PortStatus record
const FCOM_PORT_DEAD      = F_PORT_DEAD;       //port is dead (not in use)
const FCOM_PORT_ALLOCATED = F_PORT_ALLOCATED;  //port resources allocated
const FCOM_PORT_ACTIVE    = F_PORT_ACTIVE;     //port is activated
const FCOM_PACKET_ACTIVE  = F_PACKET_ACTIVE;   //packet send in progress
const FCOM_PACKET_ENABLED = F_PACKET_ENABLED;  //polled packet mode enabled
const FCOM_DEMAND_ENABLED = F_DEMAND_ENABLED;  //Demand packet mode enabled
//Note: PortState will also return other values depending on the current state of the port
//If the PortState Value is less than zero, then the port is not open and there is
//an error condition. If the PortState is zero, then it is not currently activated.
//If PortState is greater than zero, then it is active.

//===========================================================================
//Ack response control defs
const FCOM_ACK_OK = 0;    //ok to get an ack response
const FCOM_NO_ACK = 1;    //ack response not allowed

//===============================================================================================
//Possible driver errors that might be returned by FryeCom.DLL (1000 series)
const FCOM_GENERIC_ERROR = -1000;   //unknown fryecom error - something bad happened
const FCOM_FILE_NOT_FOUND = -1001;  //device driver file not found
const FCOM_ENTRY_NOT_FOUND = -1002; //entry point to fryecom driver not found
const FCOM_BAD_DRIVER = -1003;      //unknown internal problem encountered in the Driver

//common fcom errors use the 9000 series
const FCOM_PACKET_ERROR = -9000;      //generic unknown packet error
const FCOM_PORT_RANGE_ERROR = -9001;  //not a valid comport selection (out of range)
const FCOM_PORT_NOT_FOUND = -9002;    //Requested port not available
const FCOM_PORT_NOT_OPEN = -9003;     //Requested port not open for communication
const FCOM_AUTOBAUD_FAILED = -9004;   //could not find baudrate

const FCOM_NO_POLL = -9010;           //no polls from the instrument
const FCOM_SEND_OVERRUN = -9011;      //trying to send another command before old one done.
const FCOM_SEND_ERROR = -9012;        //error while trying to send the command

const FCOM_NO_RESPONSE = -9020;       //no response received
const FCOM_RESPONSE_ERROR = -9021;    //error while receiveing the response
const FCOM_RESPONSE_OVERRUN = -9022;  //current response overwrote previous response
const FCOM_NAK_RESPONSE = -9023;       //NAK rcvd as a respond
const FCOM_ILL_RESPONSE = -9024;      //illegal command rcvd as a response
const FCOM_POLL_RESPONSE = -9025;     //poll rcvd as a response
const FCOM_CMD_FAIL = -9026;          //unexpected response to a command
const FCOM_UNEXPECTED_ACK = -9027;    //got ACK response when wasn't supposed to

const FCOM_INVALID_FORMAT = -9999;    //The passed format is invalid (missing pointer?)

const FCOM_DEBUG_ERROR = -666;        //This error is used to generate a specific error during debugging
                                      //It is not used for anything else.

//===============================================================================================
//Fryers32 versions that may be returned
//Note: if you call through to the low-level Fryers DLL, you will get the Fryers DLL version numbers
//back instead of the FryeCom DLL version numbers. This is to allow backwards compatibility to
//old software that might require the Fryers Version number info.
//If you use the standard FryeCom DLL calls, you will get the FryeCom version number.
const FRYERS32_FIRST_DLL_VERSION = 500; //this is the first 32 bit dll version of fryers anything earlier won't work with 32bit windows
const FRYERS32_EARLY_DLL_VERSION = 512; //this is the first good version of the 32bit dll strongly request them to update if earlier than this
const FRYERS32_LATE_DLL_VERSION = 516;  //this is the previous good version of the 32bit dll lightly request them to update if earlier than this
const FRYERS32_GOOD_DLL_PORT_VERSION = 520; //this Fryers version fixes the comport problem (allow max of 99 ports)
const FRYERS32_BEST_DLL_PORT_VERSION = 601; //this Fryers version increases max comport available (allow max of 256 ports)

//Current Fryers version number ** Keep this updated! ** Used by Fcheck program
const FRYERS32_CURRENT_DLL_VERSION = 601; //this is the long version number of the current released DLL

//NOTE: The above is *NOT* the same as the FryeCom version number.
//The FryeCom version number starts with V7.01
//(there was an pre-release beta FryeCom DLL that declared itself to be V6.00)

//===============================================================================================
//Max Com port defines
//Note: We don't actually use FP_MAX_OLD_COM_PORT. It is here for reference only.
const FCOM_MAX_PORTS = F32_MaxComPort+1; //max ports allowed to access via Fryers (V5.40 and above)
const FCOM_MAX_OLD5_COM_PORT = 99;     //max ports of 99 allowed to access for Fryers V5.20 to V5.40 Fryers
const FCOM_MAX_OLD4_COM_PORT = 9;  //we have 9 comports allowed in this application if old fryers (V5.18 or lower)
const FCOM_MAX_COM_PORT = FCOM_MAX_PORTS-1; //we have 256 comports allowed in this application if new Fryers (6.01 or above)


//============================================================================================
//various timeout values
const FCOM_DEFAULT_NO_POLL_TIMEOUT = 5500; //default poll timeout = 5.5 sec
const FCOM_DEFAULT_RSP_TIMEOUT = 2500;   //default response timeout = 2.5sec (was 1.1 second)
const FCOM_DEFAULT_RCV_TIMEOUT = 2500;   //default receive timeout = 2.5sec (was 1.1 second)
const FCOM_MIN_NO_POLL_TIMEOUT = 500;    //Timeout less than 500ms are not allowed
const FCOM_STD_NO_POLL_TIMEOUT = 5000; //5000         //std=5sec  //msecs
const FCOM_LONG_NO_POLL_TIMEOUT = 15000;       //long=15sec
const FCOM_EXTRA_LONG_NO_POLL_TIMEOUT = 30000; //exlong=30sec
const FCOM_SUPER_LONG_NO_POLL_TIMEOUT = 60000; //superlong=1min
const FCOM_SHORT_NO_POLL_TIMEOUT = 1000;       //short=1sec

implementation
end.


