//---------------------------------------------------------------------------
//FippCore.H as of 30 Aug 2010 by Michael Day
//Frye Instrument Packet Protocol interface header
//Copyright Frye Electronics 2010
//You may use this code for any lawful purpose without fees or royalties.
//This code is intended as an example showing how to communicate with Fonix
//equipment using the Fryers.DLL device driver on the Windows operating system.
//No warranties are express or implied in the use of this code.
//---------------------------------------------------------------------------
#ifndef FippCoreH
#define FippCoreH
//---------------------------------------------------------------------------
#include "FryeRegs.h"  //provides defs for old Fryers32 interface
#include "FcomDefs.h"  //provides defs for constants and vars for Fryers interface


/////////////////////////////////////////////////////////////////////////////
// FippCore Class to provide the communication with the instrument.
// Class encapsulates both the structures and the functions to be used.
/////////////////////////////////////////////////////////////////////////////


//---------------------------------------------------------------------------
//class TclsFrye:public TObject {
class TclsFippCore {
  public:  //public variables
    int  FcomVersion;       //version of Fryers Fcom driver
    int  ThisComPort;       //The actual real port selected for the communication (0=com1, 1=com2, etc...)
    int  ActiveBaudrate;    //last known active baudrate in use (9600, 19200, 28800, 38400, 57600, 115200) 0=unknown
    bool PortInitialized;   //true = the port has been initialized
    bool LookingForPort;    //false=not looking for port, true=looking for new port
    FCOM_tPortStatusRec PortStatus;  //comport status info updated by FCOM_GetPortStatus()

    FCOM_TfcArray CmdArray;   //Used by fryers functions to pass data back and forth
    FCOM_TfcArray RspArray;   //between the computer and the Fonix instrument


    //function definitions
    __fastcall TclsFippCore();  //my constructor call

    int  __fastcall UpdatePortStatus(void);
    bool __fastcall PreIdInstrument(int InstrumentModel);
    bool __fastcall CmdRetry(int Error);
    DWORD __fastcall FixupCustomOptions(INT16 InstrumentType, DWORD CstOptions);
    int  __fastcall UnexpectedAck(int RspCmd);
    int  __fastcall UpdateFcomVersion(void);
    int  __fastcall GetMaxPort(int* MaxPort);

    int  __fastcall SetNoPoll(int Timeout);
    int  __fastcall GetNoPoll(int* pTimeout);

    int  __fastcall ClosePort(void);
    int  __fastcall InitPort(int AutoSeek, int NewComPort, int StartPort, int StopPort, int MaxRetry, int StartBaud, FCOM_TfcCallback Callback);
    int  __fastcall SendReady(FCOM_TfcCallback CallBack);
    int  __fastcall WaitForSendReady(FCOM_TfcCallback Callback);   //Function to wait until the send ready flag is set
    int  __fastcall SendCmd(int NoPollTimeout, FCOM_TfcArray* pCmdArray);//SENDS THE COMMAND AND ACCOMPANYING DATA TO THE INSTRUMENT
    int  __fastcall RspReady(void);
    int  __fastcall WaitForRspReady(FCOM_TfcCallback Callback);   //Function to wait until the response is ready
    int  __fastcall GetResponse(int NoACK, FCOM_TfcArray* pRspArray);
    int __fastcall DoCmd(int NoACK, int NoPollTime, FCOM_TfcArray* pCmdArray, FCOM_TfcArray* pRspArray, FCOM_TfcCallback Callback);

    int  __fastcall QuickTerminate(FCOM_TfcCallback Callback); //send a QuickTerm followup

};


#endif


