//---------------------------------------------------------------------------
//FippDefs definitions file for FippCore and FippUnit
//Copyright 2010 Frye Electronics, Inc.
//Written by Michael Day as of 20 Oct 2010
//You may use this code for any lawful purpose without fees or royalties.
//This code is intended as an example showing how to communicate with Fonix
//equipment using the Fryers32 or FryeCom device driver on the Windows operating system.
//No warranties are express or implied in the use of this code.
//This will compile under any later version of Borland Delphi (written using Delphi V3.00)
//---------------------------------------------------------------------------
#ifndef FippDefsH
#define FippDefsH
//---------------------------------------------------------------------------
#include "FryeDefs.h"
#include "FryeRegs.h"
#include "Fryers.h"
#include "FcomDefs.h"

#pragma anon_struct on  //allow anonymous union structures
#pragma pack(push, 1)   //make sure data is byte aligned

//Note: Some of the FIPP defs have been moved to the Fryers.h file

//other defs
#define FIPP_SOFT_RETRY  3  //number of times to retry command if failed
#define FIPP_POWER_FLAGS_MASK  0xE000 //mask used to read power control flags
#define FIPP_BATTERY_CUSTOM  8        //custom battery selection (rs232 supplied custom volts/ohms)

//remote timouts
#define FIPP_REMOTE_RSP_TIMEOUT  2000 //2sec
#define FIPP_REMOTE_POLL_TIME    50 //50ms


//OptionsState definitions
#define FIPP_OPTIONS_UNKNOWN   0 //unknown state
#define FIPP_OPTIONS_INVALID   1 //invalid data
#define FIPP_OPTIONS_BOOT      2 //bootloader state
#define FIPP_OPTIONS_VALID     3 //valid options data

//positive number means application level
//negative number means preapplication level (bootloader or test mode)
#define FIPP_FONIX_SW_APP   0 //instrument software in application mode
#define FIPP_FONIX_SW_BL   -1 //instrument software in bootloader mode

#define FIPP_MAIN_MENU_MAJOR_STATE 16  //main menu state
#define FIPP_LABEL_MINOR_STATE   100  //printer Label screen location in main menu

#define FIPP_ENTRY_MINOR_STATE   0
#define FIPP_COUPLER_MAJOR_STATE  1  //coupler screen major state
#define FIPP_COUPLER_MINOR_STATE  0  //coupler screen minor state

#define FIPP_CURRENT_LABEL_TEXT 0
#define FIPP_FACTORY_LABEL_TEXT 1
#define FIPP_STORED_LABEL_TEXT 2

#define FIPP_CURRENT_ID_TEXT -1
#define FIPP_DEFAULT_ID_TEXT 0
#define FIPP_USER1_ID_TEXT 1
#define FIPP_USER2_ID_TEXT 2
#define FIPP_USER3_ID_TEXT 3
#define FIPP_USER4_ID_TEXT 4
#define FIPP_USER5_ID_TEXT 5
#define FIPP_USER6_ID_TEXT 6
#define FIPP_USER7_ID_TEXT 7


//supported user modes - (Normally only easy and advanced are available)
#define FIPP_USER_NOVICE 0
#define FIPP_USER_EASY 1
#define FIPP_USER_ADVANCED 2
#define FIPP_USER_EXPERT 3


//defined vents
#define FIPP_FIT_VENT_OPEN      0  //{Vent Open}
#define FIPP_FIT_VENT_OCCLUDED  1  //{Vent Occluded}
#define FIPP_FIT_VENT_TIGHT     2  //{Vent tight}
#define FIPP_FIT_VENT_MM1       3  //{Vent 1mm}
#define FIPP_FIT_VENT_MM2       4  //{Vent 2mm}
#define FIPP_FIT_VENT_MM3       5  //{Vent 3mm}

//defined tubing
#define FIPP_FIT_TUBING_NONE    0  //{Tubing None  [cic, itc, ite aids] }
#define FIPP_FIT_TUBING_LIBBY4  1  //{Tubing Libby 4                    }
#define FIPP_FIT_TUBING_LIBBY3  2  //{Tubing Libby 3                    }
#define FIPP_FIT_TUBING_CFA2    3  //{Tubing CFA #2 horn                }
#define FIPP_FIT_TUBING_CFA3    4  //{Tubing CFA #3 stepped bore        }
#define FIPP_FIT_TUBING_No13    5  //{Tubing #13                        }
#define FIPP_FIT_TUBING_sixC5   6  //{Tubing 6C5                        }
#define FIPP_FIT_TUBING_sixC10  7  //{Tubing 6C10                       }

//defined aid type
#define FIPP_AID_TYPE_NONE 0   //{NONE - No aid type selected (treat same as ITC) }
#define FIPP_AID_TYPE_BTE  1    //{BTE - Behind the ear             }
#define FIPP_AID_TYPE_ITE  2    //{ITE - In the ear                 }
#define FIPP_AID_TYPE_ITC  3    //{ITC - In the ear canal           }
#define FIPP_AID_TYPE_CIC  4    //{CIC - Completely in the ear canal}
#define FIPP_AID_TYPE_UEM  5    //{UEM - BTE with user's earmold  - not used }

//defined filters
#define FIPP_AUTO_FILTER  0     //{auto-select the filter}
#define FIPP_FLAT_FILTER  1     //{flat unweighted source}
#define FIPP_ANSI_FILTER  2     //{ansi speech filter}
#define FIPP_ICRA_FILTER  3     //{irca speech filter}
#define FIPP_CLTASS_FILTER 4   //{UWO Child LTASS filter}
#define FIPP_ALTASS_FILTER 5   //{Cox&Moore Adult LTASS filter}
#define FIPP_ANSI92_FILTER 6   //{Ansi S3.42-1992 filter}
#define FIPP_PINK_FILTER   7   //{pink noise filter}
#define FIPP_ILTASS_FILTER 8   //{NAL-NL1 International ltass filter}

//Defined fit rules
#define FIPP_NALRP_FITTING_RULE  0     // (0) NALRP (was NAL-2)
#define FIPP_POGO_FITTING_RULE  1      // (1) POGO
#define FIPP_BERGER_FITTING_RULE  2    // (2) Berger
#define FIPP_THIRD_FITTING_RULE  3     // (3) 1/3 Gain
#define FIPP_HALF_FITTING_RULE  4      // (4) 1/2 Gain
#define FIPP_TWO_THIRD_FITTING_RULE  5 // (5) 2/3 Gain
#define FIPP_DSL_LIN_FITTING_RULE  6   // (6) DSL LINear fitting rule
#define FIPP_DSL_WDRC_FITTING_RULE  7  // (7) DSL WDRC fitting rule
#define FIPP_NALNL1_FITTING_RULE  8    // (8) NAL-NL1 fitting rule
#define FIPP_MOD_NALNL1_FITTING_RULE  9 //(9) Modified NAL-NL1 fitting rule
#define FIPP_NALNL2_FITTING_RULE  10    //(10) NAL-NL2 fitting rule
//fit rules 11->14 are currently undefined
#define FIPP_DIRECT_FITTING_RULE  15    // (15) Direct (manual entry)

//FP35 Leveling list defines
#define FIPP_LEVELING_ADJ_LIST  0
#define FIPP_LEVELING_FREQ_LIST 1
#define FIPP_SPECTRUM_ADJ_LIST  2
#define FIPP_LEVELING_EAR_ADJ_LIST  100
#define FIPP_LEVELING_EAR_FREQ_LIST 101
#define FIPP_LEVELING_DSL_EAR_ADJ_LIST  102
#define FIPP_LEVELING_DSL_EAR_FREQ_LIST 103
#define FIPP_LEVELING_EAR_DIFF_LIST  104


#define FIPP_CURRENT_FREQ_LIST  0 //<not settable>
#define FIPP_CURRENT_DIST_LIST  1 //<not settable>
#define FIPP_USER_FREQ_LIST 2
#define FIPP_USER_DIST_LIST 3
#define FIPP_TONE_SWEEP_SETTLE_LIST 4
#define FIPP_IO_SWEEP_SETTLE_LIST   5


//Data structure returned by cmd 28
//Note: some instruments not completely fill in the MachineVersion structure.
//unfilled/unknown items are left at zero.
//This unit will attempt to fill in InstrumentModel if it is unknown.
typedef struct {
  INT16 SoftwareVersion;
  DWORD StdOptions;
  DWORD CstOptions;
  INT16 InstrumentBaseType;
  INT16 SubType;
  INT16 InstrumentModel;
}FIPP_tMachineVersion;  //returned by cmd 28

//Data structure returned by cmd 95
//Note: some instruments do not support cmd 95, others may not completely fill it in.
//unfilled/unknown items are left at zero.
typedef struct {
  INT16 MachineType;       //[0] 35=FP35, 7000=7000, etc...
  INT16 SoftwareVersion;   //[1]
  INT16 Language;          //[2] 0=unknown, 1=english, 2=french, 3=german, 4=spanish
  INT16 BootLoaderVersion; //[3] was 1792 in FP35 < V2.12 (instead of 7)
  INT16 EEromVersion;      //[4] not available in FP35 < V2.12 (returns 0=unknown) (FP35 V2.12)
  char SerialNumber[8];    //[5..8] Frye assigned serial number    (FP35 V2.20)
  FD_tPackedCalDate MfgDate;          //[9..10] date of maufacture            (FP35 V2.20)
  FD_tPackedCalDate HwCalDate;        //[11..12] date of Hardware calibration (FP35 V2.20)
  FD_tPackedCalDate SwCalDate;        //[13..14] date of Software calibration (FP35 V2.20)
  INT16 CalStatus;                //[15] calibration status         (FP35 V3.20)
  FD_tPackedCalDate SwBuildDate;  //[16..17] date of software build (FP35 V3.20)
  INT16 SwBuildNumber;            //[18] software build number      (FP35 V3.20)
  INT16 CpuTemperature;    //[19] current cpu temperature         (FP35 V3.50)
  INT16 HwCalTemperature;  //[20] tempurature during hardware cal (FP35 V3.50)
  INT16 SysCalTemperature; //[21] temperature during software cal (FP35 V3.50)
  INT16 CpuBoardRevNumber; //[22] cpu board revision              (FP35 V6.00)
  char ModelNumber[8];     //Frye assigned model number (future feature)
}FIPP_tInstrumentInfo; //this info is returned by cmd 95

typedef struct {
  WORD Millisecond;  //set to 0 if not supported
  BYTE Second; //0-59
  BYTE Minute; //0-59
  BYTE Hour;   //0-24 or 1-12
  BYTE DayOfWeek;  //spare (is day of week on some clocks - not all) is 0 if not available
  BYTE Day;    //1-31
  BYTE Month;  //1-12
  WORD Year;   //1992-9999
} FIPP_tRTC_Time;

#define FIPP_STD_CURVE_FRAME_SIZEW 88 //{StdCurveFrameSize = std curve frame size in words}
#define FIPP_AUD_CURVE_FRAME_SIZEW 24 //{AudCurveFrameSize = aud curve frame size in words}

typedef FIPP_tBlobArray[1024]; //array[0..1023] of word; {blob array definition}
typedef FIPP_tBlobArray* FIPP_ptBlobArray;      //{pointer to the blob array}

#define fipp_ARparamsSize 4    //{four words in A/R parameter call}
typedef WORD FIPP_tARparams[fipp_ARparamsSize]; //array[0..fipp_ARparamsSize] of word;

typedef WORD FIPP_tLevelingList[256]; //array[0..256] of word;
typedef char FIPP_tStatusMsg[256];    //array[0..256] of char;
typedef WORD FIPP_tTestParametersArray[128]; //array[0..128] of word;

const fipp_MaxSpectrumPos = 80;   //{size of spectrum table in words}
const fipp_MaxPhasePos = 80;      //{size of phase table in words}
typedef INT16 FIPP_tSpectrumArray[128]; //array[0..128] of smallint;
typedef WORD FIPP_tPhaseArray[128];     //array[0..128] of word;

const fipp_MaxAuxData = 2000;
typedef char FIPP_tAuxDataArray[fipp_MaxAuxData]; //array[0..fipp_MaxAuxData] of char;

const fipp_MaxDeviceData = 255; //{max device data array size}
typedef FIPP_tDeviceDataArray[fipp_MaxDeviceData]; //array[0..fipp_MaxDeviceData] of word;

const fipp_MaxRawSampleData = 2000; //{max array size}
typedef INT16 FIPP_tRawSampleData[fipp_MaxRawSampleData];  //array[0..fipp_MaxRawSampleData] of smallint;

const fipp_MaxListData = 2000; //{max array size}
typedef INT16 FIPP_tListData[fipp_MaxListData]; //array[0..fipp_MaxListData] of smallint;

const fipp_MaxCalListData = 2000; //{max array size}
typedef INT16 FIPP_tCalListData[fipp_MaxCalListData];  //array[0..fipp_MaxCalListData] of smallint;

const fipp_IOcurveSize = (10*2); //{IOcurve size in bytes}
const MaxCurveSize = 256;        //{size of largest curve frame (in words)}

typedef WORD FIPP_tVersionArray[128]; //array[0..128] of word;

//Note: although the label arrays are declared here as array of char,
//they are actually 2D pchar arrays when used.
const FIPP_NUM_LABEL_LINE_CHAR = 28;  //{there are 28 character positions in a label line}
const FIPP_REG_EXT_LINES = 8;         //{there are eight lines in the regular extended label}
const FIPP_MAX_EXT_LINES = 10;        //{there are ten lines in the full extended label}
//const FIPP_MAX_USERID_LINE_TEXT = 28; {size of User ID line text (in char) same as a label line}

//{Note: the first five lines of an older standard label are 18 char in length}
//{The remaining 3 lines are 28 char in length. All lines must have a trailing null.}
const FIPP_NUM_STD_LABEL_CHAR = 172; //{size of std label array (in char) (18*5)+(28*3)}

//{Extended arrays are like std arrays except they allow the user to}
//{overwrite all the text in the label (including the field titles).}
//{A normal label has 8 lines of text (28 char each) with a trailing Null as the last char.}
//{A full extended label has ten lines the last two lines being the user custom ID text (see below).}
const FIPP_REG_EXT_LABEL_SIZEB = (FIPP_NUM_LABEL_LINE_CHAR*FIPP_REG_EXT_LINES); //224;  {size of regular extended label array (in char) (28*8)}
const FIPP_MAX_EXT_LABEL_SIZEB = (FIPP_NUM_LABEL_LINE_CHAR*FIPP_MAX_EXT_LINES); //size of full extended label in bytes (w/userID)

//{each label line has 28 chars (including trailing null)}
typedef char FIPP_tLabelLine[FIPP_NUM_LABEL_LINE_CHAR];

//Standard label declaration as a flat array
typedef char FIPP_tStdLabelArray [FIPP_NUM_STD_LABEL_CHAR+1];

//Extended label declaration as a flat array
typedef char FIPP_tExtLabelArray [FIPP_MAX_EXT_LABEL_SIZEB+1];

//extended label declaration as a structure
//Map FIPP_tLabelMap on top FIPP_tExtLabelArray to treat it as individual pchar text lines.
//type FIPP_tLabelMap = array[0..FIPP_MAX_EXT_LINES-1] of FIPP_tLabelLine;

//User ID array declarations
//Note: although the user ID arrays are declared here as array of char,
//they are actually 2D pchar arrays when used.
const FIPP_MAX_USERID_TEXT = 56;  //{full size of User ID text array (in char)}
typedef char FIPP_tUserIDText[FIPP_MAX_USERID_TEXT+1];
const FIPP_MAX_USER_ID = 16;     //no more than 16 user ids allowed
typedef FIPP_tUserIDText FIPP_tUserID[FIPP_MAX_USER_ID]; //there are a maximum of 16 users possible
//Note: first "user" in UserID array is always the default UserID
//User#1 starts at index[1] (there is no User#0)

//Map FIPP_tCustomID on top FIPP_tUserIDText to treate it as a two pchar text lines.
typedef struct {
  FIPP_tLabelLine Line1; //there are two lines in each user id
  FIPP_tLabelLine Line2; //there are two lines in each user id
}FIPP_tCustomID;


const FIPP_MAX_FRYE_BITMAP_DATA = 2000;  //max words of frye data allowed
const FIPP_FRYE_BITMAP_HDR_SIZEW = 8;    //eight words in the header
typedef struct {
  WORD Style;   //{2=mono, 4=16color, 8=256color}
  WORD Xpos;    //{returns bytes per scan line if w or h sent as 0, else is the xpos of the image section}
  WORD Ypos;    //{returns 0 if w or h snet as 0, else is the Ypos of the image section}
  WORD Width;   //{returns total image width if w or h sent as 0, else is width of read image}
  WORD Height;  //{returns total image height if w or h sent as 0, else is height of read image}
  WORD Page;    //{0=printer graphic, 1=screen image}
  WORD Size;    //{size in words of the image read, 0=no data}
  WORD StartOfs; //{start location (in words) of the image in the fipp packet (header words + 2)=[10]}
  WORD Data[FIPP_MAX_FRYE_BITMAP_DATA];
}FIPP_tFryeBitmap;

typedef struct {
  DWORD BitMask;
  DWORD BytesPerLine;
}FIPP_tFryeBitmapInfo;


typedef struct {
       WORD F1;
       WORD F2;
       WORD F3;
       WORD D1;
       WORD D2;
       WORD D3;
}AvgFreqValuesRec;

//{Fitting parameters used to pass via RS232 set/get fitparameter}
typedef struct {
       INT16 FitRule;        //{FX_Cur.FitRule;}
       INT16 ClientAge;      //{FX_Cur.ClientAge}
       INT16 AidGroup;       //{FX_Cur.AidGroup;}
       INT16 AidType;        //{FX_Cur.AidType;}
       INT16 AidCompression; //{FX_Cur.AidCompression;}
       INT16 OutputDevice;   //{FX_Cur.AU_OutputDevice;}
       INT16 SpeakerLoc;     //{HD_SpeakerLoc;}
       INT16 AidChannels;    //{HD_AidChannels;}
       INT16 AidLimiting;    //{HD_AidLimiting;}
       INT16 AidFitType;     //{HD_FitType;}
       INT16 AidVentType;    //{HD_AidVent;}
       INT16 AidTubingType;  //{HD_AidTubing;}
       INT16 RefMethod;      //{HD_RefMethod;}
}FitRecordType;


typedef struct {
       WORD SampleRate;     //{1}
       WORD CaptureSize;    //{2}
       WORD SourceSamples;  //{3}
       WORD RampSamples;    //{4}
       WORD CouplerSkew;    //{5}
       WORD ProbeSkew;      //{6}
       WORD GainA;          //{7}
       WORD GainB;          //{8}
       WORD RmsOffsetLeft;  //{9}
       WORD RmsOffsetRight; //{10}
       WORD MaxLevelLeft;   //{11}
       WORD MaxLevelRight;  //{12}
       //{FP35 V2.12}
       WORD GainIndexA;     //{13}
       WORD GainIndexB;     //{14}
       WORD HwGainSelectA;  //{15}
       WORD HwGainSelectB;  //{16}
       //{FP35 V3.20}
       WORD InputLevelA;    //{17}
       WORD InputLevelB;    //{18}
       WORD HeadroomA;      //{19}
       WORD HeadroomB;      //{20}
}SignalInfoRec;

const AllowedAbortTime = 100; //{allow keyboard abort after five seconds}

#pragma pack(pop)  //restore default alignment method

#endif


