//---------------------------------------------------------------------------
//FippDefs definitions file for FippCore and FippUnit
//Copyright 2010 Frye Electronics, Inc.
//Written by Michael Day as of 20 Oct 2010
//You may use this code for any lawful purpose without fees or royalties.
//This code is intended as an example showing how to communicate with Fonix
//equipment using the Fryers32 or FryeCom device driver on the Windows operating system.
//No warranties are express or implied in the use of this code.
//This will compile under any later version of Borland Delphi (written using Delphi V3.00)
//---------------------------------------------------------------------------

unit FippDefs;
interface
uses Windows,FryeDefs,FComDefs;

const FIPP_SUCCESS = 0;
const FIPP_CANCEL = -1;

//const FIPP_ACK_OK = FCOM_ACK_OK;
//const FIPP_NO_ACK = FCOM_NO_ACK;

//FIPP Errors use the -2000 series
const FIPP_INVALID_FORMAT = -2000; //specified cmd format is not valid
const FIPP_IN_BOOTLOADER = -2010;  //instrument is in boot loader and cannot do the specified cmd
const FIPP_NOGO_ERROR = -2012;     //instrument reported that previous cmd failed to operate correctly

// Communication Port constants
const FIPP_DEFAULT_BAUDRATE = 9600;      //Fonix instruments default to 9600 baud

//various timeout values
const FIPP_STD_POLL_TIMEOUT = 5000; //5000         //std=5sec  //msecs
const FIPP_LONG_POLL_TIMEOUT = 15000;       //long=15sec
const FIPP_EXTRA_LONG_POLL_TIMEOUT = 30000; //exlong=30sec
const FIPP_SUPER_LONG_POLL_TIMEOUT = 60000; //superlong=1min
const FIPP_SHORT_POLL_TIMEOUT = 1000;       //short=1sec
const FIPP_DEFAULT_NO_POLL = FIPP_STD_POLL_TIMEOUT ;//default = std
const FIPP_NO_POLL_UNCHANGED = 0;           //if zero, don't change the no-poll timeout

//other defs
const FIPP_SOFT_RETRY = 3;  //number of times to retry command if failed
const FIPP_POWER_FLAGS_MASK = $E000;  //mask used to read power control flags
const FIPP_BATTERY_CUSTOM = 8;        //custom battery selection (rs232 supplied custom volts/ohms)

//remote timouts
const FIPP_REMOTE_RSP_TIMEOUT  = 2000; //2sec
const FIPP_REMOTE_POLL_TIME  = 50; //50ms

//OptionsState definitions
const FIPP_OPTIONS_UNKNOWN  = 0; //unknown state
const FIPP_OPTIONS_INVALID  = 1; //invalid data
const FIPP_OPTIONS_BOOT     = 2; //bootloader state
const FIPP_OPTIONS_VALID    = 3; //valid options data

//positive number means application level
//negative number means preapplication level (bootloader or test mode)
const FIPP_FONIX_SW_APP  = 0; //instrument software in application mode
const FIPP_FONIX_SW_BL  = -1; //instrument software in bootloader mode

const FIPP_MAIN_MENU_MAJOR_STATE  = 16;  //main menu state
const FIPP_LABEL_MINOR_STATE  = 100;  //printer Label screen location in main menu

const FIPP_ENTRY_MINOR_STATE  = 0;
const FIPP_COUPLER_MAJOR_STATE  = 1;  //coupler screen major state
const FIPP_COUPLER_MINOR_STATE  = 0;  //coupler screen minor state

const FIPP_CURRENT_LABEL_TEXT = 0;
const FIPP_FACTORY_LABEL_TEXT = 1;
const FIPP_STORED_LABEL_TEXT = 2;

const FIPP_CURRENT_ID_TEXT = -1;
const FIPP_DEFAULT_ID_TEXT = 0;
const FIPP_USER1_ID_TEXT = 1;
const FIPP_USER2_ID_TEXT = 2;
const FIPP_USER3_ID_TEXT = 3;
const FIPP_USER4_ID_TEXT = 4;
const FIPP_USER5_ID_TEXT = 5;
const FIPP_USER6_ID_TEXT = 6;
const FIPP_USER7_ID_TEXT = 7;


//supported user modes - (Normally only easy and advanced are available)
const FIPP_USER_NOVICE = 0;
const FIPP_USER_EASY = 1;
const FIPP_USER_ADVANCED = 2;
const FIPP_USER_EXPERT = 3;


//current known Machine Model Type Constants
const FONIX_UNKNOWN = -1;
const FONIX_6500 = 0;
const FONIX_6400 = 1;
const FONIX_7000 = 7000;
const FONIX_8000 = 8000;
const FONIX_8001 = 8001;
const FONIX_FP40 = 40;
const FONIX_FP35 = 35;
const FONIX_FA10 = 100;
const FONIX_FA12 = 102;
const FONIX_FA18 = 108;
//100-200 are audiometer machine types. 100, 102, and 108 are defined as FA10,FA12,FA18

//The following software versions know about the QuickRelease command
const FIPP_QTVersion6500 = 400;
const FIPP_QTVersionFP40 = 240;
const FIPP_QTVersionFA1x = 111;
const FIPP_QTVersionFP35 = 200;  //(all versions with FIPP)
const FIPP_QTVersion7000 = 100;  //(all versions with FIPP)
const FIPP_QTVersion8000 = 100;  //(all versions with FIPP)

//defined vents
const FIPP_FIT_VENT_OPEN =     0;  {Vent Open}
const FIPP_FIT_VENT_OCCLUDED = 1;  {Vent Occluded}
const FIPP_FIT_VENT_TIGHT =    2;  {Vent tight}
const FIPP_FIT_VENT_MM1 =      3;  {Vent 1mm}
const FIPP_FIT_VENT_MM2 =      4;  {Vent 2mm}
const FIPP_FIT_VENT_MM3 =      5;  {Vent 3mm}

//defined tubing
const FIPP_FIT_TUBING_NONE   = 0;  {Tubing None  [cic, itc, ite aids] }
const FIPP_FIT_TUBING_LIBBY4 = 1;  {Tubing Libby 4                    }
const FIPP_FIT_TUBING_LIBBY3 = 2;  {Tubing Libby 3                    }
const FIPP_FIT_TUBING_CFA2   = 3;  {Tubing CFA #2 horn                }
const FIPP_FIT_TUBING_CFA3   = 4;  {Tubing CFA #3 stepped bore        }
const FIPP_FIT_TUBING_No13   = 5;  {Tubing #13                        }
const FIPP_FIT_TUBING_sixC5  = 6;  {Tubing 6C5                        }
const FIPP_FIT_TUBING_sixC10 = 7;  {Tubing 6C10                       }

//defined aid type
const FIPP_AID_TYPE_NONE = 0;   {NONE - No aid type selected (treat same as ITC) }
const FIPP_AID_TYPE_BTE = 1;    {BTE - Behind the ear             }
const FIPP_AID_TYPE_ITE = 2;    {ITE - In the ear                 }
const FIPP_AID_TYPE_ITC = 3;    {ITC - In the ear canal           }
const FIPP_AID_TYPE_CIC = 4;    {CIC - Completely in the ear canal}
const FIPP_AID_TYPE_UEM = 5;    {UEM - BTE with user's earmold  - not used }

//defined filters
const FIPP_AUTO_FILTER = 0;     {auto-select the filter}
const FIPP_FLAT_FILTER = 1;     {flat unweighted source}
const FIPP_ANSI_FILTER = 2;     {ansi speech filter}
const FIPP_ICRA_FILTER = 3;     {irca speech filter}
const FIPP_CLTASS_FILTER = 4;   {UWO Child LTASS filter}
const FIPP_ALTASS_FILTER = 5;   {Cox&Moore Adult LTASS filter}
const FIPP_ANSI92_FILTER = 6;   {Ansi S3.42-1992 filter}
const FIPP_PINK_FILTER = 7;     {pink noise filter}
const FIPP_ILTASS_FILTER = 8;   {NAL-NL1 International ltass filter}

//Defined fit rules
const FIPP_NALRP_FITTING_RULE = 0;     // (0) NALRP (was NAL-2)
const FIPP_POGO_FITTING_RULE = 1;      // (1) POGO
const FIPP_BERGER_FITTING_RULE = 2;    // (2) Berger
const FIPP_THIRD_FITTING_RULE = 3;     // (3) 1/3 Gain
const FIPP_HALF_FITTING_RULE = 4;      // (4) 1/2 Gain
const FIPP_TWO_THIRD_FITTING_RULE = 5; // (5) 2/3 Gain
const FIPP_DSL_LIN_FITTING_RULE = 6;   // (6) DSL LINear fitting rule
const FIPP_DSL_WDRC_FITTING_RULE = 7;  // (7) DSL WDRC fitting rule
const FIPP_NALNL1_FITTING_RULE = 8;    // (8) NAL-NL1 fitting rule
const FIPP_MOD_NALNL1_FITTING_RULE = 9; //(9) Modified NAL-NL1 fitting rule
const FIPP_NALNL2_FITTING_RULE = 10;    //(10) NAL-NL2 fitting rule
//fit rules 11->14 are currently undefined
const FIPP_DIRECT_FITTING_RULE = 15;    // (15) Direct (manual entry)

//FP35 Leveling list defines
const FIPP_LEVELING_ADJ_LIST = 0;
const FIPP_LEVELING_FREQ_LIST = 1;
const FIPP_SPECTRUM_ADJ_LIST = 2;
const FIPP_LEVELING_EAR_ADJ_LIST = 100;
const FIPP_LEVELING_EAR_FREQ_LIST = 101;
const FIPP_LEVELING_DSL_EAR_ADJ_LIST = 102;
const FIPP_LEVELING_DSL_EAR_FREQ_LIST = 103;
const FIPP_LEVELING_EAR_DIFF_LIST = 104;


const FIPP_CURRENT_FREQ_LIST = 0;  //<not settable>
const FIPP_CURRENT_DIST_LIST = 1;  //<not settable>
const FIPP_USER_FREQ_LIST = 2;
const FIPP_USER_DIST_LIST = 3;
const FIPP_TONE_SWEEP_SETTLE_LIST = 4;
const FIPP_IO_SWEEP_SETTLE_LIST = 5;


//Data structure returned by cmd 28
//Note: some instruments not completely fill in the MachineVersion structure.
//unfilled/unknown items are left at zero.
//This unit will attempt to fill in InstrumentModel if it is unknown.
type FIPP_tMachineVersion = packed record  //returned by cmd 28
  SoftwareVersion:INT16;
  StdOptions:DWORD;
  CstOptions:DWORD;
  InstrumentBaseType:INT16;
  SubType:INT16;
  InstrumentModel:INT16;
end;

//Data structure returned by cmd 95
//Note: some instruments do not support cmd 95, others may not completely fill it in.
//unfilled/unknown items are left at zero.
type FIPP_tInstrumentInfo = packed record //this info is returned by cmd 95
  MachineType:INT16;       //[0] 35=FP35, 7000=7000, etc...
  SoftwareVersion:INT16;   //[1]
  Language:INT16;          //[2] 0=unknown, 1=english, 2=french, 3=german, 4=spanish
  BootLoaderVersion:INT16; //[3] was 1792 in FP35 < V2.12 (instead of 7)
  EEromVersion:INT16;      //[4] not available in FP35 < V2.12 (returns 0=unknown) (FP35 V2.12)
  SerialNumber : array[0..7] of char; //[5..8] Frye assigned serial number    (FP35 V2.20)
  MfgDate:FD_tPackedCalDate;          //[9..10] date of maufacture            (FP35 V2.20)
  HwCalDate:FD_tPackedCalDate;        //[11..12] date of Hardware calibration (FP35 V2.20)
  SwCalDate:FD_tPackedCalDate;        //[13..14] date of Software calibration (FP35 V2.20)
  CalStatus:INT16;                //[15] calibration status         (FP35 V3.20)
  SwBuildDate:FD_tPackedCalDate;  //[16..17] date of software build (FP35 V3.20)
  SwBuildNumber:INT16;            //[18] software build number      (FP35 V3.20)
  CpuTemperature:INT16;    //[19] current cpu temperature         (FP35 V3.50)
  HwCalTemperature:INT16;  //[20] tempurature during hardware cal (FP35 V3.50)
  SysCalTemperature:INT16; //[21] temperature during software cal (FP35 V3.50)
  CpuBoardRevNumber:INT16; //[22] cpu board revision              (FP35 V6.00)
  ModelNumber : array[0..7]of char;  //Frye assigned model number (future feature)
end;

type FIPP_tRTC_Time = packed record
  Millisecond:WORD;  //set to 0 if not supported
  Second:BYTE; //0-59
  Minute:BYTE; //0-59
  Hour:BYTE;   //0-24 or 1-12
  DayOfWeek:BYTE;  //spare (is day of week on some clocks - not all) is 0 if not available
  Day:BYTE;    //1-31
  Month:BYTE;  //1-12
  Year:WORD;   //1992-9999
end;

const FIPP_STD_CURVE_FRAME_SIZEW = 88; {StdCurveFrameSize = std curve frame size in words}
const FIPP_AUD_CURVE_FRAME_SIZEW = 24; {AudCurveFrameSize = aud curve frame size in words}

type FIPP_tBlobArray = array[0..1023] of word; {blob array definition}
type FIPP_ptBlobArray = ^FIPP_tBlobArray;      {pointer to the blob array}

const fipp_ARparamsSize = 4;    {four words in A/R parameter call}
type FIPP_tARparams = array[0..fipp_ARparamsSize] of word;

type FIPP_tLevelingList = array[0..256] of word;
type FIPP_tStatusMsg = array[0..256] of char;
type FIPP_tTestParametersArray = array[0..128] of word;

const fipp_MaxSpectrumPos = 80;   {size of spectrum table in words}
const fipp_MaxPhasePos = 80;      {size of phase table in words}
type FIPP_tSpectrumArray = array[0..128] of smallint;
type FIPP_tPhaseArray = array[0..128] of word;

const fipp_MaxAuxData = 2000;
type FIPP_tAuxDataArray = array[0..fipp_MaxAuxData] of char;

const fipp_MaxDeviceData = 255; {max device data array size}
type FIPP_tDeviceDataArray = array[0..fipp_MaxDeviceData] of word;

const fipp_MaxRawSampleData = 2000; {max array size}
type FIPP_tRawSampleData = array[0..fipp_MaxRawSampleData] of smallint;

const FIPP_MaxListData = 2000; {max array size}
type FIPP_tListData = array[0..FIPP_MaxListData] of smallint;

const fipp_MaxCalListData = 2000; {max array size}
type FIPP_tCalListData = array[0..fipp_MaxCalListData] of smallint;

const fipp_IOcurveSize = 10*2; {IOcurve size in bytes}
const MaxCurveSize = 256;      {size of largest curve frame (in words)}

type FIPP_tVersionArray = array[0..128] of word;


//Note: although the label arrays are declared here as array of char,
//they are actually 2D pchar arrays when used.
const FIPP_NUM_LABEL_LINE_CHAR = 28;  {there are 28 character positions in a label line}
const FIPP_REG_EXT_LINES = 8;         {there are eight lines in the regular extended label}
const FIPP_MAX_EXT_LINES = 10;        {there are ten lines in the full extended label}

{Note: the first five lines of an older standard label are 18 char in length}
{The remaining 3 lines are 28 char in length. All lines must have a trailing null.}
const FIPP_NUM_STD_LABEL_CHAR = 172; {size of std label array (in char) (18*5)+(28*3)}

{Extended arrays are like std arrays except they allow the user to}
{overwrite all the text in the label (including the field titles).}
{A normal label has 8 lines of text (28 char each) with a trailing Null as the last char.}
{A full extended label has ten lines the last two lines being the user custom ID text (see below).}
const FIPP_REG_EXT_LABEL_SIZEB = (FIPP_NUM_LABEL_LINE_CHAR*FIPP_REG_EXT_LINES); //224;  {size of regular extended label array (in char) (28*8)}
const FIPP_MAX_EXT_LABEL_SIZEB = (FIPP_NUM_LABEL_LINE_CHAR*FIPP_MAX_EXT_LINES); //size of full extended label in bytes (w/userID)

{each label line has 28 chars (including trailing null)}
type FIPP_tLabelLine = array[0..FIPP_NUM_LABEL_LINE_CHAR-1] of char;

//Standard label declaration as a flat array
type FIPP_tStdLabelArray = array[0..FIPP_NUM_STD_LABEL_CHAR] of char;

//Extended label declaration as a flat array
type FIPP_tExtLabelArray = array[0..FIPP_MAX_EXT_LABEL_SIZEB] of char;

//User ID array declarations
//Note: although the user ID arrays are declared here as array of char,
//they are actually 2D pchar arrays when used.
const FIPP_MAX_USERID_TEXT = 56;  {full size of User ID text array (in char)}
type FIPP_tUserIDText = array[0..FIPP_MAX_USERID_TEXT] of char;
const FIPP_MAX_USER_ID = 16;     //no more than 16 user ids allowed
type FIPP_tUserID = array[0..FIPP_MAX_USER_ID-1] of FIPP_tUserIDText; //there are a maximum of 16 users possible
//Note: first "user" in UserID array is always the default UserID
//User#1 starts at index[1] (there is no User#0)

//Map FIPP_tCustomID on top FIPP_tUserIDText to treate it as a two pchar text lines.
type FIPP_tCustomID = packed record
  Line1 : FIPP_tLabelLine; //there are two lines in each user id
  Line2 : FIPP_tLabelLine; //there are two lines in each user id
end;


const FIPP_MAX_FRYE_BITMAP_DATA = 2000;  //max words of frye data allowed
const FIPP_FRYE_BITMAP_HDR_SIZEW = 8;    //eight words in the header
type FIPP_tFryeBitmap = packed record
  Style:WORD;   {D[0]Pk[2]: 2=mono, 4=16color, 8=256color}
  Xpos:WORD;    {D[1]Pk[3]: returns bytes per scan line if w or h sent as 0, else is the xpos of the image section}
  Ypos:WORD;    {D[2]Pk[4]: returns 0 if w or h snet as 0, else is the Ypos of the image section}
  Width:WORD;   {D[3]Pk[5]: returns total image width if w or h sent as 0, else is width of read image}
  Height:WORD;  {D[4]Pk[6]: returns total image height if w or h sent as 0, else is height of read image}
  Page:WORD;    {D[5]Pk[7]: 0=printer graphic, 1=screen image}
  Size:WORD;    {D[6]Pk[8]: size in words of the image read, 0=no data}
  StartOfs:WORD; {D[7]Pk[9]: start location (in words) of the image in the fipp packet (header words + 2)=[10]}
  Data : array[0..FIPP_MAX_FRYE_BITMAP_DATA-1] of WORD; //D[8]Pk[10]
end;

type FIPP_tFryeBitmapInfo = packed record
  BitMask : DWORD;
  BytesPerLine : DWORD;
end;


type AvgFreqValuesRec = packed record
       F1 : word;
       F2 : word;
       F3 : word;
       D1 : word;
       D2 : word;
       D3 : word;
     end;

{Fitting parameters used to pass via RS232 set/get fitparameter}
type FitRecordType = packed record
       FitRule        : smallint;   {FX_Cur.FitRule;}
       ClientAge      : smallint;   {FX_Cur.ClientAge}
       AidGroup       : smallint;   {FX_Cur.AidGroup;}
       AidType        : smallint;   {FX_Cur.AidType;}
       AidCompression : smallint;   {FX_Cur.AidCompression;}
       OutputDevice   : smallint;   {FX_Cur.AU_OutputDevice;}
       SpeakerLoc     : smallint;   {HD_SpeakerLoc;}
       AidChannels    : smallint;   {HD_AidChannels;}
       AidLimiting    : smallint;   {HD_AidLimiting;}
       AidFitType     : smallint;   {HD_FitType;}
       AidVentType    : smallint;   {HD_AidVent;}
       AidTubingType  : smallint;   {HD_AidTubing;}
       RefMethod      : smallint;   {HD_RefMethod;}
     end;


type SignalInfoRec = packed record
       SampleRate    : word; {1}
       CaptureSize   : word; {2}
       SourceSamples : word; {3}
       RampSamples   : word; {4}
       CouplerSkew   : word; {5}
       ProbeSkew     : word; {6}
       GainA         : word; {7}
       GainB         : word; {8}
       RmsOffsetLeft  : word;{9}
       RmsOffsetRight : word;{10}
       MaxLevelLeft  : word; {11}
       MaxLevelRight : word; {12}
       {V2.12}
       GainIndexA     :word; {13}
       GainIndexB     :word; {14}
       HwGainSelectA  :word; {15}
       HwGainSelectB  :word; {16}
       {V3.20}
       InputLevelA    :word; {17}
       InputLevelB    :word; {18}
       HeadroomA      :word; {19}
       HeadroomB      :word; {20}
     end;

const AllowedAbortTime = 100; {allow keyboard abort after five seconds}

implementation

//no startup code
end.
