
//{Frye Instrument Packet Protocol (FIPP) interface test unit}
//{This unit is used to communicate with Frye intstruments}
//{that use the FIPP packet protocol}
//{Copyright 1994,2010 Frye Electronics}
//{Version 5.22  Written by Michael Day  20 Sep 2010}
//{This units was written in Borland Delphi V3.00.}
//{It should compile with later versions with little or no changes.}
//{4-30-04 (med) fixed cmd 9 : was using stale crv size data}
//{23Aug04 (med) added rs232 code for skew and screenmode cmds}
//{12 Dec 04 -med - added cmds 172 and 173}
//{12 Jun 06 -med - added cmds 175->181, modified cmds 14,19 and 79}
//{5 Feb 2008 - med - added ability to access up to 99 port with new fryers driver V5.20}
//{20 Sep 2010 - med - converted from msdos format to Windows - added new cmds since last update}

//unit FippUnit;
//uses {Windows, Graphics,} BitRev, FryeDefs, FippDefs, FCErrMsg, FippCore, FcomDefs, FryeComD, FryeTools;

#include "FryeDefs.h"
#include "BitRev.h"
#include "FComDefs.h"
#include "FippCore.h"

#include "FippUnit.h"

//{===================================================================}
//This sets the Fipp callback to the target location.
//If the callback is set to NIL, it is not used.
//If it contains an address, the FCOM dll will call it
//when waiting long periods (see S}Ready and OpenPort).
//The purpose of the callback is to allow the user to update status
//and to be able to cancel the operation if there is a problem.
//See the FryeCom DLL documentation for details.
//By default, callback is set to NIL when the object is created.
//Be very careful about the use of the callback.
//FryeCom is not re-entrant for commands calls (status calls are ok).
//Also, if the address stored is stale (no longer valid),
//unexpected things can happen.
//If your callback address is no longer valid, you must set the Fipp
//callback to NIL so that it won't be called.
void __fastcall TclsFipp::SetCallback(FCOM_TfcCallback MyCallback)
{
  Callback = MyCallback;
};


//{===================================================================}
// Implmentation for the Ext}ed FippUnit class constructor
// Note: when you create the fipp object, this constructure is called
// after the FippCore constructor is called.
__fastcall TclsFipp::TclsFipp() {

  //inherited Create;
  //    InitializeCriticalSection(Csv);
  //MemImage := TBitmap.Create;
  IoModeCount = 2;  //{number of words used in IO mode command}
  CurveSelectValid = false;
  FonixVersionSize = 0;
  InstrumentInfoSize = 0;
  UserNumber = 0;
  //PollTimer := FIPP_STD_POLL_TIMEOUT;
  FD_ByteFill(FonixVersionArray,0,sizeof(FonixVersionArray));
  FD_ByteFill(&InstrumentInfo,0,sizeof(InstrumentInfo));

//  try
//    {
//    };
//  except
//  };

};

/*
{===================================================================}
destructor TclsFipp.Destroy;
{
//  DeleteCriticalSection(Csv);
  //MemImage.free;
  inherited Destroy;
};
*/

/*
procedure __fastcall TclsFippCore::BuildMemoryImageMap(MemImgW:integer; MemImgH:integer);
{
  if (MemImage.Width <> MemImgW) or (MemImage.Height <> MemImgH) then
  {
    MemImage.Width := MemImgW;
    MemImage.Height := MemImgH;
    MemImage.Canvas.Brush.Style := bsSolid;
    MemImage.Canvas.Pen.Style := psSolid;
    MemImage.Canvas.Pen.Mode := pmCopy;
    MemImage.Canvas.Brush.Color := clWhite;
    MemImage.Canvas.Pen.Color := clWhite;
    MemImage.Canvas.Rectangle(0,0,MemImage.Width,MemImage.Height);
    MemImage.Canvas.Brush.Color := clBlack;
    MemImage.Canvas.Pen.Color := clBlack;
//    if FrameCheckBox.Checked then
//    {
//      MemImage.Canvas.Moveto(0,0);
//      MemImage.Canvas.Lineto(MemImage.Width-1,0);
//      MemImage.Canvas.Lineto(MemImage.Width-1,MemImage.Height-1);
//      MemImage.Canvas.Lineto(0,MemImage.Height-1);
//      MemImage.Canvas.Lineto(0,0);
//    };
  };
};
*/


//{===================================================================}
// The following are the low level support routines.
// These routines are used to talk directly to the Fryecom dll
// to configure it for special case operations.

//{-------}
//{Get the current low-level tick counter resolution (rate of increment).}
//{Used by SetRespTimeout().}
int __fastcall TclsFipp::GetPacketTickRes(void)
{
  F_RegsType IRegs;

  IRegs.AX = 0x0ff17;   //Read the current tick multiplier value
  IRegs.CX = 0x0400;
  IRegs.DX = ThisComPort;
  FCOM_CallFryers(&IRegs);
  if ((IRegs.AX < 1) || (IRegs.AX > 255)) {
    IRegs.AX = 55; //on error, force to 55ms (default)
  }
  return(IRegs.AX);
};

//{-------}
//This gets the current value in the general purpose packet timer in milliseconds.
//Note: The actual internal default tick resolution is nominally 55ms
//However, it can be different. This function converts the time to milliseconds.
WORD __fastcall TclsFipp::GetPacketTimer(void)
{
  F_RegsType IRegs;

  IRegs.AX = 0xff17;  //{select packet timer}
  IRegs.CX = 0x0300;
  IRegs.DX = ThisComPort;
  FCOM_CallFryers(&IRegs);
  return((WORD)IRegs.BX); //return time in milliseconds
};

//{-------}
//This clears the general purpose packet timer counter to zero.
void __fastcall TclsFipp::ClearPacketTimer(void)
{
  F_RegsType IRegs;

  IRegs.AX = 0xff17;  //{select packet timer}
  IRegs.BX = 0;
  IRegs.CX = 0x03FF;
  IRegs.DX = ThisComPort;
  FCOM_CallFryers(&IRegs);
};

//{-------}
//{this sets a new value in the response timer}
//{Note: this is required to support the special case 6500 cmd (85)}
//{that breaks the protocol rules.}
void __fastcall TclsFipp::SetRespTimeout(INT16 Value)
{
  F_RegsType IRegs;
  int TickRes;

  if (Value < 1) {
    Value = 1000;  //if bad, set to one second timeout
  }
  TickRes = GetPacketTickRes();
  if (TickRes < 1) TickRes = 1;
  IRegs.AX = 0xff17;     //{set response timer}
  IRegs.BX = Value / TickRes; //RespTimer;
  IRegs.CX = 0x01ff;
  IRegs.DX = ThisComPort;
  FCOM_CallFryers(&IRegs);
};

//{-------}
//{this returns the response timer's current value}
INT16 __fastcall TclsFipp::GetRespTimeout(void)
{
  F_RegsType IRegs;

  IRegs.AX = 0xff17;    // {read response timer}
  IRegs.CX = 0x0100;
  IRegs.DX = ThisComPort;
  FCOM_CallFryers(&IRegs);
  return((INT16)IRegs.BX);
};

//{-------}
//{This can convert std or ext label arrays.}
//{This converts the label asciiZ (pchar) 2D string array from intel to motorola format}
//{and pokes it into the command array.}
//{Note: This does not set the cmd number. The caller must set the size and cmd number (6 or 66).}
//{Size is the number of chars to be converted, LabelData is the place where the label is located.}
void __fastcall TclsFipp::ConvertLabelToSend(int Size, pchar LabelData)
{
  int i;

  //{make sure Size is valid}
  if ((Size < 0) || (Size > FIPP_REG_EXT_LABEL_SIZEB)) {
    Size = FIPP_REG_EXT_LABEL_SIZEB;
  }
  i = 0;
  LabelData[(Size-1)] = 0; //{force last byte to null}
  while (i < Size) {
    CmdArray.Data[(i >> 1)] = (INT16)((WORD(LabelData[i]) << 8)+
                                      (BYTE)(LabelData[i++]));
    i = i+2;
  }//endwhile
};

//{-------}
//{This converts the UserID asciiZ (pchar) 2D string array from intel to motorola format}
//{and pokes it into the command array.}
//{Note: This does not set the cmd number. The caller must set the size and cmd number (6 or 66).}
//{Size is the number of chars to be converted, TextData is the place where the text is located.}
//{If ExtID = true, Text is assumed to go at the } of an ext}ed label cmd (66).
//{If ExtID = false, text is assumed to be for a normal UserID cmd (166).}
void __fastcall TclsFipp::ConvertUserIDToSend(bool ExtID, int Size, pchar IDText)
{
  int SrcIndex;
  int CmdIndex;

  //{If extended label format, then put the user ID at the } of the custom label}
  //{otherwise it goes at the start of the CmdArray.}
  if (ExtID == true) {
    CmdIndex = FIPP_REG_EXT_LABEL_SIZEB;
  }else{
    CmdIndex = 0;
  }
  //{make sure Size is valid}
  if ((Size < 0) || (Size > FIPP_MAX_USERID_TEXT)) {
    Size = FIPP_MAX_USERID_TEXT;
  }
  SrcIndex = 0;
  IDText[(Size-1)] = 0; //{force last byte to null}
  while (SrcIndex < Size)
  {
    CmdArray.Data[(CmdIndex >> 1)] = (INT16)( ((WORD)(IDText[SrcIndex]) << 8)+
                                               (BYTE)(IDText[SrcIndex+1]) );
    CmdIndex = CmdIndex + 2;
    SrcIndex = SrcIndex + 2;
  }//endwhile
};

//{-------}
//{This converts the received label in Motorola format to Intel asciiZ (pchar) 2D string array}
//{Size is total number of chars to be converted, LabelData is where to place the data}
void __fastcall TclsFipp::ConvertLabelFromRcv(int Size, pchar LabelData)
{
  int i;
  //{make sure Size is valid}
  if ((Size < 0) || (Size > FIPP_REG_EXT_LABEL_SIZEB)) {
    Size = FIPP_REG_EXT_LABEL_SIZEB;
  }
  i = 0;
  while (i < Size)
  {
    LabelData[i] = (char)(RspArray.Data[(i >> 1)] >> 8);
    LabelData[(i+1)] = (char)(RspArray.Data[(i >> 1)] & 0x00ff);
    i = i+2;
  };
  LabelData[(Size-1)] = 0; //{force last byte to null}
};

//{This converts the received UserID in Motorola format to Intel asciiZ (pchar) 2D string array}
//{Size is total number of chars to be converted, IDTest is where to place the data}
//{If ExtID = true Text is assumed to be at the } of an ext}ed label cmd (86).}
//{If ExtID = false, text is assumed to be for a normal UserID cmd (167).}
void __fastcall TclsFipp::GetUserIDFromRcv(bool ExtID, int Size, pchar IDText)
{
  int DestIndex;
  int RspIndex;

  if ((Size < 0)||(Size > FIPP_MAX_USERID_TEXT)) {
    Size = FIPP_MAX_USERID_TEXT;
  }
  if (ExtID == true) {
    RspIndex = FIPP_REG_EXT_LABEL_SIZEB;   //{if via ExtLabel start at first char past ext label portion}
  }else{
    RspIndex = 0;                      //{if via std User ID cmd 167, start at loc 0}
  }
  DestIndex = 0;
  while (DestIndex < Size)
  {
    IDText[DestIndex] = char(RspArray.Data[(RspIndex >> 1)] >> 8);
    IDText[DestIndex+1] = char(RspArray.Data[(RspIndex >> 1)] & 0xff);
    RspIndex = RspIndex + 2;
    DestIndex = DestIndex + 2;
  } //endwhile
  IDText[Size-1] = 0; //{force last byte to null}
};

//{===================================================================}
// The following are the mid level support routines.
// These routines are used to send/receive commands to the Fryecom dll
// via the underlaying FippCore object (inherited by the Fipp Object).

bool __fastcall TclsFipp::DoFippCmd(int NoAck, int NoPollTimeout)
{
  bool Result;
  FippError = DoCmd(NoAck, NoPollTimeout, &CmdArray, &RspArray, Callback);
  if (FippError == SUCCESS)
    Result = true;
  else Result = false;
  UpdatePortStatus();  //always update port status when done
  return(Result);
};

//{-------}
//{Similar to DoPacket, except does not do verify check.}
//{This s}s a command to the Fonix Instrument and waits for a response}
//{if an abort situation occurs it returns as false, and the}
//{error condition is provided in FippError}
bool __fastcall TclsFipp::SendCmd(void)
{
  bool Result = DoFippCmd(FCOM_ACK_OK, FIPP_LONG_POLL_TIMEOUT);
  return(Result);
};

//{-------}
//{Go ask for the status of the last command. Returns true if good,}
//{returns false if bad.}
bool __fastcall TclsFipp::CommandStatusOK(void)
//var SA1,SA2:word;
{
   bool Result = false;
   CmdStatusFailed = true;

   //Special direct call to check command status with messing up the original cmd/rsp arrays
   CsCmdArray.Cmd = fipp_GetCmdStatusCmd;
   CsCmdArray.Size = 0;
   FippError = DoCmd(FCOM_ACK_OK, FIPP_DEFAULT_NO_POLL,&CsCmdArray,&CsRspArray,NULL);
   if (FippError != SUCCESS) return(Result);
   if (CsRspArray.Data[0] != 0)
   {
     FippError = FIPP_NOGO_ERROR;
     return(Result);
   };

   Result = true;
   CmdStatusFailed = false;
   return(Result);
};

//{-------}
//{SetPacket sets various modes and values inside the target machine}
//{It returns a true if everything went OK, or false if not and the}
//{error information is returned in FippError.}
//{SetPacket assumes that the command is already in S}Array.}
//{SetPacket only recieves ACK responses, no data.}
//{The assumption is that the NoPollTimeout is unchanged (standard timeout)}
bool __fastcall TclsFipp::SetPacket(void)
{
  bool Result = DoFippCmd(FCOM_ACK_OK, FIPP_DEFAULT_NO_POLL);
  if (Result == false) return(false);
  if (Verify == false) return(false);
  ReleaseCmd();
  Result = CommandStatusOK();
  return(Result);
};


//{-------}
//{The DoPacket works exactly the same as SetPacket, but it is kept}
//{seperate so as to allow possible future modification since the}
//{function in the 6500 works differently than a SetPacket call}
//{it is up to the calling procedure to collect any data it wants}
//{after performing a DoPacket.}
//{DoPacket assumes that the command is already in S}Array.}
//{Returns a true if everything went OK, or false if not and the}
//{error information is returned in FippError.}
//{Note: the 6500 indicates that it is done "doing" by responding to}
//{the next command sent. Thus the simplest way to determine if it}
//{is ready is to ask for cmd status.}
bool __fastcall TclsFipp::DoPacket(void)
{
  bool Result = DoFippCmd(FCOM_ACK_OK, FIPP_DEFAULT_NO_POLL);
  if (Result == false) return(false);
  if (Verify == false) return(false);
  ReleaseCmd();
  Result = CommandStatusOK();
  return(Result);
};

//{-------}
//{GetPacket is used to pickup data from the target machine.}
//{GetPacket assumes that the command is already in S}Array.}
//{Returns a true if everything went OK, or false if not and the}
//{error information is returned in FippError.}
//{It is up to the calling procedure to pull the resulting response}
//{data out of RcvArray.}
//{This command expects a data response. }
//{It will cause an error if an ack is received}
bool __fastcall TclsFipp::GetPacket(void)
{
  bool Result = DoFippCmd(FCOM_NO_ACK, FIPP_DEFAULT_NO_POLL);
  return(Result);
};

//{-------}
//{SetValue is used for most of the set functions since they mostly pass}
//{a single integer value. Makes it much simpler.}
bool __fastcall TclsFipp::SetValue(WORD SetCmd, WORD GetCmd, INT16* ValueToSet)
{
  bool Result = false;
  CmdArray.Cmd = SetCmd;
  CmdArray.Size = 1;
  CmdArray.Data[0] = (WORD)(ValueToSet);
  if (SetPacket()==false) return(Result);
  if (DoubleCheck == true)
  {
    CmdArray.Cmd = GetCmd;
    CmdArray.Size = 0;
    if (GetPacket()==false) return(false);
    *ValueToSet = (INT16)(RspArray.Data[0]);
  };
  Result = true;
  return(Result);
};



//{-------}
//{GetValue is used for most of the get functions since they all pass}
//{a single integer value. Makes it much simpler.}
bool __fastcall TclsFipp::GetValue(WORD GetCmd, INT16* ValueToGet)
{
    bool Result = false;
    CmdArray.Cmd = GetCmd;
    CmdArray.Size = 0;
    if (GetPacket()==false) return(Result);
    *ValueToGet = (INT16)(RspArray.Data[0]);
    Result = true;
    return(Result);
};


//{-------}
//{This is just a wrapper around the quick terminate command so}
//{that it functions with the same format as the other commands here.}
bool __fastcall TclsFipp::ReleaseCmd(void)   //{7fff}
{
  bool Result = false;
  FippError = QuickTerminate(NULL);
  if (FippError != SUCCESS) return(Result);
  Result = true;
  return(Result);
};


//{===================================================================}
// The following are the high level support routines.
//They are divided into Set, Get and Do commands.
//The commands are listed in numeric cmd order.
//{===================================================================}

//{The following routines handle the standard FIPP Set commands}
//{the command reads and s}s the appropriate variable(s) in the Fipp object}
//{to the instrument. It is up to the calling routine to insure that the }
//{desired variable(s) are properly updated before calling the set command.}
//{If verify is on, the target is asked if it is ok after the Set cmd is done.}
//{If DoubleCheck is on, the set value is read back from the target and}
//{the proper variable is updated with the real value. It is up to the}
//{caller to determine if there is any discrepancy.}

//{Set cmds - return true if everything went ok. }
//{false if not (error in FippError)}


//{-------}
//{Assumes that the caller has set SourceAmp to the desired value.}

bool __fastcall TclsFipp::SetSourceAmp(void) //{0}
{
  return(SetValue(fipp_SetSourceAmpCmd,fipp_GetSourceAmpCmd,&SourceAmp));
};

//{-------}
//{Assumes that the caller has set DistMode to the desired value.}

bool __fastcall TclsFipp::SetDistMode(void)  //{1}
{
  return(SetValue(fipp_SetDistModeCmd,fipp_GetDistModeCmd,&DistMode));
};

//{-------}
//{Assumes that the caller has set Frequency to the desired value.}

bool __fastcall TclsFipp::SetFrequency(void) //{2}
{
  return(SetValue(fipp_SetFrequencyCmd,fipp_GetFrequencyCmd,&Frequency));
};

//{-------}
//{Assumes that the caller has set OESstate to the desired value.}

bool __fastcall TclsFipp::SetOESstate(void)   //{3}   {obsolete}
{
  return(SetValue(fipp_SetOESstateCmd,fipp_GetOESstateCmd,&OESstate));
};

//{-------}
//{Assumes that the caller has set NoiseRedCount to the desired value.}

bool __fastcall TclsFipp::SetNoiseRedCount(void)  //{4}
{
  return(SetValue(fipp_SetNoiseRedCountCmd,fipp_GetNoiseRedCountCmd,&NoiseRedCount));
};

//{-------}
//{Assumes that the caller has set SmoothState to the desired value.}

bool __fastcall TclsFipp::SetSmoothState(void)   //{5}
{
  return(SetValue(fipp_SetSmoothStateCmd,fipp_GetSmoothStateCmd,&SmoothState));
};

//{-------}
//{Assumes that the caller has set cmdarray to the desired values.}
//{Assumes that the caller has built the proper motorola formated data in CmdArray.}
//{LabelLines length is ignored (only used by 66/86 commands.}
//{Label lines are 5x18 and 3x28 char long with a null in the last character.}
//{Note: does not do double check. Note: Label is a 2D ASCIIZ string array.}
//{Label should be padded with spaces.}
bool __fastcall TclsFipp::SetStdLabel(void)   //{6}
{
  CmdArray.Cmd = fipp_SetStdLabelCmd;
  CmdArray.Size = FIPP_NUM_STD_LABEL_CHAR / 2;  //{always sends the full std label}
  return(SetPacket());
};

//{-------}
//{Assumes that the caller has set ProbeState to the desired value.}

bool __fastcall TclsFipp::SetProbeState(void)   //{7}   {obsolete}
{
  return(SetValue(fipp_SetProbeStateCmd,fipp_GetProbeStateCmd,&ProbeState));
};

//{-------}
//{Assumes that the caller has set WeightState to the desired value.}

bool __fastcall TclsFipp::SetWeightState(void) //{8}   {obsolete}
{
  return(SetValue(fipp_SetWeightStateCmd,fipp_GetWeightStateCmd,&WeightState));
};

//{-------}
//{Assumes that the caller has set the CurveFrame to the desired value.}
//{Note: does not do double check}

bool __fastcall TclsFipp::SetCurveFrame(void)  //{9}
{
  WORD CurveFormat;
  WORD ByteSize;
  bool Result;

  CurveFormat = (WORD)((CurveFrame.Flags >> 10) & 7);
  if ((CurveFormat == 2) || (CurveFormat == 3)) {
    CurveFrameSize = FIPP_AUD_CURVE_FRAME_SIZEW; //AudCurveFrameSize
  }else{
    CurveFrameSize = FIPP_STD_CURVE_FRAME_SIZEW; //StdCurveFrameSize;
  }
  //ByteSize := CurveFrameSize*2; {crv#,crvframe}
  CmdArray.Cmd = fipp_SetCurveFrameCmd;
  CmdArray.Size = (INT16)(CurveFrameSize+1);
  CmdArray.Data[0] = (WORD)(CurveNumber);
  ByteSize = (WORD)((CurveFrameSize + 1) * 2);
  FD_ByteCopy(&CmdArray.Data[1],&CurveFrame,ByteSize);
  Result = SetPacket();
  return(Result);
};

//{-------}
//{Assumes that the caller has set the IOmode to the desired value.}

bool __fastcall TclsFipp::SetIOmode(void)       //{10}
{
    bool Result;

    if (IoModeCount <= 2) {
      IoModeCount = 2;
    }else{
      IoModeCount = 4;
    }
    CmdArray.Cmd = fipp_SetIOmodeCmd;
    CmdArray.Size = IoModeCount;
    CmdArray.Data[0] = (WORD)(IOFrequency);
    CmdArray.Data[1] = (WORD)(IOGain);
    if (IoModeCount > 2)
    {
      CmdArray.Data[2] = (WORD)(IOStartMs);
      CmdArray.Data[3] = (WORD)(IOSweepMs);
    };
    if (SetPacket()==false) return(false);
    if (DoubleCheck == true)
    {
      CmdArray.Cmd = fipp_GetIOmodeCmd;
      CmdArray.Size = 0;
      if (GetPacket()==false) return(false);
      IOFrequency = (INT16)(RspArray.Data[0]);
      IOGain = (INT16)(RspArray.Data[1]);
    };
    Result = true;
    return(Result);
};

//{-------}
//{Assumes that the caller has set the SourceMethod (was TelCoilState) to the desired value.}

bool __fastcall TclsFipp::SetSourceMethod(void)  //{11}
{
   return(SetValue(fipp_SetSourceMethodCmd,fipp_GetSourceMethodCmd,&SourceMethod));
};

//{-------}
//{Assumes that the caller has set the AnalysisMode (GainState) to the desired value.}

bool __fastcall TclsFipp::SetAnalysisMode(void)    //{12}  {was GainState}
{
   return((fipp_SetAnalysisModeCmd,fipp_GetAnalysisModeCmd,&AnalysisMode));
};

//{-------}
//{note: this command assumes that the instrument type was previously obtained in Version[]}
//{note: on early FP35's this cmd is not available}
bool __fastcall TclsFipp::SetBatteryTest(void)  // {14}
{
  CmdArray.Cmd = fipp_SetBatteryTestCmd;
  if (DoPacket()==false) return(false);
  return(true);
};
//    if ((FD_Signature.InstrumentBaseType = 0) or (FD_Signature.InstrumentBaseType = 1) or
//       (FD_Signature.InstrumentBaseType = 40)) then
//    {
//      CmdArray.Size := 0;
//      BatteryTestEnable := -1;  {mark that test enable/disable is not available (6400/6500)}
//    }
    //else if (FD_Signature.InstrumentBaseType = 7000) then
//    {
//      CmdArray.Size := 1;
//      CmdArray.Data[0] := BatteryTestEnable;
//    }
//    else
//    {
//      CmdArray.Size := 0;
//    };
//    if not(SetPacket()) then Exit;

//{-------}
//{Assumes that the caller has set the TelCoilMode to the desired value.}

bool __fastcall TclsFipp::SetTelCoilMode(void)     //{39}
{
  return(SetValue(fipp_SetTelCoilModeCmd,fipp_GetTelCoilModeCmd,&TelCoilMode));
};

//{-------}
//{Assumes that the caller has set the RelAttFreq to the desired value.}

bool __fastcall TclsFipp::SetRelAttFreq(void)    //{40}
{
   return(SetValue(fipp_SetRelAttFreqCmd,fipp_GetRelAttFreqCmd,&RelAttFreq));
};

//{-------}
bool __fastcall TclsFipp::SetZetaState(void)    //{43}   {obsolete}
{
   return(SetValue(fipp_SetZetaStateCmd,fipp_GetZetaStateCmd,&ZetaState));
};


//{-------}
//{Assumes that the caller has set the Insitu data to the desired value.}

bool __fastcall TclsFipp::SetInsitu(void)    //{47}   {obsolete}
{
    CmdArray.Cmd = fipp_SetInsituCmd;
    CmdArray.Size = 3;
    CmdArray.Data[0] = (WORD)(Insitu[0]);
    CmdArray.Data[1] = (WORD)(Insitu[1]);
    CmdArray.Data[2] = (WORD)(Insitu[2]);
    if (SetPacket()==false) return(false);
    if (DoubleCheck == true)
    {
      CmdArray.Cmd = fipp_GetInsituCmd;
      CmdArray.Size = 0;
      if (GetPacket()==false) return(false);
      Insitu[0] = (WORD)(RspArray.Data[0]);
      Insitu[1] = (WORD)(RspArray.Data[1]);
      Insitu[2] = (WORD)(RspArray.Data[2]);
    };
    return(true);
};


//{-------}
bool __fastcall TclsFipp::SetAutoState(void)    //{48}
{
//   SetAutoState :=
//     SetValue(fipp_SetAutoStateCmd,fipp_GetAutoStateCmd,AutoState);
  bool Result;

  CmdArray.Cmd = fipp_SetAutoStateCmd;
  CmdArray.Size = AutoStateSize;
  CmdArray.Data[0] = AutoState;
  CmdArray.Data[1] = AutoStepDuration;
  Result = SetPacket();
  return(Result);
};


//{-------}
bool __fastcall TclsFipp::SetLimitValue(void)    //{50}
{
   return(SetValue(fipp_SetLimitValueCmd,fipp_GetLimitValueCmd,&LimitValue));
};


//{-------}
bool __fastcall TclsFipp::SetRefMicState(void)   // {52}
{
   return(SetValue(fipp_SetRefMicStateCmd,fipp_GetRefMicStateCmd,&RefMicState));
};


//{-------}
bool __fastcall TclsFipp::SetActiveStatus(void)    //{54}
{
  int OldTimer;
  bool Result;

  GetNoPoll(&OldTimer);      //{get real poll timeout value}
  PollTimer = OldTimer;      //{update current timer value}
  if (PollTimer < FIPP_SUPER_LONG_POLL_TIMEOUT)     //{If less than 60 sec}
  {
    PollTimer = FIPP_SUPER_LONG_POLL_TIMEOUT;        //{force it to 60 sec abort}
    SetNoPoll(PollTimer);
  };
  Result = SetValue(fipp_SetActiveStatusCmd,fipp_GetActiveStatusCmd,&ActiveStatus);
  PollTimer = OldTimer;
  SetNoPoll(PollTimer);      //{restore original poll timeout value}
  return(Result);
};


//{-- new v2.6x -----}
bool __fastcall TclsFipp::SetMachineState(void)   //{59}
{
    int OldTimer;
    bool Result;

    GetNoPoll(&OldTimer);      //{get real poll timeout value}
    PollTimer = OldTimer;     // {update current timer value}
    if (PollTimer < FIPP_SUPER_LONG_POLL_TIMEOUT) // {If less than 60 seconds}
    {
      PollTimer = FIPP_SUPER_LONG_POLL_TIMEOUT;       // {force it to 60 seconds abort}
      SetNoPoll(PollTimer);
    };
    CmdArray.Cmd = fipp_SetMachineStateCmd;
    CmdArray.Size = 2;
    CmdArray.Data[0] = (WORD)(MajorMachineState);
    CmdArray.Data[1] = (WORD)(MinorMachineState);
    Result = SetPacket();
    PollTimer = OldTimer;
    SetNoPoll(PollTimer);    //  {restore original poll timeout value}
    return(Result);
};

//{-- new v2.6x -----}
bool __fastcall TclsFipp::SetControlLock(void)     //{62}
{
   return(SetValue(fipp_SetControlLockCmd,fipp_GetControlLockCmd,&ControlLock));
};

//{-- new v2.6x -----}
//{Assumes that the caller has set cmdarray to the desired values.}
//{Assumes that the caller has built the proper motorola formated data in CmdArray.}
//{LabelLines must be set to the number of lines to be sent.}
//{All label lines are 28 char long with a null in the last character.}
//{This includes the User ID portion.}
//{Warning: if full ext}ed label format is not supported, LabelLines must be set to 8.}
//{Note: does not do double check.
//{Label should be padded with spaces and must be terminated with a trailing null.}
bool __fastcall TclsFipp::SetExtendedLabel(void)  //{66}
{
  bool Result;
  CmdArray.Cmd = fipp_SetExtendedLabelCmd;
  CmdArray.Size = (INT16)(LabelLines * FIPP_NUM_LABEL_LINE_CHAR);
  Result = SetPacket();
  return(Result);
};


//{-- new v2.6x -----}
bool __fastcall TclsFipp::SetSpectrum(void)     //  {68}
{
    bool Result;
    CmdArray.Cmd = fipp_SetSpectrumCmd;
    CmdArray.Size = fipp_MaxSpectrumPos;
    FD_ByteCopy(CmdArray.Data,Spectrum,fipp_MaxSpectrumPos*sizeof(WORD));
    Result  = SetPacket();
    return(Result);
};

//{-- new v2.6x -----}
bool __fastcall TclsFipp::SetPhaseTable(void)     //{69}
{
    bool Result;

    CmdArray.Cmd = fipp_SetPhaseTableCmd;
    CmdArray.Size = fipp_MaxPhasePos;
    FD_ByteCopy(CmdArray.Data,PhaseTable,fipp_MaxPhasePos*sizeof(WORD));
    Result = SetPacket();
    return(Result);
};

//{-- new v2.6x -----}
bool __fastcall TclsFipp::SetTestParameters(void)   //{70}
{
    bool Result;

    if (TestParametersSize == 0) {
      TestParametersSize = 5;
    }
    CmdArray.Cmd = fipp_SetTestParametersCmd;
    CmdArray.Size = (WORD)(TestParametersSize);
    FD_ByteCopy(CmdArray.Data,TestParameters,TestParametersSize*2);
    Result = SetPacket();
    return(Result);
};

//{-- new v2.6x -----}
bool __fastcall TclsFipp::SetKeyScanCode(void)       // {72}
{
    return(SetValue(fipp_SetKeyScanCodeCmd,fipp_GetKeyScanCodeCmd,&KeyScanCode));
};

//{-- new v3.2x -----}
bool __fastcall TclsFipp::SetPollDelay(void)    //    {73}
{
  bool Result;
  if (PollDelayCount == 2) {
    CmdArray.Size = 2;
  }else{
    CmdArray.Size = 1;
  }
  CmdArray.Cmd = fipp_SetPollDelayCmd;
  CmdArray.Data[0] = PollDelay;
  CmdArray.Data[1] = PollHoldoff;
  Result = SetPacket();
  return(Result);
};

//{-- fp40 -----}
bool __fastcall TclsFipp::SetTestEar(void)       // {75}
{
   //{   SetTestEar :=}
   //{     SetValue(SetTestEarCmd,GetTestEarCmd,FIPPrec.TestEar,FIPPrec);}

    bool Result;

    CmdArray.Cmd = fipp_SetTestEarCmd;
    if (EarConfig == 0) {
      CmdArray.Size = 2;
    }else{
      CmdArray.Size = 1;
    }
    CmdArray.Data[0] = TestEar;
    CmdArray.Data[1] = EarConfig;
    Result = SetPacket();
    return(Result);
};

//{-- fp40 -----}
bool __fastcall TclsFipp::SetSrcType(void)   // {77}
{
//  WORD OldTimer;
  return(SetValue(fipp_SetSrcTypeCmd,fipp_GetSrcTypeCmd,&SrcType));
};



//{-- fp40 -----}
//{FP40 only has one parameter, 7000/8000 use two parameters}
//{FP35 uses five parameters, 6500/6400 do not have this command}
bool __fastcall TclsFipp::SetBatteryType(void)       //  {79}
{
    CmdArray.Cmd = fipp_SetBatteryTypeCmd;
    if (BatteryFormat <= 0) {   //{make sure battery format is valid}
      BatteryFormat = 1;
    }else if (BatteryFormat > 5) {
      BatteryFormat = 5;
    }
    CmdArray.Size = BatteryFormat;
    CmdArray.Data[0] = (WORD)(BatteryType);
    CmdArray.Data[1] = (WORD)(BatterySize);
    CmdArray.Data[2] = (WORD)(BatteryMAH);
    CmdArray.Data[3] = (WORD)(BatteryVolt);
    CmdArray.Data[4] = (WORD)(BatteryImp);
    if (SetPacket()==false) return(false);
    return(true);
};


//{-- new v3.3x -----}
bool __fastcall TclsFipp::SetAvgFreqs(void)       // {82}
{
   //{   SetAvgFreqs :=}
   //{     SetValue(SetAvgFreqsCmd,GetAvgFreqsCmd,integer(FIPPrec.AvgFreqs),FIPPrec);}

    bool Result;

    CmdArray.Cmd = fipp_SetAvgFreqsCmd;
    if (UseAvgFreqValues == true)
    {
      CmdArray.Size = 6;
      FD_ByteCopy(CmdArray.Data,&AvgFreqValues,sizeof(AvgFreqValues));
    }else{
      CmdArray.Size = 1;
      CmdArray.Data[0] = AvgFreqs;
    };
    Result = SetPacket();
    return(Result);
};

//{-- new v3.3x -----} {old single parameter method - don't use this, use New version}
  //function __fastcall TclsFipp::SetSettleTime:boolean;        {84}
  //{
  //   SetSettleTime :=
  //     SetValue(fipp_SetSettleTimeCmd,fipp_GetSettleTimeCmd,FreqSettleTime);
  //};

bool __fastcall TclsFipp::SetSettleTime(void)  //{84} {new verison}
{
  //{   SetSettleTime := }
  //{     SetValue(SetSettleTimeCmd,GetSettleTimeCmd,integer(FIPPrec.SettleTime),FIPPrec); }

  CmdArray.Cmd = fipp_SetSettleTimeCmd;
  if (SettleCmdSize >= 1) {
    CmdArray.Size = 1;
    CmdArray.Data[0] = FreqSettleTime;
  };
  if (SettleCmdSize >= 3) {
    CmdArray.Size = 3;
    CmdArray.Data[0] = FreqSettleTime;
    CmdArray.Data[1] = AmpSettleTime;
    CmdArray.Data[2] = MeasureStartTime;
  };
  if (SettleCmdSize >= 5) {
    CmdArray.Size = 5;
    CmdArray.Data[3] = IoAmpSettleTime;
    CmdArray.Data[4] = IoStartDelayTime;
  };
  if (SettleCmdSize >= 6) {
    CmdArray.Size = 6;
    CmdArray.Data[5] = BurstOnTime;
  };
  if (SetPacket()==false) return(false);
  return(true);
};

//{-------}
//{Assumes that the caller has set CICstate to the desired value.}

bool __fastcall TclsFipp::SetCICstate(void)   //{88}
{
   return(SetValue(fipp_SetCICstateCmd,fipp_GetCICstateCmd,&CICstate));
};


//{-- 6500 -----}
/* old cmd 89
bool SetDefaultLabel(void)        //{89}
{
  Result := false;
  SendArray[0] = SetDefaultLabelCmd;
  SendArray[1] = 1;
  SendArray[2] = (WORD)(DefaultLabelType);
  if (SetPacket()==false) return(false);
  SetDefaultLabel := true;
};
*/

bool __fastcall TclsFipp::SetPrinterLabelStorage(void)   //{89}
{
    CmdArray.Cmd = fipp_SetPrinterLabelStorageCmd;
    CmdArray.Size = 1;
    CmdArray.Data[0] = (WORD)(PrinterLabelStorage);
    if (SetPacket()==false) return(false);
    return(true);
};

//{---6500 V4.14--}
bool __fastcall TclsFipp::SetAvgDelayTime(void)  // {90}
{
  CmdArray.Cmd = fipp_SetAvgDelayCmd;
  CmdArray.Size = 2;
  CmdArray.Data[0] = (WORD)(AvgStartTime);
  CmdArray.Data[1] = (WORD)(AvgSettleTime);
  if (SetPacket()==false) return(false);
  return(true);
};


//{---6500 V4.20--}
bool __fastcall TclsFipp::SetPrinterSelect(void)   //{92}
{
  CmdArray.Cmd = fipp_SetPrinterSelectCmd;
  CmdArray.Size = 1;
  CmdArray.Data[0] = (WORD)(PrinterSelector);
  if (PrintInfoCount > 1)
  {
    CmdArray.Size = 2;
    CmdArray.Data[1] = (WORD)(PrinterSetup);
  };
  if (PrintInfoCount > 2)
  {
    CmdArray.Size = 3;
    CmdArray.Data[2] = (WORD)(PrintDarkness); //{FP35 V6.20}
  };
  if (SetPacket() == false) return(false);
  return(true);
};



//{FP35 V1.10}
bool __fastcall TclsFipp::SetBitmap(void)  // {96}
{
  int OldTimer;
  bool Result = false;
  if (FryeBitmap.Size == 0) return(Result);
  GetNoPoll(&OldTimer);       // {get real poll timeout value}
  PollTimer = OldTimer;     // {update current timer value}
  if (PollTimer < FIPP_LONG_POLL_TIMEOUT)    // {If less than long timeout}
  {
    PollTimer = FIPP_LONG_POLL_TIMEOUT;       // {force it to long timeout}
    SetNoPoll(PollTimer);
  };
  FD_ByteCopy(&CmdArray.Data[0],&FryeBitmap,FryeBitmap.Size*2);
  CmdArray.Cmd = fipp_SetBitmapCmd;
  CmdArray.Size = (INT16)(FryeBitmap.Size + FIPP_FRYE_BITMAP_HDR_SIZEW);
  Result = SetPacket();
  PollTimer = OldTimer;
  SetNoPoll(PollTimer);      //{restore original poll timeout value}
  return(Result);
};

//{---6500---}
bool __fastcall TclsFipp::SetARparams(void)      // {97} {6500}
{
    CmdArray.Cmd = fipp_SetARparamsCmd;
    CmdArray.Size = 4;
    FD_ByteCopy(&CmdArray.Data[0],&ARparams[0],fipp_ARparamsSize*2);
    if (SetPacket()==false) return(false);
    return(true);
};

//{-- FP35 v1.21 -----}
bool __fastcall TclsFipp::SetBlob(void)   //{99}
{
    CmdArray.Cmd = fipp_SetBlobCmd;
    CmdArray.Size = BlobSize;
    FD_ByteCopy(&CmdArray.Data[0],&Blob,BlobSize*2);
    if (SetPacket()==false) return(false);
    return(true);
};


//{---FP35 V1.00--}
bool __fastcall TclsFipp::SetRealTimeClock(void)   //{104}
{
    CmdArray.Cmd = fipp_SetRealTimeClockCmd;
    CmdArray.Size = 5;
    FD_ByteCopy(&CmdArray.Data,&RealTimeClockData,sizeof(RealTimeClockData));
    if (SetPacket()==false) return(false);
    return(true);
};

//{--FP35 V2.00--}
//{Assumes that the caller has set OutputDevice to the desired value.}
bool __fastcall TclsFipp::SetOutputDevice(void)   //{106}
{
  if (OutputDeviceSize == 2) {
    CmdArray.Size = 2;
  }else{
    CmdArray.Size = 1;
  }
  CmdArray.Cmd = fipp_SetOutputDeviceCmd;
  CmdArray.Data[0] = OutputSelect;
  CmdArray.Data[1] = OutputDevice;
  if (SetPacket()==false) return(false);
  return(true);
};

//{--FP35 V2.00--}
//{Assumes that the caller has set ImpulseRej to the desired value.}
bool __fastcall TclsFipp::SetImpulseRej(void)   // {108}
{
   return(SetValue(fipp_SetImpulseRejCmd,fipp_GetImpulseRejCmd,&ImpulseRej));
};

//{--FP35 V2.00--}
//{Assumes that the caller has set CurveSelect to the desired value.}
bool __fastcall TclsFipp::SetCurveSelect(void) //{112}
{
  return(SetValue(fipp_SetCurveSelectCmd,fipp_GetCurveSelectCmd,&CurveSelect));
};

//{--FP35 V2.00--}
//{Assumes that the caller has set CurveStatus to the desired value.}
bool __fastcall TclsFipp::SetCurveStatus(void)    //{114}
{
   //{     SetValue(SetCurveStatusCmd,GetCurveStatusCmd,FIPPrec.CurveStatus,FIPPrec);}
  CmdArray.Cmd = fipp_SetCurveStatusCmd;
  CmdArray.Size = 2;
  CmdArray.Data[0] = CurveSelect;
  CmdArray.Data[1] = CurveStatus;
  if (SetPacket()==false) return(false);
  return(true);
};

//{--FP35 V2.00--}
//{Assumes that the caller has set UnaidedSelect to the desired value.}
bool __fastcall TclsFipp::SetUnaidedSelect(void)   //{116}
{
   return(SetValue(fipp_SetUnaidedSelectCmd,fipp_GetUnaidedSelectCmd,&UnaidedSelect));
};

//{-- new FP35 V4.72 -----}
bool __fastcall TclsFipp::SetListData(void)    //{118} {fp35 v4.72 }
{
  CmdArray.Cmd = fipp_SetListDataCmd;
  CmdArray.Size = (INT16)(ListDataSize+1);
  CmdArray.Data[0] = ListSelection;
  FD_ByteCopy(&CmdArray.Data[1],&ListData,ListDataSize);
  if (SetPacket()==false) return(false);
  return(true);
};

//{--FP35 V2.10--}
//{Assumes that the caller has set StaticToneSelect to the desired value.}
bool __fastcall TclsFipp::SetStaticToneSelect(void)   //{121}
{
   return(SetValue(fipp_SetStaticToneSelectCmd,fipp_GetStaticToneSelectCmd,&StaticToneSelect));
};

//{--FP35 V2.10--}
//{Assumes that the caller has set AidGroupSelect and AidTypeSelect to the desired value.}
bool __fastcall TclsFipp::SetAidInfoSelect(void)   //{123}
{
  if (AidInfoSize == 2) {
    CmdArray.Size = 2;
  }else{
    CmdArray.Size = 1;
  }
  CmdArray.Cmd = fipp_SetAidInfoSelectCmd;
  CmdArray.Data[0] = AidGroupSelect;
  CmdArray.Data[1] = AidTypeSelect;
  if (SetPacket()==false) return(false);
  return(true);
};

//{----}
bool __fastcall TclsFipp::SetBiasTone(void)   //{125}
{
  CmdArray.Cmd = fipp_SetBiasToneCmd;
  CmdArray.Size = 3;
  CmdArray.Data[0] = BiasToneSource;
  CmdArray.Data[1] = BiasToneFrequency;
  CmdArray.Data[2] = BiasToneDuration;
  if (SetPacket()==false) return(false);
  return(true);
};

//{--FP35 V2.20--}
//{Assumes that the caller has set WarbleSelect to the desired value.}
//{Only warble rate selection supported by this command. }
//{Use Build command if enhanced warblerate selection is available}
bool __fastcall TclsFipp::SetWarbleSelect(void) //{129}
{
   return(SetValue(fipp_SetWarbleSelectCmd,fipp_GetWarbleSelectCmd,&WarbleSelect));
};


//{-- new fp35 v2.20 -----}
bool __fastcall TclsFipp::SetRcvTimeout(void)       // {132}
{
  INT16 Temp;
  bool Result;

  Temp = RcvTimeout;
  Result = SetValue(fipp_SetRcvTimeoutCmd,fipp_GetRcvTimeoutCmd,&Temp);
  RcvTimeout = Temp;
  return(Result);
};


//{-- new fp35 v2.30 -----}
bool __fastcall TclsFipp::SetFitRule(void)      //  {134}
{
  INT16 Temp;
  bool Result;

  Temp = FitRule;
  Result = SetValue(fipp_SetFitRuleCmd,fipp_GetFitRuleCmd,&Temp);
  FitRule = Temp;
  return(Result);
};


//{-- new fp35 v3.00 -----}
bool __fastcall TclsFipp::SetFilter(void)      //  {136}
{
  INT16 Temp;
  bool Result;

  Temp = FilterType;
  Result = SetValue(fipp_SetFilterCmd,fipp_GetFilterCmd,&Temp);
  FilterType = Temp;
  return(Result);
};

//{--FP35 V3.00--}
//{Assumes that the caller has set compression to the desired value.}
bool __fastcall TclsFipp::SetCompression(void)  // {138}
{
   return(SetValue(fipp_SetCompressionCmd,fipp_GetCompressionCmd,&Compression));
};

//{--FP35 V3.00--}
//{Assumes that the caller has set age to the desired value.}
bool __fastcall TclsFipp::SetClientAge(void)   //{140}
{
   return(SetValue(fipp_SetClientAgeCmd,fipp_GetClientAgeCmd,&ClientAge));
};

//{--FP35 V3.10--}
//{Assumes that the caller has set location to the desired value.}
bool __fastcall TclsFipp::SetTransducerLoc(void)   //{142}
{
  CmdArray.Cmd = fipp_SetTransducerLocCmd;
  CmdArray.Size = 2;
  CmdArray.Data[0] = 0; //{currenlty only speaker location is valid}
  CmdArray.Data[1] = TransducerLoc;
  if (SetPacket()==false) return(false);
  return(true);
};


//{-- FP35 v3.20 -----}
bool __fastcall TclsFipp::SetLevelingList(void)    //   {145}
{
    CmdArray.Cmd = fipp_SetLevelingListCmd;
    CmdArray.Size = LevelingListSize;
    FD_ByteCopy(CmdArray.Data,&LevelingList,LevelingListSize*sizeof(WORD));
    return(SetPacket());
};

//{--FP35 V3.20--}
//{Assumes that the caller has set location to the desired value.}
bool __fastcall TclsFipp::SetLevelingStatus(void)   //{147}
{
   return(SetValue(fipp_SetLevelingStatusCmd,fipp_GetLevelingStatusCmd,&LevelState));
};


//{-- FP35 v3.20 -----}
bool __fastcall TclsFipp::SetAuxPort(void)       //{148}
{
    int Index;
    bool Result;

    CmdArray.Cmd = fipp_SetAuxPortCmd;
    CmdArray.Data[0] = 0x0100;
    Index = 3;
    if ((int)(AuxStartCtrl) != -1)
    {
      CmdArray.Data[0] = (INT16)(CmdArray.Data[0] | 0x0001);
      CmdArray.Data[1] = AuxStartCtrl;
      AuxCtrl = AuxStartCtrl;
      Index = Index + 1;
    };
    CmdArray.Raw[Index] = AuxOutCount;
    Index = Index + 1;
    if (AuxOutCount > 0)
    {
      FD_ByteCopy(&CmdArray.Raw[Index],&AuxOutData,AuxOutCount);
      Index = Index + ((AuxOutCount + 1) / 2);
    };
    if ((int)(AuxEndCtrl) != -1)
    {
      CmdArray.Raw[Index] = AuxEndCtrl;
      AuxCtrl = AuxEndCtrl;
      CmdArray.Data[0] = (INT16)(CmdArray.Data[0] | 0x0002);
      Index = Index + 1;
    };
    CmdArray.Size = (INT16)(Index - 2);
    Result = SetPacket();
    return(Result);
};

//{--FP35 V3.20--}
//{Assumes that the caller has set UserNumber to the desired value.}
bool __fastcall TclsFipp::SetUserNumber(void) //{150}
{
   return(SetValue(fipp_SetUserNumberCmd,fipp_GetUserNumberCmd,&UserNumber));
};


//{-- new FP35 V3.20 -----}
bool __fastcall TclsFipp::SetFitType(void)  //  {152} {fp35 v3.20 12/01/03}
{
  return(SetValue(fipp_SetFitTypeCmd,fipp_GetFitTypeCmd,&Fit.AidFitType));
};

//{-- new FP35 V3.20 -----}
bool __fastcall TclsFipp::SetVentType(void)    //{154} {fp35 v3.20 12/01/03}
{
   return(SetValue(fipp_SetVentTypeCmd,fipp_GetVentTypeCmd,&Fit.AidVentType));
};

//{-- new FP35 V3.20 -----}
bool __fastcall TclsFipp::SetTubingType(void)   // {156} {fp35 v3.20 12/01/03}
{
   return(SetValue(fipp_SetTubingTypeCmd,fipp_GetTubingTypeCmd,&Fit.AidTubingType));
};

//{-- new FP35 V3.20 -----}
bool __fastcall TclsFipp::SetAidChannels(void)    //{158} {fp35 v3.20 12/01/03}
{
   return(SetValue(fipp_SetAidChannelsCmd,fipp_GetAidChannelsCmd,&Fit.AidChannels));
};

//{-- new FP35 V3.20 -----}
bool __fastcall TclsFipp::SetAidLimiting(void)    //{160} {fp35 v3.20 12/01/03}
{
   return(SetValue(fipp_SetAidLimitingCmd,fipp_GetAidLimitingCmd,&Fit.AidLimiting));
};

//{-- new FP35 V3.70 -----}
bool __fastcall TclsFipp::SetRefMethod(void)   // {162} {fp35 v3.70 06/06/06}
{
  return(SetValue(fipp_SetRefMethodCmd,fipp_GetRefMethodCmd,&Fit.RefMethod));
};


//{-- new FP35 V3.20 -----}
bool __fastcall TclsFipp::SetFitParam(void)   // {164} {fp35 v3.20 12/01/03}
{
  INT16 FitSize;

  FitSize = (INT16)(sizeof(Fit) / sizeof(WORD));
  if ((FitCount < 12) || (FitCount > FitSize)) {
    FitCount = FitSize;
  }
  CmdArray.Cmd = fipp_SetFitParamCmd;
  CmdArray.Size = FitCount;
  FD_ByteCopy(CmdArray.Data,&Fit,sizeof(Fit));
  if (SetPacket()==false) return(false);
  return(true);
};


//{-- FP35 V3.20 -----}
bool __fastcall TclsFipp::SetUserIDText(void)   //{166}
{
    int i;
    bool Result;

    if (UserNumber > 15) {
      UserNumber = 15;
    }
    CmdArray.Cmd = fipp_SetUserIDTextCmd;
    CmdArray.Size = (FIPP_MAX_USERID_TEXT >> 1) + 1; //{div 2}
    CmdArray.Data[0] = UserNumber;
    UserIDText[UserNumber][(FIPP_MAX_USERID_TEXT-1)] = 0; //{force last byte to null}
    i = 0;
    while (i < FIPP_MAX_USERID_TEXT)
    {
      CmdArray.Raw[(i >> 1)+3] = (INT16)((WORD)((WORD)(UserIDText[UserNumber][i]) << 8)+
                                                (BYTE)(UserIDText[UserNumber][(i+1)]));
      i = i+2;
    };
    Result = SetPacket();
    return(Result);
};

//{-- new FP35 V3.30 -----}
bool __fastcall TclsFipp::SetSkew(void)    //{168} {fp35 v3.30 07/01/04}
{
  CmdArray.Cmd = fipp_SetSkewCmd;
  CmdArray.Size = 2;
  CmdArray.Data[0] = WhichSkew;
  CmdArray.Data[1] = Skew;
  if (SetPacket()==false) return(false);
  return(true);
};

//{-- new FP35 V3.40 -----}
bool __fastcall TclsFipp::SetScreenMode(void)   // {170}
{
  CmdArray.Cmd = fipp_SetScreenModeCmd;
  if (VgaOption == true)
  {
    CmdArray.Size = 2;
    CmdArray.Data[0] = LcdMode;
    CmdArray.Data[1] = VgaPalette;
  }else{
    CmdArray.Size = 1;
    CmdArray.Data[0] = LcdMode;
  };
  if (SetPacket()==false) return(false);
  return(true);
};

//{-- new FP35 V3.50 -----}
bool __fastcall TclsFipp::SetCouplerSelection(void)   // {172} {fp35 v3.50 12/16/04}
{
    CmdArray.Cmd = fipp_SetCouplerSelectionCmd;
    CmdArray.Size = 1;
    CmdArray.Data[0] = CouplerSelection;
    if (SetPacket()==false) return(false);
    return(true);
};


//{-- new FP35 v3.60 -----}
bool __fastcall TclsFipp::SetAnalysisSelection(void)   // {174} {fp35 v3.60 06/12/06}
{
   return(SetValue(fipp_SetAnalysisSelectionCmd,fipp_GetAnalysisSelectionCmd,&AnalysisSelection));
};


//{-------}
bool __fastcall TclsFipp::SetStoredParameter(void)       //{180}
{
    CmdArray.Cmd = fipp_SetStoredParameterCmd;
    CmdArray.Size = 2;
    CmdArray.Data[0] = StoredParameterNumber; //{SavedItemNumber;}
    CmdArray.Data[1] = StoredParameterValue;  //{SavedParameter;}
    return(SetPacket());
};

//{-- 8000 -----}
bool __fastcall TclsFipp::SetCurveGroupSelect(void)    //{182}
{
   bool Result = SetValue(fipp_SetCurveGroupSelectCmd,fipp_GetCurveGroupSelectCmd,&CurveGroupSelect);
   return(Result);
};

//{--------}
bool __fastcall TclsFipp::SetAgcFreqSelect(void)    //{184}
{
  CmdArray.Cmd = fipp_SetAgcFreqSelectCmd;
  CmdArray.Data[0] = AgcFreqSelect;
  CmdArray.Data[1] = AgcFreqEnable;
  CmdArray.Data[2] = AgcFreqIndex;
  if (AgcFreqSelectSize == 3) {
    CmdArray.Size = 3;
  }else{
    CmdArray.Size = 2;
  }
  if (SetPacket()==false) return(false);
  return(true);
};

//{-- FP35 -----}
bool __fastcall TclsFipp::SetInputPortSelect(void)    //{186}
{
   return(SetValue(fipp_SetInputPortSelectCmd,fipp_GetInputPortSelectCmd,&InputPortSelect));
};


//{-- 8000 -----}
bool __fastcall TclsFipp::SetAngleSelect(void)    //{188}
{
   return(SetValue(fipp_SetAngleSelectCmd,fipp_GetAngleSelectCmd,&AngleSelect));
};

//{--------}
bool __fastcall TclsFipp::SetDiffFreq(void)    //{190}
{
  CmdArray.Cmd = fipp_SetDiffFreqCmd;
  CmdArray.Data[0] = DiffFreq;
  CmdArray.Data[1] = SweepEndFreq;
  if (DiffFreqRspSize == 2) {
    CmdArray.Size = 2;
  }else{
    CmdArray.Size = 1;
  }
  if (SetPacket()==false) return(false);
  return(true);
};

//{-- FP35 -----}
bool __fastcall TclsFipp::SetUserMode(void)    //{192}
{
   return(SetValue(fipp_SetUserModeCmd,fipp_GetUserModeCmd,&UserMode));
};


//{++++++++}
//{The following procedures handle the standard FIPP Get commands}
//{the command simply updates the appropriate variable in FIPPrec}
//{it is up to the calling routine to insure that the desired variables}
//{are properly updated before using them.}

//{Get cmds return true if everything went ok. false if not (error in FippError)
//if everything went ok, value is returned in indicated variable(s)}

//{---------}
bool __fastcall TclsFipp::GetRelAttData(void)     // {18}
{
    CmdArray.Cmd = fipp_GetRelAttDataCmd;
    CmdArray.Size = 0;
    if (GetPacket()==false) return(false);
    AttackTime = (INT16)(RspArray.Data[0]);
    ReleaseTime = (INT16)(RspArray.Data[1]);
    return(true);
};

//{-------}
bool __fastcall TclsFipp::GetBatteryData(void)     //{19}
{
    CmdArray.Cmd = fipp_GetBatteryDataCmd;
    CmdArray.Size = 0;
    if (GetPacket()==false) return(false);
    BatteryCurrent = (INT16)(RspArray.Data[0]);
    BatteryType = (INT16)(RspArray.Data[1]);
    if (RspArray.Size > 2) {
      BatteryVolt = (INT16)(RspArray.Data[2]);
    }
    if (RspArray.Size > 3) {
      BatteryImp = (INT16)(RspArray.Data[3]);
    }
    return(true);
};

//{-------}
bool __fastcall TclsFipp::GetIOdata(void)      //{20}
{
    CmdArray.Cmd = fipp_GetIOdataCmd;
    CmdArray.Size = 0;
    if (GetPacket()==false) return(false);
    FD_ByteCopy(&IOcurve,&RspArray.Data[0],fipp_IOcurveSize);
    return(true);
};

//{-------}
bool __fastcall TclsFipp::GetSourceAmp(void)   //{21}
{
   return(GetValue(fipp_GetSourceAmpCmd,&SourceAmp));
};

//{-------}
bool __fastcall TclsFipp::GetDistMode(void)   //{22}
{
   return(GetValue(fipp_GetDistModeCmd,&DistMode));
};

//{-------}
bool __fastcall TclsFipp::GetFrequency(void) //{23}
{
   return(GetValue(fipp_GetFrequencyCmd,&Frequency));
};

//{-------}
bool __fastcall TclsFipp::GetOESstate(void)   //{24}   {obsolete}
{
   return(GetValue(fipp_GetOESstateCmd,&OESstate));
};

//{-------}
bool __fastcall TclsFipp::GetCurveFrame(void) // {25}
{
   WORD CurveFormat;
   WORD ByteSize;

    CmdArray.Cmd = fipp_GetCurveFrameCmd;
    CmdArray.Size = 1;
    CmdArray.Data[0] = (WORD)(CurveNumber);
    if (GetPacket()==false) return(false);

    FD_ByteFill(&CurveFrame,0,sizeof(CurveFrame));
    CurveNumber = (INT16)(RspArray.Data[0]);
    CurveFormat = (INT16)((RspArray.Data[1] >> 10) & 0x07);
    if ((CurveFormat == 2) || (CurveFormat == 3)) {
      CurveFrameSize = FIPP_AUD_CURVE_FRAME_SIZEW; //AudCurveFrameSize
    }else{
      CurveFrameSize = FIPP_STD_CURVE_FRAME_SIZEW; //StdCurveFrameSize;
    }
    ByteSize = (INT16)(CurveFrameSize*2);
    FD_ByteCopy(&CurveFrame,&RspArray.Data[1],ByteSize);
    return(true);
};

//{-------}
bool __fastcall TclsFipp::GetNoiseRedCount(void)  //{26}
{
   return(GetValue(fipp_GetNoiseRedCountCmd,&NoiseRedCount));
};

//{--------}
bool __fastcall TclsFipp::GetSmoothState(void) //{27}
{
   return(GetValue(fipp_GetSmoothStateCmd,&SmoothState));
};

//{-------}
bool __fastcall TclsFipp::GetFonixVersion(void)  //{28}
{
 // int VerSize;

  CmdArray.Cmd = fipp_GetFonixVersionCmd;
  CmdArray.Size = 0;
  if (GetPacket()==false) return(false);
  FonixVersionSize = RspArray.Size;  //size of record received in words
  if (FonixVersionSize > sizeof(FIPP_tVersionArray)) {
    FonixVersionSize = sizeof(FIPP_tVersionArray);
  }
  FD_ByteCopy(&FonixVersionArray,RspArray.Data,FonixVersionSize*2);
  FD_ByteCopy(&FonixHwVersion,RspArray.Data,sizeof(FIPP_tMachineVersion));

  //Special case hack to deal with screwy 8000 indentification
  if (FonixHwVersion.InstrumentModel <= 0)
  {
    FonixHwVersion.InstrumentModel = FonixHwVersion.InstrumentBaseType;
    if ((FonixHwVersion.InstrumentBaseType == 7000) && (FonixHwVersion.SubType == 1))
    {
      FonixHwVersion.InstrumentModel = 8000;
    };
    if ((FonixHwVersion.InstrumentBaseType == 7000) && (FonixHwVersion.SubType == 2))
    {
      FonixHwVersion.InstrumentModel = 8001;
    };
//    if (FonixHwVersion.InstrumentBaseType == 0) then
//    {
//      FonixHwVersion.InstrumentModel = 6500;
//    }
//    else if (FonixHwVersion.InstrumentBaseType == 1) then
//    {
//      FonixHwVersion.InstrumentModel = 6400;
//    };
  };
  return(true);
};

//{-------}
bool __fastcall TclsFipp::GetLevelState(void)  //  {29}
{
  // GetLevelState := GetValue(fipp_GetLevelingStatusCmd,LevelState);

  CmdArray.Cmd = fipp_GetLevelingStatusCmd;
  CmdArray.Size = 0;
  if (GetPacket()==false) return(false);
  LevelState = (INT16)(RspArray.Data[0]);
  if (RspArray.Size > 1) {
    LevelDirection = (INT16)(RspArray.Data[1]);
  }else{
    LevelDirection = INVALID_DATA16;
  }
  if (RspArray.Size > 2) {
    AdvLevelStatus = (INT16)(RspArray.Data[2]);
  }else{
    AdvLevelStatus = INVALID_DATA16;
  }
  if (RspArray.Size > 3) {
    LevelMaxSpl = (INT16)(RspArray.Data[3]);
  }else{
    LevelMaxSpl = INVALID_DATA16;
  }
  return(true);
};

//{-------}
bool __fastcall TclsFipp::GetWeightState(void)   //{30}   {obsolete}
{
   return(GetValue(fipp_GetWeightStateCmd,&WeightState));
};

//{-------}
bool __fastcall TclsFipp::GetMicData(void)   //{31}
{
   return(GetValue(fipp_GetMicDataCmd,&MicData));
};

//{-------}
bool __fastcall TclsFipp::GetDistPercent(void)   //{32}
{
   return(GetValue(fipp_GetDistPercentCmd,&DistPercent));
};

//{-------}
bool __fastcall TclsFipp::GetCmdStatus(void)   //{33}
{
  bool Result;
  CmdStatusFailed = true;
  CmdArray.Cmd = fipp_GetCmdStatusCmd;
  CmdArray.Size = 0;
  Result = DoFippCmd(FCOM_ACK_OK, FIPP_DEFAULT_NO_POLL);
  if (Result == false) return(false);

  if ((RspArray.Cmd & 0x7fff) != CmdArray.Cmd)
  {
    return(false);
  };
  CmdStatus = (INT16)(RspArray.Data[0]);

  CmdStatusFailed = false;
  return(true);
};

//{-------}
bool __fastcall TclsFipp::GetIOmode(void)   //{34}
{
    CmdArray.Cmd = fipp_GetIOmodeCmd;
    CmdArray.Size = 0;
    if (GetPacket()==false) return(false);
    IOFrequency = (INT16)(RspArray.Data[0]);
    IOGain = (INT16)(RspArray.Data[1]);
    if ((int)(RspArray.Size) > 3)
    {
      IOStartMs = (INT16)(RspArray.Data[2]);
      IOSweepMs = (INT16)(RspArray.Data[3]);
    };
    return(true);
};

//{-------}
bool __fastcall TclsFipp::GetProbeState(void)   //{35}   {obsolete}
{
   return(GetValue(fipp_GetProbeStateCmd,&ProbeState));
};

//{-------}
bool __fastcall TclsFipp::GetAnalysisMode(void)   //{36}  {was GainState}
{
   return(GetValue(fipp_GetAnalysisModeCmd,&AnalysisMode));
};

//{-------}
bool __fastcall TclsFipp::GetSourceMethod(void)   //{37}    {was GetTelCoilState}
{
   return(GetValue(fipp_GetSourceMethodCmd,&SourceMethod));
};

//{-------}
bool __fastcall TclsFipp::GetRelAttFreq(void)   //{41}
{
   return(GetValue(fipp_GetRelAttFreqCmd,&RelAttFreq));
};

//{-------}
bool __fastcall TclsFipp::GetLastCurve(void)  //{42}
{
  WORD CurveFormat;
  WORD ByteSize;

    CmdArray.Cmd = fipp_GetLastCurveCmd;    //  {- last curve is number 99}
    CmdArray.Size = 0;                    //{- note last curve is same}
    if (GetPacket()==false) return(false); //{- as normal curve, but no}
    CurveNumber = 99;                    //{- curve number is provided}
    CurveFormat = (INT16)((RspArray.Data[1] >> 10) & 0x07);
    if ((CurveFormat == 2) || (CurveFormat == 3)) {
     CurveFrameSize = FIPP_AUD_CURVE_FRAME_SIZEW; //AudCurveFrameSize
    }else{
      CurveFrameSize = FIPP_STD_CURVE_FRAME_SIZEW; //StdCurveFrameSize;
    }
    ByteSize = (INT16)((CurveFrameSize+3)*2); //{cmd,len,crv#,crv}
    FD_ByteCopy(&CurveFrame,&RspArray.Data[0],ByteSize);
    return(true);
};

//{-------}
bool __fastcall TclsFipp::GetTelCoilMode(void)  //{44}
{
   return(GetValue(fipp_GetTelCoilModeCmd,&TelCoilMode));
};

//{-------}
bool __fastcall TclsFipp::GetZetaState(void)  // {45}   {obsolete}
{
   return(GetValue(fipp_GetZetaStateCmd,&ZetaState));
};

//{-------}
bool __fastcall TclsFipp::GetInsitu(void)    //{46}   {obsolete}
{
    CmdArray.Cmd = fipp_GetInsituCmd;
    CmdArray.Size = 0;
    if (GetPacket()==false) return(false);
    Insitu[0] = (WORD)(RspArray.Data[0]);
    Insitu[1] = (WORD)(RspArray.Data[1]);
    Insitu[2] = (WORD)(RspArray.Data[2]);
    return(true);
};

//{-------}
bool __fastcall TclsFipp::GetAutoState(void)  //{49}
{
  bool Result;

  //GetAutoState := GetValue(fipp_GetAutoStateCmd,AutoState);
  CmdArray.Cmd = fipp_GetAutoStateCmd;
  CmdArray.Size = 0;
  if (GetPacket()==false) return(false);
  AutoState = (INT16)(RspArray.Data[0]);
  AutoStateSize = RspArray.Size; //how many parameters were returned
  if (RspArray.Size > 1)
  {
    AutoStepDuration = (INT16)(RspArray.Data[1]);
  };
  Result = true;
  return(Result);
};


//{-------}
bool __fastcall TclsFipp::GetLimitValue(void)     //{51}
{
   return(GetValue(fipp_GetLimitValueCmd,&LimitValue));
};


//{-------}
bool __fastcall TclsFipp::GetRefMicState(void)   //    {53}
{
   return(GetValue(fipp_GetRefMicStateCmd,&RefMicState));
};



//{-------}
bool __fastcall TclsFipp::GetActiveStatus(void)    //{55}
{
   return(GetValue(fipp_GetActiveStatusCmd,&ActiveStatus));
};


//{-------}
bool __fastcall TclsFipp::GetRefMicData(void)   //{57}
{
   return(GetValue(fipp_GetRefMicDataCmd,&RefMicData));
};


//{-- new v2.6x -----}
bool __fastcall TclsFipp::GetKeyScanCode(void)    //{58}
{
   return(GetValue(fipp_GetKeyScanCodeCmd,&KeyScanCode));
};

//{-- new v2.6x -----}
bool __fastcall TclsFipp::GetMachineState(void)   //{60}
{
    CmdArray.Cmd = fipp_GetMachineStateCmd;
    CmdArray.Size = 0;
    if (GetPacket()==false) return(false);
    MajorMachineState = (INT16)(RspArray.Data[0]);
    MinorMachineState = (INT16)(RspArray.Data[1]);
    return(true);
};

//{-- new v2.6x -----}
bool __fastcall TclsFipp::GetBlob(void)   //{61}
{
    FD_WordFill(&Blob,0x8000,sizeof(Blob) / 2);
    CmdArray.Cmd = fipp_GetBlobCmd;
    CmdArray.Size = 0;
    if (GetPacket()==false) return(false);
    BlobSize = (WORD)(RspArray.Size);
    FD_ByteCopy(&Blob,RspArray.Data,BlobSize*2);
    return(true);
};

//{-- new v2.6x -----}
bool __fastcall TclsFipp::GetControlLock(void)   //{63}
{
   return(GetValue(fipp_GetControlLockCmd,&ControlLock));
};

//{-- new v2.6x -----}
bool __fastcall TclsFipp::GetTestParameters(void)   // {71}
{
    FD_WordFill(&TestParameters[1],0x8000,(sizeof(TestParameters) / 2)-1);
    CmdArray.Cmd = fipp_GetTestParametersCmd;
    CmdArray.Size = 1;
    CmdArray.Data[0] = (WORD)(TestParameters[0]);
    if (GetPacket()==false) return(false);
    TestParametersSize = (WORD)(RspArray.Size);
    FD_ByteCopy(&TestParameters,&RspArray.Data[0],TestParametersSize*2);
    return(true);
};


//{-- new v2.6x -----}
bool __fastcall TclsFipp::GetPollDelay(void)    //{74}
{
  CmdArray.Cmd = fipp_GetPollDelayCmd;
  CmdArray.Size = 0;
  if (GetPacket()==false) return(false);
  PollDelay = RspArray.Data[0];
  if (RspArray.Size > 1)
  {
    PollHoldoff = RspArray.Data[1];
  };
  PollDelayCount = RspArray.Size;
  return(true);
};

//{-- fp40 -----}
bool __fastcall TclsFipp::GetTestEar(void)     //{76}
{
    bool Result;

    CmdArray.Cmd = fipp_GetTestEarCmd;
    CmdArray.Size = 0;
    if (GetPacket()==false) return(false);
    TestEar = (INT16)(RspArray.Data[0]);
    if (RspArray.Size > 1) {
      EarConfig = (INT16)(RspArray.Data[1]);
    }else{
      EarConfig = -1;
    }
    Result = true;
    return(Result);
//   { if EarConfig >= 0 then EarCmdType = 1 else EarCmdType = 2;}
//   {GetTestEar :=
//     GetValue(GetTestEarCmd,integer(FIPPrec.TestEar),FIPPrec);}
};

//{-- fp40 -----}
bool __fastcall TclsFipp::GetSrcType(void)    // {78}
{
   return(GetValue(fipp_GetSrcTypeCmd,&SrcType));
};


//{-------------}
INT16 PowerFlagsToState(INT16 PowerFlags)
{
  INT16 Result;
  int TestFlags;
  TestFlags = PowerFlags & FIPP_POWER_FLAGS_MASK;
  if ((TestFlags & BIT14) != 0) {
    Result = 2;
  }else if ((TestFlags & BIT13) != 0) {
    Result = 1;
  }else{
    Result = 0;
  }
  return(Result);
};

bool __fastcall TclsFipp::GetPowerStatus(void)    //{80}
{
    PowerCmdSize = 0;
    CmdArray.Cmd = fipp_GetPowerStatusCmd;
    CmdArray.Size = 0;
    if (GetPacket()==false) return(false);
    PowerCmdSize = RspArray.Size;
    PowerVoltage = (INT16)(RspArray.Data[0]);
    PowerFlags = (WORD)(RspArray.Data[1]);
    PowerState = PowerFlagsToState(PowerFlags);
    if (PowerCmdSize > 2) {
      StandbyTimeout = (WORD)(RspArray.Data[2]);
    }else{
      StandbyTimeout = -1;
    }
    if (PowerCmdSize > 3) {
      PowerDownTimeout = (WORD)(RspArray.Data[3]);
    }else{
      PowerDownTimeout = -1;
    }
    return(true);
};


//{-- new v3.3x -----}
bool __fastcall TclsFipp::GetAvgFreqs(void)    // {81}
{
   //{GetAvgFreqs :=}
   //{  GetValue(GetAvgFreqsCmd,integer(FIPPrec.AvgFreqs),FIPPrec);}

    CmdArray.Cmd = fipp_GetAvgFreqsCmd;
    if (UseAvgFreqValues == true)
    {
      CmdArray.Size = 1;
      CmdArray.Data[0] = AvgFreqs;
    }else{
      CmdArray.Size = 0;
    }
    if (GetPacket()==false) return(false);
    if ((UseAvgFreqValues==false) && ((INT16)(RspArray.Data[0]) == -1))
    {
      AvgFreqs = -1;
      CmdArray.Size = 1;
      CmdArray.Data[0] = RspArray.Data[0];
      UseAvgFreqValues = true;
    };
    if (GetPacket()==false) return(false);
    if (UseAvgFreqValues == true) {
      FD_ByteCopy(&AvgFreqValues,&RspArray.Data[0],sizeof(AvgFreqValues));
    }else{
      AvgFreqs = INT16(RspArray.Data[0]);
    }
    return(true);
};

//{-- new v3.3x -----}
bool __fastcall TclsFipp::GetSettleTime(void)     // {83}
{
  // {GetSettleTime := }
  // {  GetValue(GetSettleTimeCmd,integer(FIPPrec.SettleTime),FIPPrec); }

    CmdArray.Cmd = fipp_GetSettleTimeCmd;
    CmdArray.Size = 0;
    if (GetPacket()==false) return(false);
    SettleCmdSize = RspArray.Size;
    if (SettleCmdSize >= 1)
    {
      FreqSettleTime = (INT16)(RspArray.Data[0]);
    };
    if (SettleCmdSize >= 2)
    {
      AmpSettleTime = (INT16)(RspArray.Data[1]);
    };
    if (SettleCmdSize >= 3)
    {
      MeasureStartTime = (INT16)(RspArray.Data[2]);
    };
    if (SettleCmdSize >= 4)
    {
      IoAmpSettleTime = (INT16)(RspArray.Data[3]);
    };
    if (SettleCmdSize >= 5)
    {
      IoStartDelayTime = (INT16)(RspArray.Data[4]);
    };
    if (SettleCmdSize >= 6)
    {
      BurstOnTime = (INT16)(RspArray.Data[5]);
    };
    return(true);
};


//{-- new v4.0x -----}
//{read the label from the fipp object and convert it to asciiz format}
//{Note: does not do double check. Note: Label is a 2D ASCIIZ string array.}
//{Label should be padded with spaces.}
//{If Lines is zero, the old call method is used (return full label only).}
//{If Lines is > 0 (1->8), then the number of indicated lines is returned.}
//{If Lines is > 8 (9 or 10), then the user ID is also returned (lines 9 and 10).}
bool __fastcall TclsFipp::GetExtendedLabel(void)    //{86}
{
    int Size;
    CmdArray.Cmd = fipp_GetExtendedLabelCmd;
    if (LabelLines == 0)
    {
      CmdArray.Size = 1;
      CmdArray.Data[0] = LabelType;
    }else{
      CmdArray.Size = 2;
      CmdArray.Data[0] = LabelType;
      CmdArray.Data[1] = LabelLines;
    };
    if (GetPacket()==false) return(false);
    Size = RspArray.Size * 2;
    if (Size > sizeof(ExtLabelData)) {
      Size = sizeof(ExtLabelData);
    }
    ConvertLabelFromRcv(Size,ExtLabelData);
    if (LabelLines > 8)
    {
      GetUserIDFromRcv(true,sizeof(FIPP_tUserIDText),UserIDText[UserNumber]);
    };
    return(true);
};

//{-------}
bool __fastcall TclsFipp::GetCICstate(void)   //{87}
{
   return(GetValue(fipp_GetCICstateCmd,&CICstate));
};


//{---6500 V4.14--}
bool __fastcall TclsFipp::GetAvgDelayTime(void)  // {91}
{
    CmdArray.Cmd = fipp_GetAvgDelayCmd;
    CmdArray.Size = 0;
    if (GetPacket()==false) return(false);
    AvgStartTime = (INT16)(RspArray.Data[0]);
    AvgSettleTime = (INT16)(RspArray.Data[1]);
    return(true);
};

//{---6500 V4.20--}
bool __fastcall TclsFipp::GetPrinterSelect(void)   //{93}
{
    CmdArray.Cmd = fipp_GetPrinterSelectCmd;
    CmdArray.Size = 0;
    if (GetPacket()==false) return(false);
    PrinterSelector = (INT16)(RspArray.Data[0]);
    PrintInfoCount = 1;
    if ((int)(RspArray.Size) > 1)
    {
      PrinterSetup = (INT16)(RspArray.Data[1]);
      PrintInfoCount = 2;
    };
    if ((int)(RspArray.Size) > 2)
    {
      PrintDarkness = (INT16)(RspArray.Data[2]);
      PrintInfoCount = 3;
    };
    return(true);
};


//{---6500 V4.40--}
bool __fastcall TclsFipp::GetHFAMeasurement(void)  // {94}
{
    CmdArray.Cmd = fipp_GetHFAMeasurementCmd;
    CmdArray.Size = 0;
    if (GetPacket()==false) return(false);
    HFAData = (INT16)(RspArray.Data[0]);
    return(true);
};

//{---FP35 V2.00-- : SerialNumber & mfg/cal dates added in V2.20}
bool __fastcall TclsFipp::GetInstrumentInformation(void)   //{95}
{
  int Size;

  CmdArray.Cmd = fipp_GetInstrumentInfoCmd;
  CmdArray.Size = 0;
  InstrumentInfoSize = 0;
  FD_ByteFill(&InstrumentInfo,0,sizeof(InstrumentInfo));
  //fillchar(InstrumentInfo.SerialNumber,sizeof(InstrumentInfo.SerialNumber),'?');
  FD_ByteCopy(InstrumentInfo.SerialNumber,"UNKNOWN?",8);
  if (GetPacket()==false) return(false);
  Size = RspArray.Size;
  if (Size < 0) Size = 0;
  if (Size > sizeof(InstrumentInfo) / 2) {
    Size = sizeof(InstrumentInfo) / 2;
  }
  InstrumentInfoSize = Size;     //size of instrument info record received in words
  FD_ByteCopy(&InstrumentInfo,&RspArray.Data[0],Size*2);
  if ((InstrumentInfo.BootLoaderVersion == 1792)&&(InstrumentInfo.MachineType == FONIX_FP35)) {
    InstrumentInfo.BootLoaderVersion = 7; //hack to fix broken BL7 version number in the FP35
  }
  return(true);
};

//{------- 6500 ------}
bool __fastcall TclsFipp::GetARparams(void)        //{98} {6500}
{
  CmdArray.Cmd = fipp_GetARparamsCmd;
  CmdArray.Size = 0;
  if (GetPacket()==false) return(false);
  FD_ByteCopy(&ARparams,&RspArray.Data[0],fipp_ARparamsSize*2);
  return(true);
};

//{---FP35 V1.00--}
bool __fastcall TclsFipp::GetLastIdDevice(void)   // {100}
{
  CmdArray.Cmd = fipp_GetLastIdDeviceCmd;
  CmdArray.Size = 0;
  if (GetPacket()==false) return(false);
  LastIdDevice = (INT16)(RspArray.Data[0]);
  return(true);
};

//{---FP35 V1.00--}
bool __fastcall TclsFipp::GetLongDeviceID(void)   //{101}
{
  CmdArray.Cmd = fipp_GetLongDeviceIDCmd;
  CmdArray.Size = 1;
  CmdArray.Data[0] = DeviceIDNumber;
  if (GetPacket()==false) return(false);
  FD_ByteCopy(&LongDeviceID,&RspArray.Data[0],sizeof(LongDeviceID));
  return(true);
};


//{---FP35 V2.00--}
bool __fastcall TclsFipp::GetDeviceData(void)   //{102}
{
  CmdArray.Cmd = fipp_GetDeviceDataCmd;
  CmdArray.Size = 2;
  CmdArray.Data[0] = DeviceIDNumber;
  CmdArray.Data[1] = DeviceSelection;
  if (GetPacket()==false) return(false);
  DeviceDataSize = (WORD)(RspArray.Size);
  if (DeviceDataSize > sizeof(DeviceDataArray)) {
    DeviceDataSize = sizeof(DeviceDataArray);
  }
  FD_ByteCopy(&DeviceDataArray,&RspArray.Data[0],DeviceDataSize*2);
  return(true);
};

//{---FP35 V1.00--}
bool __fastcall TclsFipp::GetRealTimeClock(void)   //{103}
{
  CmdArray.Cmd = fipp_GetRealTimeClockCmd;
  CmdArray.Size = 0;
  if (GetPacket()==false) return(false);
  FD_ByteCopy(&RealTimeClockData,&RspArray.Data[0],sizeof(RealTimeClockData));
  return(true);
};

//{--FP35 V2.00---}
bool __fastcall TclsFipp::GetOutputDevice(void)   //{105}
{
  CmdArray.Cmd = fipp_GetOutputDeviceCmd;
  CmdArray.Size = 0;
  if (GetPacket()==false) return(false);
  OutputDeviceSize = RspArray.Size;
  OutputSelect = RspArray.Data[0];
  if (RspArray.Size > 1)
  {
    OutputDevice = RspArray.Data[1];
  };
  return(true);
};

//{--FP35 V2.00---}
bool __fastcall TclsFipp::GetImpulseRej(void)   //{107}
{
  return(GetValue(fipp_GetImpulseRejCmd,&ImpulseRej));
};

//{---FP35 V2.00--}
bool __fastcall TclsFipp::GetSignalInfo(void)   //{109}
{
  CmdArray.Cmd = fipp_GetSignalInfoCmd;
  CmdArray.Size = 0;
  if (GetPacket()==false) return(false);
  if (RspArray.Size > (sizeof(SignalInfo) / 2)) {
    SignalInfoSize = sizeof(SignalInfo) / 2;
  }else{
    SignalInfoSize = RspArray.Size;
  }
  FD_ByteCopy(&SignalInfo,&RspArray.Data[0],SignalInfoSize*2);
  return(true);
};


bool __fastcall TclsFipp::GetCalListData(void)   //{111}
{
  CmdArray.Cmd = fipp_GetCalListDataCmd;
  CmdArray.Size = 2;
  CmdArray.Data[0] = CalMicSelection;
  CmdArray.Data[1] = CalListSelection;
  if (GetPacket()==false) return(false);
  CalListDataSize = (WORD)(RspArray.Size+2);
  if (CalListDataSize > fipp_MaxCalListData) {
    CalListDataSize = fipp_MaxCalListData;
  }
  FD_ByteCopy(&CalListData,RspArray.Data,CalListDataSize*2);
  return(true);
};

//{---FP35 V1.00--}
bool __fastcall TclsFipp::GetRawSampleData(void)   //{110}
{
  CmdArray.Cmd = fipp_GetRawSampleDataCmd;
  CmdArray.Size = 3;
  CmdArray.Data[0] = RawDataSelection;
  CmdArray.Data[1] = RawDataMethod;
  CmdArray.Data[2] = RawSampleCount;
  if (GetPacket()==false) return(false);
  RawSamplePacketSize = (WORD)(RspArray.Size+2);
  if (RawSamplePacketSize > fipp_MaxRawSampleData) {
    RawSamplePacketSize = fipp_MaxRawSampleData;
  }
  FD_ByteCopy(&RawSampleData,&RspArray.Raw,RawSamplePacketSize*2);
  return(true);
};

//{--FP35 V2.00---}
bool __fastcall TclsFipp::GetCurveSelect(void)    //{113}
{
  return(GetValue(fipp_GetCurveSelectCmd,&CurveSelect));
};

//{--FP35 V2.00---}
bool __fastcall TclsFipp::GetCurveStatus(void)   //{115}
{
  //{GetValue(GetCurveStatusCmd,FIPPrec.CurveStatus,FIPPrec);}

  CmdArray.Cmd = fipp_GetCurveStatusCmd;
  CmdArray.Size = 1;
  CmdArray.Data[0] = CurveSelect; //{use curve select for the curve we want}
  if (GetPacket()==false) return(false);
  CurveStatus = RspArray.Data[0];
  return(true);
};

//{--FP35 V2.00---}
bool __fastcall TclsFipp::GetUnaidedSelect(void)   //{117}
{
  return(GetValue(fipp_GetUnaidedSelectCmd,&UnaidedSelect));
};

//{---FP35 V4.72--}
bool __fastcall TclsFipp::GetListData(void)   //{119}
{
  CmdArray.Cmd = fipp_GetListDataCmd;
  CmdArray.Size = 1;
  CmdArray.Data[0] = ListSelection;
  if (GetPacket()==false) return(false);
  ListDataSize = (WORD)(RspArray.Size+2);
  if (ListDataSize > fipp_MaxListData) {
    ListDataSize = fipp_MaxListData;
  }
  FD_ByteCopy(&ListData,&RspArray.Data[0],ListDataSize*2);
  return(true);
};

//{--FP35 V2.10---}
//{Note: we can only recieve a max of 2000 words at a time.}
//{reading a whole screen requires breaking it up into multiple reads}
//{if w=0 or h=0}
//{ returns bytes per scan line in Xpos, Ypos = 0, }
//{ Width is page width (pixels), Height is page height (scan lines).}
//{ if w returned as 0, it indicates the requested page is not available.}
//{ returns default style available in Style (2=mono,4=16color,8=256color)}
//{ Bitmap.Size = 0 (you have to calc the size yourself)}
//{ Bitmap.Offset = required Data offset from the start of the Bitmap record in words (10).}
//{ To calc bitmap size : s} cmd with W=0, then Bitmap Size in [bytes = Xpos*Height] }
//{ If the size if > 2000 bytes, it must be broken into multiple reads. }
bool __fastcall TclsFipp::GetBitmap(int Xpos, int Ypos, int Width, int Height, int Style, int Page)   //{120}
{
  int BSize;

  CmdArray.Cmd = fipp_GetBitmapCmd;
  CmdArray.Size = 6;
  CmdArray.Data[0] = (INT16)Style;  //style
  CmdArray.Data[1] = (INT16)Xpos;   //x pos
  CmdArray.Data[2] = (INT16)Ypos;   //y pos
  CmdArray.Data[3] = (INT16)Width;  //width  (0=get page info)
  CmdArray.Data[4] = (INT16)Height; //height
  CmdArray.Data[5] = (INT16)Page;   //page
  if (GetPacket()==false) return(false);
  BSize = RspArray.Size * 2;
  if (BSize > sizeof(FryeBitmap)) {
    BSize = sizeof(FryeBitmap);
  }
  FD_ByteCopy(&FryeBitmap,&RspArray.Data[0],BSize);
  return(true);
};

//{--FP35 V2.10---}
bool __fastcall TclsFipp::GetStaticToneSelect(void)   //{122}
{
  return(GetValue(fipp_GetStaticToneSelectCmd,&StaticToneSelect));
};

//{--FP35 V2.10---}
bool __fastcall TclsFipp::GetAidInfoSelect(void)   //{124}
{
  CmdArray.Cmd = fipp_GetAidInfoSelectCmd;
  CmdArray.Size = 0;
  if (GetPacket()==false) return(false);
  AidInfoSize = RspArray.Size; //{number items actually received}
  AidGroupSelect = RspArray.Data[0];
  if (RspArray.Size > 1)
  {
    AidTypeSelect = RspArray.Data[1];
  };
  return(true);
};

//{--FP35 V2.10---}
bool __fastcall TclsFipp::GetBiasTone(void)  // {126}
{
  CmdArray.Cmd = fipp_GetBiasToneCmd;
  CmdArray.Size = 0;
  if (GetPacket()==false) return(false);
  BiasToneSize = RspArray.Size; //{number items actually received}
  BiasToneSource = RspArray.Data[0];
  BiasToneFrequency = RspArray.Data[1];
  BiasToneDuration = RspArray.Data[2];
  return(true);
};

//{--FP35 V2.20---}
bool __fastcall TclsFipp::GetWarbleSelect(void)   //{130}
{
  CmdArray.Cmd = fipp_GetWarbleSelectCmd;
  CmdArray.Size = 0;
  if (GetPacket()==false) return(false);
  WarbleSelect = RspArray.Data[0];
  if (RspArray.Size > 1) {
    WarbleAmount = RspArray.Data[1];
  }else{
     WarbleAmount = 0;
  }
  if (RspArray.Size > 2) {
    WarbleRate = RspArray.Data[2];
  }else{
    WarbleRate = 0;
  }
  return(true);
};

//{--6500 V4.72---}
bool __fastcall TclsFipp::GetDelayMeasurments(void)   //{131}
{
  CmdArray.Cmd = fipp_GetMeasurmentDelaysCmd;
  CmdArray.Size = 0;
  if (GetPacket()==false) return(false);
  HaDelaySize = RspArray.Size;
  SystemDelay = (WORD)(RspArray.Data[0]);
  HearingAidDelay1 = (WORD)(RspArray.Data[1]);
  HearingAidDelay2 = (WORD)(RspArray.Data[2]);
  return(true);
};

//{-- new fp35 v2.20 -----}
bool __fastcall TclsFipp::GetRcvTimeout(void)    // {133}
{
   INT16 Temp;
   bool Result;
   Result = GetValue(fipp_GetRcvTimeoutCmd,&Temp);
   RcvTimeout = Temp;
   return(Result);
};


//{-- new fp35 v2.30 -----}
bool __fastcall TclsFipp::GetFitRule(void)     //{135}
{
   INT16 Temp;
   bool Result;
   Result = GetValue(fipp_GetFitRuleCmd,&Temp);
   FitRule = Temp;
   return(Result);
};

//{-- new fp35 v3.00 -----}
bool __fastcall TclsFipp::GetFilter(void)    //{137}
{
  INT16 Temp;
  bool Result;
  Result = GetValue(fipp_GetFilterCmd,&Temp);
  FilterType = Temp;
  return(Result);
};

//{--FP35 V3.00---}
bool __fastcall TclsFipp::GetCompression(void)   //{139}
{
  return(GetValue(fipp_GetCompressionCmd,&Compression));
};

//{--FP35 V3.00---}
bool __fastcall TclsFipp::GetClientAge(void)   //{141}
{
  return(GetValue(fipp_GetClientAgeCmd,&ClientAge));
};

//{--FP35 V3.10---}
bool __fastcall TclsFipp::GetTransducerLoc(void)   //{143}
{
  CmdArray.Cmd = fipp_GetTransducerLocCmd;
  CmdArray.Size = 1;
  CmdArray.Data[0] = 0; //{only speaker currently used}
  if (GetPacket()==false) return(false);
  TransducerLoc = (WORD)(RspArray.Data[0]);
  return(true);
};

//{--FP35 V5.00---}
bool __fastcall TclsFipp::DoCalAdj(void)   //{144}
{
  int OldTimer;
  bool Result;
  GetNoPoll(&OldTimer);      //{get real poll timeout value}
  PollTimer = OldTimer;      //{update current timer value}
  if (PollTimer < FIPP_SUPER_LONG_POLL_TIMEOUT)     //{If less than 60 sec}
  {
    PollTimer = FIPP_SUPER_LONG_POLL_TIMEOUT;        //{force it to 60 sec abort}
    SetNoPoll(PollTimer);
  };
  CmdArray.Cmd = fipp_DoCalAdjCmd;
  CmdArray.Data[0] = CalAdjValue;
  //special case handling for top cal screen (do sys cal)
  if ((MajorMachineState == 32) && (MinorMachineState == 0))
  {
    CmdArray.Size = 1;  //{always size of one for this}
    Result = DoFippCmd(FCOM_ACK_OK, FIPP_NO_POLL_UNCHANGED);
  }

  else //otherwise mic sens adjustment cmd is done if in other screens
  {
    CmdArray.Size = CalAdjCmdSize;  //{make sure you set this for what you want to do!}
    CmdArray.Data[0] = CalAdjSelect;
    CmdArray.Data[1] = CalAdjValue;
    Result = DoFippCmd(FCOM_ACK_OK, FIPP_NO_POLL_UNCHANGED);
    //returns adjustment result as response
    if (RspArray.Size > 0) {
      CalAdjValue = (WORD)(RspArray.Data[0]);
    }else{
      CalAdjValue = 0;
    }

  };
  PollTimer = OldTimer;
  SetNoPoll(PollTimer);      //{restore original poll timeout value}
  return(Result);
};


//{-------}
bool __fastcall TclsFipp::GetLevelingList(void)  // {146}
{
  //WORD CurveFormat;
  WORD ByteSize;

  CmdArray.Cmd = fipp_GetLevelingListCmd;
  CmdArray.Size = 2;
  CmdArray.Data[0] = WhichListChannel;
  CmdArray.Data[1] = WhichLevelingList;
  if (GetPacket()==false) return(false);
  LevelingListSize = RspArray.Size;
  ByteSize = (INT16)(LevelingListSize*2);
  if (ByteSize > sizeof(LevelingList))
  {
    ByteSize = sizeof(LevelingList);
    LevelingListSize = (INT16)(ByteSize / 2);
  };
  FD_ByteFill(&LevelingList,0,sizeof(LevelingList));
  FD_ByteCopy(&LevelingList,RspArray.Data,ByteSize);
  return(true);
};

//{--FP35 V3.20---}
bool __fastcall TclsFipp::GetAuxPort(void)   //{149}
{
  CmdArray.Cmd = fipp_GetAuxPortCmd;
  CmdArray.Size = 1;
  CmdArray.Data[0] = 0x0101;
  if (GetPacket()==false) return(false);
  AuxCtrl = (WORD)(RspArray.Data[0]);
  if (RspArray.Size > 1)
  {
    FD_ByteFill(AuxInData,0,sizeof(AuxInData));
    AuxInCount = RspArray.Data[1];
    if (AuxInCount > 0) {
      FD_ByteCopy(&AuxInData,&RspArray.Data[2],AuxInCount);
    }
  };
  return(true);
};


//{--FP35 V3.20---}
bool __fastcall TclsFipp::GetUserNumber(void)   //{151}
{
  CmdArray.Cmd = fipp_GetUserNumberCmd;
  CmdArray.Size = 0;
  if (GetPacket()==false) return(false);
  UserNumber = (WORD)(RspArray.Data[0]);
  if (RspArray.Size > 1) {
    MaxUser = RspArray.Data[1];
  }
  return(true);
};

//{-- new FP35 V3.20 -----}
bool __fastcall TclsFipp::GetFitType(void)    // {153} {fp35 v3.20 12/01/03}
{
   return(GetValue(fipp_GetFitTypeCmd,&Fit.AidFitType));
};

//{-- new FP35 V3.20 -----}
bool __fastcall TclsFipp::GetVentType(void)    //{155} {fp35 v3.20 12/01/03}
{
   return(GetValue(fipp_GetVentTypeCmd,&Fit.AidVentType));
};

//{-- new FP35 V3.20 -----}
bool __fastcall TclsFipp::GetTubingType(void)    //{157} {fp35 v3.20 12/01/03}
{
   return(GetValue(fipp_GetTubingTypeCmd,&Fit.AidTubingType));
};

//{-- new FP35 V3.20 -----}
bool __fastcall TclsFipp::GetAidChannels(void)    //{159} {fp35 v3.20 12/01/03}
{
   return(GetValue(fipp_GetAidChannelsCmd,&Fit.AidChannels));
};

//{-- new FP35 V3.20 -----}
bool __fastcall TclsFipp::GetAidLimiting(void)    //{161} {fp35 v3.20 12/01/03}
{
   return(GetValue(fipp_GetAidLimitingCmd,&Fit.AidLimiting));
};

//{-- new FP35 V3.70 -----}
bool __fastcall TclsFipp::GetRefMethod(void)    //{163} {fp35 v3.70 06/06/06}
{
   return(GetValue(fipp_GetRefMethodCmd,&Fit.RefMethod));
};


//{-- new FP35 V3.20 -----}
bool __fastcall TclsFipp::GetFitParam(void)    //{165} {fp35 v3.20 12/01/03}
{
  CmdArray.Cmd = fipp_GetFitParamCmd;
  CmdArray.Size = 0;
  if (GetPacket()==false) return(false);
  if (RspArray.Size > (sizeof(Fit) / 2)) {
    FitCount = sizeof(Fit) / 2;
  }else{
    FitCount = RspArray.Size;
  }
  FD_ByteCopy(&Fit,RspArray.Data,FitCount*2);
  return(true);
};

//{-- new FP35 V3.20 -----}
bool __fastcall TclsFipp::GetUserIDText(void)  //{167}
{
  int i;
  if (UserNumber > 15) {
    UserNumber = 0;
  }
  CmdArray.Cmd = fipp_GetUserIDTextCmd;
  CmdArray.Size = 1;
  CmdArray.Data[0] = UserNumber;
  if (GetPacket()==false) return(false);
  i = 0;
  while (i < FIPP_MAX_USERID_TEXT)  //MaxUserIDTextSize do
  {
    UserIDText[UserNumber][i] = char(RspArray.Raw[(i >> 1)+2] >> 8);
    UserIDText[UserNumber][(i+1)] = char(RspArray.Raw[(i >> 1)+2] & 0xff);
    i = i+2;
  };
  UserIDText[UserNumber][(FIPP_MAX_USERID_TEXT-1)] = 0; //{force last byte to null}
  return(true);
};



//{-- new FP35 V3.30 -----}
bool __fastcall TclsFipp::GetSkew(void)    //{169} {fp35 v3.30 07/01/04}
{
  CmdArray.Cmd = fipp_GetSkewCmd;
  CmdArray.Size = 1;
  CmdArray.Data[0] = WhichSkew;
  if (GetPacket()==false) return(false);
  Skew = RspArray.Data[0];
  return(true);
};



//{-- new FP35 V3.40 -----}
bool __fastcall TclsFipp::GetScreenMode(void)    //{171} {fp35 v3.40 08/20/04}
{
  CmdArray.Cmd = fipp_GetScreenModeCmd;
  CmdArray.Size = 0;
  if (GetPacket()==false) return(false);
  if (RspArray.Size > 1)
  {
    LcdMode = RspArray.Data[0];
    VgaPalette = RspArray.Data[1];
    VgaOption = true;
  }else{
    LcdMode = RspArray.Data[0];
    VgaOption = false;
  };
  return(true);
};


//{-- new FP35 V3.50 -----}
bool __fastcall TclsFipp::GetCouplerSelection(void)    //{173} {fp35 v3.50 12/16/04}
{
  CmdArray.Cmd = fipp_GetCouplerSelectionCmd;
  CmdArray.Size = 0;
  if (GetPacket()==false) return(false);
  CouplerSelection = RspArray.Data[0];
  return(true);
};


//{-- new FP35 V3.60 -----}
bool __fastcall TclsFipp::GetAnalysisSelection(void)   // {175} {fp35 v3.60 06/12/06}
{
  CmdArray.Cmd = fipp_GetAnalysisSelectionCmd;
  CmdArray.Size = 0;
  if (GetPacket()==false) return(false);
  AnalysisSelection = RspArray.Data[0];
  return(true);
};


//{FP40 does not support cmd 179, 7000/8000 use two parameters}
//{FP35 uses five parameters, 6500/6400 do not have this command}
//{FP35 returns BatterySize and BatteryMAH as invalid data}
bool __fastcall TclsFipp::GetBatteryInfo(void)    //{179}
{
  CmdArray.Cmd = fipp_GetBatteryInfoCmd;
  CmdArray.Size = 0;
  BatteryInfoSize = 0;
  //BatteryType := INVALID_DATA16; //{leave battery type alone}
  BatterySize = INVALID_DATA16; // {init battery values before reading}
  BatteryMAH = INVALID_DATA16;
  BatteryVolt = INVALID_DATA16;
  BatteryImp = INVALID_DATA16;
  if (GetPacket()==false) return(false);
  BatteryInfoSize = RspArray.Size; //{save how many items we read}
  if (BatteryInfoSize >= 1)
  {
    BatteryType = RspArray.Data[0];
  };
  if (BatteryInfoSize >= 2)
  {
    BatterySize = RspArray.Data[1]; //{7000/8000 format}
  };
  if (BatteryInfoSize >= 3)
  {
    BatteryMAH = RspArray.Data[2];
  };
  if (BatteryInfoSize >= 4)
  {
    BatteryVolt = RspArray.Data[3];
  };
  if (BatteryInfoSize >= 5)
  {
    BatteryImp = RspArray.Data[4];
  };
  return(true);
};


//{-------}
bool __fastcall TclsFipp::GetStoredParameter(void)   ///  {181}
{
  CmdArray.Cmd = fipp_GetStoredParameterCmd;
  CmdArray.Size = 1;
  CmdArray.Data[0] = StoredParameterNumber; //{SavedItemNumber;}
  if (GetPacket()==false) return(false);
  if (RspArray.Size > 1)
  {
    StoredParameterNumber = RspArray.Data[0];
    StoredParameterValue = RspArray.Data[1];
  };
  return(true);
};


bool __fastcall TclsFipp::GetCurveGroupSelect(void)   //{183} {8000}
{
  return(GetValue(fipp_GetCurveGroupSelectCmd,&CurveGroupSelect));
};

//{--------}
bool __fastcall TclsFipp::GetAgcFreqSelect(void)     //{185}
{
  bool Result;
  if ((AgcFreqSelectSize < 0) || (AgcFreqSelectSize > 3))
  {
    AgcFreqSelectSize = 2; //fixup size if error
  };
  CmdArray.Cmd = fipp_GetAgcFreqSelectCmd;
  CmdArray.Size = AgcFreqSelectSize;
  CmdArray.Data[0] = AgcFreqSelect;
  CmdArray.Data[1] = AgcFreqEnable;
  CmdArray.Data[2] = AgcFreqIndex;
  if (GetPacket()==false) return(false);
  AgcFreqSelectSize = RspArray.Size;
  AgcFreqSelect = RspArray.Data[0];
  AgcFreqEnable = RspArray.Data[1];
  AgcFreqIndex = RspArray.Data[2];
  Result = true;
  return(Result);
};

//{-------}
bool __fastcall TclsFipp::GetInputPortSelect(void)    //{187} {FP35}
{
  return(GetValue(fipp_GetInputPortSelectCmd,&InputPortSelect));
};

//{-------}
bool __fastcall TclsFipp::GetAngleSelect(void)    ///{189} {8000}
{
  return(GetValue(fipp_GetAngleSelectCmd,&AngleSelect));
};


//{-------}
bool __fastcall TclsFipp::GetDiffFreq(void)    //{191}
{
  bool Result = false;
  CmdArray.Cmd = fipp_GetDiffFreqCmd;
  CmdArray.Size = 0;
  if (GetPacket()==false) return(Result);
  DiffFreq = RspArray.Data[0];
  DiffFreqRspSize = RspArray.Size;
  if (RspArray.Size > 1)
  {
    SweepEndFreq = RspArray.Data[1];
  };
  Result = true;
  return(Result);
};

//{------}
bool __fastcall TclsFipp::GetUserMode(void)     //{193} {FP35}
{
  return(GetValue(fipp_GetUserModeCmd,&UserMode));
};



//{+++++++++}
//{The following procedures handle the standard FIPP Do commands}

//{-------}
//{SendDoCmd is used for most of the Do functions since they all pass}
//{a single integer value. Makes it much simpler.}
bool __fastcall TclsFipp::SendDoCmd(WORD DoCmd)
{
  CmdArray.Cmd = DoCmd;
  CmdArray.Size = 0;
  if (DoPacket()==false) return(false);
  return(true);
};


//{++++++}
//{Do cmds - return true if everything went ok. }
//{false if not (error in FippError)}


//{-------}
//{Assumes that the desired state has been stored to RelAttState.}
//{Note: Must be called with RelAttState "0" to exit this mode.}

bool __fastcall TclsFipp::DoRelAttSelect(void)  //  {13}
{
     int OldTimer;
     bool Result;

     GetNoPoll(&OldTimer);      //{get real poll timeout value}
     PollTimer = OldTimer;      //{update current timer value}
     if (PollTimer < FIPP_EXTRA_LONG_POLL_TIMEOUT)   //{If less than 30 seconds}
     {
       PollTimer = FIPP_EXTRA_LONG_POLL_TIMEOUT;        //{force it to 30 seconds abort}
       SetNoPoll(PollTimer);
     };
     Result = false;
     CmdArray.Cmd = fipp_DoRelAttSelectCmd;
     CmdArray.Size = 1;
     CmdArray.Data[0] = (WORD)(RelAttState);
     if (DoPacket()==true) {
       Result = true;
     }
     PollTimer = OldTimer;
     SetNoPoll(PollTimer);      //{restore original poll timeout value}
     return(Result);
};

//{-------}
//{Assumes that the desired state has been stored to IOState.}
//{Note: Must be called with IOState "0" to exit this mode.}

bool __fastcall TclsFipp::DoIOSelect(void)     //{15}
{
  int OldTimer;
  bool Result = false;

  GetNoPoll(&OldTimer);      //{get real poll timeout value}
  PollTimer = OldTimer;      //{update current timer value}
  if (PollTimer < FIPP_LONG_POLL_TIMEOUT)     //{If less than 15 seconds}
  {
    PollTimer = FIPP_LONG_POLL_TIMEOUT;        //{force it to 15 seconds abort}
    SetNoPoll(PollTimer);
  };
  CmdArray.Cmd = fipp_DoIOSelectCmd;
  CmdArray.Size = 1;
  CmdArray.Data[0] = (WORD)(IOState);
  if (DoPacket()==false) {
    Result = false;
  }
  PollTimer = OldTimer;
  SetNoPoll(PollTimer);      //{restore original poll timeout value}
  return(Result);
};

//{-------}
//{note: since the sweep can take an excessive time this command forces the}
//{timeout value to two minutes unless it is equal to or greater than that}

bool __fastcall TclsFipp::DoTest(void)    //{16}
{
  int OldTimer;
  bool Result;

  GetNoPoll(&OldTimer);      //{get real poll timeout value}
  PollTimer = OldTimer;      //{update current timer value}
  if (PollTimer < FIPP_SUPER_LONG_POLL_TIMEOUT)   // {If less than two minutes}
  {
    PollTimer = FIPP_SUPER_LONG_POLL_TIMEOUT;   //     {force it to two minute abort}
    SetNoPoll(PollTimer);
  };
  Result = SendDoCmd(fipp_DoTestCmd);  //{do the sweep}
  PollTimer = OldTimer;
  SetNoPoll(PollTimer);      //{restore original poll timeout value}
  return(Result);
};

//{-------}
bool __fastcall TclsFipp::DoLevel(void)       // {17}
{
  int OldTimer;
  bool Result;

  GetNoPoll(&OldTimer);      //{get real poll timeout value}
  PollTimer = OldTimer;     // {update current timer value}
  if (PollTimer < FIPP_SUPER_LONG_POLL_TIMEOUT)    //{If less than two minutes}
  {
    PollTimer = FIPP_SUPER_LONG_POLL_TIMEOUT;        //{force it to two minute abort}
    SetNoPoll(PollTimer);
  };
  CmdArray.Cmd = fipp_DoLevelCmd;
  CmdArray.Size = 0;
  Result = DoFippCmd(FCOM_ACK_OK, FIPP_NO_POLL_UNCHANGED);
  PollTimer = OldTimer;
  SetNoPoll(PollTimer);
  return(Result);
};

//{-------}
bool __fastcall TclsFipp::DoReset(void)       // {38}
{
     int OldTimer, OldResp;
     bool Result;

     GetNoPoll(&OldTimer);      //{get real poll timeout value}
     PollTimer = OldTimer;     // {update current timer value}
     OldResp = GetRespTimeout();    //  {get real resp timeout value}
     RespTimer = (INT16)OldResp;
     if (PollTimer < FIPP_SUPER_LONG_POLL_TIMEOUT)    // {If less than two minutes}
     {
       PollTimer = FIPP_SUPER_LONG_POLL_TIMEOUT;      //  {force it to two minute abort}
       SetNoPoll(PollTimer);
     };
/*     if RespTimer < (100) then    {If less than 5 seconds}
     {
       RespTimer := (100);        {force it to 5 seconds abort}
       SetRespTimer(FIPPrec);
     };
*/
     Result = SendDoCmd(fipp_DoResetCmd);
     PollTimer = OldTimer;
     SetNoPoll(PollTimer);
     //RespTimer := OldResp;
//     SetRespTimer(FIPPrec);      {restore original resp timeout value}
   return(Result);
};

//{-------}
//{special 6500 version of SetPower (DoSleep) command}
//{Note: if sleep status = 2 does not verify cmd because it can't }
//{The DoSleep command is for the 6500 only}
//{the 6500 DoSleep command has no parameters.}
bool __fastcall TclsFipp::DoSleep(void)       // {56} {6500 only}
{
  return(SendDoCmd(fipp_DoSleepCmd));
};

//{-------}
//{note: if Power status is 2, the instrument is in deep sleep mode (hibernate)}
//{and will not respond most commands. The FP40 will not respond at all}
//{since the only way to get it back is to _physically_ turn it back on.}
//{If power Status is 1, the intrument is in sleep mode (screen saver) }
//{and will normally automatically wake up on commands that require it to be awake.}
//{SetPower, GetPower, GetVersion, GetCmdStatus and Reset are always available.}
bool __fastcall TclsFipp::SetPower(void)           //{56}  {Others (ie not 6500)}
{
  int OldTimer;
  bool Result = false;

  GetNoPoll(&OldTimer);        //{get real poll timeout value}
  PollTimer = OldTimer;      //{update current timer value}
  CmdArray.Cmd = fipp_SetPowerCmd;

  if (PollTimer < (FIPP_DEFAULT_NO_POLL))   //{If less than 5 seconds}
  {
    PollTimer = (FIPP_DEFAULT_NO_POLL);    //    {force it to 5 seconds abort}
    SetNoPoll(PollTimer);
  };

  //Does the instrument support the screen saver setting?
  if (PowerCmdSize == 2)
  {
    CmdArray.Size = 2;
    CmdArray.Data[0] = (WORD)(PowerState);
    CmdArray.Data[1] = (WORD)(StandbyTimeout);
    if (DoFippCmd(FCOM_ACK_OK,PollTimer)==true) {
      Result = true;
    }
  }

  //Does it support power down time?
  else if (PowerCmdSize > 2)
  {
    CmdArray.Size = 3;
    CmdArray.Data[0] = (WORD)(PowerState);
    CmdArray.Data[1] = (WORD)(StandbyTimeout);
    CmdArray.Data[2] = (WORD)(PowerDownTimeout);
    if (DoFippCmd(FCOM_ACK_OK,PollTimer) == true) {
      Result = true;
    }
  }

  //for anything else, fall back to default of one parameter
  else
  {
    CmdArray.Size = 1;
    CmdArray.Data[0] = (WORD)(PowerState);
    if (DoFippCmd(FCOM_ACK_OK,PollTimer)==true) {
      Result = true;
    }
  };

  //if power status is 2 or higher, quick terminate may not work
  //because the instrument may be powered down already.
  if (PowerState < 2)
  {
    QuickTerminate(Callback);
  };

  PollTimer = OldTimer;
  SetNoPoll(PollTimer);      //{restore original poll timeout value}
  return(Result);
};

//{-- new v2.6x -----}
bool __fastcall TclsFipp::DoLineFeeds(void)     //  {64}
{
  //int OldResp;
  int OldTimer;
  bool Result = false;

  GetNoPoll(&OldTimer);      //{get real poll timeout value}
  PollTimer = OldTimer;      //{update current timer value}
//  GetRespTimer();      {get real resp timeout value}
//  OldResp := RespTimer;
  if (PollTimer < FIPP_SUPER_LONG_POLL_TIMEOUT)    //{If less than 30 seconds}
  {
    PollTimer = FIPP_SUPER_LONG_POLL_TIMEOUT;        //{force it to 30 seconds abort}
    SetNoPoll(PollTimer);
  };
//  if RespTimer < (100) then    {If less than 5 seconds}
//  {
//    RespTimer := (100);        {force it to 5 seconds abort}
//    SetRespTimer();
//  };

  CmdArray.Cmd = fipp_DoLineFeedsCmd;
  CmdArray.Size = 1;
  CmdArray.Data[0] = (WORD)(PrintFeeds);
  if (DoPacket()==true) {
    Result = true;
  }
  PollTimer = OldTimer;
  SetNoPoll(PollTimer);      //{restore original poll timeout value}
  //RespTimer := OldResp;
  //SetRespTimer();      {restore original resp timeout value}
  return(Result);
};


//{-- new v2.6x -----}
bool __fastcall TclsFipp::DoPrint(void)         //  {65}
{
  //int OldResp;
  int OldTimer;
  bool Result = false;

  GetNoPoll(&OldTimer);    //  {get real poll timeout value}
  PollTimer =OldTimer;     // {update current timer value}
//  GetRespTimer();      //{get real resp timeout value}
//  OldResp := RespTimer;
  if (PollTimer < FIPP_SUPER_LONG_POLL_TIMEOUT)   //{If less than 60 seconds}
  {
    PollTimer = FIPP_SUPER_LONG_POLL_TIMEOUT;       // {force it to 60 seconds abort}
    //SetNoPoll(PollTimer);
  };
//  if RespTimer < (100) then    {If less than 5 seconds}
//  {
//    RespTimer := (100);        {force it to 5 seconds abort}
//    SetRespTimer();
//  };

  CmdArray.Cmd = fipp_DoPrintCmd;
  CmdArray.Size = 1;
  CmdArray.Data[0] = (WORD)(PrintControl);
  if (DoFippCmd(FCOM_ACK_OK,PollTimer)==true) {
    Result = true;
  }
  QuickTerminate(Callback);
  PollTimer = OldTimer;
  SetNoPoll(PollTimer);      //{restore original poll timeout value}
//  RespTimer = OldResp;
//  SetRespTimer();      //{restore original resp timeout value}
  return(Result);
};



//{-------}
bool __fastcall TclsFipp::DoError(void)  //{67}
{
  CmdArray.Cmd = fipp_DoErrorCmd;
  return(DoFippCmd(FCOM_ACK_OK,FIPP_NO_POLL_UNCHANGED));
};



//{---6500 V4.14--}
bool __fastcall TclsFipp::DoMeasurement(void)  ///{85}
{
  int OldTimer,OldResp;
  INT32 STime;
  bool Valid = false;
//  bool Result = false;

  STime = DoMeasureSettleTime / 55;
  GetNoPoll(&OldTimer);       //{get real poll timeout value}
  PollTimer = OldTimer;      //{update current timer value}
  if (PollTimer < (FIPP_STD_POLL_TIMEOUT+STime))      //{If less than 5+settle seconds}
  {
    PollTimer = (FIPP_STD_POLL_TIMEOUT+STime);    //{force it to 5+settle seconds abort}
    SetNoPoll(PollTimer);
  };
  OldResp = GetRespTimeout();      //{get real resp timeout value}
  RespTimer = (INT16)OldResp;
  if (FonixHwVersion.InstrumentBaseType == FONIX_6500)
  {
     if (RespTimer < (FIPP_STD_POLL_TIMEOUT+STime))   //{If less than 5+settle seconds}
     {
       RespTimer = (INT16)(FIPP_STD_POLL_TIMEOUT+STime);    //    {force it to 5+settle seconds abort}
       SetRespTimeout(RespTimer);
     };
  };
  CmdArray.Cmd = fipp_DoMeasurementCmd;
  CmdArray.Size = 3;
  CmdArray.Data[0] = (WORD)(Frequency);
  CmdArray.Data[1] = (WORD)(SourceAmp);
  CmdArray.Data[2] = (WORD)(DoMeasureSettleTime);

  if (GetPacket() == true) //{we need a response from this one}
  {
    MeasureMicData = (INT16)(RspArray.Data[0]);
    Valid = true;
  };
  PollTimer = OldTimer;
  SetNoPoll(PollTimer);     // {restore original poll timeout value}
  if (FonixHwVersion.InstrumentBaseType == FONIX_6500)
  {
    RespTimer = (INT16)OldResp;
    SetRespTimeout(RespTimer);      //{restore original resp timeout value}
  };

  if ((Verify == true)&& (Valid == true)) {
    if (CommandStatusOK()==false) return(false);
  }
  return(Valid);
};


bool __fastcall TclsFipp::DoCustomTest(void)     //{176}
{
   int OldTimer;
   bool Result;

   GetNoPoll(&OldTimer);        //{get real poll timeout value}
   PollTimer = OldTimer;      //{update current timer value}
   if (PollTimer < FIPP_SUPER_LONG_POLL_TIMEOUT)    //{if less than two minutes}
   {
     PollTimer = FIPP_SUPER_LONG_POLL_TIMEOUT;      //{force it to two minute abort}
     SetNoPoll(PollTimer);
   };
   CmdArray.Cmd = fipp_DoCustomTestCmd;
   Result = DoFippCmd(FCOM_ACK_OK,FIPP_NO_POLL_UNCHANGED);  //{do the test}
   PollTimer = OldTimer;
   SetNoPoll(PollTimer);      //{restore original poll timeout value}
   return(Result);
};


bool __fastcall TclsFipp::DoParameterSave(void)    // {177}
{
  CmdArray.Cmd = fipp_DoParameterSaveCmd;
  CmdArray.Size = 1;
  CmdArray.Data[0] = ParameterSaveHow;
  return(SetPacket());
};


bool __fastcall TclsFipp::DoTarget(void)    // {178}
{
  return(SendDoCmd(fipp_DoTargetCmd));  //{do the test}
};

//{----------------}
bool __fastcall TclsFipp::SetFonixBaudrate(void)   //{31747}
{
  bool Result;

  CmdArray.Cmd = fipp_SetFonixBaudrateCmd;
  CmdArray.Size = 1;
  CmdArray.Data[0] = (INT16)(NewBaudrate / 10);
  Result = DoFippCmd(FCOM_ACK_OK, FIPP_DEFAULT_NO_POLL);
  if (Result == false) return(false);
  //{do a quick terminate to release the instrument so it can change the baudrate}
  ReleaseCmd(); //{but ignore any errors.}
  if (Verify == true)
  {
    Result = CommandStatusOK();  //check on the command status if required
  };
  return(Result);
};


//{==============================================================================}


//{ ********** }
//{initialization section}

//{
  //Fipp := __fastcall TclsFipp::Create();
  //Fipp := __fastcall TclsFipp::Create();
//  new(RawSampleData);
//  new(DeviceDataArray);
//  new(AuxInData);
//  new(AuxOutData);
//}.


