//---------------------------------------------------------------------------
//FippUnit.H as of 10 Oct 2010 by Michael Day
//Frye Instrument Packet Protocol interface header
//Copyright Frye Electronics 2010
//You may use this code for any lawful purpose without fees or royalties.
//This code is intended as an example showing how to communicate with Fonix
//equipment using the Fryers.DLL device driver on the Windows operating system.
//No warranties are express or implied in the use of this code.
//---------------------------------------------------------------------------
#ifndef FippUnitH
#define FippInitH
//---------------------------------------------------------------------------
#include "FryeRegs.h"
#include "FcomDefs.h"
#include "FippDefs.h"

//typedef FCOM_TfcCallback FC_tCallback;

class TclsFipp : public TclsFippCore {
//    SavePictureDialog1: TSavePictureDialog; //used to save bitmap images to a file as BMPs

    public:
//    private:
      int OldPacketTimer;
      FCOM_TfcCallback Callback;

    //function definitions
    __fastcall TclsFipp();  //my constructor call

      void __fastcall SetRespTimeout(INT16 Value);
      INT16 __fastcall GetRespTimeout(void);
      int  __fastcall GetPacketTickRes(void);
      bool __fastcall DoFippCmd(int NoAck, int NoPollTimeout);

//        MemImage : TBitmap;

        bool Verify;  //{verify cmds with cmd stat chk}
        bool DoubleCheck;  //{double check set values}
        bool Autobaud;
        bool BaudSeek;
        bool AGCaid;  //{aid type}
        bool UseAvgFreqValues; //{true = refer to avg/dist freq values not selection}
        bool CmdStatusFailed;
        int PacketStatus;
        int PacketControl;
        int PollErrorCount;
          WORD PollDelayCount;
          WORD PollDelay;   //{poll delay time}
          WORD PollHoldoff;   //{poll hold off time}
          WORD RcvTimeout;   //{instrument receive timeout}
          WORD RespTimer;   //{response timeout tick count}
          int PollTimer;   //{poll timeout tick count}
          int FippError; //{last known FIPP command/response status}
          //StatAX      : word;   {PacketStatus ext}ed status info}
          //StatBX      : word;
          //StatCX      : word;
          //StatDX      : word;
          WORD PacketTickTimeMS;
          WORD PacketTickMultMS;
        INT16 CmdStatus;  //{result of last cmdstatus check}
          int NewBaudrate;
        INT16 RelAttState;
        INT16 RelAttFreq;
        INT16 AttackTime;
        INT16 ReleaseTime;
         INT16 BatteryInfoSize; //{number of params read by GetBattInfo (cmd:179)}
         INT16 BatteryFormat;  //{number of params to s} (cmd:79) 1=one, 2=two, 5=five}
         INT16 BatteryTestEnable;
          INT16 BatteryCurrent;
          INT16 BatteryType;
          INT16 BatteryVolt;
          INT16 BatteryImp;
          INT16 BatterySize;
          INT16 BatteryMAH;
        INT16 DistMode;
        INT16 DistPercent;
          INT16 Frequency;
          INT16 SourceAmp;
          INT16 MicData;
          INT16 RefMicData;
          INT16 AvgMicAmp;
          INT16 LimitValue;
         INT16 AvgStartTime;
         INT16 AvgSettleTime;
        INT16 SettleCmdSize; //{0=old style, 1=new style}
        INT16 FreqSettleTime;
        INT16 AmpSettleTime;
        INT16 MeasureStartTime;
         INT16 IoAmpSettleTime;
         INT16 IoStartDelayTime;
           INT16 BurstOnTime;
         INT16 DoMeasureSettleTime;
          INT16 CalAdjValue;
          INT16 CalAdjSelect;
          INT16 CalAdjCmdSize;
          INT16 MeasureMicData;
        INT16 LevelState;
        INT16 LevelDirection;
        INT16 AdvLevelStatus;
        INT16 LevelMaxSpl;
        INT16 AnalysisMode; //{0=spl fft, 1=gain, 2=3rd oct : was GainState}
        INT16 WeightState;  //{obsolete}
        INT16 SmoothState;
        INT16 ProbeState;  //{obsolete}
        INT16 SourceMethod;  //{was telcoilstate}
        INT16 TelCoilMode;
        INT16 OESstate;  //{obsolete}
        INT16 CICstate;  //{obsolete}
        INT16 CouplerSelection;
        INT16 ZetaState;   //{obsolete}
        INT16 AutoState;
        INT16 AutoStepDuration;
        INT16 AutoStateSize;
        INT16 SrcType;
        INT16 RefMicState;
        INT16 TestEar;
        INT16 EarConfig;
         INT16 ControlLock;
         INT16 KeyScanCode;
        INT16 AvgFreqs;
        WORD OutputDeviceSize;
        INT16 OutputSelect;
        INT16 OutputDevice;
        bool CurveSelectValid;
        INT16 CurveSelect;
        INT16 CurveStatus;
        INT16 UnaidedSelect;
        WORD SystemDelay;
        WORD HaDelaySize;
        WORD HearingAidDelay1;
        WORD HearingAidDelay2;
          INT16 FitRule;
          INT16 FilterType;
          INT16 Compression;
          INT16 ClientAge;

        WORD PrinterSelector;
        WORD PrinterLabelStorage;
        WORD PrinterSetup;
        WORD PrintDarkness;
        WORD PrintInfoCount;
        INT16 PrintControl;
        INT16 PrintFeeds;

          INT16 WarbleSelect;
          INT16 WarbleAmount;
          INT16 WarbleRate;
          INT16 BiasToneSize;
          INT16 BiasToneSource;
          INT16 BiasToneFrequency;
          INT16 BiasToneDuration;
        INT16 MajorMachineState;
        INT16 MinorMachineState;
        INT16 ActiveStatus;

         WORD PowerCmdSize;         //how many words rcvd in the power cmd (80)
         INT16 PowerState;
         INT16 StandbyTimeout;  //screen saver timeout
         INT16 PowerDownTimeout;  //power down timeout
         INT16 PowerVoltage;       //FP40 battery voltage
         WORD PowerFlags;           //power control flags

        bool VgaOption;
        INT16 LcdMode;
        INT16 VgaPalette;
          INT16 WhichSkew;
          INT16 Skew;
        INT16 ImpulseRej;
          INT16 RefTestGain;
          INT16 EqInNoise;
          INT16 NoiseRedCount;
            INT16 FAvgF1;     //{the three frequencies}
            INT16 FAvgF2;     //{HFA/SPA averaging}
            INT16 FAvgF3;
           INT16 HFAData;     //{HFA measurment data}
        INT16 CurveGroupSelect;
          WORD IoModeCount;  //{number of words used in IO mode command}
          INT16 IOState;
          INT16 IOFrequency;
          INT16 IOGain;
           INT16 IOStartMs;
           INT16 IOSweepMs;
         WORD BlobSize;
         WORD TestParametersSize;
         WORD LabelType;
         WORD LabelLines;
         WORD LastIdDevice;
         WORD DeviceIDNumber;
         WORD DeviceSelection;
         WORD DeviceDataSize;
         WORD RawDataSelection;
         WORD RawSampleCount;
         WORD RawDataMethod;
         WORD RawSamplePacketSize;
         WORD ListDataSize;
         WORD ListSelection;
         WORD AuxInCount;
         WORD AuxOutCount;
         WORD AuxCtrl;
         WORD AuxStartCtrl;
         WORD AuxEndCtrl;
           INT16 UserMode;
          INT16 UserNumber;
          INT16 MaxUser;
         INT16 ParameterSaveHow;
         INT16 StoredParameterNumber;
         INT16 StoredParameterValue;
        INT16 StaticToneSelect;
        INT16 AidTypeSelect;
        INT16 AidGroupSelect;
        INT16 AidInfoSize;
        INT16 TransducerLoc;
        INT16 AnalysisSelection;
          INT16 FitCount;
        //{SavedItemNumber : SmallInt;}
        //{SavedParameter : SmallInt; }
        INT16 CurveNumber;
        INT16 CurveFrameSize;
        tCurveFrame CurveFrame;  //temp working storage for curve frames
        INT16 IOcurve[10];
        WORD Insitu[3];   //{type of Insitu conversion}  {obsolete}
          INT16 AgcFreqSelectSize;
          INT16 AgcFreqSelect;
          INT16 AgcFreqEnable;
          INT16 AgcFreqIndex;
            INT16 InputPortSelect;
         INT16 AngleSelect;
         INT16 DiffFreqRspSize;
         INT16 DiffFreq;
         INT16 SweepEndFreq;
        WORD WhichLevelingList;
        WORD WhichListChannel;
        WORD LevelingListSize;
        FIPP_tLevelingList LevelingList;
        INT16 CalMicSelection;
        INT16 CalListSelection;
        WORD CalListDataSize;
        FIPP_tCalListData CalListData;

        WORD FonixVersionSize; //{how many words were returned in the get version call (28)}
        FIPP_tVersionArray FonixVersionArray; //{raw data copied from cmd 28 response}
        FIPP_tMachineVersion FonixHwVersion;  //{copy of current known version structure}
        FIPP_tStdLabelArray StdLabelData;   //{2d pchar array to place label data in}
        FIPP_tExtLabelArray ExtLabelData; //ExtLabelDataType; {2d pchar array to place ext label data in}
        FIPP_tUserIDText UserIDText[FIPP_MAX_USER_ID+1]; //{UserID text 2d pchar arrays (one per user, 16 max)}
        FIPP_tRTC_Time RealTimeClockData; //RealTimeClockRec; {array to place real time clock data}
        int InstrumentInfoSize;        //number of words used in Instrument Info record
        FIPP_tInstrumentInfo InstrumentInfo;   //{record of instrument information}
        AvgFreqValuesRec AvgFreqValues; //{record of averaging freqs and dist freqs}
        WORD SignalInfoSize;
        SignalInfoRec SignalInfo;   //{record of signal info data}
        FIPP_tStatusMsg StatusMsg;   //{array to place status msg in}
        FIPP_tSpectrumArray Spectrum; //{array to put spectrum data in}
        FIPP_tPhaseArray PhaseTable;  //{array to put phase data in}
        FIPP_tBlobArray Blob;   //{array to stuff blob data in}
        FitRecordType Fit;   //{record to stuff fit info into}
        FIPP_tTestParametersArray TestParameters; //{array to stuff option data in}
        FIPP_tARparams ARparams;    //{array for attack and release parameters}
        FD_tDeviceID LongDeviceID; //LongDeviceIDRec; {array to stuff long device ID in}
        FIPP_tAuxDataArray AuxInData; //{array to stuff raw aux data}
        FIPP_tAuxDataArray AuxOutData; //{array to stuff raw aux data}
        FIPP_tDeviceDataArray DeviceDataArray; //{array to stuff device data in}
        FIPP_tFryeBitmap FryeBitmap; //{Frye bitmap array used for graphics}
        FIPP_tRawSampleData RawSampleData; //{array to stuff raw sample data}
        FIPP_tListData ListData; //{array to stuff list data}

        FCOM_TfcArray CsCmdArray;     //Special cmd array for cmd status check
        FCOM_TfcArray CsRspArray;     //Special rsp array for cmd status check

        void __fastcall ClearPacketTimer(void);
        WORD __fastcall GetPacketTimer(void);  //get packet timer value in ms (55ms resolution)
        void __fastcall ConvertLabelToSend(int Size, pchar LabelData);
        void __fastcall ConvertUserIDToSend(bool ExtID, int Size, pchar IDText);
        void __fastcall ConvertLabelFromRcv(int Size, pchar LabelData);
        void __fastcall GetUserIDFromRcv(bool ExtID, int Size, pchar IDText);
        //procedure BuildMemoryImageMap(MemImgW:integer; MemImgH:integer);

        void __fastcall SetCallback(FCOM_TfcCallback MyCallback);
        bool __fastcall SendCmd(void);
        bool __fastcall SetPacket(void);
        bool __fastcall GetPacket(void);
        bool __fastcall DoPacket(void);
        bool __fastcall CommandStatusOK(void);
        bool __fastcall SetValue(WORD SetCmd, WORD GetCmd, INT16* ValueToSet);
        bool __fastcall GetValue(WORD GetCmd, INT16* ValueToGet);



        //{------- FIPP commands ------}
        //{these are the high-level functions to communicate to the tester}
        //{all data is passed in the Fipp object. Set cmds should preset the proper}
        //{variable before issuing a command. Get cmds will return the requested}
        //{information in the appropriate variable. Do cmds will cause the tester}
        //{to perform the requested action. If Verify is on the tester is polled}
        //{to see if it accepted the cmd. If DoubleCheck is on the resulting value}
        //{in the tester after a set cmd is reloaded back into the appropriate}
        //{variable. All commands return true if everything went ok. All commands}
        //{return false if a problem occured. The specific error can be found}
        //{in FippError. If needed, further information on the error can be}
        //{found in PortStatus}
        bool __fastcall ReleaseCmd(void);   //{7fff}
        bool __fastcall SetSourceAmp(void); //{0}
        bool __fastcall SetDistMode(void);  //{1}
        bool __fastcall SetFrequency(void); //{2}
        bool __fastcall SetOESstate(void);   //{3}  {obsolete}
        bool __fastcall SetNoiseRedCount(void);  //{4}
        bool __fastcall SetSmoothState(void);// {5}
        bool __fastcall SetStdLabel(void);    //{6}  {obsolete}
        bool __fastcall SetProbeState(void);    // {7}  {obsolete}
        bool __fastcall SetWeightState(void); //{8}  {obsolete}
        bool __fastcall SetCurveFrame(void); //{9}
        bool __fastcall SetIOmode(void);      //{10}
        bool __fastcall SetSourceMethod(void);   //  {11} {was SetTelcoilState}
        bool __fastcall SetAnalysisMode(void);   // {12} {was SetGainState}
        bool __fastcall SetBatteryTest(void);    //  {14}
        bool __fastcall SetTelCoilMode(void);    // {39}
        bool __fastcall SetRelAttFreq(void);   // {40}
        bool __fastcall SetZetaState(void);    //{43}  {obsolete}
        bool __fastcall SetInsitu(void);     // {47}   {obsolete}
        bool __fastcall SetAutoState(void);   // {48}
        bool __fastcall SetLimitValue(void);  //  {50}
        bool __fastcall SetRefMicState(void); //   {52}
        bool __fastcall SetActiveStatus(void); //   {54}
        bool __fastcall SetPower(void);         //  {56}
        bool __fastcall SetMachineState(void);  // {59}
        bool __fastcall SetControlLock(void);   //  {62}
        bool __fastcall SetExtendedLabel(void); // {66}
        bool __fastcall SetSpectrum(void);    //   {68}
        bool __fastcall SetPhaseTable(void);  //   {69}
        bool __fastcall SetTestParameters(void); //  {70}
        bool __fastcall SetKeyScanCode(void);     //   {72}
        bool __fastcall SetPollDelay(void);    //    {73}
        bool __fastcall SetTestEar(void);      //  {75}
        bool __fastcall SetSrcType(void);   // {77}
        bool __fastcall SetBatteryType(void);  //      {79}
        bool __fastcall SetAvgFreqs(void);      //  {82}
        bool __fastcall SetSettleTime(void);  //{84} {new verison}
        bool __fastcall SetCICstate(void);   //{88}
        bool __fastcall SetPrinterLabelStorage(void); //  {89}
        bool __fastcall SetAvgDelayTime(void);   //{90}
        bool __fastcall SetPrinterSelect(void);  // {92}
        bool __fastcall SetBitmap(void);   //{96}
        bool __fastcall SetARparams(void);    //   {97}
        bool __fastcall SetBlob(void);          // {99}
        bool __fastcall SetRealTimeClock(void);  // {104}
        bool __fastcall SetOutputDevice(void); //{106}
        bool __fastcall SetImpulseRej(void); //{108}
        bool __fastcall SetCurveSelect(void); //{112}
        bool __fastcall SetCurveStatus(void); //{114}
        bool __fastcall SetUnaidedSelect(void); //{116}
        bool __fastcall SetListData(void);   //{118}
        bool __fastcall SetStaticToneSelect(void); //{121}
        bool __fastcall SetAidInfoSelect(void); //{123}
        bool __fastcall SetBiasTone(void); //{125}
        bool __fastcall SetWarbleSelect(void); //{129}
        bool __fastcall SetRcvTimeout(void);     //   {132}
        bool __fastcall SetFitRule(void);        //{134}
        bool __fastcall SetFilter(void);     //   {136}
        bool __fastcall SetCompression(void); //{138}
        bool __fastcall SetClientAge(void); //{140}
        bool __fastcall SetTransducerLoc(void); //{142}
        bool __fastcall SetLevelingList(void);    //   {145}
        bool __fastcall SetLevelingStatus(void); //{147}
        bool __fastcall SetAuxPort(void);     //{148}
        bool __fastcall SetUserNumber(void); //{150}
        bool __fastcall SetFitType(void);    //{152} {fp35 v3.20 12/01/03}
        bool __fastcall SetVentType(void);    //{154} {fp35 v3.20 12/01/03}
        bool __fastcall SetTubingType(void);   // {156} {fp35 v3.20 12/01/03}
        bool __fastcall SetAidChannels(void);   // {158} {fp35 v3.20 12/01/03}
        bool __fastcall SetAidLimiting(void);    //{160} {fp35 v3.20 12/01/03}
        bool __fastcall SetRefMethod(void);   // {162} {fp35 v3.70 06/06/06}
        bool __fastcall SetFitParam(void);    //{164} {fp35 v3.20 12/01/03}
        bool __fastcall SetUserIDText(void);  //{166}
        bool __fastcall SetSkew(void);    //{168} {fp35 v3.30 07/01/04}
        bool __fastcall SetScreenMode(void);   // {170}
        bool __fastcall SetCouplerSelection(void);   // {172} {fp35 v3.50 12/16/04}
        bool __fastcall SetAnalysisSelection(void);  //  {174} {fp35 v3.60 06/12/06}
        bool __fastcall SetStoredParameter(void);    //   {180}
        bool __fastcall SetCurveGroupSelect(void);   // {182}
        bool __fastcall SetAgcFreqSelect(void);   // {184}
        bool __fastcall SetInputPortSelect(void);  //  {186}
        bool __fastcall SetAngleSelect(void);   // {188}
        bool __fastcall SetDiffFreq(void);   // {190}
        bool __fastcall SetUserMode(void);   // {192}

        bool __fastcall GetRelAttData(void);      //{18}
        bool __fastcall GetBatteryData(void);     //{19}
        bool __fastcall GetIOdata(void);      //{20}
        bool __fastcall GetSourceAmp(void);   //{21}
        bool __fastcall GetDistMode(void);   // {22}
        bool __fastcall GetFrequency(void);  // {23}
        bool __fastcall GetOESstate(void);   //{24}  {obsolete}
        bool __fastcall GetCurveFrame(void);  //{25}
        bool __fastcall GetNoiseRedCount(void); //   {26}
        bool __fastcall GetSmoothState(void); //{27}
        bool __fastcall GetFonixVersion(void);  //    {28}
        bool __fastcall GetLevelState(void);  //{29}
        bool __fastcall GetWeightState(void); //{30}   {obsolete}
        bool __fastcall GetMicData(void);       //{31}
        bool __fastcall GetDistPercent(void);    //{32}
        bool __fastcall GetCmdStatus(void);    //{33}
        bool __fastcall GetIOmode(void);       //{34}
        bool __fastcall GetProbeState(void);    //{35}   {obsolete}
        bool __fastcall GetAnalysisMode(void);   //{36}  {was GetGainState}
        bool __fastcall GetSourceMethod(void); //{37}    {was GetTelcoilState}
        bool __fastcall GetRelAttFreq(void);  //  {41}
        bool __fastcall GetLastCurve(void);    // {42}
        bool __fastcall GetTelCoilMode(void); //{44}
        bool __fastcall GetZetaState(void);   // {45}   {obsolete}
        bool __fastcall GetInsitu(void);      // {46}   {obsolete}
        bool __fastcall GetAutoState(void);   // {49}
        bool __fastcall GetLimitValue(void);   // {51}
        bool __fastcall GetRefMicState(void);   // {53}
        bool __fastcall GetActiveStatus(void);   // {55}
        bool __fastcall GetRefMicData(void);     //  {57}
        bool __fastcall GetKeyScanCode(void);     //   {58}
        bool __fastcall GetMachineState(void);  // {60}
        bool __fastcall GetBlob(void);           //{61}
        bool __fastcall GetControlLock(void);   //  {63}
        bool __fastcall GetTestParameters(void); //  {71}
        bool __fastcall GetPollDelay(void);    // {74}
        bool __fastcall GetTestEar(void);    // {76}
        bool __fastcall GetSrcType(void);    //{78}
        bool __fastcall GetPowerStatus(void);  // {80}
        bool __fastcall GetAvgFreqs(void);    // {81}
        bool __fastcall GetSettleTime(void);    // {83}
        bool __fastcall GetExtendedLabel(void); // {86}
        bool __fastcall GetCICstate(void);  // {87}
        bool __fastcall GetAvgDelayTime(void);  // {91}
        bool __fastcall GetPrinterSelect(void);  // {93}
        bool __fastcall GetHFAMeasurement(void);  // {94}
        bool __fastcall GetInstrumentInformation(void); //  {95}
        bool __fastcall GetARparams(void);    //   {98}
        bool __fastcall GetLastIdDevice(void);  // {100}
        bool __fastcall GetLongDeviceID(void);//   {101}
        bool __fastcall GetDeviceData(void);  // {102}
        bool __fastcall GetRealTimeClock(void); //  {103}
        bool __fastcall GetOutputDevice(void);  // {105}
        bool __fastcall GetImpulseRej(void); //  {107}
        bool __fastcall GetSignalInfo(void);  // {109}
        bool __fastcall GetRawSampleData(void); //  {110}
        bool __fastcall GetCalListData(void);  // {111}
        bool __fastcall GetCurveSelect(void);  // {113}
        bool __fastcall GetCurveStatus(void);  // {115}
        bool __fastcall GetUnaidedSelect(void);  // {117}
        bool __fastcall GetListData(void);  // {119}
        bool __fastcall GetBitmap(int Xpos, int Ypos, int Width, int Height, int Style, int Page); //  {120}
        bool __fastcall GetStaticToneSelect(void);   //{122}
        bool __fastcall GetAidInfoSelect(void);  // {124}
        bool __fastcall GetBiasTone(void);   //{126}
        bool __fastcall GetWarbleSelect(void);  // {130}
        bool __fastcall GetDelayMeasurments(void);  // {131}
        bool __fastcall GetRcvTimeout(void);  //   {133}
        bool __fastcall GetFitRule(void);     //{135}
        bool __fastcall GetFilter(void);     //{137}
        bool __fastcall GetCompression(void);  // {139}
        bool __fastcall GetClientAge(void);   //{141}
        bool __fastcall GetTransducerLoc(void);  // {143}
        bool __fastcall GetLevelingList(void);  //{146}
        bool __fastcall GetAuxPort(void);   //{149}
        bool __fastcall GetUserNumber(void);  // {151}
        bool __fastcall GetFitType(void);   // {153} {fp35 v3.20 12/01/03}
        bool __fastcall GetVentType(void);    //{155} {fp35 v3.20 12/01/03}
        bool __fastcall GetTubingType(void);  //  {157} {fp35 v3.20 12/01/03}
        bool __fastcall GetAidChannels(void); //   {159} {fp35 v3.20 12/01/03}
        bool __fastcall GetAidLimiting(void); //   {161} {fp35 v3.20 12/01/03}
        bool __fastcall GetRefMethod(void);   // {163} {fp35 v3.70 06/06/06}
        bool __fastcall GetFitParam(void);   // {165} {fp35 v3.20 12/01/03}
        bool __fastcall GetUserIDText(void); // {167}
        bool __fastcall GetSkew(void);    //{169} {fp35 v3.30 07/01/04}
        bool __fastcall GetScreenMode(void);  //  {171} {fp35 v3.40 08/20/04}
        bool __fastcall GetCouplerSelection(void);  //  {173} {fp35 v3.50 12/16/04}
        bool __fastcall GetAnalysisSelection(void);  //  {175} {fp35 v3.60 06/12/06}
        bool __fastcall GetBatteryInfo(void);    //{179}
        bool __fastcall GetStoredParameter(void);  //  {181}
        bool __fastcall GetCurveGroupSelect(void);   // {183}
        bool __fastcall GetAgcFreqSelect(void);    //{185}
        bool __fastcall GetInputPortSelect(void); //   {187}
        bool __fastcall GetAngleSelect(void);  //  {189}
        bool __fastcall GetDiffFreq(void);   // {191}
        bool __fastcall GetUserMode(void);    //{193}

        bool __fastcall SendDoCmd(WORD DoCmd);
        bool __fastcall DoRelAttSelect(void);  //{13}
        bool __fastcall DoIOSelect(void);  //{15}
        bool __fastcall DoTest(void);     //{16}
        bool __fastcall DoLevel(void);        //{17}
        bool __fastcall DoReset(void);        //{38}
        bool __fastcall DoSleep(void);        //{56}
        bool __fastcall DoLineFeeds(void);       //{64}
        bool __fastcall DoPrint(void);           //{65}
        bool __fastcall DoError(void);        //{67}
        bool __fastcall DoMeasurement(void);  //{85}
        bool __fastcall DoCustomTest(void);     //{176}
        bool __fastcall DoParameterSave(void);  //{177}
        bool __fastcall DoTarget(void);         //{178}
        bool __fastcall DoCalAdj(void);       //{144}

        bool __fastcall SetFonixBaudrate(void); //{31747}

    //-------------------------------
    //constructor Create;
    //destructor Destroy; override;

     };

//var Fipp : TclsFipp; //object is declared elsewhere

//{-------}
//{These are the current possible FIPP commands that are available}
//{state=target is in a condition where other commands are affected}
//{example: probestate=on means that only probe cmds will work}
//{mode=an option under which a specific __fastcall changes operation}
//{example:distortion mode=0 only affects how distortion is measured.}
//{These ae used by the Fipp __fastcalls to perform the associated command.}
const fipp_SetSourceAmpCmd     = 0;
const fipp_SetDistModeCmd      = 1;
const fipp_SetFrequencyCmd     = 2;
const fipp_SetOESstateCmd      = 3;   //{obsolete}
const fipp_SetNoiseRedCountCmd = 4;
const fipp_SetSmoothStateCmd   = 5;
const fipp_SetStdLabelCmd      = 6;
const fipp_SetProbeStateCmd    = 7;   //{obsolete}
const fipp_SetWeightStateCmd   = 8;   //{obsolete}
const fipp_SetCurveFrameCmd    = 9;
const fipp_SetIOmodeCmd        = 10;
const fipp_SetSourceMethodCmd  = 11; //{was SetTelCoilStateCmd}
const fipp_SetAnalysisModeCmd  = 12; //{was SetGainState}
const fipp_DoRelAttSelectCmd   = 13;
const fipp_SetBatteryTestCmd   = 14;
const fipp_DoIOSelectCmd       = 15;
const fipp_DoTestCmd           = 16;
const fipp_DoLevelCmd          = 17;
const fipp_GetRelAttDataCmd    = 18;
const fipp_GetBatteryDataCmd   = 19;
const fipp_GetIOdataCmd        = 20;
const fipp_GetSourceAmpCmd     = 21;
const fipp_GetDistModeCmd      = 22;
const fipp_GetFrequencyCmd     = 23;
const fipp_GetOESstateCmd      = 24;  //{obsolete}
const fipp_GetCurveFrameCmd    = 25;
const fipp_GetNoiseRedCountCmd = 26;
const fipp_GetSmoothStateCmd   = 27;
const fipp_GetFonixVersionCmd    = 28;
const fipp_GetLevelingStatusCmd= 29;
const fipp_GetWeightStateCmd   = 30;
const fipp_GetMicDataCmd       = 31;
const fipp_GetDistPercentCmd   = 32;
const fipp_GetCmdStatusCmd     = 33;
const fipp_GetIOmodeCmd        = 34;
const fipp_GetProbeStateCmd    = 35;  //{obsolete}
const fipp_GetAnalysisModeCmd  = 36;  //{was GetGainState}
const fipp_GetSourceMethodCmd  = 37;  //{was GetTelCoilStateCmd}
const fipp_DoResetCmd          = 38;
const fipp_SetTelCoilModeCmd   = 39;
const fipp_SetRelAttFreqCmd    = 40;
const fipp_GetRelAttFreqCmd    = 41;
const fipp_GetLastCurveCmd     = 42;
const fipp_SetZetaStateCmd     = 43;  //{obsolete}
const fipp_GetTelCoilModeCmd   = 44;
const fipp_GetZetaStateCmd     = 45;  //{obsolete}
const fipp_GetInsituCmd        = 46;  //{obsolete}
const fipp_SetInsituCmd        = 47;  //{obsolete}
const fipp_SetAutoStateCmd     = 48;
const fipp_GetAutoStateCmd     = 49;
const fipp_SetLimitValueCmd    = 50;
const fipp_GetLimitValueCmd    = 51;
const fipp_SetRefMicStateCmd   = 52;
const fipp_GetRefMicStateCmd   = 53;
const fipp_SetActiveStatusCmd  = 54;
const fipp_GetActiveStatusCmd  = 55;
const fipp_DoSleepCmd          = 56; //{6500 only}
const fipp_GetRefMicDataCmd    = 57;
const fipp_GetKeyScanCodeCmd   = 58;
const fipp_SetMachineStateCmd  = 59;
const fipp_GetMachineStateCmd  = 60;
const fipp_GetBlobCmd          = 61;
const fipp_SetControlLockCmd    = 62;
const fipp_GetControlLockCmd    = 63;
const fipp_DoLineFeedsCmd      = 64;
const fipp_DoPrintCmd          = 65;
const fipp_SetExtendedLabelCmd = 66;
const fipp_DoErrorCmd          = 67;
const fipp_SetSpectrumCmd      = 68;
const fipp_SetPhaseTableCmd    = 69;
const fipp_SetTestParametersCmd  = 70;
const fipp_GetTestParametersCmd  = 71;
const fipp_SetKeyScanCodeCmd   = 72;
const fipp_SetPollDelayCmd     = 73;
const fipp_GetPollDelayCmd     = 74;
const fipp_SetTestEarCmd       = 75;  //{fp40}
const fipp_GetTestEarCmd       = 76;  //{fp40}
const fipp_SetSrcTypeCmd       = 77;  //{fp40}
const fipp_GetSrcTypeCmd       = 78;  //{fp40}
const fipp_SetPowerCmd         = 56;
const fipp_SetBatteryTypeCmd   = 79;  //{fp40}
const fipp_GetPowerStatusCmd   = 80;  //{fp40}
const fipp_GetAvgFreqsCmd      = 81;
const fipp_SetAvgFreqsCmd      = 82;
const fipp_GetSettleTimeCmd    = 83;
const fipp_SetSettleTimeCmd    = 84;
const fipp_GetExtendedLabelCmd = 86;
const fipp_GetCICstateCmd      = 87;
const fipp_SetCICstateCmd      = 88;
const fipp_SetPrinterLabelStorageCmd = 89;
const fipp_DoMeasurementCmd    = 85;  //{6500 v4.14}
const fipp_SetAvgDelayCmd      = 90;  //{6500 v4.14}
const fipp_GetAvgDelayCmd      = 91;  //{6500 v4.14}
const fipp_SetPrinterSelectCmd   = 92;  //{6500 v4.20}
const fipp_GetPrinterSelectCmd   = 93;  //{6500 v4.20}
const fipp_GetHFAMeasurementCmd = 94; //{6500 V4.40}

const fipp_GetInstrumentInfoCmd      = 95;  //{FP35 V2.00}
const fipp_SetBitmapCmd             = 96;  //{FP35 V1.10}
const fipp_SetARparamsCmd             = 97;  //{6500 V4.50}
const fipp_GetARparamsCmd             = 98;  //{6500 V4.50}
const fipp_SetBlobCmd                = 99;  //{FP35 V1.21}
const fipp_GetLastIdDeviceCmd        = 100; //{FP35 V1.00}
const fipp_GetLongDeviceIDCmd        = 101; //{FP35 V1.00}
const fipp_GetDeviceDataCmd          = 102; //{FP35 V1.20}
const fipp_GetRealTimeClockCmd       = 103; //{FP35 V1.10}
const fipp_SetRealTimeClockCmd       = 104; //{FP35 V1.10}
const fipp_GetOutputDeviceCmd        = 105; //{FP35 V2.00/V2.20enh}
const fipp_SetOutputDeviceCmd        = 106; //{FP35 V2.00/V2.20enh}
const fipp_GetImpulseRejCmd          = 107; //{FP35 V2.00}
const fipp_SetImpulseRejCmd          = 108; //{FP35 V2.00}
const fipp_GetSignalInfoCmd          = 109; //{FP35 V2.00}
const fipp_GetRawSampleDataCmd       = 110; //{FP35 V1.10}
const fipp_GetCalListDataCmd         = 111; //{FP35 V2.00}
const fipp_SetCurveSelectCmd         = 112; //{FP35 V2.00}
const fipp_GetCurveSelectCmd         = 113; //{FP35 V2.00}
const fipp_SetCurveStatusCmd         = 114; //{FP35 V2.00}
const fipp_GetCurveStatusCmd         = 115; //{FP35 V2.00}
const fipp_SetUnaidedSelectCmd       = 116; //{FP35 V2.00}
const fipp_GetUnaidedSelectCmd       = 117; //{FP35 V2.00}
const fipp_SetListDataCmd            = 118; //{FP35 V4.72}
const fipp_GetListDataCmd            = 119; //{FP35 V4.72}
const fipp_GetBitmapCmd              = 120; //{FP35 V2.10}
const fipp_SetStaticToneSelectCmd    = 121; //{FP35 V2.10}
const fipp_GetStaticToneSelectCmd    = 122; //{FP35 V2.10}
const fipp_SetAidInfoSelectCmd       = 123; //{FP35 V2.10}
const fipp_GetAidInfoSelectCmd       = 124; //{FP35 V2.10}
const fipp_SetBiasToneCmd            = 125;
const fipp_GetBiasToneCmd            = 126;
//const      {cmd 127 <reserved>}
//const      {cmd 128 <reserved>}
const fipp_SetWarbleSelectCmd       = 129; //{FP35 V2.20}
const fipp_GetWarbleSelectCmd       = 130; //{FP35 V2.20}
const fipp_GetMeasurmentDelaysCmd   = 131; //{6500 V4.72}
const fipp_SetRcvTimeoutCmd        = 132;
const fipp_GetRcvTimeoutCmd        = 133;
const fipp_SetFitRuleCmd          = 134;  //{FP35 V2.30}
const fipp_GetFitRuleCmd          = 135;  //{FP35 V2.30}
const fipp_SetFilterCmd        = 136;  //{FP35 V3.00}
const fipp_GetFilterCmd        = 137;  //{FP35 V3.00}
const fipp_SetCompressionCmd   = 138;  //{FP35 V3.00}
const fipp_GetCompressionCmd   = 139;  //{FP35 V3.00}
const fipp_SetClientAgeCmd     = 140;  //{FP35 V3.00}
const fipp_GetClientAgeCmd     = 141;  //{FP35 V3.00}
const fipp_SetTransducerLocCmd = 142;  //{FP35 V3.10}
const fipp_GetTransducerLocCmd = 143;  //{FP35 V3.10}
const fipp_DoCalAdjCmd = 144;           //{FP35 V5.00}
const fipp_SetLevelingListCmd = 145;  //{FP35 V3.20}
const fipp_GetLevelingListCmd = 146;  //{FP35 V3.20}
const fipp_SetLevelingStatusCmd = 147;  //{FP35 V3.20}
const fipp_SetAuxPortCmd = 148;        //{FP35 V3.20}
const fipp_GetAuxPortCmd = 149;        //{FP35 V3.20}
const fipp_SetUserNumberCmd = 150;        //{FP35 V3.20}
const fipp_GetUserNumberCmd = 151;        //{FP35 V3.20}

const fipp_SetFitTypeCmd = 152;        //{FP35 V3.20}
const fipp_GetFitTypeCmd = 153;        //{FP35 V3.20}
const fipp_SetVentTypeCmd = 154;       //{FP35 V3.20}
const fipp_GetVentTypeCmd = 155;       //{FP35 V3.20}
const fipp_SetTubingTypeCmd = 156;     //{FP35 v3.20}
const fipp_GetTubingTypeCmd = 157;     //{FP35 V3.20}
const fipp_SetAidChannelsCmd = 158;    //{FP35 V3.20}
const fipp_GetAidChannelsCmd = 159;    //{FP35 V3.20}
const fipp_SetAidLimitingCmd = 160;    //{FP35 V3.20}
const fipp_GetAidLimitingCmd = 161;    //{FP35 V3.20}
const fipp_SetRefMethodCmd = 162;     //{FP35 v3.70}
const fipp_GetRefMethodCmd = 163; //{FP35 v3.70}

const fipp_SetFitParamCmd = 164;       //{FP35 v3.20}
const fipp_GetFitParamCmd = 165;       //{FP35 v3.20}
const fipp_SetUserIDTextCmd = 166;     //{FP35 V3.20}
const fipp_GetUserIDTextCmd = 167;     //{FP35 V3.20}
const fipp_SetSkewCmd = 168;     //{FP35 V3.30}
const fipp_GetSkewCmd = 169;     //{FP35 V3.30}
const fipp_SetScreenModeCmd = 170;       //{FP35 v3.40}
const fipp_GetScreenModeCmd = 171;       //{FP35 v3.40}
const fipp_SetCouplerSelectionCmd = 172;     //{FP35 V3.50}
const fipp_GetCouplerSelectionCmd = 173;     //{FP35 V3.50}
const fipp_SetAnalysisSelectionCmd = 174;     //{FP35 V3.60}
const fipp_GetAnalysisSelectionCmd = 175;     //{FP35 V3.60}
const fipp_DoCustomTestCmd    = 176; //{FP35 V3.60}
const fipp_DoParameterSaveCmd = 177; //{FP35 V3.60}
const fipp_DoTargetCmd        = 178; //{FP35 V3.70}
const fipp_GetBatteryInfoCmd  = 179;

const fipp_SetStoredParameterCmd = 180;     //{FP35 V3.70}
const fipp_GetStoredParameterCmd = 181;     //{FP35 V3.70}

const fipp_SetCurveGroupSelectCmd = 182;     //{8000}
const fipp_GetCurveGroupSelectCmd = 183;     //{8000}
const fipp_SetAgcFreqSelectCmd = 184;     //{7000}
const fipp_GetAgcFreqSelectCmd = 185;     //{7000}
const fipp_SetInputPortSelectCmd = 186;   //{FP35}
const fipp_GetInputPortSelectCmd = 187;   //{FP35}

const fipp_SetAngleSelectCmd = 188;  //{8000}
const fipp_GetAngleSelectCmd = 189;  //{8000}
const fipp_SetDiffFreqCmd = 190;  //{FP35}
const fipp_GetDiffFreqCmd = 191;  //{FP35}
const fipp_SetUserModeCmd = 192;  //{FP35}
const fipp_GetUserModeCmd = 193;  //{FP35}

const fipp_SetFonixBaudrateCmd = 31747;  //{0x7c03}
const fipp_QuickTerminateCmd   = 0x7fff;

//{ *********** }

#endif

