
{Frye Instrument Packet Protocol (FIPP) interface test unit}
{This unit is used to communicate with Frye intstruments}
{that use the FIPP packet protocol}
{Copyright 1994,2010 Frye Electronics}
{Version 5.22  Written by Michael Day  20 Sep 2010}
{This units was written in Borland Delphi V3.00.}
{It should compile with later versions with little or no changes.}
{4-30-04 (med) fixed cmd 9 : was using stale crv size data}
{23Aug04 (med) added rs232 code for skew and screenmode cmds}
{12 Dec 04 -med - added cmds 172 and 173}
{12 Jun 06 -med - added cmds 175->181, modified cmds 14,19 and 79}
{5 Feb 2008 - med - added ability to access up to 99 port with new fryers driver V5.20}
{20 Sep 2010 - med - converted from msdos format to Windows - added new cmds since last update}

unit FippUnit;
interface
uses {Windows, Graphics,} BitRev, FryeDefs, Fryers, FippDefs, FCErrMsg, FippCore, FcomDefs, FryeComD, FryeTools;

type TclsFipp = class(TclsFippCore)
//    SavePictureDialog1: TSavePictureDialog; //used to save bitmap images to a file as BMPs

    private
      OldPacketTimer : integer;
      Callback:FC_tCallback;

      procedure SetRespTimeout(Value:INT16);
      function GetRespTimeout:INT16;
      function GetPacketTickRes:integer;
      function DoFippCmd(NoAck:integer; NoPollTimeout:integer):boolean;

    public
//        MemImage : TBitmap;
        PortMethod  : smallint; {method of operation on the port (demand/polled)}
        Verify      : boolean;  {verify cmds with cmd stat chk}
        DoubleCheck : boolean;  {double check set values}
        Autobaud    : boolean;
        BaudSeek    : boolean;
        AGCaid      : boolean;  {aid type}
        UseAvgFreqValues : boolean; {true = refer to avg/dist freq values not selection}
        CmdStatusFailed : boolean;
        PacketStatus : integer;
        PacketControl : integer;
        PollErrorCount : integer;
          PollDelayCount : word;
          PollDelay   : word;   {poll delay time}
          PollHoldoff : word;   {poll hold off time}
          RcvTimeout  : word;   {instrument receive timeout}
          RespTimer   : word;   {response timeout tick count}
          PollTimer   : integer;   {poll timeout tick count}
          FippError    : integer; {last known FIPP command/response status}
          //StatAX      : word;   {PacketStatus extended status info}
          //StatBX      : word;
          //StatCX      : word;
          //StatDX      : word;
          PacketTickTimeMS : word;
          PacketTickMultMS : word;
        CmdStatus       : Smallint;  {result of last cmdstatus check}
          NewBaudrate : integer;
        RelAttState     : Smallint;
        RelAttFreq      : Smallint;
        AttackTime      : Smallint;
        ReleaseTime     : Smallint;
         BatteryInfoSize : Smallint; {number of params read by GetBattInfo (cmd:179)}
         BatteryFormat   : Smallint; {number of params to send (cmd:79) 1=one, 2=two, 5=five}
         BatteryTestEnable : Smallint;
          BatteryCurrent : Smallint;
          BatteryType    : Smallint;
          BatteryVolt    : Smallint;
          BatteryImp     : Smallint;
          BatterySize    : Smallint;
          BatteryMAH     : Smallint;
        DistMode    : Smallint;
        DistPercent : Smallint;
          Frequency  : Smallint;
          SourceAmp  : Smallint;
          MicData    : Smallint;
          RefMicData : Smallint;
          AvgMicAmp  : Smallint;
          LimitValue : Smallint;
         AvgStartTime   : Smallint;
         AvgSettleTime  : Smallint;
        SettleCmdSize   : Smallint; {0=old style, 1=new style}
        FreqSettleTime   : Smallint;
        AmpSettleTime    : Smallint;
        MeasureStartTime : Smallint;
         IoAmpSettleTime  : Smallint;
         IoStartDelayTime : Smallint;
           BurstOnTime  : smallint;
         DoMeasureSettleTime  : Smallint;
          CalAdjValue : Smallint;
          CalAdjSelect : smallint;
          CalAdjCmdSize : smallint;
          MeasureMicData : Smallint;
        LevelState    : Smallint;
        LevelDirection : SmallInt;
        AdvLevelStatus : SmallInt;
        LevelMaxSpl    : SmallInt;
        AnalysisMode  : Smallint; {0=spl fft, 1=gain, 2=3rd oct : was GainState}
        WeightState   : Smallint;  {obsolete}
        SmoothState   : Smallint;
        ProbeState    : Smallint;  {obsolete}
        SourceMethod  : Smallint;  {was telcoilstate}
        TelCoilMode   : Smallint;
        OESstate      : Smallint;  {obsolete}
        CICstate      : Smallint;  {obsolete}
        CouplerSelection : Smallint;
        ZetaState     : Smallint;   {obsolete}
        AutoState     : Smallint;
        AutoStepDuration : Smallint;
        AutoStateSize : Smallint;
        SrcType       : Smallint;
        RefMicState   : Smallint;
        TestEar       : Smallint;
        EarConfig     : Smallint;
         ControlLock  : Smallint;
         KeyScanCode  : Smallint;
        AvgFreqs   : Smallint;
        OutputDeviceSize : word;
        OutputSelect : Smallint;
        OutputDevice : Smallint;
        CurveSelectValid : boolean;
        CurveSelect : Smallint;
        CurveStatus : Smallint;
        UnaidedSelect : Smallint;
        SystemDelay : word;
        HaDelaySize : word;
        HearingAidDelay1 : word;
        HearingAidDelay2 : word;
          FitRule : Smallint;
          FilterType : Smallint;
          Compression : Smallint;
          ClientAge   : Smallint;

        PrinterSelector : word;
        PrinterLabelStorage : word;
        PrinterSetup : word;
        PrintDarkness : word;
        PrintInfoCount : word;
        PrintControl      : Smallint;
        PrintFeeds        : Smallint;

          WarbleSelect : Smallint;
          WarbleAmount : Smallint;
          WarbleRate : Smallint;
          BiasToneSize : Smallint;
          BiasToneSource : Smallint;
          BiasToneFrequency : Smallint;
          BiasToneDuration : Smallint;
        MajorMachineState : Smallint;
        MinorMachineState : Smallint;
        ActiveStatus      : Smallint;

         PowerCmdSize : word;         //how many words rcvd in the power cmd (80)
         PowerState       : Smallint;
         StandbyTimeout    : Smallint;  //screen saver timeout
         PowerDownTimeout  : Smallint;  //power down timeout
         PowerVoltage : Smallint;       //FP40 battery voltage
         PowerFlags   : word;           //power control flags

        VgaOption : boolean;
        LcdMode : Smallint;
        VgaPalette : Smallint;
          WhichSkew : Smallint;
          Skew : Smallint;
        ImpulseRej   : Smallint;
          RefTestGain   : Smallint;
          EqInNoise     : Smallint;
          NoiseRedCount : Smallint;
            FAvgF1    : Smallint;     {the three frequencies}
            FAvgF2    : Smallint;     {HFA/SPA averaging}
            FAvgF3    : Smallint;
           HFAData    : Smallint;     {HFA measurment data}
        CurveGroupSelect : Smallint;
          IoModeCount : word;  {number of words used in IO mode command}
          IOState       : Smallint;
          IOFrequency   : Smallint;
          IOGain        : Smallint;
           IOStartMs     : Smallint;
           IOSweepMs     : Smallint;
         BlobSize   : word;
         TestParametersSize : word;
         LabelType  : word;
         LabelLines : word;
         LastIdDevice : word;
         DeviceIDNumber : word;
         DeviceSelection : word;
         DeviceDataSize : word;
         RawDataSelection : word;
         RawSampleCount : word;
         RawDataMethod : word;
         RawSamplePacketSize : word;
         ListDataSize : word;
         ListSelection : word;
         AuxInCount : word;
         AuxOutCount : word;
         AuxCtrl      : word;
         AuxStartCtrl : word;
         AuxEndCtrl   : word;
           UserMode : smallint;
          UserNumber : Smallint;
          MaxUser    : Smallint;
         ParameterSaveHow : Smallint;
         StoredParameterNumber : Smallint;
         StoredParameterValue : Smallint;
        StaticToneSelect : Smallint;
        AidTypeSelect : Smallint;
        AidGroupSelect : Smallint;
        AidInfoSize : smallint;
        TransducerLoc : Smallint;
        AnalysisSelection : SmallInt;
          FitCount : SmallInt;
        {SavedItemNumber : SmallInt;}
        {SavedParameter : SmallInt; }
        CurveNumber : Smallint;
        CurveFrameSize : Smallint;
        CurveFrame : tCurveFrame;  //temp working storage for curve frames
        IOcurve    : array [0..9] of smallint;
        Insitu     : array [0..2] of word;   {type of Insitu conversion}  {obsolete}
          AgcFreqSelectSize : smallint;
          AgcFreqSelect : smallint;
          AgcFreqEnable : smallint;
          AgcFreqIndex : smallint;
            InputPortSelect : smallint;
         AngleSelect : smallint;
         DiffFreqRspSize : smallint;
         DiffFreq    : smallint;
         SweepEndFreq : smallint;
        WhichLevelingList : word;
        WhichListChannel : word;
        LevelingListSize : word;
        LevelingList : FIPP_tLevelingList;
        CalMicSelection : smallint;
        CalListSelection : smallint;
        CalListDataSize : word;
        CalListData : FIPP_tCalListData;

        FonixVersionSize : word; {how many words were returned in the get version call (28)}
        FonixVersionArray : FIPP_tVersionArray; {raw data copied from cmd 28 response}
        FonixHwVersion : FIPP_tMachineVersion;  {copy of current known version structure}
        StdLabelData  : FIPP_tStdLabelArray;   {2d pchar array to place label data in}
        ExtLabelData  : FIPP_tExtLabelArray; //ExtLabelDataType; {2d pchar array to place ext label data in}
        UserIDText : array[0..FIPP_MAX_USER_ID] of FIPP_tUserIDText; {UserID text 2d pchar arrays (one per user, 16 max)}
        RealTimeClockData : FIPP_tRTC_Time; //RealTimeClockRec; {array to place real time clock data}
        InstrumentInfoSize : integer;        //number of words used in Instrument Info record
        InstrumentInfo : FIPP_tInstrumentInfo;   {record of instrument information}
        AvgFreqValues : AvgFreqValuesRec; {record of averaging freqs and dist freqs}
        SignalInfoSize : word;
        SignalInfo : SignalInfoRec;   {record of signal info data}
        StatusMsg  : FIPP_tStatusMsg;   {array to place status msg in}
        Spectrum   : FIPP_tSpectrumArray; {array to put spectrum data in}
        PhaseTable : FIPP_tPhaseArray;  {array to put phase data in}
        Blob       : FIPP_tBlobArray;   {array to stuff blob data in}
        Fit        : FitRecordType;   {record to stuff fit info into}
        TestParameters : FIPP_tTestParametersArray; {array to stuff option data in}
        ARparams   : FIPP_tARparams;    {array for attack and release parameters}
        LongDeviceID : FD_tDeviceID; //LongDeviceIDRec; {array to stuff long device ID in}
        AuxInData : FIPP_tAuxDataArray; {array to stuff raw aux data}
        AuxOutData : FIPP_tAuxDataArray; {array to stuff raw aux data}
        DeviceDataArray : FIPP_tDeviceDataArray; {array to stuff device data in}
        FryeBitmap : FIPP_tFryeBitmap; {Frye bitmap array used for graphics}
        RawSampleData : FIPP_tRawSampleData; {array to stuff raw sample data}
        ListData : FIPP_tListData; {array to stuff list data}

        CsCmdArray:FC_tCmdArray;     //Special cmd array for cmd status check
        CsRspArray:FC_tCmdArray;     //Special rsp array for cmd status check

        procedure ClearPacketTimer;
        function GetPacketTimer:word;  //get packet timer value in ms (55ms resolution)
        procedure ConvertLabelToSend(Size:integer; LabelData:pchar);
        procedure ConvertUserIDToSend(ExtID:boolean; Size:integer; IDText:pchar);
        procedure ConvertLabelFromRcv(Size:integer; LabelData:pchar);
        procedure GetUserIDFromRcv(ExtID:boolean; Size:integer; IDText:pchar);
        //procedure BuildMemoryImageMap(MemImgW:integer; MemImgH:integer);

        procedure SetCallback(MyCallback:FC_tCallback);
        function SendCmd:boolean;
        function SetPacket:boolean;
        function GetPacket:boolean;
        function DoPacket:boolean;
        function CommandStatusOK:boolean;
        function SetValue(SetCmd,GetCmd:word; var ValueToSet:SmallInt):boolean;
        function GetValue(GetCmd:word; var ValueToGet:smallint):boolean;



        {------- FIPP commands ------}
        {these are the high-level functions to communicate to the tester}
        {all data is passed in the Fipp object. Set cmds should preset the proper}
        {variable before issuing a command. Get cmds will return the requested}
        {information in the appropriate variable. Do cmds will cause the tester}
        {to perform the requested action. If Verify is on the tester is polled}
        {to see if it accepted the cmd. If DoubleCheck is on the resulting value}
        {in the tester after a set cmd is reloaded back into the appropriate}
        {variable. All commands return true if everything went ok. All commands}
        {return false if a problem occured. The specific error can be found}
        {in FippError. If needed, further information on the error can be}
        {found in PortStatus}
        function ReleaseCmd:boolean;   {7fff}
        function SetSourceAmp:boolean; {0}
        function SetDistMode:boolean;  {1}
        function SetFrequency:boolean; {2}
        function SetOESstate:boolean;   {3}  {obsolete}
        function SetNoiseRedCount:boolean;  {4}
        function SetSmoothState:boolean; {5}
        function SetStdLabel:boolean;    {6}  {obsolete}
        function SetProbeState:boolean;     {7}  {obsolete}
        function SetWeightState:boolean; {8}  {obsolete}
        function SetCurveFrame:boolean; {9}
        function SetIOmode:boolean;      {10}
        function SetSourceMethod:boolean;     {11} {was SetTelcoilState}
        function SetAnalysisMode:boolean;    {12} {was SetGainState}
        function SetBatteryTest:boolean;      {14}
        function SetTelCoilMode:boolean;     {39}
        function SetRelAttFreq:boolean;    {40}
        function SetZetaState:boolean;    {43}  {obsolete}
        function SetInsitu:boolean;      {47}   {obsolete}
        function SetAutoState:boolean;    {48}
        function SetLimitValue:boolean;    {50}
        function SetRefMicState:boolean;    {52}
        function SetActiveStatus:boolean;    {54}
        function SetPower:boolean;           {56}
        function SetMachineState:boolean;   {59}
        function SetControlLock:boolean;     {62}
        function SetExtendedLabel:boolean;  {66}
        function SetSpectrum:boolean;       {68}
        function SetPhaseTable:boolean;     {69}
        function SetTestParameters:boolean;   {70}
        function SetKeyScanCode:boolean;        {72}
        function SetPollDelay:boolean;        {73}
        function SetTestEar:boolean;        {75}
        function SetSrcType:boolean;    {77}
        function SetBatteryType:boolean;        {79}
        function SetAvgFreqs:boolean;        {82}
        function SetSettleTime:boolean;  {84} {new verison}
        function SetCICstate:boolean;   {88}
        function SetPrinterLabelStorage:boolean;   {89}
        function SetAvgDelayTime:boolean;   {90}
        function SetPrinterSelect:boolean;   {92}
        function SetBitmap:boolean;   {96}
        function SetARparams:boolean;       {97}
        function SetBlob:boolean;           {99}
        function SetRealTimeClock:boolean;   {104}
        function SetOutputDevice:boolean; {106}
        function SetImpulseRej:boolean; {108}
        function SetCurveSelect:boolean; {112}
        function SetCurveStatus:boolean; {114}
        function SetUnaidedSelect:boolean; {116}
        function SetListData:boolean;   {118}
        function SetStaticToneSelect:boolean; {121}
        function SetAidInfoSelect:boolean; {123}
        function SetBiasTone:boolean; {125}
        function SetWarbleSelect:boolean; {129}
        function SetRcvTimeout:boolean;        {132}
        function SetFitRule:boolean;        {134}
        function SetFilter:boolean;        {136}
        function SetCompression:boolean; {138}
        function SetClientAge:boolean; {140}
        function SetTransducerLoc:boolean; {142}
        function SetLevelingList:boolean;       {145}
        function SetLevelingStatus:boolean; {147}
        function SetAuxPort:boolean;       {148}
        function SetUserNumber:boolean; {150}
        function SetFitType:boolean;    {152} {fp35 v3.20 12/01/03}
        function SetVentType:boolean;    {154} {fp35 v3.20 12/01/03}
        function SetTubingType:boolean;    {156} {fp35 v3.20 12/01/03}
        function SetAidChannels:boolean;    {158} {fp35 v3.20 12/01/03}
        function SetAidLimiting:boolean;    {160} {fp35 v3.20 12/01/03}
        function SetRefMethod:boolean;    {162} {fp35 v3.70 06/06/06}
        function SetFitParam:boolean;    {164} {fp35 v3.20 12/01/03}
        function SetUserIDText:boolean;  {166}
        function SetSkew:boolean;    {168} {fp35 v3.30 07/01/04}
        function SetScreenMode:boolean;    {170}
        function SetCouplerSelection:boolean;    {172} {fp35 v3.50 12/16/04}
        function SetAnalysisSelection:boolean;    {174} {fp35 v3.60 06/12/06}
        function SetStoredParameter:boolean;       {180}
        function SetCurveGroupSelect:boolean;    {182}
        function SetAgcFreqSelect:boolean;    {184}
        function SetInputPortSelect:boolean;    {186}
        function SetAngleSelect:boolean;    {188}
        function SetDiffFreq:boolean;    {190}
        function SetUserMode:boolean;    {192}

        function GetRelAttData:boolean;      {18}
        function GetBatteryData:boolean;     {19}
        function GetIOdata:boolean;      {20}
        function GetSourceAmp:boolean;   {21}
        function GetDistMode:boolean;    {22}
        function GetFrequency:boolean;   {23}
        function GetOESstate:boolean;   {24}  {obsolete}
        function GetCurveFrame:boolean;  {25}
        function GetNoiseRedCount:boolean;    {26}
        function GetSmoothState:boolean; {27}
        function GetFonixVersion:boolean;      {28}
        function GetLevelState:boolean;  {29}
        function GetWeightState:boolean; {30}   {obsolete}
        function GetMicData:boolean;       {31}
        function GetDistPercent:boolean;    {32}
        function GetCmdStatus:boolean;    {33}
        function GetIOmode:boolean;       {34}
        function GetProbeState:boolean;    {35}   {obsolete}
        function GetAnalysisMode:boolean;   {36}  {was GetGainState}
        function GetSourceMethod:boolean; {37}    {was GetTelcoilState}
        function GetRelAttFreq:boolean;    {41}
        function GetLastCurve:boolean;     {42}
        function GetTelCoilMode:boolean; {44}
        function GetZetaState:boolean;    {45}   {obsolete}
        function GetInsitu:boolean;       {46}   {obsolete}
        function GetAutoState:boolean;    {49}
        function GetLimitValue:boolean;    {51}
        function GetRefMicState:boolean;    {53}
        function GetActiveStatus:boolean;    {55}
        function GetRefMicData:boolean;       {57}
        function GetKeyScanCode:boolean;        {58}
        function GetMachineState:boolean;   {60}
        function GetBlob:boolean;           {61}
        function GetControlLock:boolean;     {63}
        function GetTestParameters:boolean;   {71}
        function GetPollDelay:boolean;     {74}
        function GetTestEar:boolean;     {76}
        function GetSrcType:boolean;    {78}
        function GetPowerStatus:boolean;   {80}
        function GetAvgFreqs:boolean;     {81}
        function GetSettleTime:boolean;     {83}
        function GetExtendedLabel:boolean;  {86}
        function GetCICstate:boolean;   {87}
        function GetAvgDelayTime:boolean;   {91}
        function GetPrinterSelect:boolean;   {93}
        function GetHFAMeasurement:boolean;   {94}
        function GetInstrumentInformation:boolean;   {95}
        function GetARparams:boolean;       {98}
        function GetLastIdDevice:boolean;   {100}
        function GetLongDeviceID:boolean;   {101}
        function GetDeviceData:boolean;   {102}
        function GetRealTimeClock:boolean;   {103}
        function GetOutputDevice:boolean;   {105}
        function GetImpulseRej:boolean;   {107}
        function GetSignalInfo:boolean;   {109}
        function GetRawSampleData:boolean;   {110}
        function GetCalListData:boolean;   {111}
        function GetCurveSelect:boolean;   {113}
        function GetCurveStatus:boolean;   {115}
        function GetUnaidedSelect:boolean;   {117}
        function GetListData:boolean;   {119}
        function GetBitmap(Xpos,Ypos,Width,Height,Style,Page:integer):boolean;   {120}
        function GetStaticToneSelect:boolean;   {122}
        function GetAidInfoSelect:boolean;   {124}
        function GetBiasTone:boolean;   {126}
        function GetWarbleSelect:boolean;   {130}
        function GetDelayMeasurments:boolean;   {131}
        function GetRcvTimeout:boolean;     {133}
        function GetFitRule:boolean;     {135}
        function GetFilter:boolean;     {137}
        function GetCompression:boolean;   {139}
        function GetClientAge:boolean;   {141}
        function GetTransducerLoc:boolean;   {143}
        function GetLevelingList:boolean;  {146}
        function GetAuxPort:boolean;   {149}
        function GetUserNumber:boolean;   {151}
        function GetFitType:boolean;    {153} {fp35 v3.20 12/01/03}
        function GetVentType:boolean;    {155} {fp35 v3.20 12/01/03}
        function GetTubingType:boolean;    {157} {fp35 v3.20 12/01/03}
        function GetAidChannels:boolean;    {159} {fp35 v3.20 12/01/03}
        function GetAidLimiting:boolean;    {161} {fp35 v3.20 12/01/03}
        function GetRefMethod:boolean;    {163} {fp35 v3.70 06/06/06}
        function GetFitParam:boolean;    {165} {fp35 v3.20 12/01/03}
        function GetUserIDText:boolean;  {167}
        function GetSkew:boolean;    {169} {fp35 v3.30 07/01/04}
        function GetScreenMode:boolean;    {171} {fp35 v3.40 08/20/04}
        function GetCouplerSelection:boolean;    {173} {fp35 v3.50 12/16/04}
        function GetAnalysisSelection:boolean;    {175} {fp35 v3.60 06/12/06}
        function GetBatteryInfo:boolean;    {179}
        function GetStoredParameter:boolean;    {181}
        function GetCurveGroupSelect:boolean;    {183}
        function GetAgcFreqSelect:boolean;    {185}
        function GetInputPortSelect:boolean;    {187}
        function GetAngleSelect:boolean;    {189}
        function GetDiffFreq:boolean;    {191}
        function GetUserMode:boolean;    {193}

        function SendDoCmd(DoCmd:word):boolean;
        function DoRelAttSelect:boolean;  {13}
        function DoIOSelect:boolean;  {15}
        function DoTest:boolean;     {16}
        function DoLevel:boolean;        {17}
        function DoReset:boolean;        {38}
        function DoSleep:boolean;        {56}
        function DoLineFeeds:boolean;       {64}
        function DoPrint:boolean;           {65}
        function DoError:boolean;        {67}
        function DoMeasurement:boolean;  {85}
        function DoCustomTest:boolean;     {176}
        function DoParameterSave:boolean;  {177}
        function DoTarget:boolean;         {178}
        function DoCalAdj:boolean;       {144}

        function SetFonixBaudrate:boolean; {31747}
        function SetPolledMethod:boolean;     {0x7ff7}
        function SetDemandMethod:boolean;     {0x7ff8}

    //-------------------------------
    constructor Create;
    destructor Destroy; override;

     end;

//var Fipp : TclsFipp; //object is declared elsewhere

{-------}
{These are the current possible FIPP commands that are available}
{state=target is in a condition where other commands are affected}
{example: probestate=on means that only probe cmds will work}
{mode=an option under which a specific function changes operation}
{example:distortion mode=0 only affects how distortion is measured.}
{These ae used by the Fipp functions to perform the associated command.}
const
     fipp_SetSourceAmpCmd     = 0;
     fipp_SetDistModeCmd      = 1;
     fipp_SetFrequencyCmd     = 2;
     fipp_SetOESstateCmd      = 3;   {obsolete}
     fipp_SetNoiseRedCountCmd = 4;
     fipp_SetSmoothStateCmd   = 5;
     fipp_SetStdLabelCmd      = 6;
     fipp_SetProbeStateCmd    = 7;   {obsolete}
     fipp_SetWeightStateCmd   = 8;   {obsolete}
     fipp_SetCurveFrameCmd    = 9;
     fipp_SetIOmodeCmd        = 10;
     fipp_SetSourceMethodCmd  = 11; {was SetTelCoilStateCmd}
     fipp_SetAnalysisModeCmd  = 12; {was SetGainState}
     fipp_DoRelAttSelectCmd   = 13;
     fipp_SetBatteryTestCmd   = 14;
     fipp_DoIOSelectCmd       = 15;
     fipp_DoTestCmd           = 16;
     fipp_DoLevelCmd          = 17;
     fipp_GetRelAttDataCmd    = 18;
     fipp_GetBatteryDataCmd   = 19;
     fipp_GetIOdataCmd        = 20;
     fipp_GetSourceAmpCmd     = 21;
     fipp_GetDistModeCmd      = 22;
     fipp_GetFrequencyCmd     = 23;
     fipp_GetOESstateCmd      = 24;  {obsolete}
     fipp_GetCurveFrameCmd    = 25;
     fipp_GetNoiseRedCountCmd = 26;
     fipp_GetSmoothStateCmd   = 27;
     fipp_GetFonixVersionCmd    = 28;
     fipp_GetLevelingStatusCmd= 29;
     fipp_GetWeightStateCmd   = 30;
     fipp_GetMicDataCmd       = 31;
     fipp_GetDistPercentCmd   = 32;
     fipp_GetCmdStatusCmd     = 33;
     fipp_GetIOmodeCmd        = 34;
     fipp_GetProbeStateCmd    = 35;  {obsolete}
     fipp_GetAnalysisModeCmd  = 36;  {was GetGainState}
     fipp_GetSourceMethodCmd  = 37;  {was GetTelCoilStateCmd}
     fipp_DoResetCmd          = 38;
     fipp_SetTelCoilModeCmd   = 39;
     fipp_SetRelAttFreqCmd    = 40;
     fipp_GetRelAttFreqCmd    = 41;
     fipp_GetLastCurveCmd     = 42;
     fipp_SetZetaStateCmd     = 43;  {obsolete}
     fipp_GetTelCoilModeCmd   = 44;  
     fipp_GetZetaStateCmd     = 45;  {obsolete}
     fipp_GetInsituCmd        = 46;  {obsolete}
     fipp_SetInsituCmd        = 47;  {obsolete}
     fipp_SetAutoStateCmd     = 48;
     fipp_GetAutoStateCmd     = 49;
     fipp_SetLimitValueCmd    = 50;
     fipp_GetLimitValueCmd    = 51;
     fipp_SetRefMicStateCmd   = 52;
     fipp_GetRefMicStateCmd   = 53;
     fipp_SetActiveStatusCmd  = 54;
     fipp_GetActiveStatusCmd  = 55;
     fipp_DoSleepCmd          = 56; {6500 only}
     fipp_GetRefMicDataCmd    = 57;
     fipp_GetKeyScanCodeCmd   = 58;
     fipp_SetMachineStateCmd  = 59;
     fipp_GetMachineStateCmd  = 60;
     fipp_GetBlobCmd          = 61;
     fipp_SetControlLockCmd    = 62;
     fipp_GetControlLockCmd    = 63;
     fipp_DoLineFeedsCmd      = 64;
     fipp_DoPrintCmd          = 65;
     fipp_SetExtendedLabelCmd = 66;
     fipp_DoErrorCmd          = 67;
     fipp_SetSpectrumCmd      = 68;
     fipp_SetPhaseTableCmd    = 69;
     fipp_SetTestParametersCmd  = 70;
     fipp_GetTestParametersCmd  = 71;
     fipp_SetKeyScanCodeCmd   = 72;
     fipp_SetPollDelayCmd     = 73;
     fipp_GetPollDelayCmd     = 74;
     fipp_SetTestEarCmd       = 75;  {fp40}
     fipp_GetTestEarCmd       = 76;  {fp40}
     fipp_SetSrcTypeCmd       = 77;  {fp40}
     fipp_GetSrcTypeCmd       = 78;  {fp40}
     fipp_SetPowerCmd         = 56;
     fipp_SetBatteryTypeCmd   = 79;  {fp40}
     fipp_GetPowerStatusCmd   = 80;  {fp40}
     fipp_GetAvgFreqsCmd      = 81;
     fipp_SetAvgFreqsCmd      = 82;
     fipp_GetSettleTimeCmd    = 83;
     fipp_SetSettleTimeCmd    = 84;
     fipp_GetExtendedLabelCmd = 86;
     fipp_GetCICstateCmd      = 87;
     fipp_SetCICstateCmd      = 88;
     fipp_SetPrinterLabelStorageCmd = 89;
     fipp_DoMeasurementCmd    = 85;  {6500 v4.14}
     fipp_SetAvgDelayCmd      = 90;  {6500 v4.14}
     fipp_GetAvgDelayCmd      = 91;  {6500 v4.14}
     fipp_SetPrinterSelectCmd   = 92;  {6500 v4.20}
     fipp_GetPrinterSelectCmd   = 93;  {6500 v4.20}
     fipp_GetHFAMeasurementCmd = 94; {6500 V4.40}

     fipp_GetInstrumentInfoCmd      = 95;  {FP35 V2.00}
     fipp_SetBitmapCmd             = 96;  {FP35 V1.10}
     fipp_SetARparamsCmd             = 97;  {6500 V4.50}
     fipp_GetARparamsCmd             = 98;  {6500 V4.50}
     fipp_SetBlobCmd                = 99;  {FP35 V1.21}
     fipp_GetLastIdDeviceCmd        = 100; {FP35 V1.00}
     fipp_GetLongDeviceIDCmd        = 101; {FP35 V1.00}
     fipp_GetDeviceDataCmd          = 102; {FP35 V1.20}
     fipp_GetRealTimeClockCmd       = 103; {FP35 V1.10}
     fipp_SetRealTimeClockCmd       = 104; {FP35 V1.10}
     fipp_GetOutputDeviceCmd        = 105; {FP35 V2.00/V2.20enh}
     fipp_SetOutputDeviceCmd        = 106; {FP35 V2.00/V2.20enh}
     fipp_GetImpulseRejCmd          = 107; {FP35 V2.00}
     fipp_SetImpulseRejCmd          = 108; {FP35 V2.00}
     fipp_GetSignalInfoCmd          = 109; {FP35 V2.00}
     fipp_GetRawSampleDataCmd       = 110; {FP35 V1.10}
     fipp_GetCalListDataCmd         = 111; {FP35 V2.00}
     fipp_SetCurveSelectCmd         = 112; {FP35 V2.00}
     fipp_GetCurveSelectCmd         = 113; {FP35 V2.00}
     fipp_SetCurveStatusCmd         = 114; {FP35 V2.00}
     fipp_GetCurveStatusCmd         = 115; {FP35 V2.00}
     fipp_SetUnaidedSelectCmd       = 116; {FP35 V2.00}
     fipp_GetUnaidedSelectCmd       = 117; {FP35 V2.00}
     fipp_SetListDataCmd            = 118; {FP35 V4.72}
     fipp_GetListDataCmd            = 119; {FP35 V4.72}
     fipp_GetBitmapCmd              = 120; {FP35 V2.10}
     fipp_SetStaticToneSelectCmd    = 121; {FP35 V2.10}
     fipp_GetStaticToneSelectCmd    = 122; {FP35 V2.10}
     fipp_SetAidInfoSelectCmd       = 123; {FP35 V2.10}
     fipp_GetAidInfoSelectCmd       = 124; {FP35 V2.10}
     fipp_SetBiasToneCmd            = 125; {future}
     fipp_GetBiasToneCmd            = 126; {future}
     {cmd 127 <reserved>}
     {cmd 128 <reserved>}
     fipp_SetWarbleSelectCmd       = 129; {FP35 V2.20}
     fipp_GetWarbleSelectCmd       = 130; {FP35 V2.20}
     fipp_GetMeasurmentDelaysCmd   = 131; {6500 V4.72}
     fipp_SetRcvTimeoutCmd        = 132;
     fipp_GetRcvTimeoutCmd        = 133;
     fipp_SetFitRuleCmd          = 134;  {FP35 V2.30}
     fipp_GetFitRuleCmd          = 135;  {FP35 V2.30}
     fipp_SetFilterCmd        = 136;  {FP35 V3.00}
     fipp_GetFilterCmd        = 137;  {FP35 V3.00}
     fipp_SetCompressionCmd   = 138;  {FP35 V3.00}
     fipp_GetCompressionCmd   = 139;  {FP35 V3.00}
     fipp_SetClientAgeCmd     = 140;  {FP35 V3.00}
     fipp_GetClientAgeCmd     = 141;  {FP35 V3.00}
     fipp_SetTransducerLocCmd = 142;  {FP35 V3.10}
     fipp_GetTransducerLocCmd = 143;  {FP35 V3.10}
     fipp_DoCalAdjCmd = 144;           {fp35 V5.00}
     fipp_SetLevelingListCmd = 145;  {FP35 V3.20}
     fipp_GetLevelingListCmd = 146;  {FP35 V3.20}
     fipp_SetLevelingStatusCmd = 147;  {FP35 V3.20}
     fipp_SetAuxPortCmd = 148;        {FP35 V3.20}
     fipp_GetAuxPortCmd = 149;        {FP35 V3.20}
     fipp_SetUserNumberCmd = 150;        {FP35 V3.20}
     fipp_GetUserNumberCmd = 151;        {FP35 V3.20}

     fipp_SetFitTypeCmd = 152;        {fp35 V3.20}
     fipp_GetFitTypeCmd = 153;        {fp35 V3.20}
     fipp_SetVentTypeCmd = 154;       {fp35 V3.20}
     fipp_GetVentTypeCmd = 155;       {fp35 V3.20}
     fipp_SetTubingTypeCmd = 156;     {fp35 v3.20}
     fipp_GetTubingTypeCmd = 157;     {fp35 V3.20}
     fipp_SetAidChannelsCmd = 158;    {fp35 V3.20}
     fipp_GetAidChannelsCmd = 159;    {fp35 V3.20}
     fipp_SetAidLimitingCmd = 160;    {fp35 V3.20}
     fipp_GetAidLimitingCmd = 161;    {fp35 V3.20}
     fipp_SetRefMethodCmd = 162;     {fp35 v3.70}
     fipp_GetRefMethodCmd = 163; {fp35 v3.70}

     fipp_SetFitParamCmd = 164;       {fp35 v3.20}
     fipp_GetFitParamCmd = 165;       {fp35 v3.20}
     fipp_SetUserIDTextCmd = 166;     {FP35 V3.20}
     fipp_GetUserIDTextCmd = 167;     {FP35 V3.20}
     fipp_SetSkewCmd = 168;     {FP35 V3.30}
     fipp_GetSkewCmd = 169;     {FP35 V3.30}
     fipp_SetScreenModeCmd = 170;       {fp35 v3.40}
     fipp_GetScreenModeCmd = 171;       {fp35 v3.40}
     fipp_SetCouplerSelectionCmd = 172;     {FP35 V3.50}
     fipp_GetCouplerSelectionCmd = 173;     {FP35 V3.50}
     fipp_SetAnalysisSelectionCmd = 174;     {FP35 V3.60}
     fipp_GetAnalysisSelectionCmd = 175;     {FP35 V3.60}
     fipp_DoCustomTestCmd    = 176; {FP35 V3.60}
     fipp_DoParameterSaveCmd = 177; {FP35 V3.60}
     fipp_DoTargetCmd        = 178; {FP35 V3.70}
     fipp_GetBatteryInfoCmd  = 179;

     fipp_SetStoredParameterCmd = 180;     {FP35 V3.70}
     fipp_GetStoredParameterCmd = 181;     {FP35 V3.70}

     fipp_SetCurveGroupSelectCmd = 182;     {8000}
     fipp_GetCurveGroupSelectCmd = 183;     {8000}
     fipp_SetAgcFreqSelectCmd = 184;     {7000}
     fipp_GetAgcFreqSelectCmd = 185;     {7000}
     fipp_SetInputPortSelectCmd = 186;   {FP35}
     fipp_GetInputPortSelectCmd = 187;   {fp35}

     fipp_SetAngleSelectCmd = 188;  {8000}
     fipp_GetAngleSelectCmd = 189;  {8000}
     fipp_SetDiffFreqCmd = 190;  {fp35}
     fipp_GetDiffFreqCmd = 191;  {fp35}
     fipp_SetUserModeCmd = 192;  {fp35}
     fipp_GetUserModeCmd = 193;  {fp35}

     fipp_SetFonixBaudrateCmd = 31747;  {0x7c03}
     fipp_SetDemandModeCmd    = $7ff7;
     fipp_SetPolledModeCmd    = $7ff8;
     fipp_QuickTerminateCmd   = $7fff;

{ *********** }

implementation

{===================================================================}
// Implmentation for the Extended FippUnit class constructor
// Note: when you create the fipp object, this constructure is called
// after the FippCore constructor is called.
constructor TclsFipp.Create;
begin
  inherited Create;
  //    InitializeCriticalSection(Csv);
  //MemImage := TBitmap.Create;
  IoModeCount := 2;  {number of words used in IO mode command}
  CurveSelectValid := false;
  FonixVersionSize := 0;
  InstrumentInfoSize := 0;
  UserNumber := 0;
  //PollTimer := FIPP_STD_POLL_TIMEOUT;
  fillchar(FonixVersionArray,sizeof(FonixVersionArray),0);
  fillchar(InstrumentInfo,sizeof(InstrumentInfo),0);

//  try
//    begin
//    end;
//  except
//  end;

end;

{===================================================================}
destructor TclsFipp.Destroy;
begin
//  DeleteCriticalSection(Csv);
  //MemImage.free;
  inherited Destroy;
end;

(*
procedure TclsFipp.BuildMemoryImageMap(MemImgW:integer; MemImgH:integer);
begin
  if (MemImage.Width <> MemImgW) or (MemImage.Height <> MemImgH) then
  begin
    MemImage.Width := MemImgW;
    MemImage.Height := MemImgH;
    MemImage.Canvas.Brush.Style := bsSolid;
    MemImage.Canvas.Pen.Style := psSolid;
    MemImage.Canvas.Pen.Mode := pmCopy;
    MemImage.Canvas.Brush.Color := clWhite;
    MemImage.Canvas.Pen.Color := clWhite;
    MemImage.Canvas.Rectangle(0,0,MemImage.Width,MemImage.Height);
    MemImage.Canvas.Brush.Color := clBlack;
    MemImage.Canvas.Pen.Color := clBlack;
//    if FrameCheckBox.Checked then
//    begin
//      MemImage.Canvas.Moveto(0,0);
//      MemImage.Canvas.Lineto(MemImage.Width-1,0);
//      MemImage.Canvas.Lineto(MemImage.Width-1,MemImage.Height-1);
//      MemImage.Canvas.Lineto(0,MemImage.Height-1);
//      MemImage.Canvas.Lineto(0,0);
//    end;
  end;
end;
*)

{------------------------------------------------------------------------}
{same as SkipPoll, but waits for T clock ticks after skipping poll}
{This method is obsolete it is no longer used.}
(*
procedure SkipPollTick(T:integer);
begin
  SkipPoll(FIPPrec);
  ClkWait(T);
end;
*)
(*
{This method is obsolete it is no longer used.}
function WaitLongPoll(var FIPPrec:FIPPrecType):boolean;
var tb:boolean;
begin
  WaitLongPoll := false;
  begin
    PollTimer := LongPoll;     {set for long poll timeout}
    SetPollTimer(FIPPrec);
    SkipPollTick(2,FIPPrec);   {skip a single poll}
    tb := not(GetCmdStatus(FIPPrec));
    PollTimer := DefaultPoll;   {restore normal poll timeout}
    SetPollTimer(FIPPrec);
    if tb then Exit;           {Exit if something went wrong}
  end;
  WaitLongPoll := true;
end;
*)

{===================================================================}
//This sets the Fipp callback to the target location.
//If the callback is set to NIL, it is not used.
//If it contains an address, the FCOM dll will call it
//when waiting long periods (see SendReady and OpenPort).
//The purpose of the callback is to allow the user to update status
//and to be able to cancel the operation if there is a problem.
//See the FryeCom DLL documentation for details.
//By default, callback is set to NIL when the object is created.
//Be very careful about the use of the callback.
//FryeCom is not re-entrant for commands calls (status calls are ok).
//Also, if the address stored is stale (no longer valid),
//unexpected things can happen.
//If your callback address is no longer valid, you must set the Fipp
//callback to NIL so that it won't be called.
procedure TclsFipp.SetCallback(MyCallback:FC_tCallback);
begin
  Callback := MyCallback;
end;

{===================================================================}
// The following are the low level support routines.
// These routines are used to talk directly to the Fryecom dll
// to configure it for special case operations.

{-------}
{Get the current low-level tick counter resolution (rate of increment).}
{Used by SetRespTimeout().}
function TclsFipp.GetPacketTickRes:integer;
var IRegs : F_RegsType;
begin
  IRegs.AX := $0ff17;   //Read the current tick multiplier value
  IRegs.CX := $0400;
  IRegs.DX := ThisComPort;
  FCOM_CallFryers(IRegs);
  if (IRegs.AX < 1) or (IRegs.AX > 255) then IRegs.AX := 55; //on error, force to 55ms (default)
  Result := IRegs.AX
end;

{-------}
//This gets the current value in the general purpose packet timer in milliseconds.
//Note: The actual internal default tick resolution is nominally 55ms
//However, it can be different. This function converts the time to milliseconds.
function TclsFipp.GetPacketTimer:word;
var IRegs : F_RegsType;
var TickRes:integer;
begin
  IRegs.AX := $ff17;  {select packet timer}
  IRegs.CX := $0300;
  IRegs.DX := ThisComPort;
  FCOM_CallFryers(IRegs);
  GetPacketTimer := IRegs.BX; //return time in milliseconds
end;

{-------}
//This clears the general purpose packet timer counter to zero.
procedure TclsFipp.ClearPacketTimer;
var IRegs : F_RegsType;
begin
  IRegs.AX := $ff17;  {select packet timer}
  IRegs.BX := 0;
  IRegs.CX := $03FF;
  IRegs.DX := ThisComPort;
  FCOM_CallFryers(IRegs);
end;

{-------}
{this sets a new value in the response timer}
{Note: this is required to support the special case 6500 cmd (85)}
{that breaks the protocol rules.}
procedure TclsFipp.SetRespTimeout(Value:INT16);
var IRegs : F_RegsType;
var TickRes:integer;
begin
  if (Value < 1) then Value := 1000;  //if bad, set to one second timeout
  TickRes := GetPacketTickRes();
  if (TickRes < 1) then TickRes := 1;
  IRegs.AX := $ff17;     {set response timer}
  IRegs.BX := Value div TickRes; //RespTimer;
  IRegs.CX := $01ff;
  IRegs.DX := ThisComPort;
  FCOM_CallFryers(IRegs);
end;

{-------}
{this returns the response timer's current value}
function TclsFipp.GetRespTimeout:INT16;
var IRegs : F_RegsType;
begin
  IRegs.AX := $ff17;     {read response timer}
  IRegs.CX := $0100;
  IRegs.DX := ThisComPort;
  FCOM_CallFryers(IRegs);
  GetRespTimeout := IRegs.BX;
end;

{-------}
{This can convert std or ext label arrays.}
{This converts the label asciiZ (pchar) 2D string array from intel to motorola format}
{and pokes it into the command array.}
{Note: This does not set the cmd number. The caller must set the size and cmd number (6 or 66).}
{Size is the number of chars to be converted, LabelData is the place where the label is located.}
procedure TclsFipp.ConvertLabelToSend(Size:integer; LabelData:pchar);
var i:integer;
begin
  {make sure Size is valid}
  if (Size < 0) or (Size > FIPP_REG_EXT_LABEL_SIZEB) then
    Size := FIPP_REG_EXT_LABEL_SIZEB;
  i := 0;
  LabelData[pred(Size)] := #0; {force last byte to null}
  while i < Size do
  begin
    CmdArray.Data[(i shr 1)] := (ord(LabelData[i]) shl 8)+
                                  ord(LabelData[succ(i)]);
    inc(i,2);
  end;
end;

{-------}
{This converts the UserID asciiZ (pchar) 2D string array from intel to motorola format}
{and pokes it into the command array.}
{Note: This does not set the cmd number. The caller must set the size and cmd number (6 or 66).}
{Size is the number of chars to be converted, TextData is the place where the text is located.}
{If ExtID = true, Text is assumed to go at the end of an extended label cmd (66).
{If ExtID = false, text is assumed to be for a normal UserID cmd (166).}
procedure TclsFipp.ConvertUserIDToSend(ExtID:boolean; Size:integer; IDText:pchar);
var SrcIndex:integer;
var CmdIndex:integer;
begin
  {If extended label format, then put the user ID at the end of the custom label}
  {otherwise it goes at the start of the CmdArray.}
  if (ExtID = true) then
    CmdIndex := FIPP_REG_EXT_LABEL_SIZEB
  else CmdIndex := 0;
  {make sure Size is valid}
  if (Size < 0) or (Size > FIPP_MAX_USERID_TEXT) then
    Size := FIPP_MAX_USERID_TEXT;

  SrcIndex := 0;
  IDText[pred(Size)] := #0; {force last byte to null}
  while SrcIndex < Size do
  begin
    CmdArray.Data[(CmdIndex shr 1)] := (ord(IDText[SrcIndex]) shl 8)+
                                         ord(IDText[SrcIndex+1]);
    inc(CmdIndex,2);
    inc(SrcIndex,2);
  end;
end;

{-------}
{This converts the received label in Motorola format to Intel asciiZ (pchar) 2D string array}
{Size is total number of chars to be converted, LabelData is where to place the data}
procedure TclsFipp.ConvertLabelFromRcv(Size:integer; LabelData:pchar);
var i:integer;
begin
  {make sure Size is valid}
  if (Size < 0) or (Size > FIPP_REG_EXT_LABEL_SIZEB) then
    Size := FIPP_REG_EXT_LABEL_SIZEB;
  i := 0;
  while i < Size do
  begin
    LabelData[i] := char(RspArray.Data[(i shr 1)] shr 8);
    LabelData[succ(i)] := char(RspArray.Data[(i shr 1)] and $ff);
    inc(i,2);
  end;
  LabelData[pred(Size)] := #0; {force last byte to null}
end;

{This converts the received UserID in Motorola format to Intel asciiZ (pchar) 2D string array}
{Size is total number of chars to be converted, IDTest is where to place the data}
{If ExtID = true Text is assumed to be at the end of an extended label cmd (86).}
{If ExtID = false, text is assumed to be for a normal UserID cmd (167).}
procedure TclsFipp.GetUserIDFromRcv(ExtID:boolean; Size:integer; IDText:pchar);
var DestIndex:integer;
var RspIndex:integer;
begin
  if (Size < 0)or(Size > FIPP_MAX_USERID_TEXT) then Size := FIPP_MAX_USERID_TEXT;
  if (ExtID = true) then
    RspIndex := FIPP_REG_EXT_LABEL_SIZEB   {if via ExtLabel start at first char past ext label portion}
  else RspIndex := 0;                      {if via std User ID cmd 167, start at loc 0}
  DestIndex := 0;
  while DestIndex < Size do
  begin
    IDText[DestIndex] := char(RspArray.Data[(RspIndex shr 1)] shr 8);
    IDText[DestIndex+1] := char(RspArray.Data[(RspIndex shr 1)] and $ff);
    inc(RspIndex,2);
    inc(DestIndex,2);
  end;
  IDText[Size-1] := #0; {force last byte to null}
end;

{===================================================================}
// The following are the mid level support routines.
// These routines are used to send/receive commands to the Fryecom dll
// via the underlaying FippCore object (inherited by the Fipp Object).

function TclsFipp.DoFippCmd(NoAck:integer; NoPollTimeout:integer):boolean;
begin
  FippError := DoCmd(NoAck, NoPollTimeout, CmdArray, RspArray, Callback);
  if (FippError = SUCCESS) then
    Result := true
  else Result := false;
  UpdatePortStatus();  //always update port status when done
end;

{-------}
{Similar to DoPacket, except does not do verify check.}
{This sends a command to the Fonix Instrument and waits for a response}
{if an abort situation occurs it returns as false, and the}
{error condition is provided in FippError}
function TclsFipp.SendCmd:boolean;
begin
  SendCmd := DoFippCmd(FCOM_ACK_OK, FIPP_LONG_POLL_TIMEOUT);
end;

{-------}
{Go ask for the status of the last command. Returns true if good,}
{returns false if bad.}
function TclsFipp.CommandStatusOK:boolean;
//var SA1,SA2:word;
begin
   CommandStatusOK := false;
   CmdStatusFailed := true;

   //Special direct call to check command status with messing up the original cmd/rsp arrays
   CsCmdArray.Cmd := fipp_GetCmdStatusCmd;
   CsCmdArray.Size := 0;
   FippError := DoCmd(FCOM_ACK_OK, FIPP_DEFAULT_NO_POLL,CsCmdArray,CsRspArray,NIL);
   if FippError <> SUCCESS then Exit;
   if CsRspArray.Data[0] <> 0 then
   begin
     FippError := FIPP_NOGO_ERROR;
     Exit;
   end;

   CommandStatusOK := true;
   CmdStatusFailed := false;
end;

{-------}
{SetPacket sets various modes and values inside the target machine}
{It returns a true if everything went OK, or false if not and the}
{error information is returned in FippError.}
{SetPacket assumes that the command is already in SendArray.}
{SetPacket only recieves ACK responses, no data.}
{The assumption is that the NoPollTimeout is unchanged (standard timeout)}
function TclsFipp.SetPacket:boolean;
begin
  Result := DoFippCmd(FCOM_ACK_OK, FIPP_DEFAULT_NO_POLL);
  if (Result = false) then Exit;
  if (Verify = false) then Exit;
  ReleaseCmd();
  Result := CommandStatusOK();
end;


{-------}
{The DoPacket works exactly the same as SetPacket, but it is kept}
{seperate so as to allow possible future modification since the}
{function in the 6500 works differently than a SetPacket call}
{it is up to the calling procedure to collect any data it wants}
{after performing a DoPacket.}
{DoPacket assumes that the command is already in SendArray.}
{Returns a true if everything went OK, or false if not and the}
{error information is returned in FippError.}
{Note: the 6500 indicates that it is done "doing" by responding to}
{the next command sent. Thus the simplest way to determine if it}
{is ready is to ask for cmd status.}
function TclsFipp.DoPacket:boolean;
begin
  Result := DoFippCmd(FCOM_ACK_OK, FIPP_DEFAULT_NO_POLL);
  if Result = false then Exit;
  if Verify = false then Exit;
  ReleaseCmd();
  Result := CommandStatusOK();
end;

{-------}
{GetPacket is used to pickup data from the target machine.}
{GetPacket assumes that the command is already in SendArray.}
{Returns a true if everything went OK, or false if not and the}
{error information is returned in FippError.}
{It is up to the calling procedure to pull the resulting response}
{data out of RcvArray.}
{This command expects a data response. }
{It will cause an error if an ack is received}
function TclsFipp.GetPacket:boolean;
begin
  Result := DoFippCmd(FCOM_NO_ACK, FIPP_DEFAULT_NO_POLL);
end;

{-------}
{SetValue is used for most of the set functions since they mostly pass}
{a single integer value. Makes it much simpler.}
function TclsFipp.SetValue(SetCmd,GetCmd:word; var ValueToSet:SmallInt):boolean;
begin
  SetValue := false;
  CmdArray.Cmd := SetCmd;
  CmdArray.Size := 1;
  CmdArray.Data[0] := word(ValueToSet);
  if not(SetPacket()) then Exit;
  if DoubleCheck then
  begin
    CmdArray.Cmd := GetCmd;
    CmdArray.Size := 0;
    if not(GetPacket()) then Exit;
    ValueToSet := integer(RspArray.Data[0]);
  end;
  SetValue := true;
end;



{-------}
{GetValue is used for most of the get functions since they all pass}
{a single integer value. Makes it much simpler.}
function TclsFipp.GetValue(GetCmd:word; var ValueToGet:smallint):boolean;
begin
    GetValue := false;
    CmdArray.Cmd := GetCmd;
    CmdArray.Size := 0;
    if not(GetPacket()) then Exit;
    ValueToGet := integer(RspArray.Data[0]);
    GetValue := true;
end;


{-------}
{This is just a wrapper around the quick terminate command so}
{that it functions with the same format as the other commands here.}
function TclsFipp.ReleaseCmd:boolean;   {7fff}
begin
  ReleaseCmd := false;
  FippError := QuickRelease(NIL);
  if FippError <> SUCCESS then Exit;
  ReleaseCmd := true;
end;


{===================================================================}
// The following are the high level support routines.
//They are divided into Set, Get and Do commands.
//The commands are listed in numeric cmd order.
{===================================================================}

{The following routines handle the standard FIPP Set commands}
{the command reads and sends the appropriate variable(s) in the Fipp object}
{to the instrument. It is up to the calling routine to insure that the }
{desired variable(s) are properly updated before calling the set command.}
{If verify is on, the target is asked if it is ok after the Set cmd is done.}
{If DoubleCheck is on, the set value is read back from the target and}
{the proper variable is updated with the real value. It is up to the}
{caller to determine if there is any discrepancy.}

{Set cmds - return true if everything went ok. }
{false if not (error in FippError)}


{-------}
{Assumes that the caller has set SourceAmp to the desired value.}

function TclsFipp.SetSourceAmp:boolean; {0}
begin
  SetSourceAmp := SetValue(fipp_SetSourceAmpCmd,fipp_GetSourceAmpCmd,SourceAmp);
end;

{-------}
{Assumes that the caller has set DistMode to the desired value.}

function TclsFipp.SetDistMode:boolean;  {1}
begin
  SetDistMode := SetValue(fipp_SetDistModeCmd,fipp_GetDistModeCmd,DistMode);
end;

{-------}
{Assumes that the caller has set Frequency to the desired value.}

function TclsFipp.SetFrequency:boolean; {2}
begin
  SetFrequency := SetValue(fipp_SetFrequencyCmd,fipp_GetFrequencyCmd,Frequency);
end;

{-------}
{Assumes that the caller has set OESstate to the desired value.}

function TclsFipp.SetOESstate:boolean;   {3}   {obsolete}
begin
  SetOESstate := SetValue(fipp_SetOESstateCmd,fipp_GetOESstateCmd,OESstate);
end;

{-------}
{Assumes that the caller has set NoiseRedCount to the desired value.}

function TclsFipp.SetNoiseRedCount:boolean;  {4}
begin
  SetNoiseRedCount := SetValue(fipp_SetNoiseRedCountCmd,fipp_GetNoiseRedCountCmd,NoiseRedCount);
end;

{-------}
{Assumes that the caller has set SmoothState to the desired value.}

function TclsFipp.SetSmoothState:boolean; {5}
begin
  SetSmoothState := SetValue(fipp_SetSmoothStateCmd,fipp_GetSmoothStateCmd,SmoothState);
end;

{-------}
{Assumes that the caller has set cmdarray to the desired values.}
{Assumes that the caller has built the proper motorola formated data in CmdArray.}
{LabelLines length is ignored (only used by 66/86 commands.}
{Label lines are 5x18 and 3x28 char long with a null in the last character.}
{Note: does not do double check. Note: Label is a 2D ASCIIZ string array.}
{Label should be padded with spaces.}
{Note: this is an obsolete command. Future instruments will only use cmd 66.}
function TclsFipp.SetStdLabel:boolean;    {6}  {obsolete}
begin
  SetStdLabel := false;
  CmdArray.Cmd := fipp_SetStdLabelCmd;
  CmdArray.Size := FIPP_NUM_STD_LABEL_CHAR div 2;  {always sends the full std label}
  SetStdLabel := SetPacket();
end;

{-------}
{Assumes that the caller has set ProbeState to the desired value.}

function TclsFipp.SetProbeState:boolean;     {7}   {obsolete}
begin
  SetProbeState := SetValue(fipp_SetProbeStateCmd,fipp_GetProbeStateCmd,ProbeState);
end;

{-------}
{Assumes that the caller has set WeightState to the desired value.}

function TclsFipp.SetWeightState:boolean; {8}   {obsolete}
begin
  SetWeightState := SetValue(fipp_SetWeightStateCmd,fipp_GetWeightStateCmd,WeightState);
end;

{-------}
{Assumes that the caller has set the CurveFrame to the desired value.}
{Note: does not do double check}

function TclsFipp.SetCurveFrame:boolean; {9}
var CurveFormat: word;
var ByteSize : word;
begin
  SetCurveFrame := false;
  CurveFormat := (CurveFrame.Flags shr 10) and 7;
  if ((CurveFormat = 2) or (CurveFormat = 3)) then
   CurveFrameSize := FIPP_AUD_CURVE_FRAME_SIZEW //AudCurveFrameSize
  else CurveFrameSize := FIPP_STD_CURVE_FRAME_SIZEW; //StdCurveFrameSize;
  //ByteSize := CurveFrameSize*2; {crv#,crvframe}
  CmdArray.Cmd := fipp_SetCurveFrameCmd;
  CmdArray.Size := CurveFrameSize+1;
  CmdArray.Data[0] := word(CurveNumber);
  ByteSize := (CurveFrameSize + 1) * 2;
  move(CurveFrame,CmdArray.Data[1],ByteSize);
  SetCurveFrame := SetPacket();
end;

{-------}
{Assumes that the caller has set the IOmode to the desired value.}

function TclsFipp.SetIOmode:boolean;      {10}
begin
    SetIOmode := false;
    if IOModeCount <= 2 then IOModeCount := 2 else IOModeCount := 4;
    CmdArray.Cmd := fipp_SetIOmodeCmd;
    CmdArray.Size := IOModeCount;
    CmdArray.Data[0] := word(IOFrequency);
    CmdArray.Data[1] := word(IOGain);
    if (IOmodeCount > 2) then
    begin
      CmdArray.Data[2] := word(IOStartMs);
      CmdArray.Data[3] := word(IOSweepMs);
    end;
    if not(SetPacket()) then Exit;
    if DoubleCheck then
    begin
      CmdArray.Cmd := fipp_GetIOmodeCmd;
      CmdArray.Size := 0;
      if not(GetPacket()) then Exit;
      IOFrequency := integer(RspArray.Data[0]);
      IOGain := integer(RspArray.Data[1]);
    end;
    SetIOmode := true;
end;

{-------}
{Assumes that the caller has set the SourceMethod (was TelCoilState) to the desired value.}

function TclsFipp.SetSourceMethod:boolean;     {11}
begin
   SetSourceMethod :=
      SetValue(fipp_SetSourceMethodCmd,fipp_GetSourceMethodCmd,SourceMethod);
end;

{-------}
{Assumes that the caller has set the AnalysisMode (GainState) to the desired value.}

function TclsFipp.SetAnalysisMode:boolean;    {12}  {was GainState}
begin
   SetAnalysisMode :=
     SetValue(fipp_SetAnalysisModeCmd,fipp_GetAnalysisModeCmd,AnalysisMode);
end;

{-------}
{note: this command assumes that the instrument type was previously obtained in Version[]}
{note: on early FP35's this cmd is not available}
function TclsFipp.SetBatteryTest:boolean;      {14}
begin
  SetBatteryTest := false;
  CmdArray.Cmd := fipp_SetBatteryTestCmd;
  if not(DoPacket()) then Exit;
  SetBatteryTest := true;
end;
//    if ((FD_Signature.InstrumentBaseType = 0) or (FD_Signature.InstrumentBaseType = 1) or
//       (FD_Signature.InstrumentBaseType = 40)) then
//    begin
//      CmdArray.Size := 0;
//      BatteryTestEnable := -1;  {mark that test enable/disable is not available (6400/6500)}
//    end
    //else if (FD_Signature.InstrumentBaseType = 7000) then
//    begin
//      CmdArray.Size := 1;
//      CmdArray.Data[0] := BatteryTestEnable;
//    end
//    else
//    begin
//      CmdArray.Size := 0;
//    end;
//    if not(SetPacket()) then Exit;

{-------}
{Assumes that the caller has set the TelCoilMode to the desired value.}

function TclsFipp.SetTelCoilMode:boolean;     {39}
begin
   SetTelCoilMode :=
     SetValue(fipp_SetTelCoilModeCmd,fipp_GetTelCoilModeCmd,TelCoilMode);
end;

{-------}
{Assumes that the caller has set the RelAttFreq to the desired value.}

function TclsFipp.SetRelAttFreq:boolean;    {40}
begin
   SetRelAttFreq :=
     SetValue(fipp_SetRelAttFreqCmd,fipp_GetRelAttFreqCmd,RelAttFreq);
end;

{-------}
function TclsFipp.SetZetaState:boolean;    {43}   {obsolete}
begin
   SetZetaState :=
     SetValue(fipp_SetZetaStateCmd,fipp_GetZetaStateCmd,ZetaState);
end;


{-------}
{Assumes that the caller has set the Insitu data to the desired value.}

function TclsFipp.SetInsitu:boolean;      {47}   {obsolete}
begin
    SetInsitu := false;
    CmdArray.Cmd := fipp_SetInsituCmd;
    CmdArray.Size := 3;
    CmdArray.Data[0] := word(Insitu[0]);
    CmdArray.Data[1] := word(Insitu[1]);
    CmdArray.Data[2] := word(Insitu[2]);
    if not(SetPacket()) then Exit;
    if DoubleCheck then
    begin
      CmdArray.Cmd:= fipp_GetInsituCmd;
      CmdArray.Size := 0;
      if not(GetPacket()) then Exit;
      Insitu[0] := word(RspArray.Data[0]);
      Insitu[1] := word(RspArray.Data[1]);
      Insitu[2] := word(RspArray.Data[2]);
    end;
    SetInsitu := true;
end;


{-------}
function TclsFipp.SetAutoState:boolean;    {48}
begin
//   SetAutoState :=
//     SetValue(fipp_SetAutoStateCmd,fipp_GetAutoStateCmd,AutoState);

  CmdArray.Cmd := fipp_SetAutoStateCmd;
  CmdArray.Size := AutoStateSize;
  CmdArray.Data[0] := AutoState;
  CmdArray.Data[1] := AutoStepDuration;
  Result := SetPacket();
end;


{-------}
function TclsFipp.SetLimitValue:boolean;    {50}
begin
   SetLimitValue :=
     SetValue(fipp_SetLimitValueCmd,fipp_GetLimitValueCmd,LimitValue);
end;


{-------}
function TclsFipp.SetRefMicState:boolean;    {52}
begin
   SetRefMicState :=
     SetValue(fipp_SetRefMicStateCmd,fipp_GetRefMicStateCmd,RefMicState);
end;


{-------}
function TclsFipp.SetActiveStatus:boolean;    {54}
VAR OldTimer:integer;
begin
  GetNoPoll(OldTimer);      {get real poll timeout value}
  PollTimer := OldTimer;      {update current timer value}
  if PollTimer < FIPP_SUPER_LONG_POLL_TIMEOUT then    {If less than 60 sec}
  begin
    PollTimer := FIPP_SUPER_LONG_POLL_TIMEOUT;        {force it to 60 sec abort}
    SetNoPoll(PollTimer);
  end;
  SetActiveStatus :=
    SetValue(fipp_SetActiveStatusCmd,fipp_GetActiveStatusCmd,ActiveStatus);
  PollTimer := OldTimer;
  SetNoPoll(PollTimer);      {restore original poll timeout value}
end;


{-- new v2.6x -----}
function TclsFipp.SetMachineState:boolean;   {59}
var OldTimer : integer;
begin
    SetMachineState := false;
    GetNoPoll(OldTimer);      {get real poll timeout value}
    PollTimer := OldTimer;      {update current timer value}
    if PollTimer < FIPP_SUPER_LONG_POLL_TIMEOUT then    {If less than 60 seconds}
    begin
      PollTimer := FIPP_SUPER_LONG_POLL_TIMEOUT;        {force it to 60 seconds abort}
      SetNoPoll(PollTimer);
    end;
    CmdArray.Cmd := fipp_SetMachineStateCmd;
    CmdArray.Size := 2;
    CmdArray.Data[0] := word(MajorMachineState);
    CmdArray.Data[1] := word(MinorMachineState);
    SetMachineState := SetPacket();
    PollTimer := OldTimer;
    SetNoPoll(PollTimer);      {restore original poll timeout value}
end;

{-- new v2.6x -----}
function TclsFipp.SetControlLock:boolean;     {62}
begin
   SetControlLock :=
     SetValue(fipp_SetControlLockCmd,fipp_GetControlLockCmd,ControlLock);
end;

{-- new v2.6x -----}
{Assumes that the caller has set cmdarray to the desired values.}
{Assumes that the caller has built the proper motorola formated data in CmdArray.}
{LabelLines must be set to the number of lines to be sent.}
{All label lines are 28 char long with a null in the last character.}
{This includes the User ID portion.}
{Warning: if full extended label format is not supported, LabelLines must be set to 8.}
{Note: does not do double check.
{Label should be padded with spaces and must be terminated with a trailing null.}
function TclsFipp.SetExtendedLabel:boolean;  {66}
begin
  SetExtendedLabel := false;
  CmdArray.Cmd := fipp_SetExtendedLabelCmd;
  CmdArray.Size := LabelLines * FIPP_NUM_LABEL_LINE_CHAR;
  SetExtendedLabel := SetPacket();
end;


{-- new v2.6x -----}
function TclsFipp.SetSpectrum:boolean;       {68}
begin
    SetSpectrum := false;
    CmdArray.Cmd := fipp_SetSpectrumCmd;
    CmdArray.Size := fipp_MaxSpectrumPos;
    move(Spectrum,CmdArray.Data,fipp_MaxSpectrumPos*sizeof(word));
    SetSpectrum := SetPacket();
end;

{-- new v2.6x -----}
function TclsFipp.SetPhaseTable:boolean;     {69}
begin
    SetPhaseTable := false;
    CmdArray.Cmd := fipp_SetPhaseTableCmd;
    CmdArray.Size := fipp_MaxPhasePos;
    move(PhaseTable,CmdArray.Data,fipp_MaxPhasePos*sizeof(word));
    SetPhaseTable := SetPacket();
end;

{-- new v2.6x -----}
function TclsFipp.SetTestParameters:boolean;   {70}
begin
    SetTestParameters := false;
    if TestParametersSize = 0 then TestParametersSize := 5;
    CmdArray.Cmd := fipp_SetTestParametersCmd;
    CmdArray.Size := word(TestParametersSize);
    move(TestParameters,CmdArray.Data,TestParametersSize*2);
    SetTestParameters := SetPacket();
end;

{-- new v2.6x -----}
function TclsFipp.SetKeyScanCode:boolean;        {72}
begin
  SetKeyScanCode :=
    SetValue(fipp_SetKeyScanCodeCmd,fipp_GetKeyScanCodeCmd,KeyScanCode);
end;

{-- new v3.2x -----}
function TclsFipp.SetPollDelay:boolean;        {73}
begin
  if PollDelayCount = 2 then
    CmdArray.Size := 2
  else CmdArray.Size := 1;
  CmdArray.Cmd := fipp_SetPollDelayCmd;
  CmdArray.Data[0] := PollDelay;
  CmdArray.Data[1] := PollHoldoff;
  Result := SetPacket();
end;

{-- fp40 -----}
function TclsFipp.SetTestEar:boolean;        {75}
begin
{   SetTestEar :=}
{     SetValue(SetTestEarCmd,GetTestEarCmd,FIPPrec.TestEar,FIPPrec);}

    SetTestEar := false;
    CmdArray.Cmd := fipp_SetTestEarCmd;
    if EarConfig = 0 then CmdArray.Size := 2 else CmdArray.Size := 1;
    CmdArray.Data[0] := TestEar;
    CmdArray.Data[1] := EarConfig;
    SetTestEar := SetPacket();
end;

{-- fp40 -----}
function TclsFipp.SetSrcType:boolean;    {77}
var OldTimer:word;
begin
  SetSrcType :=
    SetValue(fipp_SetSrcTypeCmd,fipp_GetSrcTypeCmd,SrcType);
end;



{-- fp40 -----}
{FP40 only has one parameter, 7000/8000 use two parameters}
{FP35 uses five parameters, 6500/6400 do not have this command}
function TclsFipp.SetBatteryType:boolean;        {79}
begin
    Result := false;
    CmdArray.Cmd := fipp_SetBatteryTypeCmd;
    if (BatteryFormat <= 0) then  {make sure battery format is valid}
      BatteryFormat := 1
    else if (BatteryFormat > 5) then
      BatteryFormat := 5;

    CmdArray.Size := BatteryFormat;
    CmdArray.Data[0] := word(BatteryType);
    CmdArray.Data[1] := word(BatterySize);
    CmdArray.Data[2] := word(BatteryMAH);
    CmdArray.Data[3] := word(BatteryVolt);
    CmdArray.Data[4] := word(BatteryImp);
    if not(SetPacket()) then Exit;
    Result := true;
end;


{-- new v3.3x -----}
function TclsFipp.SetAvgFreqs:boolean;        {82}
begin
{   SetAvgFreqs :=}
{     SetValue(SetAvgFreqsCmd,GetAvgFreqsCmd,integer(FIPPrec.AvgFreqs),FIPPrec);}

    SetAvgFreqs := false;
    CmdArray.Cmd := fipp_SetAvgFreqsCmd;
    if UseAvgFreqValues then
    begin
      CmdArray.Size := 6;
      move(AvgFreqValues,CmdArray.Data,sizeof(AvgFreqValues));
    end
    else
    begin
      CmdArray.Size := 1;
      CmdArray.Data[0] := AvgFreqs;
    end;
    SetAvgFreqs := SetPacket();
end;

{-- new v3.3x -----} {old single parameter method - don't use this, use New version}
//function TclsFipp.SetSettleTime:boolean;        {84}
//begin
//   SetSettleTime :=
//     SetValue(fipp_SetSettleTimeCmd,fipp_GetSettleTimeCmd,FreqSettleTime);
//end;

function TclsFipp.SetSettleTime:boolean;  {84} {new verison}
begin
{   SetSettleTime := }
{     SetValue(SetSettleTimeCmd,GetSettleTimeCmd,integer(FIPPrec.SettleTime),FIPPrec); }
  Result := false;
  CmdArray.Cmd := fipp_SetSettleTimeCmd;
  if SettleCmdSize >= 1 then
  begin
    CmdArray.Size := 1;
    CmdArray.Data[0] := FreqSettleTime;
  end;
  if SettleCmdSize >= 3 then
  begin
    CmdArray.Size := 3;
    CmdArray.Data[0] := FreqSettleTime;
    CmdArray.Data[1] := AmpSettleTime;
    CmdArray.Data[2] := MeasureStartTime;
  end;
  if SettleCmdSize >= 5 then
  begin
    CmdArray.Size := 5;
    CmdArray.Data[3] := IoAmpSettleTime;
    CmdArray.Data[4] := IoStartDelayTime;
  end;
  if SettleCmdSize >= 6 then
  begin
    CmdArray.Size := 6;
    CmdArray.Data[5] := BurstOnTime;
  end;
  if not(SetPacket()) then Exit;
  Result := true;
end;

{-------}
{Assumes that the caller has set CICstate to the desired value.}

function TclsFipp.SetCICstate:boolean;   {88}
begin
   SetCICstate :=
      SetValue(fipp_SetCICstateCmd,fipp_GetCICstateCmd,CICstate);
end;


{-- 6500 -----}
(* old cmd 89
function SetDefaultLabel:boolean;        {89}
begin
  SetDefaultLabel := false;
  SendArray[0] := SetDefaultLabelCmd;
  SendArray[1] := 1;
  SendArray[2] := word(DefaultLabelType);
  if not(SetPacket()) then Exit;
  SetDefaultLabel := true;
end;
*)

function TclsFipp.SetPrinterLabelStorage:boolean;   {89}
begin
    SetPrinterLabelStorage := false;
    CmdArray.Cmd := fipp_SetPrinterLabelStorageCmd;
    CmdArray.Size := 1;
    CmdArray.Data[0] := word(PrinterLabelStorage);
    if not SetPacket() then Exit;
    SetPrinterLabelStorage := true;
end;

{---6500 V4.14--}
function TclsFipp.SetAvgDelayTime:boolean;   {90}
begin
  SetAvgDelayTime := false;
  CmdArray.Cmd := fipp_SetAvgDelayCmd;
  CmdArray.Size := 2;
  CmdArray.Data[0] := word(AvgStartTime);
  CmdArray.Data[1] := word(AvgSettleTime);
  if not SetPacket() then Exit;
  SetAvgDelayTime := true;
end;


{---6500 V4.20--}
function TclsFipp.SetPrinterSelect:boolean;   {92}
begin
  SetPrinterSelect := false;
  CmdArray.Cmd := fipp_SetPrinterSelectCmd;
  CmdArray.Size := 1;
  CmdArray.Data[0] := word(PrinterSelector);
  if (PrintInfoCount > 1) then
  begin
    CmdArray.Size := 2;
    CmdArray.Data[1] := word(PrinterSetup);
  end;
  if (PrintInfoCount > 2) then
  begin
    CmdArray.Size := 3;
    CmdArray.Data[2] := word(PrintDarkness); {FP35 V6.20}
  end;
  if not SetPacket() then Exit;
  SetPrinterSelect := true;
end;



{FP35 V1.10}
function TclsFipp.SetBitmap:boolean;   {96}
var OldTimer:integer;
begin
  Result := false;
  if (FryeBitmap.Size = 0) then Exit;
  GetNoPoll(OldTimer);      {get real poll timeout value}
  PollTimer := OldTimer;      {update current timer value}
  if PollTimer < FIPP_LONG_POLL_TIMEOUT then    {If less than long timeout}
  begin
    PollTimer := FIPP_LONG_POLL_TIMEOUT;        {force it to long timeout}
    SetNoPoll(PollTimer);
  end;
  move(FryeBitmap,CmdArray.Data[0],FryeBitmap.Size*2);
  CmdArray.Cmd := fipp_SetBitmapCmd;
  CmdArray.Size := FryeBitmap.Size + FIPP_FRYE_BITMAP_HDR_SIZEW;
  Result := SetPacket();
  PollTimer := OldTimer;
  SetNoPoll(PollTimer);      {restore original poll timeout value}
end;

{---6500---}
function TclsFipp.SetARparams:boolean;       {97} {6500}
begin
    SetARparams := false;
    CmdArray.cmd := fipp_SetARparamsCmd;
    CmdArray.Size := 4;
    move(ARparams[0],CmdArray.Data[0],fipp_ARparamsSize*2);
    if not(SetPacket()) then Exit;
    SetARparams := true;
end;

{-- FP35 v1.21 -----}
function TclsFipp.SetBlob:boolean;           {99}
begin
    SetBlob := false;
    CmdArray.Cmd := fipp_SetBlobCmd;
    CmdArray.Size := BlobSize;
    move(Blob,CmdArray.Data[0],BlobSize*2);
    if not(SetPacket()) then Exit;
    SetBlob := true;
end;


{---FP35 V1.00--}
function TclsFipp.SetRealTimeClock:boolean;   {104}
var i : integer;
begin
    SetRealTimeClock := false;
    CmdArray.Cmd := fipp_SetRealTimeClockCmd;
    CmdArray.Size := 5;
    move(RealTimeClockData,CmdArray.Data,sizeof(RealTimeClockData));
    if not(SetPacket()) then Exit;
    SetRealTimeClock := true;
end;

{--FP35 V2.00--}
{Assumes that the caller has set OutputDevice to the desired value.}
function TclsFipp.SetOutputDevice:boolean; {106}
begin
  Result := false;
  if (OutputDeviceSize = 2) then CmdArray.Size := 2 else CmdArray.Size := 1;
  CmdArray.Cmd := fipp_SetOutputDeviceCmd;
  CmdArray.Data[0] := OutputSelect;
  CmdArray.Data[1] := OutputDevice;
  if not(SetPacket()) then Exit;
  Result := true;
end;

{--FP35 V2.00--}
{Assumes that the caller has set ImpulseRej to the desired value.}
function TclsFipp.SetImpulseRej:boolean; {108}
begin
   SetImpulseRej :=
      SetValue(fipp_SetImpulseRejCmd,fipp_GetImpulseRejCmd,ImpulseRej);
end;

{--FP35 V2.00--}
{Assumes that the caller has set CurveSelect to the desired value.}
function TclsFipp.SetCurveSelect:boolean; {112}
begin
   SetCurveSelect :=
      SetValue(fipp_SetCurveSelectCmd,fipp_GetCurveSelectCmd,CurveSelect);
end;

{--FP35 V2.00--}
{Assumes that the caller has set CurveStatus to the desired value.}
function TclsFipp.SetCurveStatus:boolean; {114}
begin
  SetCurveStatus := false;
 {     SetValue(SetCurveStatusCmd,GetCurveStatusCmd,FIPPrec.CurveStatus,FIPPrec);}
  CmdArray.Cmd := fipp_SetCurveStatusCmd;
  CmdArray.Size := 2;
  CmdArray.Data[0] := CurveSelect;
  CmdArray.Data[1] := CurveStatus;
  if not(SetPacket()) then Exit;
  SetCurveStatus := true;
end;

{--FP35 V2.00--}
{Assumes that the caller has set UnaidedSelect to the desired value.}
function TclsFipp.SetUnaidedSelect:boolean; {116}
begin
   SetUnaidedSelect :=
      SetValue(fipp_SetUnaidedSelectCmd,fipp_GetUnaidedSelectCmd,UnaidedSelect);
end;

{-- new FP35 V4.72 -----}
function TclsFipp.SetListData:boolean;    {118} {fp35 v4.72 }
var ListSize : integer;
begin
  Result := false;
  CmdArray.Cmd := fipp_SetListDataCmd;
  CmdArray.Size := ListDataSize+1;
  CmdArray.Data[0] := ListSelection;
  move(ListData,CmdArray.Data[1],ListDataSize*2);
  if not(SetPacket()) then Exit;
  Result := true;
end;

{--FP35 V2.10--}
{Assumes that the caller has set StaticToneSelect to the desired value.}
function TclsFipp.SetStaticToneSelect:boolean; {121}
begin
   SetStaticToneSelect :=
      SetValue(fipp_SetStaticToneSelectCmd,fipp_GetStaticToneSelectCmd,StaticToneSelect);
end;

{--FP35 V2.10--}
{Assumes that the caller has set AidGroupSelect and AidTypeSelect to the desired value.}
function TclsFipp.SetAidInfoSelect:boolean; {123}
begin
  Result := false;
  if (AidInfoSize = 2) then
    CmdArray.Size := 2
  else CmdArray.Size := 1;
  CmdArray.Cmd := fipp_SetAidInfoSelectCmd;
  CmdArray.Data[0] := AidGroupSelect;
  CmdArray.Data[1] := AidTypeSelect;
  if not(SetPacket()) then Exit;
  Result := true;
end;

{future}
function TclsFipp.SetBiasTone:boolean; {125}
begin
  SetBiasTone := false;
  CmdArray.Cmd := fipp_SetBiasToneCmd;
  CmdArray.Size := 3;
  CmdArray.Data[0] := BiasToneSource;
  CmdArray.Data[1] := BiasToneFrequency;
  CmdArray.Data[2] := BiasToneDuration;
  if not(SetPacket()) then Exit;
  SetBiasTone := true;
end;

{--FP35 V2.20--}
{Assumes that the caller has set WarbleSelect to the desired value.}
{Only warble rate selection supported by this command. }
{Use Build command if enhanced warblerate selection is available}
function TclsFipp.SetWarbleSelect:boolean; {129}
begin
   SetWarbleSelect :=
      SetValue(fipp_SetWarbleSelectCmd,fipp_GetWarbleSelectCmd,WarbleSelect);
end;


{-- new fp35 v2.20 -----}
function TclsFipp.SetRcvTimeout:boolean;        {132}
var Temp : smallint;
begin
  Temp := RcvTimeout;
  SetRcvTimeout := SetValue(fipp_SetRcvTimeoutCmd,fipp_GetRcvTimeoutCmd,Temp);
  RcvTimeout := Temp;
end;

{-- new fp35 v2.30 -----}
function TclsFipp.SetFitRule:boolean;        {134}
var Temp : smallint;
begin
  Temp := FitRule;
  SetFitRule := SetValue(fipp_SetFitRuleCmd,fipp_GetFitRuleCmd,Temp);
  FitRule := Temp;
end;


{-- new fp35 v3.00 -----}
function TclsFipp.SetFilter:boolean;        {136}
var Temp : smallint;
begin
  Temp := FilterType;
  SetFilter := SetValue(fipp_SetFilterCmd,fipp_GetFilterCmd,Temp);
  FilterType := Temp;
end;

{--FP35 V3.00--}
{Assumes that the caller has set compression to the desired value.}
function TclsFipp.SetCompression:boolean; {138}
begin
   SetCompression :=
      SetValue(fipp_SetCompressionCmd,fipp_GetCompressionCmd,Compression);
end;

{--FP35 V3.00--}
{Assumes that the caller has set age to the desired value.}
function TclsFipp.SetClientAge:boolean; {140}
begin
   SetClientAge :=
      SetValue(fipp_SetClientAgeCmd,fipp_GetClientAgeCmd,ClientAge);
end;

{--FP35 V3.10--}
{Assumes that the caller has set location to the desired value.}
function TclsFipp.SetTransducerLoc:boolean; {142}
begin
  SetTransducerLoc := false;
  CmdArray.Cmd := fipp_SetTransducerLocCmd;
  CmdArray.Size := 2;
  CmdArray.Data[0] := 0; {currenlty only speaker location is valid}
  CmdArray.Data[1] := TransducerLoc;
  if not(SetPacket()) then Exit;
  SetTransducerLoc := true;
end;


{-- FP35 v3.20 -----}
function TclsFipp.SetLevelingList:boolean;       {145}
begin
    SetLevelingList := false;
    CmdArray.Cmd := fipp_SetLevelingListCmd;
    CmdArray.Size := LevelingListSize;
    move(LevelingList,CmdArray.Data,LevelingListSize*sizeof(word));
    SetLevelingList := SetPacket();
end;

{--FP35 V3.20--}
{Assumes that the caller has set location to the desired value.}
function TclsFipp.SetLevelingStatus:boolean; {147}
begin
   SetLevelingStatus :=
      SetValue(fipp_SetLevelingStatusCmd,fipp_GetLevelingStatusCmd,LevelState);
end;


{-- FP35 v3.20 -----}
function TclsFipp.SetAuxPort:boolean;       {148}
var Index : integer;
begin
    SetAuxPort := false;
    CmdArray.Cmd := fipp_SetAuxPortCmd;
    CmdArray.Data[0] := $0100;
    Index := 3;
    if integer(AuxStartCtrl) <> -1 then
    begin
      CmdArray.Data[0] := CmdArray.Data[0] or $0001;
      CmdArray.Data[1] := AuxStartCtrl;
      AuxCtrl := AuxStartCtrl;
      Index := Index + 1;
    end;
    CmdArray.Raw[Index] := AuxOutCount;
    Index := Index + 1;
    if AuxOutCount > 0 then
    begin
      move(AuxOutData,CmdArray.Raw[Index],AuxOutCount);
      Index := Index + ((AuxOutCount + 1) div 2);
    end;
    if integer(AuxEndCtrl) <> -1 then
    begin
      CmdArray.Raw[Index] := AuxEndCtrl;
      AuxCtrl := AuxEndCtrl;
      CmdArray.Data[0] := CmdArray.Data[0] or $0002;
      Index := Index + 1;
    end;
    CmdArray.Size := Index - 2;
    SetAuxPort := SetPacket();
end;

{--FP35 V3.20--}
{Assumes that the caller has set UserNumber to the desired value.}
function TclsFipp.SetUserNumber:boolean; {150}
begin
   SetUserNumber :=
      SetValue(fipp_SetUserNumberCmd,fipp_GetUserNumberCmd,UserNumber);
end;


{-- new FP35 V3.20 -----}
function TclsFipp.SetFitType:boolean;    {152} {fp35 v3.20 12/01/03}
begin
   SetFitType :=
      SetValue(fipp_SetFitTypeCmd,fipp_GetFitTypeCmd,Fit.AidFitType);
end;

{-- new FP35 V3.20 -----}
function TclsFipp.SetVentType:boolean;    {154} {fp35 v3.20 12/01/03}
begin
   SetVentType :=
      SetValue(fipp_SetVentTypeCmd,fipp_GetVentTypeCmd,Fit.AidVentType);
end;

{-- new FP35 V3.20 -----}
function TclsFipp.SetTubingType:boolean;    {156} {fp35 v3.20 12/01/03}
begin
   SetTubingType :=
      SetValue(fipp_SetTubingTypeCmd,fipp_GetTubingTypeCmd,Fit.AidTubingType);
end;

{-- new FP35 V3.20 -----}
function TclsFipp.SetAidChannels:boolean;    {158} {fp35 v3.20 12/01/03}
begin
   SetAidChannels :=
      SetValue(fipp_SetAidChannelsCmd,fipp_GetAidChannelsCmd,Fit.AidChannels);
end;

{-- new FP35 V3.20 -----}
function TclsFipp.SetAidLimiting:boolean;    {160} {fp35 v3.20 12/01/03}
begin
   SetAidLimiting :=
      SetValue(fipp_SetAidLimitingCmd,fipp_GetAidLimitingCmd,Fit.AidLimiting);
end;

{-- new FP35 V3.70 -----}
function TclsFipp.SetRefMethod:boolean;    {162} {fp35 v3.70 06/06/06}
begin
   SetRefMethod :=
      SetValue(fipp_SetRefMethodCmd,fipp_GetRefMethodCmd,Fit.RefMethod);
end;


{-- new FP35 V3.20 -----}
function TclsFipp.SetFitParam:boolean;    {164} {fp35 v3.20 12/01/03}
var FitSize : integer;
begin
  FitSize := sizeof(Fit) div sizeof(Word);
  SetFitParam := false;
  if (FitCount < 12) or (FitCount > FitSize) then
    FitCount := FitSize;
  CmdArray.Cmd := fipp_SetFitParamCmd;
  CmdArray.Size := FitCount;
  move(Fit,CmdArray.Data,sizeof(Fit));
  if not(SetPacket()) then Exit;
  SetFitParam := true;
end;


{-- FP35 V3.20 -----}
function TclsFipp.SetUserIDText:boolean;  {166}
var i : integer;
begin
    SetUserIDText := false;
    if UserNumber > 15 then UserNumber := 15;
    CmdArray.Cmd:= fipp_SetUserIDTextCmd;
    CmdArray.Size := (FIPP_MAX_USERID_TEXT shr 1) + 1; {div 2}
    CmdArray.Data[0] := UserNumber;
    UserIDText[UserNumber][pred(FIPP_MAX_USERID_TEXT)] := #0; {force last byte to null}
    i := 0;
    while i < FIPP_MAX_USERID_TEXT do
    begin
      CmdArray.Raw[(i shr 1)+3] := (ord(UserIDText[UserNumber][i]) shl 8)+
                                 ord(UserIDText[UserNumber][succ(i)]);
      inc(i,2);
    end;
    SetUserIDText := SetPacket();
end;

{-- new FP35 V3.30 -----}
function TclsFipp.SetSkew:boolean;    {168} {fp35 v3.30 07/01/04}
begin
  SetSkew := false;
  CmdArray.Cmd := fipp_SetSkewCmd;
  CmdArray.Size := 2;
  CmdArray.Data[0] := WhichSkew;
  CmdArray.Data[1] := Skew;
  if not(SetPacket()) then Exit;
  SetSkew := true;
end;

{-- new FP35 V3.40 -----}
function TclsFipp.SetScreenMode:boolean;    {170}
begin
  SetScreenMode := false;
  CmdArray.Cmd := fipp_SetScreenModeCmd;
  if VgaOption = true then
  begin
    CmdArray.Size := 2;
    CmdArray.Data[0] := LcdMode;
    CmdArray.Data[1] := VgaPalette;
  end
  else
  begin
    CmdArray.Size := 1;
    CmdArray.Data[0] := LcdMode;
  end;
  if not(SetPacket()) then Exit;
  SetScreenMode := true;
end;

{-- new FP35 V3.50 -----}
function TclsFipp.SetCouplerSelection:boolean;    {172} {fp35 v3.50 12/16/04}
begin
    SetCouplerSelection := false;
    CmdArray.Cmd := fipp_SetCouplerSelectionCmd;
    CmdArray.Size := 1;
    CmdArray.Data[0] := CouplerSelection;
    if not(SetPacket()) then Exit;
    SetCouplerSelection := true;
end;


{-- new FP35 V3.60 -----}
function TclsFipp.SetAnalysisSelection:boolean;    {174} {fp35 v3.60 06/12/06}
begin
   SetAnalysisSelection :=
      SetValue(fipp_SetAnalysisSelectionCmd,fipp_GetAnalysisSelectionCmd,AnalysisSelection);
end;


{-------}
function TclsFipp.SetStoredParameter:boolean;       {180}
begin
    SetStoredParameter := false;
    CmdArray.Cmd := fipp_SetStoredParameterCmd;
    CmdArray.Size := 2;
    CmdArray.Data[0] := StoredParameterNumber; {SavedItemNumber;}
    CmdArray.Data[1] := StoredParameterValue;  {SavedParameter;}
    SetStoredParameter := SetPacket();
end;

{-- 8000 -----}
function TclsFipp.SetCurveGroupSelect:boolean;    {182}
begin
   Result := SetValue(fipp_SetCurveGroupSelectCmd,fipp_GetCurveGroupSelectCmd,CurveGroupSelect);
end;

{--------}
function TclsFipp.SetAgcFreqSelect:boolean;    {184}
begin
  Result := false;
  CmdArray.Cmd := fipp_SetAgcFreqSelectCmd;
  CmdArray.Data[0] := AgcFreqSelect;
  CmdArray.Data[1] := AgcFreqEnable;
  CmdArray.Data[2] := AgcFreqIndex;
  if AgcFreqSelectSize = 3 then
    CmdArray.Size := 3
  else CmdArray.Size := 2;
  if not(SetPacket()) then Exit;
  Result := true;
end;

{-- FP35 -----}
function TclsFipp.SetInputPortSelect:boolean;    {186}
begin
   Result := SetValue(fipp_SetInputPortSelectCmd,fipp_GetInputPortSelectCmd,InputPortSelect);
end;


{-- 8000 -----}
function TclsFipp.SetAngleSelect:boolean;    {188}
begin
   Result := SetValue(fipp_SetAngleSelectCmd,fipp_GetAngleSelectCmd,AngleSelect);
end;

{--------}
function TclsFipp.SetDiffFreq:boolean;    {190}
begin
  Result := false;
  CmdArray.Cmd := fipp_SetDiffFreqCmd;
  CmdArray.Data[0] := DiffFreq;
  CmdArray.Data[1] := SweepEndFreq;
  if DiffFreqRspSize = 2 then
    CmdArray.Size := 2
  else CmdArray.Size := 1;
  if not(SetPacket()) then Exit;
  Result := true;
end;

{-- FP35 -----}
function TclsFipp.SetUserMode:boolean;    {192}
begin
   Result := SetValue(fipp_SetUserModeCmd,fipp_GetUserModeCmd,UserMode);
end;


{++++++++}
{The following procedures handle the standard FIPP Get commands}
{the command simply updates the appropriate variable in FIPPrec}
{it is up to the calling routine to insure that the desired variables}
{are properly updated before using them.}

{Get cmds return true if everything went ok. false if not (error in FippError)
//if everything went ok, value is returned in indicated variable(s)}

{---------}
function TclsFipp.GetRelAttData:boolean;      {18}
begin
    GetRelAttData := false;
    CmdArray.Cmd := fipp_GetRelAttDataCmd;
    CmdArray.Size := 0;
    if not(GetPacket()) then Exit;
    AttackTime := integer(RspArray.Data[0]);
    ReleaseTime := integer(RspArray.Data[1]);
    GetRelAttData := true;
end;

{-------}
function TclsFipp.GetBatteryData:boolean;     {19}
begin
    GetBatteryData := false;
    CmdArray.Cmd := fipp_GetBatteryDataCmd;
    CmdArray.Size := 0;
    if not(GetPacket()) then Exit;
    BatteryCurrent := integer(RspArray.Data[0]);
    BatteryType := integer(RspArray.Data[1]);
    if RspArray.Size > 2 then
      BatteryVolt := integer(RspArray.Data[2]);
    if RspArray.Size > 3 then
      BatteryImp := integer(RspArray.Data[3]);
    GetBatteryData := true;
end;

{-------}
function TclsFipp.GetIOdata:boolean;      {20}
begin
    GetIOdata := false;
    CmdArray.Cmd := fipp_GetIOdataCmd;
    CmdArray.Size := 0;
    if not(GetPacket()) then Exit;
    move(RspArray.Data[0],IOcurve,fipp_IOcurveSize);
    GetIOdata := true;
end;

{-------}
function TclsFipp.GetSourceAmp:boolean;   {21}
begin
   GetSourceAmp := GetValue(fipp_GetSourceAmpCmd,SourceAmp);
end;

{-------}
function TclsFipp.GetDistMode:boolean;    {22}
begin
   GetDistMode := GetValue(fipp_GetDistModeCmd,DistMode);
end;

{-------}
function TclsFipp.GetFrequency:boolean;   {23}
begin
   GetFrequency := GetValue(fipp_GetFrequencyCmd,Frequency);
end;

{-------}
function TclsFipp.GetOESstate:boolean;   {24}   {obsolete}
begin
   GetOESstate := GetValue(fipp_GetOESstateCmd,OESstate);
end;

{-------}
function TclsFipp.GetCurveFrame:boolean;  {25}
var CurveFormat: word;
var ByteSize : word;
begin
    GetCurveFrame := false;
    CmdArray.Cmd := fipp_GetCurveFrameCmd;
    CmdArray.Size := 1;
    CmdArray.Data[0] := word(CurveNumber);
    if not(GetPacket()) then Exit;

    fillchar(CurveFrame,sizeof(CurveFrame),0);
    CurveNumber := integer(RspArray.Data[0]);
    CurveFormat := (RspArray.Data[1] shr 10) and 7;
    if ((CurveFormat = 2) or (CurveFormat = 3)) then
     CurveFrameSize := FIPP_AUD_CURVE_FRAME_SIZEW //AudCurveFrameSize
    else CurveFrameSize := FIPP_STD_CURVE_FRAME_SIZEW; //StdCurveFrameSize;
    ByteSize := CurveFrameSize*2;
    move(RspArray.Data[1],CurveFrame,ByteSize);
    GetCurveFrame := true;
end;

{-------}
function TclsFipp.GetNoiseRedCount:boolean;    {26}
begin
   GetNoiseRedCount := GetValue(fipp_GetNoiseRedCountCmd,NoiseRedCount);
end;

{--------}
function TclsFipp.GetSmoothState:boolean; {27}
begin
   GetSmoothState := GetValue(fipp_GetSmoothStateCmd,SmoothState);
end;

{-------}
function TclsFipp.GetFonixVersion:boolean;      {28}
var VerSize:integer;
begin
  GetFonixVersion := false;
  CmdArray.Cmd := fipp_GetFonixVersionCmd;
  CmdArray.Size := 0;
  if not(GetPacket()) then Exit;
  FonixVersionSize := RspArray.Size;  //size of record received in words
  if FonixVersionSize > sizeof(FIPP_tVersionArray) then
    FonixVersionSize := sizeof(FIPP_tVersionArray);
  move(RspArray.Data,FonixVersionArray,FonixVersionSize*2);
  move(RspArray.Data,FonixHwVersion,sizeof(FIPP_tMachineVersion));

  //Special case hack to deal with screwy 8000 indentification
  if (FonixHwVersion.InstrumentModel <= 0) then
  begin
    FonixHwVersion.InstrumentModel := FonixHwVersion.InstrumentBaseType;
    if ((FonixHwVersion.InstrumentBaseType = 7000) and (FonixHwVersion.SubType = 1)) then
    begin
      FonixHwVersion.InstrumentModel := 8000;
    end;
    if ((FonixHwVersion.InstrumentBaseType = 7000) and (FonixHwVersion.SubType = 2)) then
    begin
      FonixHwVersion.InstrumentModel := 8001;
    end;
//    if (FonixHwVersion.InstrumentBaseType = 0) then
//    begin
//      FonixHwVersion.InstrumentModel := 6500;
//    end
//    else if (FonixHwVersion.InstrumentBaseType = 1) then
//    begin
//      FonixHwVersion.InstrumentModel := 6400;
//    end;
  end;
  GetFonixVersion := true;
end;

{-------}
function TclsFipp.GetLevelState:boolean;  {29}
begin
  // GetLevelState := GetValue(fipp_GetLevelingStatusCmd,LevelState);
  Result := false;
  CmdArray.Cmd := fipp_GetLevelingStatusCmd;
  CmdArray.Size := 0;
  if not(GetPacket()) then Exit;
  LevelState := integer(RspArray.Data[0]);
  if (RspArray.Size > 1) then
    LevelDirection := integer(RspArray.Data[1])
  else LevelDirection := INVALID_DATA16;
  if (RspArray.Size > 2) then
   AdvLevelStatus := integer(RspArray.Data[2])
  else AdvLevelStatus := INVALID_DATA16;
  if (RspArray.Size > 3) then
   LevelMaxSpl := integer(RspArray.Data[3])
  else LevelMaxSpl := INVALID_DATA16;
  Result := true;
end;

{-------}
function TclsFipp.GetWeightState:boolean; {30}   {obsolete}
begin
   GetWeightState := GetValue(fipp_GetWeightStateCmd,WeightState);
end;

{-------}
function TclsFipp.GetMicData:boolean;       {31}
begin
   GetMicData := GetValue(fipp_GetMicDataCmd,MicData);
end;

{-------}
function TclsFipp.GetDistPercent:boolean;    {32}
begin
   GetDistPercent := GetValue(fipp_GetDistPercentCmd,DistPercent);
end;

{-------}
function TclsFipp.GetCmdStatus:boolean;    {33}
begin
  CmdStatusFailed := true;
  CmdArray.Cmd := fipp_GetCmdStatusCmd;
  CmdArray.Size := 0;
  Result := DoFippCmd(FCOM_ACK_OK, FIPP_DEFAULT_NO_POLL);
  if Result = false then Exit;

  if (RspArray.Cmd and $7fff) <> CmdArray.Cmd then
  begin
    Exit;
  end;
  CmdStatus := integer(RspArray.Data[0]);

  CmdStatusFailed := false;
  Result := true;
end;

{-------}
function TclsFipp.GetIOmode:boolean;       {34}
begin
    GetIOmode := false;
    CmdArray.Cmd := fipp_GetIOmodeCmd;
    CmdArray.Size := 0;
    if not(GetPacket()) then Exit;
    IOFrequency := integer(RspArray.Data[0]);
    IOGain := integer(RspArray.Data[1]);
    if (integer(RspArray.Size) > 3) then
    begin
      IOStartMs := integer(RspArray.Data[2]);
      IOSweepMs := integer(RspArray.Data[3]);
    end;
    GetIOmode := true;
end;

{-------}
function TclsFipp.GetProbeState:boolean;    {35}   {obsolete}
begin
   GetProbeState := GetValue(fipp_GetProbeStateCmd,ProbeState);
end;

{-------}
function TclsFipp.GetAnalysisMode:boolean;   {36}  {was GainState}
begin
   GetAnalysisMode := GetValue(fipp_GetAnalysisModeCmd,AnalysisMode);
end;

{-------}
function TclsFipp.GetSourceMethod:boolean; {37}    {was GetTelCoilState}
begin
   GetSourceMethod := GetValue(fipp_GetSourceMethodCmd,SourceMethod);
end;

{-------}
function TclsFipp.GetRelAttFreq:boolean;    {41}
begin
   GetRelAttFreq := GetValue(fipp_GetRelAttFreqCmd,RelAttFreq);
end;

{-------}
function TclsFipp.GetLastCurve:boolean;     {42}
var CurveFormat: word;
var ByteSize : word;
begin
    GetLastCurve := false;
    CmdArray.Cmd := fipp_GetLastCurveCmd;      {- last curve is number 99}
    CmdArray.Size := 0;                    {- note last curve is same}
    if not(GetPacket()) then Exit; {- as normal curve, but no}
    CurveNumber := 99;                    {- curve number is provided}
    CurveFormat := (RspArray.Data[1] shr 10) and 7;
    if ((CurveFormat = 2) or (CurveFormat = 3)) then
     CurveFrameSize := FIPP_AUD_CURVE_FRAME_SIZEW //AudCurveFrameSize
    else CurveFrameSize := FIPP_STD_CURVE_FRAME_SIZEW; //StdCurveFrameSize;
    ByteSize := (CurveFrameSize+3)*2; {cmd,len,crv#,crv}
    move(RspArray.Data[0],CurveFrame,ByteSize);
    GetLastCurve := true;
end;

{-------}
function TclsFipp.GetTelCoilMode:boolean; {44}
begin
   GetTelCoilMode := GetValue(fipp_GetTelCoilModeCmd,TelCoilMode);
end;

{-------}
function TclsFipp.GetZetaState:boolean;    {45}   {obsolete}
begin
   GetZetaState := GetValue(fipp_GetZetaStateCmd,ZetaState);
end;

{-------}
function TclsFipp.GetInsitu:boolean;       {46}   {obsolete}
begin
    GetInsitu := false;
    CmdArray.Cmd := fipp_GetInsituCmd;
    CmdArray.Size := 0;
    if not(GetPacket()) then Exit;
    Insitu[0] := word(RspArray.Data[0]);
    Insitu[1] := word(RspArray.Data[1]);
    Insitu[2] := word(RspArray.Data[2]);
    GetInsitu := true;
end;

{-------}
function TclsFipp.GetAutoState:boolean;    {49}
begin
  Result := false;
  //GetAutoState := GetValue(fipp_GetAutoStateCmd,AutoState);
  CmdArray.Cmd := fipp_GetAutoStateCmd;
  CmdArray.Size := 0;
  if not(GetPacket()) then Exit;
  AutoState := integer(RspArray.Data[0]);
  AutoStateSize := RspArray.Size; //how many parameters were returned
  if (RspArray.Size > 1) then
  begin
    AutoStepDuration := integer(RspArray.Data[1]);
  end;
  Result := true;
end;


{-------}
function TclsFipp.GetLimitValue:boolean;    {51}
begin
   GetLimitValue := GetValue(fipp_GetLimitValueCmd,LimitValue);
end;


{-------}
function TclsFipp.GetRefMicState:boolean;    {53}
begin
   GetRefMicState := GetValue(fipp_GetRefMicStateCmd,RefMicState);
end;



{-------}
function TclsFipp.GetActiveStatus:boolean;    {55}
begin
   GetActiveStatus := GetValue(fipp_GetActiveStatusCmd,ActiveStatus);
end;


{-------}
function TclsFipp.GetRefMicData:boolean;       {57}
begin
   GetRefMicData := GetValue(fipp_GetRefMicDataCmd,RefMicData);
end;


{-- new v2.6x -----}
function TclsFipp.GetKeyScanCode:boolean;        {58}
begin
   GetKeyScanCode := GetValue(fipp_GetKeyScanCodeCmd,KeyScanCode);
end;

{-- new v2.6x -----}
function TclsFipp.GetMachineState:boolean;   {60}
begin
    GetMachineState := false;
    CmdArray.Cmd := fipp_GetMachineStateCmd;
    CmdArray.Size := 0;
    if not(GetPacket()) then Exit;
    MajorMachineState := integer(RspArray.Data[0]);
    MinorMachineState := integer(RspArray.Data[1]);
    GetMachineState := true;
end;

{-- new v2.6x -----}
function TclsFipp.GetBlob:boolean;           {61}
begin
    GetBlob := false;
    FD_WordFill(Blob,$8000,Sizeof(Blob) div 2);
    CmdArray.Cmd := fipp_GetBlobCmd;
    CmdArray.Size := 0;
    if not(GetPacket()) then Exit;
    BlobSize := word(RspArray.Size);
    move(RspArray.Data,Blob,BlobSize*2);
    GetBlob := true;
end;

{-- new v2.6x -----}
function TclsFipp.GetControlLock:boolean;     {63}
begin
   GetControlLock := GetValue(fipp_GetControlLockCmd,ControlLock);
end;

{-- new v2.6x -----}
function TclsFipp.GetTestParameters:boolean;   {71}
begin
    GetTestParameters := false;
    FD_WordFill(TestParameters[1],$8000,(Sizeof(TestParameters) div 2)-1);
    CmdArray.Cmd := fipp_GetTestParametersCmd;
    CmdArray.Size := 1;
    CmdArray.Data[0] := word(TestParameters[0]);
    if not(GetPacket()) then Exit;
    TestParametersSize := word(RspArray.Size);
    move(RspArray.Data[0],TestParameters,TestParametersSize*2);
    GetTestParameters := true;
end;


{-- new v2.6x -----}
function TclsFipp.GetPollDelay:boolean;     {74}
begin
  Result := false;
  CmdArray.Cmd := fipp_GetPollDelayCmd;
  CmdArray.Size := 0;
  if not(GetPacket()) then Exit;
  PollDelay := RspArray.Data[0];
  if (RspArray.Size > 1) then
  begin
    PollHoldoff := RspArray.Data[1];
  end;
  PollDelayCount := RspArray.Size;
  Result := true;
end;

{-- fp40 -----}
function TclsFipp.GetTestEar:boolean;     {76}
begin
    GetTestEar := false;
    CmdArray.Cmd := fipp_GetTestEarCmd;
    CmdArray.Size := 0;
    if not(GetPacket()) then Exit;
    TestEar := integer(RspArray.Data[0]);
    if (RspArray.Size > 1) then
      EarConfig := integer(RspArray.Data[1])
    else EarConfig := -1;
    GetTestEar := true;

   { if EarConfig >= 0 then EarCmdType = 1 else EarCmdType = 2;}
   {GetTestEar :=
     GetValue(GetTestEarCmd,integer(FIPPrec.TestEar),FIPPrec);}
end;

{-- fp40 -----}
function TclsFipp.GetSrcType:boolean;    {78}
begin
   GetSrcType := GetValue(fipp_GetSrcTypeCmd,SrcType);
end;


{-------------}
function PowerFlagsToState(PowerFlags:smallint):smallint;
var TestFlags : integer;
begin
  TestFlags := PowerFlags and FIPP_POWER_FLAGS_MASK;
  if (TestFlags and BIT14) <> 0 then
    Result := 2
  else if (TestFlags and BIT13) <> 0 then
    Result := 1
  else Result := 0;
end;

function TclsFipp.GetPowerStatus:boolean;   {80}
begin
    GetPowerStatus := false;
    PowerCmdSize := 0;
    CmdArray.Cmd := fipp_GetPowerStatusCmd;
    CmdArray.Size := 0;
    if not(GetPacket()) then Exit;
    PowerCmdSize := RspArray.Size;
    PowerVoltage := integer(RspArray.Data[0]);
    PowerFlags := word(RspArray.Data[1]);
    PowerState := PowerFlagsToState(PowerFlags);
    if (PowerCmdSize > 2) then
      StandbyTimeout := word(RspArray.Data[2])
    else StandbyTimeout := -1;
    if (PowerCmdSize > 3) then
      PowerDownTimeout := word(RspArray.Data[3])
    else PowerDownTimeout := -1;
    GetPowerStatus := true;
end;


{-- new v3.3x -----}
function TclsFipp.GetAvgFreqs:boolean;     {81}
begin
   {GetAvgFreqs :=}
   {  GetValue(GetAvgFreqsCmd,integer(FIPPrec.AvgFreqs),FIPPrec);}

    GetAvgFreqs := false;
    CmdArray.Cmd := fipp_GetAvgFreqsCmd;
    if UseAvgFreqValues then
    begin
      CmdArray.Size := 1;
      CmdArray.Data[0] := AvgFreqs;
    end
    else CmdArray.Size := 0;
    if not(GetPacket()) then Exit;
    if not(UseAvgFreqValues) and (smallint(RspArray.Data[0]) = -1) then
    begin
      AvgFreqs := -1;
      CmdArray.Size := 1;
      CmdArray.Data[0] := RspArray.Data[0];
      UseAvgFreqValues := true;
    end;
    if not(GetPacket()) then Exit;
    if UseAvgFreqValues then
      move(RspArray.Data[0],AvgFreqValues,sizeof(AvgFreqValues))
    else AvgFreqs := smallint(RspArray.Data[0]);
    GetAvgFreqs := true;
end;

{-- new v3.3x -----}
function TclsFipp.GetSettleTime:boolean;     {83}
begin
   {GetSettleTime := }
   {  GetValue(GetSettleTimeCmd,integer(FIPPrec.SettleTime),FIPPrec); }

    GetSettleTime := false;
    CmdArray.Cmd := fipp_GetSettleTimeCmd;
    CmdArray.Size := 0;
    if not(GetPacket()) then Exit;
    SettleCmdSize := RspArray.Size;
    if (SettleCmdSize >= 1) then
    begin
      FreqSettleTime := integer(RspArray.Data[0]);
    end;
    if SettleCmdSize >= 2 then
    begin
      AmpSettleTime := integer(RspArray.Data[1]);
    end;
    if SettleCmdSize >= 3 then
    begin
      MeasureStartTime := integer(RspArray.Data[2]);
    end;
    if SettleCmdSize >= 4 then
    begin
      IoAmpSettleTime := integer(RspArray.Data[3]);;
    end;
    if SettleCmdSize >= 5 then
    begin
      IoStartDelayTime := integer(RspArray.Data[4]);;
    end;
    if SettleCmdSize >= 6 then
    begin
      BurstOnTime := integer(RspArray.Data[5]);;
    end;
    GetSettleTime := true;
end;


{-- new v4.0x -----}
{read the label from the fipp object and convert it to asciiz format}
{Note: does not do double check. Note: Label is a 2D ASCIIZ string array.}
{Label should be padded with spaces.}
{If Lines is zero, the old call method is used (return full label only).}
{If Lines is > 0 (1->8), then the number of indicated lines is returned.}
{If Lines is > 8 (9 or 10), then the user ID is also returned (lines 9 and 10).}
function TclsFipp.GetExtendedLabel:boolean;  {86}
var Size:integer;
begin
    GetExtendedLabel := false;
    CmdArray.Cmd := fipp_GetExtendedLabelCmd;
    if (LabelLines = 0) then
    begin
      CmdArray.Size := 1;
      CmdArray.Data[0] := LabelType;
    end
    else
    begin
      CmdArray.Size := 2;
      CmdArray.Data[0] := LabelType;
      CmdArray.Data[1] := LabelLines;
    end;
    if not(GetPacket()) then Exit;
    Size := RspArray.Size * 2;
    if (Size > sizeof(ExtLabelData)) then Size := sizeof(ExtLabelData);
    ConvertLabelFromRcv(Size,ExtLabelData);
    if (LabelLines > 8) then
    begin
      GetUserIDFromRcv(true,sizeof(FIPP_tUserIDText),UserIDText[UserNumber]);
    end;
    GetExtendedLabel := true;
end;

{-------}
function TclsFipp.GetCICstate:boolean;   {87}
begin
   GetCICstate := GetValue(fipp_GetCICstateCmd,CICstate);
end;


{---6500 V4.14--}
function TclsFipp.GetAvgDelayTime:boolean;   {91}
begin
    GetAvgDelayTime := false;
    CmdArray.Cmd := fipp_GetAvgDelayCmd;
    CmdArray.Size := 0;
    if not(GetPacket()) then Exit;
    AvgStartTime := integer(RspArray.Data[0]);
    AvgSettleTime := integer(RspArray.Data[1]);
    GetAvgDelayTime := true;
end;

{---6500 V4.20--}
function TclsFipp.GetPrinterSelect:boolean;   {93}
begin
    GetPrinterSelect := false;
    CmdArray.Cmd := fipp_GetPrinterSelectCmd;
    CmdArray.Size := 0;
    if not(GetPacket()) then Exit;
    PrinterSelector := integer(RspArray.Data[0]);
    PrintInfoCount := 1;
    if (integer(RspArray.Size) > 1) then
    begin
      PrinterSetup := integer(RspArray.Data[1]);
      PrintInfoCount := 2;
    end;
    if (integer(RspArray.Size) > 2) then
    begin
      PrintDarkness := integer(RspArray.Data[2]);
      PrintInfoCount := 3;
    end;
    GetPrinterSelect := true;
end;


{---6500 V4.40--}
function TclsFipp.GetHFAMeasurement:boolean;   {94}
begin
    GetHFAMeasurement := false;
    CmdArray.Cmd := fipp_GetHFAMeasurementCmd;
    CmdArray.Size := 0;
    if not(GetPacket()) then Exit;
    HFAData := integer(RspArray.Data[0]);
    GetHFAMeasurement := true;
end;

{---FP35 V2.00-- : SerialNumber & mfg/cal dates added in V2.20}
function TclsFipp.GetInstrumentInformation:boolean;   {95}
var Size : integer;
begin
  GetInstrumentInformation := false;
  //FippError := GetInstrumentInfo(NIL);

  CmdArray.Cmd := fipp_GetInstrumentInfoCmd;
  CmdArray.Size := 0;
  InstrumentInfoSize := 0;
  fillchar(InstrumentInfo,sizeof(InstrumentInfo),0);
  //fillchar(InstrumentInfo.SerialNumber,sizeof(InstrumentInfo.SerialNumber),'?');
  InstrumentInfo.SerialNumber := 'UNKNOWN?';
  if not(GetPacket()) then Exit;
  Size := RspArray.Size;
  if Size < 0 then Size := 0;
  if Size > (sizeof(InstrumentInfo) div 2) then
    Size := sizeof(InstrumentInfo) div 2;
  InstrumentInfoSize := Size;     //size of instrument info record received in words
  move(RspArray.Data[0],InstrumentInfo,Size*2);
  if ((InstrumentInfo.BootLoaderVersion = 1792)and(InstrumentInfo.MachineType = FONIX_FP35)) then
    InstrumentInfo.BootLoaderVersion := 7; //hack to fix broken BL7 version number in the FP35
  GetInstrumentInformation := true;
end;

{------- 6500 ------}
function TclsFipp.GetARparams:boolean;       {98} {6500}
begin
  GetARparams := false;
  CmdArray.Cmd := fipp_GetARparamsCmd;
  CmdArray.Size := 0;
  if not(GetPacket()) then Exit;
  move(RspArray.Data[0],ARparams,fipp_ARparamsSize*2);
  GetARparams := true;
end;

{---FP35 V1.00--}
function TclsFipp.GetLastIdDevice:boolean;   {100}
begin
  Result := false;
  CmdArray.Cmd := fipp_GetLastIdDeviceCmd;
  CmdArray.Size := 0;
  if not(GetPacket()) then Exit;
  LastIdDevice := integer(RspArray.Data[0]);
  Result := true;
end;

{---FP35 V1.00--}
function TclsFipp.GetLongDeviceID:boolean;   {101}
{var i : integer;}
begin
  GetLongDeviceID := false;
  CmdArray.Cmd := fipp_GetLongDeviceIDCmd;
  CmdArray.Size := 1;
  CmdArray.Data[0] := DeviceIDNumber;
  if not(GetPacket()) then Exit;
  move(RspArray.Data[0],LongDeviceID,sizeof(LongDeviceID));
  GetLongDeviceID := true;
end;


{---FP35 V2.00--}
function TclsFipp.GetDeviceData:boolean;   {102}
var i : integer;
begin
  GetDeviceData := false;
  CmdArray.Cmd := fipp_GetDeviceDataCmd;
  CmdArray.Size := 2;
  CmdArray.Data[0] := DeviceIDNumber;
  CmdArray.Data[1] := DeviceSelection;
  if not(GetPacket()) then Exit;
  DeviceDataSize := word(RspArray.Size);
  if DeviceDataSize > sizeof(DeviceDataArray) then
    DeviceDataSize := sizeof(DeviceDataArray);
  move(RspArray.Data[0],DeviceDataArray,DeviceDataSize*2);
  GetDeviceData := true;
end;

{---FP35 V1.00--}
function TclsFipp.GetRealTimeClock:boolean;   {103}
var i : integer;
begin
  GetRealTimeClock := false;
  CmdArray.Cmd := fipp_GetRealTimeClockCmd;
  CmdArray.Size := 0;
  if not(GetPacket()) then Exit;
  move(RspArray.Data[0],RealTimeClockData,sizeof(RealTimeClockData));
  GetRealTimeClock := true;
end;

{--FP35 V2.00---}
function TclsFipp.GetOutputDevice:boolean;   {105}
begin
  Result := false;
  CmdArray.Cmd := fipp_GetOutputDeviceCmd;
  CmdArray.Size := 0;
  if not(GetPacket()) then Exit;
  OutputDeviceSize := RspArray.Size;
  OutputSelect := RspArray.Data[0];
  if (RspArray.Size > 1) then
  begin
    OutputDevice := RspArray.Data[1];
  end;
  Result := true;
end;

{--FP35 V2.00---}
function TclsFipp.GetImpulseRej:boolean;   {107}
begin
  GetImpulseRej := GetValue(fipp_GetImpulseRejCmd,ImpulseRej);
end;

{---FP35 V2.00--}
function TclsFipp.GetSignalInfo:boolean;   {109}
begin
  GetSignalInfo := false;
  CmdArray.Cmd := fipp_GetSignalInfoCmd;
  CmdArray.Size := 0;
  if not(GetPacket()) then Exit;
  if RspArray.Size > (sizeof(SignalInfo) div 2) then
    SignalInfoSize := sizeof(SignalInfo) div 2
  else SignalInfoSize := RspArray.Size;
  move(RspArray.Data[0],SignalInfo,SignalInfoSize*2);
  GetSignalInfo := true;
end;


function TclsFipp.GetCalListData:boolean;   {111}
var i : integer;
begin
  Result := false;
  CmdArray.Cmd := fipp_GetCalListDataCmd;
  CmdArray.Size := 2;
  CmdArray.Data[0] := CalMicSelection;
  CmdArray.Data[1] := CalListSelection;
  if not(GetPacket()) then Exit;
  CalListDataSize := word(RspArray.Size+2);
  if CalListDataSize > fipp_MaxCalListData then
    CalListDataSize := fipp_MaxCalListData;
  move(RspArray.Data,CalListData,CalListDataSize*2);
  Result := true;
end;

{---FP35 V1.00--}
function TclsFipp.GetRawSampleData:boolean;   {110}
var i : integer;
begin
  GetRawSampleData := false;
  CmdArray.Cmd := fipp_GetRawSampleDataCmd;
  CmdArray.Size := 3;
  CmdArray.Data[0] := RawDataSelection;
  CmdArray.Data[1] := RawDataMethod;
  CmdArray.Data[2] := RawSampleCount;
  if not(GetPacket()) then Exit;
  RawSamplePacketSize := word(RspArray.Size+2);
  if RawSamplePacketSize > fipp_MaxRawSampleData then
    RawSamplePacketSize := fipp_MaxRawSampleData;
  move(RspArray.Raw,RawSampleData,RawSamplePacketSize*2);
  GetRawSampleData := true;
end;

{--FP35 V2.00---}
function TclsFipp.GetCurveSelect:boolean;   {113}
begin
  GetCurveSelect := GetValue(fipp_GetCurveSelectCmd,CurveSelect);
end;

{--FP35 V2.00---}
function TclsFipp.GetCurveStatus:boolean;   {115}
begin
  GetCurveStatus := false;
  {GetValue(GetCurveStatusCmd,FIPPrec.CurveStatus,FIPPrec);}

  CmdArray.Cmd := fipp_GetCurveStatusCmd;
  CmdArray.Size := 1;
  CmdArray.Data[0] := CurveSelect; {use curve select for the curve we want}
  if not(GetPacket()) then Exit;
  CurveStatus := RspArray.Data[0];
  GetCurveStatus := true;
end;

{--FP35 V2.00---}
function TclsFipp.GetUnaidedSelect:boolean;   {117}
begin
  GetUnaidedSelect := GetValue(fipp_GetUnaidedSelectCmd,UnaidedSelect);
end;

{---FP35 V4.72--}
function TclsFipp.GetListData:boolean;   {119}
var i : integer;
begin
  Result := false;
  CmdArray.Cmd := fipp_GetListDataCmd;
  CmdArray.Size := 1;
  CmdArray.Data[0] := ListSelection;
  if not(GetPacket()) then Exit;
  ListDataSize := word(RspArray.Size+2);
  if ListDataSize > fipp_MaxListData then
    ListDataSize := fipp_MaxListData;
  move(RspArray.Data[0],ListData,ListDataSize*2);
  Result := true;
end;

{--FP35 V2.10---}
{Note: we can only recieve a max of 2000 words at a time.}
{reading a whole screen requires breaking it up into multiple reads}
{if w=0 or h=0}
{ returns bytes per scan line in Xpos, Ypos = 0, }
{ Width is page width (pixels), Height is page height (scan lines).}
{ if w returned as 0, it indicates the requested page is not available.}
{ returns default style available in Style (2=mono,4=16color,8=256color)}
{ Bitmap.Size = 0 (you have to calc the size yourself)}
{ Bitmap.Offset = required Data offset from the start of the Bitmap record in words (10).}
{ To calc bitmap size : send cmd with W=0, then Bitmap Size in [bytes = Xpos*Height] }
{ If the size if > 2000 bytes, it must be broken into multiple reads. }
function TclsFipp.GetBitmap(Xpos,Ypos,Width,Height,Style,Page:integer):boolean;   {120}
var i : integer;
var BSize : integer;
begin
  Result := false;
  CmdArray.Cmd := fipp_GetBitmapCmd;
  CmdArray.Size := 6;
  CmdArray.Data[0] := Style;  //style
  CmdArray.Data[1] := Xpos;   //x pos
  CmdArray.Data[2] := Ypos;   //y pos
  CmdArray.Data[3] := Width;  //width  (0=get page info)
  CmdArray.Data[4] := Height; //height
  CmdArray.Data[5] := Page;   //page
  if not(GetPacket()) then Exit;
  BSize := RspArray.Size * 2;
  if (BSize > sizeof(FryeBitMap)) then BSize := sizeof(FryeBitMap);
  move(RspArray.Data[0],FryeBitMap,BSize);
  Result := true;
end;

{--FP35 V2.10---}
function TclsFipp.GetStaticToneSelect:boolean;   {122}
begin
  GetStaticToneSelect := GetValue(fipp_GetStaticToneSelectCmd,StaticToneSelect);
end;

{--FP35 V2.10---}
function TclsFipp.GetAidInfoSelect:boolean;   {124}
begin
  Result := false;
  CmdArray.Cmd := fipp_GetAidInfoSelectCmd;
  CmdArray.Size := 0;
  if not(GetPacket()) then Exit;
  AidInfoSize := RspArray.Size; {number items actually received}
  AidGroupSelect := RspArray.Data[0];
  if (RspArray.Size > 1) then
  begin
    AidTypeSelect := RspArray.Data[1];
  end;
  Result := true;
end;

{--FP35 V2.10---}
function TclsFipp.GetBiasTone:boolean;   {126}
begin
  GetBiasTone := false;
  CmdArray.Cmd := fipp_GetBiasToneCmd;
  CmdArray.Size := 0;
  if not(GetPacket()) then Exit;
  BiasToneSize := RspArray.Size; {number items actually received}
  BiasToneSource := RspArray.Data[0];
  BiasToneFrequency := RspArray.Data[1];
  BiasToneDuration := RspArray.Data[2];
  GetBiasTone := true;
end;

{--FP35 V2.20---}
function TclsFipp.GetWarbleSelect:boolean;   {130}
begin
  GetWarbleSelect := false;
  CmdArray.Cmd := fipp_GetWarbleSelectCmd;
  CmdArray.Size := 0;
  if not(GetPacket()) then Exit;
  WarbleSelect := RspArray.Data[0];
  if RspArray.Size > 1 then
    WarbleAmount := RspArray.Data[1]
  else WarbleAmount := 0;
  if RspArray.Size > 2 then
    WarbleRate := RspArray.Data[2]
  else WarbleRate := 0;
  GetWarbleSelect := true;
end;

{--6500 V4.72---}
function TclsFipp.GetDelayMeasurments:boolean;   {131}
begin
  Result := false;
  CmdArray.Cmd := fipp_GetMeasurmentDelaysCmd;
  CmdArray.Size := 0;
  if not(GetPacket()) then Exit;
  HaDelaySize := RspArray.Size;
  SystemDelay := word(RspArray.Data[0]);
  HearingAidDelay1 := word(RspArray.Data[1]);
  HearingAidDelay2 := word(RspArray.Data[2]);
  Result := true;
end;

{-- new fp35 v2.20 -----}
function TclsFipp.GetRcvTimeout:boolean;     {133}
var Temp : smallint;
begin
   GetRcvTimeout := GetValue(fipp_GetRcvTimeoutCmd,Temp);
   RcvTimeout := Temp;
end;


{-- new fp35 v2.30 -----}
function TclsFipp.GetFitRule:boolean;     {135}
var Temp : smallint;
begin
   GetFitRule := GetValue(fipp_GetFitRuleCmd,Temp);
   FitRule := Temp;
end;

{-- new fp35 v3.00 -----}
function TclsFipp.GetFilter:boolean;     {137}
var Temp : smallint;
begin
  GetFilter := GetValue(fipp_GetFilterCmd,Temp);
  FilterType := Temp;
end;

{--FP35 V3.00---}
function TclsFipp.GetCompression:boolean;   {139}
begin
  GetCompression := GetValue(fipp_GetCompressionCmd,Compression);
end;

{--FP35 V3.00---}
function TclsFipp.GetClientAge:boolean;   {141}
begin
  GetClientAge := GetValue(fipp_GetClientAgeCmd,ClientAge);
end;

{--FP35 V3.10---}
function TclsFipp.GetTransducerLoc:boolean;   {143}
begin
  GetTransducerLoc := false;
  CmdArray.Cmd := fipp_GetTransducerLocCmd;
  CmdArray.Size := 1;
  CmdArray.Data[0] := 0; {only speaker currently used}
  if not(GetPacket()) then Exit;
  TransducerLoc := word(RspArray.Data[0]);
  GetTransducerLoc := true;
end;

{--FP35 V5.00---}
function TclsFipp.DoCalAdj:boolean;   {144}
var OldTimer:integer;
begin
  Result := false;
  GetNoPoll(OldTimer);      {get real poll timeout value}
  PollTimer := OldTimer;      {update current timer value}
  if PollTimer < FIPP_SUPER_LONG_POLL_TIMEOUT then    {If less than 60 sec}
  begin
    PollTimer := FIPP_SUPER_LONG_POLL_TIMEOUT;        {force it to 60 sec abort}
    SetNoPoll(PollTimer);
  end;
  CmdArray.Cmd := fipp_DoCalAdjCmd;
  CmdArray.Data[0] := CalAdjValue;
  //special case handling for top cal screen (do sys cal)
  if (MajorMachineState = 32) and (MinorMachineState = 0) then
  begin
    CmdArray.Size := 1;  {always size of one for this}
    Result := DoFippCmd(FCOM_ACK_OK, FIPP_NO_POLL_UNCHANGED);
  end

  else //otherwise mic sens adjustment cmd is done if in other screens
  begin
    CmdArray.Size := CalAdjCmdSize;  {make sure you set this for what you want to do!}
    CmdArray.Data[0] := CalAdjSelect;
    CmdArray.Data[1] := CalAdjValue;
    Result := DoFippCmd(FCOM_ACK_OK, FIPP_NO_POLL_UNCHANGED);
    //returns adjustment result as response
    if (RspArray.Size > 0) then
      CalAdjValue := word(RspArray.Data[0])
    else CalAdjValue := 0;

  end;
  PollTimer := OldTimer;
  SetNoPoll(PollTimer);      {restore original poll timeout value}
end;


{-------}
function TclsFipp.GetLevelingList:boolean;  {146}
var CurveFormat: word;
var ByteSize : word;
begin
  GetLevelingList := false;
  CmdArray.Cmd := fipp_GetLevelingListCmd;
  CmdArray.Size := 2;
  CmdArray.Data[0] := WhichListChannel;
  CmdArray.Data[1] := WhichLevelingList;
  if not(GetPacket()) then Exit;
  LevelingListSize := RspArray.Size;
  ByteSize := LevelingListSize*2;
  if ByteSize > sizeof(LevelingList) then
  begin
    ByteSize := sizeof(LevelingList);
    LevelingListSize := ByteSize div 2;
  end;
  fillchar(LevelingList,sizeof(LevelingList),0);
  move(RspArray.Data,LevelingList,ByteSize);
  GetLevelingList := true;
end;

{--FP35 V3.20---}
function TclsFipp.GetAuxPort:boolean;   {149}
begin
  GetAuxPort := false;
  CmdArray.Cmd := fipp_GetAuxPortCmd;
  CmdArray.Size := 1;
  CmdArray.Data[0] := $0101;
  if not(GetPacket()) then Exit;
  AuxCtrl := word(RspArray.Data[0]);
  if RspArray.Size > 1 then
  begin
    fillchar(AuxInData,sizeof(AuxInData),0);
    AuxInCount := RspArray.Data[1];
    if AuxInCount > 0 then
      move(RspArray.Data[2],AuxInData,AuxInCount);
  end;
  GetAuxPort := true;
end;


{--FP35 V3.20---}
function TclsFipp.GetUserNumber:boolean;   {151}
begin
  GetUserNumber := false;
  CmdArray.Cmd := fipp_GetUserNumberCmd;
  CmdArray.Size := 0;
  if not(GetPacket()) then Exit;
  UserNumber := word(RspArray.Data[0]);
  if RspArray.Size > 1 then
    MaxUser := RspArray.Data[1];
  GetUserNumber := true;
end;

{-- new FP35 V3.20 -----}
function TclsFipp.GetFitType:boolean;    {153} {fp35 v3.20 12/01/03}
begin
   GetFitType := GetValue(fipp_GetFitTypeCmd,Fit.AidFitType);
end;

{-- new FP35 V3.20 -----}
function TclsFipp.GetVentType:boolean;    {155} {fp35 v3.20 12/01/03}
begin
   GetVentType := GetValue(fipp_GetVentTypeCmd,Fit.AidVentType);
end;

{-- new FP35 V3.20 -----}
function TclsFipp.GetTubingType:boolean;    {157} {fp35 v3.20 12/01/03}
begin
   GetTubingType := GetValue(fipp_GetTubingTypeCmd,Fit.AidTubingType);
end;

{-- new FP35 V3.20 -----}
function TclsFipp.GetAidChannels:boolean;    {159} {fp35 v3.20 12/01/03}
begin
   GetAidChannels := GetValue(fipp_GetAidChannelsCmd,Fit.AidChannels);
end;

{-- new FP35 V3.20 -----}
function TclsFipp.GetAidLimiting:boolean;    {161} {fp35 v3.20 12/01/03}
begin
   GetAidLimiting := GetValue(fipp_GetAidLimitingCmd,Fit.AidLimiting);
end;

{-- new FP35 V3.70 -----}
function TclsFipp.GetRefMethod:boolean;    {163} {fp35 v3.70 06/06/06}
begin
   GetRefMethod := GetValue(fipp_GetRefMethodCmd,Fit.RefMethod);
end;


{-- new FP35 V3.20 -----}
function TclsFipp.GetFitParam:boolean;    {165} {fp35 v3.20 12/01/03}
begin
  GetFitParam := false;
  CmdArray.Cmd := fipp_GetFitParamCmd;
  CmdArray.Size := 0;
  if not(GetPacket()) then Exit;
  if RspArray.Size > (sizeof(Fit) div 2) then
    FitCount := sizeof(Fit) div 2
  else FitCount := RspArray.Size;
  move(RspArray.Data,Fit,FitCount*2);
  GetFitParam := true;
end;

{-- new FP35 V3.20 -----}
function TclsFipp.GetUserIDText:boolean;  {167}
var i : integer;
begin
  GetUserIDText := false;
  if UserNumber > 15 then UserNumber := 0;
  CmdArray.Cmd := fipp_GetUserIDTextCmd;
  CmdArray.Size := 1;
  CmdArray.Data[0] := UserNumber;
  if not(GetPacket()) then Exit;
  i := 0;
  while i < FIPP_MAX_USERID_TEXT do //MaxUserIDTextSize do
  begin
    UserIDText[UserNumber][i] := char(RspArray.Raw[(i shr 1)+2] shr 8);
    UserIDText[UserNumber][succ(i)] := char(RspArray.Raw[(i shr 1)+2] and $ff);
    inc(i,2);
  end;
  UserIDText[UserNumber][pred(FIPP_MAX_USERID_TEXT)] := #0; {force last byte to null}
  GetUserIDText := true;
end;



{-- new FP35 V3.30 -----}
function TclsFipp.GetSkew:boolean;    {169} {fp35 v3.30 07/01/04}
begin
  GetSkew := false;
  CmdArray.Cmd := fipp_GetSkewCmd;
  CmdArray.Size := 1;
  CmdArray.Data[0] := WhichSkew;
  if not(GetPacket()) then Exit;
  Skew := RspArray.Data[0];
  GetSkew := true;
end;



{-- new FP35 V3.40 -----}
function TclsFipp.GetScreenMode:boolean;    {171} {fp35 v3.40 08/20/04}
begin
  GetScreenMode := false;
  CmdArray.Cmd := fipp_GetScreenModeCmd;
  CmdArray.Size := 0;
  if not(GetPacket()) then Exit;
  if RspArray.Size > 1 then
  begin
    LcdMode := RspArray.Data[0];
    VgaPalette := RspArray.Data[1];
    VgaOption := true;
  end
  else
  begin
    LcdMode := RspArray.Data[0];
    VgaOption := false;
  end;
  GetScreenMode := true;
end;


{-- new FP35 V3.50 -----}
function TclsFipp.GetCouplerSelection:boolean;    {173} {fp35 v3.50 12/16/04}
begin
  GetCouplerSelection := false;
  CmdArray.Cmd := fipp_GetCouplerSelectionCmd;
  CmdArray.Size := 0;
  if not(GetPacket()) then Exit;
  CouplerSelection := RspArray.Data[0];
  GetCouplerSelection := true;
end;


{-- new FP35 V3.60 -----}
function TclsFipp.GetAnalysisSelection:boolean;    {175} {fp35 v3.60 06/12/06}
begin
  GetAnalysisSelection := false;
  CmdArray.Cmd := fipp_GetAnalysisSelectionCmd;
  CmdArray.Size := 0;
  if not(GetPacket()) then Exit;
  AnalysisSelection := RspArray.Data[0];
  GetAnalysisSelection := true;
end;


{FP40 does not support cmd 179, 7000/8000 use two parameters}
{FP35 uses five parameters, 6500/6400 do not have this command}
{FP35 returns BatterySize and BatteryMAH as invalid data}
function TclsFipp.GetBatteryInfo:boolean;    {179}
begin
  GetBatteryInfo := false;
  CmdArray.Cmd := fipp_GetBatteryInfoCmd;
  CmdArray.Size := 0;
  BatteryInfoSize := 0;
  //BatteryType := INVALID_DATA16; {leave battery type alone}
  BatterySize := INVALID_DATA16; {init battery values before reading}
  BatteryMAH := INVALID_DATA16;
  BatteryVolt := INVALID_DATA16;
  BatteryImp := INVALID_DATA16;
  if not(GetPacket()) then Exit;
  BatteryInfoSize := RspArray.Size; {save how many items we read}
  if (BatteryInfoSize >= 1) then
  begin
    BatteryType := RspArray.Data[0];
  end;
  if (BatteryInfoSize >= 2) then
  begin
    BatterySize := RspArray.Data[1]; {7000/8000 format}
  end;
  if (BatteryInfoSize >= 3) then
  begin
    BatteryMAH := RspArray.Data[2];
  end;
  if (BatteryInfoSize >= 4) then
  begin
    BatteryVolt := RspArray.Data[3];
  end;
  if (BatteryInfoSize >= 5) then
  begin
    BatteryImp := RspArray.Data[4];
  end;
  GetBatteryInfo := true;
end;


{-------}
function TclsFipp.GetStoredParameter:boolean;    {181}
begin
  GetStoredParameter := false;
  CmdArray.Cmd := fipp_GetStoredParameterCmd;
  CmdArray.Size := 1;
  CmdArray.Data[0] := StoredParameterNumber; {SavedItemNumber;}
  if not(GetPacket()) then Exit;
  if RspArray.Size > 1 then
  begin
    StoredParameterNumber := RspArray.Data[0];
    StoredParameterValue := RspArray.Data[1];
  end;
  GetStoredParameter := true;
end;


function TclsFipp.GetCurveGroupSelect:boolean;    {183} {8000}
begin
  Result := GetValue(fipp_GetCurveGroupSelectCmd,CurveGroupSelect);
end;

{--------}
function TclsFipp.GetAgcFreqSelect:boolean;    {185}
begin
  Result := false;
  if (AgcFreqSelectSize < 0)or (AgcFreqSelectSize > 3) then
  begin
    AgcFreqSelectSize := 2; //fixup size if error
  end;
  CmdArray.Cmd := fipp_GetAgcFreqSelectCmd;
  CmdArray.Size := AgcFreqSelectSize;
  CmdArray.Data[0] := AgcFreqSelect;
  CmdArray.Data[1] := AgcFreqEnable;
  CmdArray.Data[2] := AgcFreqIndex;
  if not(GetPacket()) then Exit;
  AgcFreqSelectSize := RspArray.Size;
  AgcFreqSelect := RspArray.Data[0];
  AgcFreqEnable := RspArray.Data[1];
  AgcFreqIndex := RspArray.Data[2];
  Result := true;
end;

function TclsFipp.GetInputPortSelect:boolean;    {187} {FP35}
begin
  Result := GetValue(fipp_GetInputPortSelectCmd,InputPortSelect);
end;

function TclsFipp.GetAngleSelect:boolean;    {189} {8000}
begin
  Result := GetValue(fipp_GetAngleSelectCmd,AngleSelect);
end;


{-------}
function TclsFipp.GetDiffFreq:boolean;    {191}
begin
  Result := false;
  CmdArray.Cmd := fipp_GetDiffFreqCmd;
  CmdArray.Size := 0;
  if not(GetPacket()) then Exit;
  DiffFreq := RspArray.Data[0];
  DiffFreqRspSize := RspArray.Size;
  if RspArray.Size > 1 then
  begin
    SweepEndFreq := RspArray.Data[1];
  end;
  Result := true;
end;

function TclsFipp.GetUserMode:boolean;    {193} {FP35}
begin
  Result := GetValue(fipp_GetUserModeCmd,UserMode);
end;



{+++++++++}
{The following procedures handle the standard FIPP Do commands}

{-------}
{SendDoCmd is used for most of the Do functions since they all pass}
{a single integer value. Makes it much simpler.}
function TclsFipp.SendDoCmd(DoCmd:word):boolean;
begin
  SendDoCmd := false;
  CmdArray.Cmd := DoCmd;
  CmdArray.Size := 0;
  if not(DoPacket()) then Exit;
  SendDoCmd := true;
end;


{++++++}
{Do cmds - return true if everything went ok. }
{false if not (error in FippError)}


{-------}
{Assumes that the desired state has been stored to RelAttState.}
{Note: Must be called with RelAttState "0" to exit this mode.}

function TclsFipp.DoRelAttSelect:boolean;  {13}
var OldTimer:integer;
begin
     GetNoPoll(OldTimer);      {get real poll timeout value}
     PollTimer := OldTimer;      {update current timer value}
     if PollTimer < FIPP_EXTRA_LONG_POLL_TIMEOUT then    {If less than 30 seconds}
     begin
       PollTimer := FIPP_EXTRA_LONG_POLL_TIMEOUT;        {force it to 30 seconds abort}
       SetNoPoll(PollTimer);
     end;
     DoRelAttSelect := false;
     CmdArray.Cmd := fipp_DoRelAttSelectCmd;
     CmdArray.Size := 1;
     CmdArray.Data[0] := word(RelAttState);
     if DoPacket() then
       DoRelAttSelect := true;
     PollTimer := OldTimer;
     SetNoPoll(PollTimer);      {restore original poll timeout value}
end;

{-------}
{Assumes that the desired state has been stored to IOState.}
{Note: Must be called with IOState "0" to exit this mode.}

function TclsFipp.DoIOSelect:boolean;  {15}
var OldTimer:integer;
begin
  DoIOSelect := false;
  GetNoPoll(OldTimer);      {get real poll timeout value}
  PollTimer := OldTimer;      {update current timer value}
  if PollTimer < FIPP_LONG_POLL_TIMEOUT then    {If less than 15 seconds}
  begin
    PollTimer := FIPP_LONG_POLL_TIMEOUT;        {force it to 15 seconds abort}
    SetNoPoll(PollTimer);
  end;
  CmdArray.Cmd := fipp_DoIOSelectCmd;
  CmdArray.Size := 1;
  CmdArray.Data[0] := word(IOstate);
  if DoPacket() then
    DoIOSelect := true;
  PollTimer := OldTimer;
  SetNoPoll(PollTimer);      {restore original poll timeout value}
end;

{-------}
{note: since the sweep can take an excessive time this command forces the}
{timeout value to two minutes unless it is equal to or greater than that}

function TclsFipp.DoTest:boolean;     {16}
var OldTimer:integer;
begin
  GetNoPoll(OldTimer);      {get real poll timeout value}
  PollTimer := OldTimer;      {update current timer value}
  if PollTimer < FIPP_SUPER_LONG_POLL_TIMEOUT then    {If less than two minutes}
  begin
    PollTimer := FIPP_SUPER_LONG_POLL_TIMEOUT;        {force it to two minute abort}
    SetNoPoll(PollTimer);
  end;
  DoTest := SendDoCmd(fipp_DoTestCmd);  {do the sweep}
  PollTimer := OldTimer;
  SetNoPoll(PollTimer);      {restore original poll timeout value}
end;

{-------}
function TclsFipp.DoLevel:boolean;        {17}
var OldTimer:integer;
begin
  GetNoPoll(OldTimer);      {get real poll timeout value}
  PollTimer := OldTimer;      {update current timer value}
  if PollTimer < FIPP_SUPER_LONG_POLL_TIMEOUT then    {If less than two minutes}
  begin
    PollTimer := FIPP_SUPER_LONG_POLL_TIMEOUT;        {force it to two minute abort}
    SetNoPoll(PollTimer);
  end;
  CmdArray.Cmd := fipp_DoLevelCmd;
  CmdArray.Size := 0;
  Result := DoFippCmd(FCOM_ACK_OK, FIPP_NO_POLL_UNCHANGED);
  PollTimer := OldTimer;
  SetNoPoll(PollTimer);
end;

{-------}
function TclsFipp.DoReset:boolean;        {38}
var OldTimer,OldResp:integer;
begin
     GetNoPoll(OldTimer);      {get real poll timeout value}
     PollTimer := OldTimer;      {update current timer value}
     OldResp := GetRespTimeout();      {get real resp timeout value}
     RespTimer := OldResp;
     if PollTimer < FIPP_SUPER_LONG_POLL_TIMEOUT then    {If less than two minutes}
     begin
       PollTimer := FIPP_SUPER_LONG_POLL_TIMEOUT;        {force it to two minute abort}
       SetNoPoll(PollTimer);
     end;
(*     if RespTimer < (100) then    {If less than 5 seconds}
     begin
       RespTimer := (100);        {force it to 5 seconds abort}
       SetRespTimer(FIPPrec);
     end; *)

     DoReset := SendDoCmd(fipp_DoResetCmd);
     PollTimer := OldTimer;
     SetNoPoll(PollTimer);
     //RespTimer := OldResp;
(*     SetRespTimer(FIPPrec);      {restore original resp timeout value} *)
end;

{-------}
{special 6500 version of SetPower (DoSleep) command}
{Note: if sleep status = 2 does not verify cmd because it can't }
{The DoSleep command is for the 6500 only}
{the 6500 DoSleep command has no parameters.}
function TclsFipp.DoSleep:boolean;        {56} {6500 only}
begin
  DoSleep := SendDoCmd(fipp_DoSleepCmd);
end;

{-------}
{note: if Power status is 2, the instrument is in deep sleep mode (hibernate)}
{and will not respond most commands. The FP40 will not respond at all}
{since the only way to get it back is to _physically_ turn it back on.}
{If power Status is 1, the intrument is in sleep mode (screen saver) }
{and will normally automatically wake up on commands that require it to be awake.}
{SetPower, GetPower, GetVersion, GetCmdStatus and Reset are always available.}
function TclsFipp.SetPower:boolean;           {56}  {Others (ie not 6500)}
var OldTimer:integer;
begin
  Result := false;
  GetNoPoll(OldTimer);      {get real poll timeout value}
  PollTimer := OldTimer;      {update current timer value}
  CmdArray.Cmd := fipp_SetPowerCmd;

  if PollTimer < (FIPP_DEFAULT_NO_POLL) then    {If less than 5 seconds}
  begin
    PollTimer := (FIPP_DEFAULT_NO_POLL);        {force it to 5 seconds abort}
    SetNoPoll(PollTimer);
  end;

  //Does the instrument support the screen saver setting?
  if PowerCmdSize = 2 then
  begin
    CmdArray.Size := 2;
    CmdArray.Data[0] := word(PowerState);
    CmdArray.Data[1] := word(StandbyTimeOut);
    if DoFippCmd(FCOM_ACK_OK,PollTimer) then
      Result := true;
  end

  //Does it support power down time?
  else if PowerCmdSize > 2 then
  begin
    CmdArray.Size := 3;
    CmdArray.Data[0] := word(PowerState);
    CmdArray.Data[1] := word(StandbyTimeOut);
    CmdArray.Data[2] := word(PowerDownTimeout);
    if DoFippCmd(FCOM_ACK_OK,PollTimer) then
      Result := true;
  end

  //for anything else, fall back to default of one parameter
  else
  begin
    CmdArray.Size := 1;
    CmdArray.Data[0] := word(PowerState);
    if DoFippCmd(FCOM_ACK_OK,PollTimer) then
      Result := true;
  end;

  //if power status is 2 or higher, quick terminate may not work
  //because the instrument may be powered down already.
  if (PowerState < 2) then
  begin
    QuickRelease(Callback);
  end;

  PollTimer := OldTimer;
  SetNoPoll(PollTimer);      {restore original poll timeout value}
end;

{-- new v2.6x -----}
function TclsFipp.DoLineFeeds:boolean;       {64}
var OldTimer,OldResp:integer;
begin
  DoLineFeeds := false;
  GetNoPoll(OldTimer);      {get real poll timeout value}
  PollTimer := OldTimer;      {update current timer value}
//  GetRespTimer();      {get real resp timeout value}
//  OldResp := RespTimer;
  if PollTimer < FIPP_SUPER_LONG_POLL_TIMEOUT then    {If less than 30 seconds}
  begin
    PollTimer := FIPP_SUPER_LONG_POLL_TIMEOUT;        {force it to 30 seconds abort}
    SetNoPoll(PollTimer);
  end;
//  if RespTimer < (100) then    {If less than 5 seconds}
//  begin
//    RespTimer := (100);        {force it to 5 seconds abort}
//    SetRespTimer();
//  end;

  CmdArray.Cmd := fipp_DoLineFeedsCmd;
  CmdArray.Size := 1;
  CmdArray.Data[0] := word(PrintFeeds);
  if DoPacket() then
    DoLineFeeds := true;

  PollTimer := OldTimer;
  SetNoPoll(PollTimer);      {restore original poll timeout value}
  //RespTimer := OldResp;
  //SetRespTimer();      {restore original resp timeout value}
end;


{-- new v2.6x -----}
function TclsFipp.DoPrint:boolean;           {65}
var OldTimer,OldResp:integer;
begin
  DoPrint := false;
  GetNoPoll(OldTimer);      {get real poll timeout value}
  PollTimer :=OldTimer;      {update current timer value}
//  GetRespTimer();      {get real resp timeout value}
//  OldResp := RespTimer;
  if PollTimer < FIPP_SUPER_LONG_POLL_TIMEOUT then    {If less than 60 seconds}
  begin
    PollTimer := FIPP_SUPER_LONG_POLL_TIMEOUT;        {force it to 60 seconds abort}
    //SetNoPoll(PollTimer);
  end;
//  if RespTimer < (100) then    {If less than 5 seconds}
//  begin
//    RespTimer := (100);        {force it to 5 seconds abort}
//    SetRespTimer();
//  end;

  CmdArray.Cmd := fipp_DoPrintCmd;
  CmdArray.Size := 1;
  CmdArray.Data[0] := word(PrintControl);
  if DoFippCmd(FCOM_ACK_OK,PollTimer) then
    DoPrint := true;
  QuickRelease(Callback);
  PollTimer := OldTimer;
  SetNoPoll(PollTimer);      {restore original poll timeout value}
//  RespTimer := OldResp;
//  SetRespTimer();      {restore original resp timeout value}
end;



{-------}
function TclsFipp.DoError:boolean;        {67}
begin
  CmdArray.Cmd := fipp_DoErrorCmd;
  DoError := DoFippCmd(FCOM_ACK_OK,FIPP_NO_POLL_UNCHANGED);
end;



{---6500 V4.14--}
function TclsFipp.DoMeasurement:boolean;  {85}
var OldTimer,OldResp:integer;
    STime : longint;
    Valid : boolean;
begin
  DoMeasurement := false;
  Valid := false;
  stime := DoMeasureSettleTime div 55;
  GetNoPoll(OldTimer);      {get real poll timeout value}
  PollTimer := OldTimer;      {update current timer value}
  if PollTimer < (FIPP_STD_POLL_TIMEOUT+stime) then    {If less than 5+settle seconds}
  begin
    PollTimer := (FIPP_STD_POLL_TIMEOUT+stime);        {force it to 5+settle seconds abort}
    SetNoPoll(PollTimer);
  end;
  OldResp := GetRespTimeout();      {get real resp timeout value}
  RespTimer := OldResp;
  if (FonixHwVersion.InstrumentBaseType = FONIX_6500) then
  begin
     if RespTimer < (FIPP_STD_POLL_TIMEOUT+stime) then    {If less than 5+settle seconds}
     begin
       RespTimer := (FIPP_STD_POLL_TIMEOUT+stime);        {force it to 5+settle seconds abort}
       SetRespTimeout(RespTimer);
     end;
  end;
  CmdArray.Cmd := fipp_DoMeasurementCmd;
  CmdArray.Size := 3;
  CmdArray.Data[0] := word(Frequency);
  CmdArray.Data[1] := word(SourceAmp);
  CmdArray.Data[2] := word(DoMeasureSettleTime);

  if GetPacket() then  {we need a response from this one}
  begin
    MeasureMicData := integer(RspArray.Data[0]);
    Valid := true;
  end;
  PollTimer := OldTimer;
  SetNoPoll(PollTimer);      {restore original poll timeout value}
  if (FonixHwVersion.InstrumentBaseType = FONIX_6500) then
  begin
    RespTimer := OldResp;
    SetRespTimeout(RespTimer);      {restore original resp timeout value}
  end;

  if Verify and Valid then
    if not(CommandStatusOK()) then Exit;

  DoMeasurement := Valid;
end;


function TclsFipp.DoCustomTest:boolean;     {176}
var OldTimer:integer;
begin
   GetNoPoll(OldTimer);      {get real poll timeout value}
   PollTimer := OldTimer;      {update current timer value}
   if PollTimer < FIPP_SUPER_LONG_POLL_TIMEOUT then    {If less than two minutes}
   begin
     PollTimer := FIPP_SUPER_LONG_POLL_TIMEOUT;        {force it to two minute abort}
     SetNoPoll(PollTimer);
   end;
   CmdArray.Cmd := fipp_DoCustomTestCmd;
   DoCustomTest := DoFippCmd(FCOM_ACK_OK,FIPP_NO_POLL_UNCHANGED);  {do the test}
   PollTimer := OldTimer;
   SetNoPoll(PollTimer);      {restore original poll timeout value}
end;


function TclsFipp.DoParameterSave:boolean;     {177}
begin
  DoParameterSave := false;
  CmdArray.Cmd := fipp_DoParameterSaveCmd;
  CmdArray.Size := 1;
  CmdArray.Data[0] := ParameterSaveHow;
  DoParameterSave := SetPacket();
end;


function TclsFipp.DoTarget:boolean;     {178}
begin
  DoTarget := SendDoCmd(fipp_DoTargetCmd);  {do the test}
end;

{----------------}
function TclsFipp.SetFonixBaudrate:boolean; {31747}
begin
  Result := false;
  CmdArray.Cmd := fipp_SetFonixBaudrateCmd;
  CmdArray.Size := 1;
  CmdArray.Data[0] := NewBaudrate div 10;
  Result := DoFippCmd(FCOM_ACK_OK, FIPP_DEFAULT_NO_POLL);
  if (Result = false) then Exit;
  {do a quick terminate to release the instrument so it can change the baudrate}
  ReleaseCmd(); {but ignore any errors.}
  if (Verify = true) then
  begin
    Result := CommandStatusOK();  //check on the command status if required
  end;
end;

function TclsFipp.SetPolledMethod:boolean;     {0x7ff8}
begin
  FippError := SetPolledMode(Callback);
  if (FippError <> SUCCESS) then
    Result := false
  else Result := true;
end;

function TclsFipp.SetDemandMethod:boolean;     {0x7ff7}
begin
  FippError := SetDemandMode(Callback);
  if (FippError <> SUCCESS) then
    Result := false
  else Result := true;
end;


{==============================================================================}


{ ********** }
{initialization section}

begin
  //Fipp := TclsFipp.Create();
  //Fipp := TclsFipp.Create();
//  new(RawSampleData);
//  new(DeviceDataArray);
//  new(AuxInData);
//  new(AuxOutData);
end.


