//---------------------------------------------------------------------------
#ifndef FonixIDH
#define FonixIDH
//---------------------------------------------------------------------------

enum {
  FID_SUCCESS = 0,    //FID file read successfuly
  FID_NOT_READ = -1,  //FID file not yet read
  FID_NO_FILE = -2,   //FID file not found
  FID_NO_DATA = -3,   //No data found in FID file
  FID_NOT_FOUND = -4, //Requested FID not found in the file
  FID_CORRUPT = -5,   //FID data file corrupted
  FID_OVERRUN = -6,   //FID file too large
  FID_ERROR = -7      //generic error (unknown cause)
};

#define MAX_FONIX_ID 1000  //we can load up to 1000 IDs max.

extern int FID_FileStatus;

extern int FID_GetInstrumentName(INT16 InstType, INT16 SubType, INT16 InstModel, char* psName);
extern int FID_GetInstrumentModel(char* Name, INT16* ModelNumber);
extern int FID_LoadFonixID(AnsiString* aFilename);

extern AnsiString FID_aFilename;


#endif
