//---------------------------------------------------------------------------
//FryeColors common definitions file
//Copyright 2010 Frye Electronics, Inc.
//Written by Michael Day as of 10 Oct 2010
//You may use this code for any lawful purpose without fees or royalties.
//This code is intended as an example showing how to communicate with Fonix
//equipment using the Fryers32 or FryeCom device driver on the Windows operating system.
//No warranties are express or implied in the use of this code.
//This will compile under any later version of Borland Delphi (written using Delphi V3.00)
//---------------------------------------------------------------------------

unit FryeColors;
interface
uses Graphics;

//============================================================

//text colors
const NORMAL_TEXT_COLOR : TColor = clBlack;      //normal status messages text color
const DANGER_TEXT_COLOR : TColor = clWhite;      //Danger status message text color
const ERROR_TEXT_COLOR  : TColor = clWhite;      //Error status message text color


//Background colors

//all colors use black text except for danger which uses white text
const SUCCESS_COLOR : TColor = clLime;     //done
const STATUS_COLOR : TColor = clWhite;     //normal process
const ACTION_COLOR : TColor = clSilver;    //What's going on
const NOTICE_COLOR : TColor = clYellow;    //Please notice this message
const FILE_COLOR : TColor = clAqua;        //File information
const WARNING_COLOR : TColor = clFuchsia;  //Warning message
const ERROR_COLOR : TColor = clRed;        //something went wrong
const EMPTY_COLOR : TColor = clYellow;
const CHECKING_COLOR : TColor = clSilver;
const REF_DO_CAL_COLOR : TColor = clYellow;
const REF_CALIBRATED_COLOR : TColor = clWhite;
const DANGER_COLOR : TColor = clMaroon;    //Danger Will Robinson!  (white text)
const NO_COLOR : TColor = (TColor(0));     //don't change the color

//Standard colors
const WHITE_COLOR : TColor = clWhite;
const BLACK_COLOR : TColor = clBlack;

const GRAY_COLOR : TColor = clGray;
const DARK_GRAY_COLOR : TColor = clDkGray;
const LIGHT_GRAY_COLOR : TColor = clLtGray;
const SILVER_COLOR : TColor = clSilver;

const RED_COLOR : TColor = clRed;
const BLUE_COLOR : TColor = clBlue;
const GREEN_COLOR : TColor = clGreen;
const YELLOW_COLOR : TColor = clYellow;

const AQUA_COLOR : TColor = clAqua;
const TEAL_COLOR : TColor = clTeal;
const FUCHSIA_COLOR : TColor = clFuchsia;
const PURPLE_COLOR : TColor = clPurple;
const MAROON_COLOR : TColor = clMaroon;
const NAVY_COLOR : TColor = clNavy;
const LIME_COLOR : TColor = clLime;
const OLIVE_COLOR : TColor = clOlive;

//Special colors
const DEFAULT_COLOR : TColor = clSilver;   //start up color for boxes
const INACTIVE_COLOR : TColor = clBtnFace; //use default color if inactive
const ERROR_FONT_COLOR : TColor = clNavy;  //font color for error text
const GREEN_ACTIVITY_COLOR  : TColor = (TColor($00DDFFDD));  //pastel color for doing a special activity
const BLUE_ACTIVITY_COLOR   : TColor = (TColor($00FFDDDD));  //pastel color for doing a special activity
const PINK_ACTIVITY_COLOR   : TColor = (TColor($00DDDDFF));  //pastel color for doing a special activity
const YELLOW_ACTIVITY_COLOR : TColor = (TColor($00DDFFFF));  //pastel color for doing a special activity
const CYAN_ACTIVITY_COLOR   : TColor = (TColor($00FFFFDD));  //pastel color for doing a special activity
const SILVER_ACTIVITY_COLOR : TColor = (TColor($00DDDDDD));  //pastel color for doing a special activity

implementation
//nothing to do here
end.


