//Fryers Interface header file for FryeComD.cpp
//Copyright 2010 Frye Electronics, Inc.
//Written by Michael Day as of 30 Aug 2010

#ifndef FryeComDH
#define FryeComDH

#include <windows.h>  //used to get the DLL calling API from Windows
#include "FComDefs.h" //common declarations used with FCOM DLL.

//--------------------------------
//These three items are not normally used, they are available for debugging.
extern HINSTANCE FCOM_FryersLibHandle;
extern char const FCOM_DLL_NAME[];
extern int FCOM_ProcedureNumber;  //used for debugging to indicate which call failed
extern bool FCOM_FryersLoaded;    //false=fryecom not yet loaded

extern int FCOM_DllLoaded(void);   //export 1
extern int FCOM_CallFryers(F_RegsType* pIRegs);  //export 2

extern int FCOM_OpenPort(int ComPort, int PortControl, int Baudrate, FCOM_TfcCallback Callback);  //export 3
extern int FCOM_ClosePort(int ComPort);   //export 4
extern int FCOM_GetPortStatus(int ComPort, FCOM_tPortStatusRec* pPortStatus);  //export 5

extern int FCOM_SendReady(int ComPort, FCOM_TfcCallback Callback); //export 6
extern int FCOM_SendCmdArray(int ComPort, FCOM_TfcArray* pData);  //export 7
extern int FCOM_RspReady(int ComPort);   //export 8
extern int FCOM_GetRspArray(int ComPort, FCOM_TfcArray* pData); //export 9

extern int FCOM_SetNoPollTimeout(int ComPort, int Value); //export 10
extern int FCOM_GetNoPollTimeout(int ComPort, int* pValue);  //export 11
extern int FCOM_GetFcomVersion(int* pFcomVersion);  //export 12
extern int FCOM_MaxComPort(int* pMaxPort);  //export 13
extern int FCOM_GetDebugStatus(int ComPort, FCOM_tDebugStatusRec* pDebugStatus); //export 14
extern int FCOM_SetPortMode(int ComPort, int NewPortMode);      //export 15
extern int FCOM_GetPortMode(int ComPort, int* CurrentPortMode); //export 16

//--------------------------------
#endif

