//FryeComS static DLL load interface unit
//Copyright 2010 Frye Electronics, Inc.
//Written by Michael Day as of 30 Aug 2010
//You may use this code for any lawful purpose without fees or royalties.
//This code is intended as an example showing how to communicate with Fonix
//equipment using the FryeCom.DLL device driver on the Windows operating system.
//No warranties are express or implied in the use of this code.
//This will compile under any version of Borland BCB (written using BCB V3.00)
//This code uses only C specific code so it should compile with most c compilers.
//To use this version of the DLL interface, you will need to have the FryeCom.LIB
//file in your project directory along with the FryeCom.DLL file.
//Add the FryeCom.LIB file to your project make file LibFiles section.
//In BCB this is done by Selecting Project/Add to Project, then select the *.LIB
//file types, then select the FryeCom.LIB file and then click on the Open
//button. The FryeCom.LIB interface library will now be included in your project.
//For an easier interface process, look at the FryeComD version which dynamically
//loads the DLL at runtime. You don't need the FryeCom.LIB file if you use the
//FryeComD dynamic load version.
//Note: This mainly provides wrappers around the DLL functions to make them
//compatible to the dynamic loaded version of this code.
//----------------------------------------------------

#include "FryeComS.h"

//-----------------------------------------------------------------------
//This method uses the static DLL loading convention.
//If you use a static load (load the dll at application startup),
//Windows will refuse to start the application if the DLL is not found.
//If you want the program to be able to start up without the DLL,
//use the dynamic DLL load method instead.
//All calls use the stdcall convention except CallFryers_C.
//-----------------------------------------------------------------------
//exports
//  CallFryers       index 1,  //call thru to Fryers32
//  CallFryers_C     index 2,  //cdecl version of CallFryers (not supported here)
//
//  OpenPort         index 3,  //Open the selected port
//  ClosePort        index 4,  //close the current port
//  GetPortStatus    index 5,  //get operational status of the port
//
//  SendReady        index 6,  //check if Ready to send
//  SendCmdArray     index 7,  //send a command array
//  RspReady         index 8,  //check if a response is available
//  GetRspArray      index 9,  //get a response array
//
//  SetNoPollTimeout index 10, //set new no_poll timeout value
//  GetNoPollTimeout index 11, //get current no_poll timeout value
//  GetFVersion      index 12, //*get FryeCom Driver version number
//  MaxComPort       index 13, //*get max possible available com port
//  GetDebugStatus   index 14; //get extended debug port status
//
//--> *Note: GetFVersion and MaxComPort do not require a ComPort handle.

const bool FCOM_FryersLoaded = true; //Static load model is always loaded

//open and close Fryers ports
extern "C" _stdcall __declspec(dllimport) void CallFryers(F_RegsType* IRegs);  //export 1

extern "C" _stdcall __declspec(dllimport) int OpenPort(int ComPort, int AutoSeek, int StartBaud, 
                                              FCOM_TfcCallback Callback);      //export 3
extern "C" _stdcall __declspec(dllimport) int ClosePort(int ComPort);          //export 4

extern "C" _stdcall __declspec(dllimport) int GetPortStatus(int ComPort, FCOM_tPortStatusRec* PortStatus); //export 5

//Fryers command transfers
extern "C" _stdcall __declspec(dllimport) int SendReady(int ComPort, FCOM_TfcCallback Callback);  //export 6
extern "C" _stdcall __declspec(dllimport) int SendCmdArray(int ComPort, FCOM_TfcArray* pData);    //export 7
extern "C" _stdcall __declspec(dllimport) int RspReady(int ComPort);                              //export 8
extern "C" _stdcall __declspec(dllimport) int GetRspArray(int ComPort, FCOM_TfcArray* pData);     //export 9

//Special maintance commands.
extern "C" _stdcall __declspec(dllimport) int SetNoPollTimeout(int ComPort, int Value);   //export 10
extern "C" _stdcall __declspec(dllimport) int GetNoPollTimeout(int ComPort, int* pValue); //export 11

extern "C" _stdcall __declspec(dllimport) int GetFVersion(int* pFVersion);      //export 12
extern "C" _stdcall __declspec(dllimport) int MaxComPort(int* pMaxPort);        //export 13
extern "C" _stdcall __declspec(dllimport) int GetDebugStatus(int ComPort, FCOM_tDebugStatusRec* pDebugStatus); //export 14

//---------------------------------------------------------------------------
//The following wrappers convert the static DLL calls to the FCOM_ calls
//to be compatible with the dynamic loaded version.

int FCOM_CallFryers(F_RegsType* pIRegs) {
  CallFryers(pIRegs);
  return(FCOM_SUCCESS);
};

int FCOM_OpenPort(int ComPort, int AutoSeek, int StartBaud, FCOM_TfcCallback Callback) {
  return(OpenPort(ComPort, AutoSeek, StartBaud, Callback));
};

int FCOM_ClosePort(int ComPort) {
  return(ClosePort(ComPort));
};

int FCOM_GetPortStatus(int ComPort, FCOM_tPortStatusRec* pPortStatus) {
  return(GetPortStatus(ComPort, pPortStatus));
};

int FCOM_SendReady(int ComPort, FCOM_TfcCallback Callback) {
  return(SendReady(ComPort, Callback));
};

int FCOM_SendCmdArray(int ComPort, FCOM_TfcArray* pData) {
  return(SendCmdArray(ComPort, pData));
};

int FCOM_RspReady(int ComPort) {
  return(RspReady(ComPort));
};

int FCOM_GetRspArray(int ComPort, FCOM_TfcArray* pData) {
  return(GetRspArray(ComPort, pData));
};

int FCOM_SetNoPollTimeout(int ComPort, int Value) {
  return(SetNoPollTimeout(ComPort, Value));
};

int FCOM_GetNoPollTimeout(int ComPort, int* pValue) {
  return(GetNoPollTimeout(ComPort, pValue));
};

int FCOM_GetFVersion(int* pFVersion) {
  return(GetFVersion(pFVersion));
};

int FCOM_MaxComPort(int* pMaxPort) {
  return(MaxComPort(pMaxPort));
};

int FCOM_GetDebugStatus(int ComPort, FCOM_tDebugStatusRec* pDebugStatus) {
  return(GetDebugStatus(ComPort, pDebugStatus));
};

