//FryeDef definitions file for Fryers32.DLL and FryeCom.DLL
//Copyright 2010 Frye Electronics, Inc.
//Written by Michael Day as of 30 Aug 2010
//You may use this code for any lawful purpose without fees or royalties.
//This code is intended as an example showing how to communicate with Fonix
//equipment using the Fryers32 or FryeCom device driver on the Windows operating system.
//No warranties are express or implied in the use of this code.
//This will compile under any version of Borland BCB (written using BCB V3.00)
//This code uses only C specific code so it should compile with most c compilers.
//---------------------------------------------------------------------------

#include "FryeDefs.h"

//char FD_ErrorFilename[1024] = ""; //used by error handler to pick up last referenced filename

int FD_WhichDLL = FD_NO_DLL_LOADED;  //0=none, 1=fryers32, 2=fryecom
bool FD_CancelOperation = false;
bool FD_CallBackActive = false;

FD_tCalDate FD_NoCalDate = {0,0,0,0};   //Default No Calibration date
FD_tPackedCalDate FD_NoPackedDate = 0;  //Default No packed cal date

//special case ID values
FD_tDeviceID FD_Cal_Jig_ID    = {0,{0,0,0,0,0,0},0}; //calibrator jig ID
FD_tDeviceID FD_No_Device_ID  = {0,{0,0,0,0,0,0},1}; //no attached ID device found
FD_tDeviceID FD_Bad_Device_ID = {0,{0,0,0,0,0,0},2}; //bad ID read
FD_tDeviceID FD_Unknown_Device_ID = {0,{0,0,0,0,0,0},3}; //device ID not read yet
FD_tDeviceID FD_6500_Device_ID = {0,{0,0,0,0,0,0},0x65}; //fake device ID for 6500
FD_tDeviceID FD_FP40_Device_ID = {0,{0,0,0,0,0,0},0x40}; //fake device ID for FP40

//=====================================================================
//A note about building forms.
//Windows has a habit of setting the form to what it thinks
//the size should be at start up when set to fsNormal and the
//borders are set to be resizable.
//Unfortunately it likes to build the form too small and puts scroll bars on
//it if you use large fonts. To "fix" this, put a bevel on the form.
//Set the top left corner to (0,0) and then set the left and bottom edges
//of the bevel to where you want the left and bottom edges of the form to be
//created at. Then in FormCreate place the following code:
//  Form1->ClientWidth = MasterBevel->Width;
//  Form1->ClientHeight = MasterBevel->Height;
// If you have a status panel or text attached to the bottom of the form,
// change the second line to this:
//  Form1->ClientHeight = MasterBevel->Height + StatusPanel->Height;
//This will cause the form to be resized to where youu want it to be.
//Do this to all forms that you create (if you want them to be created
//the way you want them to be created). The user can still resize the form
//if they wish. The above just sets the form size at the time it is created.
//Note: you can hide the bevel if you wish to get rid of the visual edge it
//creates (MasterBevel->Visible = false;).
//======================================================================
//Another trick is to place the form where the user last left it.
//Windows will either place the form at a random location, or at the designed
//location depending on how you set it up. The user though normally prefers it
//to be at a particular location. You can track this by saving the window
//information in the registry
//on FormCloseQuery() add the following code:
//  MainTop = Form1->Top;
//  MainLeft = Form1->Left;
//  REG_Value(WRITE_REGISTRY_INTEGER,&MainTop,aPrgKey,"WINDOW_POSITION_TOP");
//  REG_Value(WRITE_REGISTRY_INTEGER,&MainLeft,aPrgKey,"WINDOW_POSITION_LEFT");
//Where "aPrgKey" is the keyname for the program in the registry.
//Then in the FormCreate() routine add the following code:
//  MainTop = 1;
//  MainLeft = 1;
//  REG_Value(READ_REGISTRY_INTEGER,&MainTop,aPrgKey,"WINDOW_POSITION_TOP");
//  REG_Value(READ_REGISTRY_INTEGER,&MainLeft,aPrgKey,"WINDOW_POSITION_LEFT");
//  if ((MainTop < 1)||(MainTop > Form1->Height)) MainTop = 1;
//  if ((MainLeft < 1)||(MainLeft > Form1->Width)) MainLeft = 1;
//  Form1->Top = MainTop;
//  Form1->Left = MainLeft;
//This will cause the form to be placed back on the screen where the user
//left it when it was closed. It will also check to verify that the form is
//still on the screen and will move it if it is not. No more lost forms when
//they change screen resolution.
//=======================================================================

//---------------------------------------------------------------------------
//copy src to dest for size in bytes.
//if either pointer is null, do nothing.
void FD_ByteCopy(void* Dest, void* Src, int Size) {
  int i;
  BYTE* Dst = (BYTE*)Dest;
  BYTE* Sr = (BYTE*)Src;
  for (i=0; i<Size; i++) {
    *Dst = *Sr;
    Dst++;
    Sr++;
  }//endfor(i)
};

//---------------------------------------------------------------------------
//copy src to dest for size in words.
//if either pointer is null, do nothing.
void FD_WordCopy(void* Dest, void* Src, int Size) {
  int i;
  WORD* Dst = (WORD*)Dest;
  WORD* Sr = (WORD*)Src;
  for (i=0; i<Size; i++) {
    *Dst = *Sr;
    Dst++;
    Sr++;
  }//endfor(i)
};

//---------------------------------------------------------------------------
//Fill Dest with Data BYTE for size in BYTEs.
void FD_ByteFill(void* Dest, BYTE Data, int Size) {
  int i;
  BYTE* Dst = (BYTE*)Dest;
  for (i=0; i<Size; i++) {
    *Dst = Data;
    Dst++;
  }
};

//Fill Dest with Data WORD for size in WORDs.
void FD_WordFill(void* Dest, WORD Data, int Size) {
  int i;
  WORD* Dst = (WORD*)Dest;
  for (i=0; i<Size; i++) {
    *Dst = Data;
    Dst++;
  }
};

//Fill Dest with Data DWORD for size in DWORDs.
void FD_LongFill(void* Dest, long Data, int Size) {
  int i;
  long* Dst = (long*)Dest;
  for (i=0; i<Size; i++) {
    *Dst = Data;
    Dst++;
  }
};

//<eof>


