//Fryers Interface definition header file for FryeDefs
//Copyright 2010 Frye Electronics, Inc.
//Written by Michael Day as of 30 Aug 2010
//You may use this code for any lawful purpose without fees or royalties.
//This code is intended as an example showing how to communicate with Fonix
//equipment using the Fryers32 or FryeCom device driver on the Windows
//operating system.
//No warranties are expressed or implied in the use of this code.
//This will compile under any version of Borland BCB (written using BCB V3.00)
//This code uses only C specific code so it should compile with most c compilers.
//---------------------------------------------------------------------------
#ifndef FryeDefsH
#define FryeDefsH
//---------------------------------------------------------------------------
#include <windows.h>
#include "FryeColors.h"

#define SUCCESS 0 //my success always = 0
#define CANCEL -1 //my cancel always = -1

#define FOREVER true

typedef unsigned char BYTE;
typedef short int INT16;
typedef unsigned short int WORD;
typedef unsigned long DWORD;
typedef int INT32;
typedef char* pchar;

typedef void (*PROCEDURE)(); //procedure declaration (used by callback and menus)
typedef int  (*FUNCTION)();  //function declaration (used by sequence)
typedef int  (*PFUNCTION)(int Parm);  //function declaration with one parameter

#define INVALID_DATA16 -32768  //Value used to identify data value not used (8000H)
//Note: values that reference INVALID_DATA16 should be declared as INT16
//otherwise wierd compiler screwups can happen when the compiler fails to properly
//promote the INVALID_DATA16 constant.

#define sEND "\0"             // end string in a string list is a null string

//==============================================================================
//color defs are now located in FryeColors.h"
//#define ERROR_COLOR clRed        //something went wrong
//#define WARNING_COLOR clFuchsia  //Warning message
//#define NOTICE_COLOR clYellow    //Please notice this message
//#define STATUS_COLOR clWhite     //normal process
//#define ACTION_COLOR clSilver    //What's going on
//#define SUCCESS_COLOR clLime     //done
//#define NO_COLOR ((TColor)0)     //don't change the color

#define ENABLE true
#define DISABLE false

//==============================================================================
// Curve frame definitions
//==============================================================================
#define CURVE_HEADER_SIZE_WORDS 8 //headers are eight words long
#define NUM_PTS_IO_CURVE 9        //Num of data pts in IO curve

#define NO_DIST_LIST NULL         //No distortion list provided
#define NUM_PTS_TONE_DIST 16      //Num of Tone Normal Distortion values

#define NUM_PTS_CRV_FRAME_64 64   //Num of data pts in Curve Frame 0
#define NUM_PTS_CRV_FRAME_80 80   //Num of data pts in Curve Frame 1
#define NUM_PTS_CRV_FRAME_16 16  //Num of data pts in Curve Frame 2
#define NUM_PTS_CRV_FRAME_32 32  //Num of data pts in Curve Frame 3
#define MAX_CRV_DATA 80           //max possible curve data is 80 points
#define MAX_CRV_LIST (MAX_CRV_DATA+1) //max list size is data size +1
#define MAX_AUD_DATA 14               //max audiogram data items

//------------------------------------------------------------------------------
//WARNING! *NEVER*EVER* change this structure. It is exported to the real world.
// this structure must be compiled in packed form (one byte resolution)
typedef struct {       //standard curve frame definition
  DWORD Flags;         //flag bits identifying how measurement was done
  DWORD TimeStamp;     //time stamp for the curve (0=none available)
  INT16 Source;        //source spl used to measure curve data (db*100)
  INT16 Peak;          //peak value in curve frame (db*100)
  INT16 Output;        //overall rms of composite curve, avg of PT curve (db*100)
  BYTE NoiseReduction; //amount of noise reduction used (0-255)
  BYTE Spare;          //reserved for future use (should be set to zero)
  INT16 Data[MAX_CRV_DATA]; //80 points of data
}tCurveFrame; //(88 words total)
//Note: the easiest way to tell if a curve frame has valid data is to look
//at the Peak value. If it is INVALID_DATA16, data has never been placed in the
//array since the source will always be either OFF(0) or some valid value.

//------------------------------------------------------------------------------
//WARNING! *NEVER*EVER* change this structure. It is exported to the real world.
//Note it is possible to map the tAudFrame24 on top of the standard tCrvFrame
//using a type cast in order to pass it around, but be very careful if you do
//so that you don't pass it to a routine that will try to access the data points
//beyond the end of the smaller audiogram structure.
typedef struct { //audiogram curve frame (short 24word version) [CURVE_FRAME_16]
  DWORD Flags;      //flag bits identifying how measurement was done
  DWORD TimeStamp;  //time stamp for the curve (0=none available)
  INT16 Source;     //reserved for future use (should be set to INVALID_DATA)
  INT16 Peak;       //peak value in frame section #1 (9-24) (in db*100)
  INT16 Average;    //500/1000/2000 average value
  BYTE NoiseReduction;//amount of noise reduction used (0-255)
  BYTE Spare;       //reserved for future use (should be set to zero)
  INT16 Data[14];   //14 points of HL data
  INT16 Spare4;
  INT16 Spare5;     //two extra spare words at the end
}tAudFrame24;  //[CURVE_FRAME_16]

//audiometric curve frame data locations
enum {
  AF_DATA_125 = 0,
  AF_DATA_250 = 1,
  AF_DATA_500 = 2,
  AF_DATA_750 = 3,
  AF_DATA_1000 = 4,
  AF_DATA_1500 = 5,
  AF_DATA_2000 = 6,
  AF_DATA_3000 = 7,
  AF_DATA_4000 = 8,
  AF_DATA_6000 = 9,
  AF_DATA_8000 = 10,
  AF_DATA_10000 = 11,
  AF_DATA_12000 = 12,
  AF_DATA_16000 = 13,
};

#define CURVE_FRAME_THIRD_OCT_FLAG   0x00020000 //was ear def flag
#define CURVE_FRAME_SMOOTH_FLAG      0x00000020
#define CURVE_FRAME_DISTORTION_FLAGS 0x00000006
#define CURVE_FRAME_2ND_HARM_FLAGS   0x00000002
#define CURVE_FRAME_3RD_HARM_FLAGS   0x00000004
#define CURVE_FRAME_TOT_HARM_FLAGS   0x00000006
#define CURVE_FRAME_TYPE_FLAGS       0x00001c00
#define CURVE_FRAME_TYPE_64_FLAGS    0x00000000
#define CURVE_FRAME_TYPE_80_FLAGS    0x00000400
#define CURVE_FRAME_TYPE_16_FLAGS    0x00000800
#define CURVE_FRAME_TYPE_USER_FLAGS  0x00001c00
#define CURVE_FRAME_LEVEL_FLAG   0x00002000
#define CURVE_FRAME_REFMIC_FLAG  0x00000010
#define CURVE_FRAME_MODIFIED     0x00040000
#define CURVE_FRAME_ENV_FLAGS  0x000000c0
#define CURVE_FRAME_TCOIL_FLAG 0x00000040
#define CURVE_FRAME_OES_FLAG  0x00010000
#define CURVE_FRAME_CIC_FLAG  0x00800000
#define CURVE_FRAME_COR_FLAGS 0x00810000

#define CURVE_FRAME_GAIN_FLAG    0x00004000

#define CURVE_FRAME_WEIGHTING_FLAGS 0x00000300
#define CURVE_FRAME_INPUT_WEIGHTING_FLAG  0x00000100
#define CURVE_FRAME_OUTPUT_WEIGHTING_FLAG 0x00000200
#define CURVE_FRAME_FLAT_WEIGHTED_FLAGS   0x00000000
#define CURVE_FRAME_WEIGHTED_POWER_FLAGS  0x00000200
#define CURVE_FRAME_WEIGHTED_GAIN_FLAGS   0x00000300

#define CURVE_TYPE_FLAGS           0x0f000000
#define CURVE_TYPE_UNAIDED_FLAGS   0x01000000
#define CURVE_TYPE_LEVELING_FLAGS  0x05000000
#define CURVE_TYPE_AIDED_FLAGS     0x02000000
#define CURVE_TYPE_INSERTION_FLAGS 0x04000000
#define CURVE_TYPE_TARGET_FLAGS    0x08000000
#define CURVE_SUBINFO_FLAGS        0xf0000000

#define CURVE_FRAME_FITRULE_FLAGS 0xf0000000

//--------
#define CURVE_FRAME_CRVREF_FLAGS     0x00208000 //crv frame crvref flags mask
#define CURVE_FRAME_MEASURED_FLAGS   0x00000000 //part of crvref
#define CURVE_FRAME_AVERAGE_FLAGS    0x00200000 //part of crvref
#define CURVE_FRAME_DIFFERENCE_FLAGS 0x00008000 //part of crvref
#define CURVE_FRAME_PREDICTED_FLAGS  0x00208000 //part of crvref
//--------

//The default probe header is used to make curve frames from target and
//other curves like average unaided.   (80pt, gain, leveled, snd field)
#define DEFAULT_PROBE_HEADER 0x00006480

//==============================================================================
// Other misc data and structure definitions
//==============================================================================

// The Curve Frame Time Stamp only exists in curve frames
//---------------------------------------------------------------
//               Curve Frame Time Stamp Format
//----------- high word --------- ---------- low word -----------
//F E D C B A 9 8 7 6 5 4 3 2 1 0 F E D C B A 9 8 7 6 5 4 3 2 1 0
//|---------| |-----| |-------| |-------------------------------|
//   Year      Month     Day          Seconds in Day  H*M*S
//   (0-63)     (1-12)   (1-31)              (0-86399)
//   0=1990     1=Jan                   00:00:00 to 23:59:59
//---------------------------------------------------------------

typedef DWORD FD_tCrvTimeStamp;    //The packed crv stamp is formated as a Dword


//Frye uses the MSDOS/Windows date/time record for expanded date/time
typedef struct {
  WORD Millisecond;  //set to 0 if not supported
  BYTE Second; //0-59
  BYTE Minute; //0-59
  BYTE Hour;   //0-24 or 1-12
  BYTE spare;  //spare (is day of week on some clocks)
  BYTE Day;    //1-31
  BYTE Month;  //1-12
  WORD Year;   //1992-9999
} FD_tTime;

//like above but with the time fields removed
typedef struct {
  BYTE Day;    //1-31
  BYTE Month;  //1-12
  WORD Year;   //1992-9999
} FD_tDate;


//---------------------------------------------------------------------------
//Frye uses two different calibration date formats. The data packed into
//the Dallas part is the Packed date format shown below. Upon being read, it
//is expanded to the CalDate format shown.
//---------------------------------------------------------------------------
//Frye Packed Date format is a DWORD formated with the following nibbles:
//dd:ee:yyy:m - where "dd"=day(31-24), "ee"=expire(23-16)
//"yyy" = year(bits 15-4), "m"=month(3-0), (year=0->4095)
typedef DWORD FD_tPackedCalDate;    //A packed date is formated as a Dword

//Unpacked Frye Cal date structure
typedef struct {
   WORD Expire;  //expiration in months from date of calibration
   WORD Year;    //Year of calibration
   BYTE Month;   //month of calibration
   BYTE Day;     //day of calibration
} FD_tCalDate;

//date string format
enum {
  DATE_US,
  DATE_US_SHORT,
  DATE_COMPUTER
};

typedef struct {   // ID information (from dallas part in instrument)
  BYTE Family;
  BYTE Serial[6];
  BYTE Crc;
}FD_tDeviceID;  //returned by cmd 101

//-----------------------------------------------------------------------------
//Signature is used to provide information about the instrument.
//This information is normally filled in at the time the attached Fonix
//instrument is identified. Not all the fields may be filled in.
//Some instruements may not have the information available.
//Also this is only filled in if you use the GetInstrumentInfo call
//to collect the information about the instrument.

//State information - (status of the Instrument Signature record)
#define SIG_INVALID 0 //the signature has not been updated
#define SIG_BINARY 1  //only the binary values are valid
#define SIG_STRING 2  //only the strings are valid
#define SIG_VALID 3   //both the binary values and the strings are valid

#define MAX_MICID 8   //we can handle up to 8 different Mic IDs

//The following variables are updated by GetMachineInfo() (see GetVersion cmd)
//*When in the application mode, InstrumentBaseType, InstrumentSubType,
// InstrumentModel, SoftwareVersion, StdOptions and CstOptions are valid.
//**When in Bootloader mode, only BootVersion is valid.
//----------
//#GetDeviceInfo will fill out the remaining fields where applicable.
//The information is only available when the instrument is in the application
//mode as this information is related to the application software.
//GetDevice info is normally called once after the instrument has been identified
//with GetMachineInfo(). GetMachineInfo should be called periodically to detect
//if the instrument has been changed. If a change is detected, GetDevice info
//should be called to determine the characteristics of the new instrument that
//was detected.
//--------
//Items marked with "#" are updated by the GetInstrumentInfo() call
//which is called by GetDeviceInfo().
//##GetMicID returns the ID of the currently active microphone.
//GetMicID is called by GetDeviceInfo().
//###GetPrinterLabel will return the currently active Printer label and
//where applicable the currently active UserID.
//The label information is stored in ExtLabel rather than Signature.
//The GetUserId is collected by a call to GetUserIDText from GetDeviceInfo().
//If UserID data is available, it is stored in the Signature record structure.
//UserNumber and MaxUserNumber are also collected by GetDeviceInfo() by
//calling GetUserNumber(). If User selection is not available,
//these numbers will be zero.
//***For instruments that have a unique identifier (CpuID), CpuID will be
//updated by the GetMachineID() which is called by GetDeviceInfo().
//Much of the detail information is returned by GetInstrumentInfo().
//Not all instruments will return all the information. It depends on the
//instrument and version of software running on the instrument.
//------------
//Note: InstrumentBaseType, InstrumentSubType, InstrumentModel, SoftwareVersion,
//StdOptions and CstOptions will always be valid for any Fonix instrument when it
//is in application mode ant the GetMachineInfo() command is called successfully.
//Other values in this record may or may not be valid depending on the instrument.
typedef struct {
  int State;                //0=invalid, 1=binary info valid, 3=all valid
  int InstSoftwareMode;     //Mode the instrument is in 0=normal, -1=bootloader
  int OptionsState;         //0=unknown, 1=invalid, 2=bootloader, 3=valid application
  DWORD StdOptions;         //*standard options for this instrument (0=off, 1=on)
  DWORD CstOptions;         //*custom options for this instrument (0=off, 1=on)
  FD_tDeviceID CpuID;       //***ID for this instrument
  FD_tDeviceID MicID[MAX_MICID]; //##ID for the currently active microphone in the instrument (up to 8 supported)
  INT16 MicIDcount;         //number of Mic IDs available
  INT16 InstrumentBaseType; //*what instrument base type this is  (0=6500, 35=fp35, 7000=7000, etc)
  INT16 InstrumentSubType;  //*additional identification of the instrument
  INT16 InstrumentModel;    //*what instrument model number this is for (0=6500, 35=fp35, 7000=7000, etc)
  INT16 SoftwareVersion;    //*version number of the associated software
  INT16 Language;           //#language the instrument program uses
  INT16 NvsVersion;         //#eerom format version number
  INT16 BootVersion;        //#**Boot loader version
  FD_tCalDate MfgDate;      //#Mfg date and warranty expiration
  FD_tCalDate HwCalDate;    //#hardware calibration date and expiration
  FD_tCalDate SwCalDate;    //#Software calibration date and expiration
  INT16 CalibrationStatus;  //#current calibration status
  FD_tCalDate SwBuildDate;  //#Software build date
  INT16 SwBuildNumber;      //#Software build number
  INT16 UserNumber;         //###Currently active user number
  INT16 MaxUsers;           //###Max available user numbers.
  char SerialNumber[9];   //#serial number string (eight places plus null tag)
  char ModelNumber[9];    //model number string (eight places plus null tag)
  char UserID1[28];       //###first line of user ID
  char UserID2[28];       //###second line of user ID
}FD_tSignature;
//InstrumentType verse InstrumentNumber...
//The Instrument type number is the raw type number read via RS232 from the instrument.
//Normally this is the same as the Instrument Number, but because

extern bool FD_CancelOperation;
extern bool FD_CallBackActive;

//-----------------------------------------------------------------------
//Info to determine which DLL we are using
#define FD_NO_DLL_LOADED 0
#define FD_FRYERS32_LOADED 1
#define FD_FRYECOM_LOADED 2
extern int FD_WhichDLL;  //0=none, 1=fryers32, 2=fryecom

//-----------------------------------------------------------------------

extern FD_tCalDate FD_NoCalDate;           //Default No Calibration date
extern FD_tPackedCalDate FD_NoPackedDate;  //Default No packed cal date

//special case ID values
extern FD_tDeviceID FD_Cal_Jig_ID;      //calibrator jig ID
extern FD_tDeviceID FD_No_Device_ID;    //no attached ID device found
extern FD_tDeviceID FD_Bad_Device_ID; //bad ID read
extern FD_tDeviceID FD_Unknown_Device_ID; //device ID not read yet
extern FD_tDeviceID FD_6500_Device_ID; //fake device ID for 6500
extern FD_tDeviceID FD_FP40_Device_ID; //fake device ID for FP40

//extern char FD_ErrorFilename[];

//non-library versions of memory copy/fill.
extern void FD_ByteCopy(void* Dest, void* Src, int Size);
extern void FD_WordCopy(void* Dest, void* Src, int Size);
extern void FD_ByteFill(void* Dest, BYTE Data, int Size);
extern void FD_WordFill(void* Dest, WORD Data, int Size);
extern void FD_LongFill(void* Dest, long Data, int Size);


#endif
